/***************************************************************************
                          cclient.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>

#ifndef WIN32
#include <malloc.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

#include <dclib/dcobject.h>
#include <dclib/cencrypt.h>
#include <dclib/cmessagehandler.h>

#include "cclient.h"

CClient::CClient()
{
	CallBack = 0;

	ecMode = ecmNone;

	sBuffer         = "";
	sNick           = "";
	sEMail          = "";
	sConnectionType = "";
	sComment        = "";
	sHubName        = "";
	sShareSize      = "";
	sVersion        = "";
	bAdmin          = FALSE;
	bHandshake      = TRUE;
	bHandleUserList = TRUE;
	lHubShareSize   = 0;
	pUserList = new CStringList();
}

CClient::~CClient()
{
	Stop();

	if ( pUserList )
	{
		delete pUserList;
		pUserList = 0;
	}
}

/** */
void CClient::ConnectionState( eConnectionState state )
{
	int err = -1;

	CMessageConnectionState *Object = new CMessageConnectionState();

	if (!Object)
	{
		return;
	}

	if ( (state == estCONNECTED) ||
	     (state == estDISCONNECTED) )
	{
		sBuffer       = "";
		bHandshake    = 1;
		lHubShareSize = 0;

		if ( pUserList )
		{
			pUserList->Clear();
		}
	}

	Object->eType    = DC_MESSAGE_CONNECTION_STATE;
	Object->eState   = state;
	Object->sMessage = GetSocketError();

	if ( CallBack != 0 )
	{
		err = CallBack( this, Object );
	}
	else
	{
		err = DC_CallBack( Object );
	}

	if ( err == -1 )
	{
		delete Object;
	}
}

/** */
void CClient::DataAvailable( const char * buffer, int len )
{
	CString s;
	int i,i_old;

	if ( len <= 0 )
	{
		return;
	}

	i = i_old = 0;
	s = sBuffer + buffer;

	// search '|'
	while((i=s.Find('|',i))>=0)
	{
		i++;
		i_old = i;
	}

	if ( i_old > 0 )
	{
		sBuffer = s.Mid(0,i_old);
		HandleMessage( sBuffer );
	}

	if (i_old==s.Length())
	{
		sBuffer = "";
	}
	else
	{
		sBuffer = s.Mid( i_old, s.Length()-i_old );
	}
}

/** */
void CClient::DataTimeout()
{
	timeConnection = time(0);

	printf("CClient: data timeout ...\n");fflush(stdout);

	// send myinfo and test the connection (not in handshake mode ...)
	if ( bHandshake == 0 )
	{
		SendMyInfo( sNick, sComment, sConnectionType, eAwayMode, sEMail, sShareSize );
	}
	else
	{
		SendString("|");
	}
}

/** */
int CClient::HandleMessage( const CString message )
{
	int err;
	int pointer;
	eDCMessage type;
	CObject * Object;
	CMessageHandler MessageHandler;

	if ( message == "" )
	{
		return 0;
	}

	pointer = 0;

	while( (type=MessageHandler.Parse(message,pointer,Object=0)) != DC_MESSAGE_PARSE_ERROR )
	{
		switch (type)
		{
			case DC_MESSAGE_LOCK:
			{
				CString sAnswer;
				CEncrypt Encrypt;
				CMessageLock * msg = (CMessageLock*)Object;

				// reset admin value
				bAdmin = 0;

				if(!msg)
					break;

				Encrypt.Encrypt(msg->sData,sAnswer);

				SendKey( sAnswer );

				SendValidateNick( sNick );

				break;
			}

			case DC_MESSAGE_LOGEDIN:
			{
				bAdmin = 1;

				break;
			}

			case DC_MESSAGE_HUBNAME:
			{
				CMessageHubName * msg = (CMessageHubName*)Object;

				SetHubName(msg->sHubName);

				break;
			}

			case DC_MESSAGE_HELLO:
			{
				CMessageHello * msg = (CMessageHello*)Object;

				if ( msg->sNick == sNick )
				{
					SendVersion( sVersion );
					SendMyInfo( sNick, sComment, sConnectionType, eAwayMode, sEMail, sShareSize );
					bHandshake = 0;
				}
				else
				{
					AppendUser(msg->sNick);
				}

				break;
			}

			case DC_MESSAGE_MYINFO:
			{
				CMessageMyInfo * msg = (CMessageMyInfo*)Object;

				if( bHandleUserList == TRUE )
				{
					if ( UpdateUser(msg) == FALSE )
					{
						delete Object;
						Object = 0;
					}
				}

				break;
			}

			case DC_MESSAGE_QUIT:
			{
				CMessageQuit * msg = (CMessageQuit*)Object;

				RemoveUser(msg->sNick);

				break;
			}

			case DC_MESSAGE_NICKLIST:
			{
				CMessageNickList * msg = (CMessageNickList*)Object;

				lHubShareSize = 0;

				if( (pUserList) && (bHandleUserList == TRUE))
				{
					pUserList->Clear();

					InitUserList(msg);
				}

				break;
			}

			case DC_MESSAGE_OPLIST:
			{
				CMessageNickList * msg = (CMessageNickList*)Object;

				// operators allready in the userlist
				if( (pUserList) && (bHandleUserList == TRUE))
				{
					InitOperatorList(msg);
				}
				break;
			}

			case DC_MESSAGE_SEARCH:
			{
				CMessageSearch * msg = (CMessageSearch*)Object;

				break;
			}

			default:
			{
				break;
			}
		}

		if (Object)
		{
			((CDCMessage*)Object)->eType = type;

			if ( CallBack != 0 )
			{
				err = CallBack( this, Object );
			}
			else
			{
				err = DC_CallBack( Object );
			}

			if ( err == -1 )
			{
				delete Object;
			}
		}
	}

	return 0;
}

/** */
void CClient::InitUserList( CMessageNickList * nicklist )
{
	CString s;
	CString *nick;
	CMessageMyInfo *myinfo;

	if (!nicklist)
		return;
	if (!pUserList)
		return;

	for(nick=0;(nick=nicklist->NickList.Next(nick))!=0;)
	{
		myinfo = new CMessageMyInfo();
		myinfo->sNick   = *nick;
		myinfo->lShared = 0;
		myinfo->bOperator = FALSE;
		myinfo->eAwayMode = euamNORMAL;
		pUserList->Add(*nick,myinfo);

		SendGetInfo(*nick,GetNick());
	}
}

/** */
void CClient::InitOperatorList( CMessageNickList * nicklist )
{
	CString *nick;
	CMessageMyInfo *myinfo=0;

	if (!pUserList)
		return;

	for(nick=0;(nick=nicklist->NickList.Next(nick))!=0;)
	{
		if ( pUserList->Get( *nick, (CObject*&)myinfo) == 0 )
		{
			myinfo->bOperator = TRUE;
		}
	}
}

/** */
void CClient::AppendUser( CString nick )
{
	CString s;
	CMessageMyInfo *myinfo=0;

	if (!pUserList)
		return;

	pUserList->Get( nick, (CObject*&)myinfo );

	if (!myinfo)
	{
		myinfo = new CMessageMyInfo();
		myinfo->sNick   = nick;
		myinfo->lShared = 0;
		myinfo->bOperator = FALSE;
		myinfo->eAwayMode = euamNORMAL;
		pUserList->Add(nick,myinfo);

		SendGetInfo(nick,GetNick());
	}
}

/** */
void CClient::RemoveUser( CString nick )
{
	CMessageMyInfo *myinfo=0;

	if (!pUserList)
		return;

	if ( pUserList->Get( nick, (CObject*&)myinfo ) == 0 )
	{
		if ( myinfo->lShared > lHubShareSize )
			lHubShareSize = 0;
		else
			lHubShareSize -= myinfo->lShared;
		pUserList->Del(nick);
	}
}

/** */
bool CClient::UpdateUser( CMessageMyInfo * pMyInfo )
{
	bool res = FALSE;
	CMessageMyInfo *myinfo=0;

	if (!pMyInfo)
		return FALSE;
	if (!pUserList)
		return FALSE;

	if ( pUserList->Get( pMyInfo->sNick, (CObject*&)myinfo ) == 0 )
	{
		if ( myinfo->lShared >= lHubShareSize )
			lHubShareSize = 0;
		else
			lHubShareSize -= myinfo->lShared;
	}

	if(!myinfo)
	{
		res = TRUE;
		myinfo = new CMessageMyInfo();
		myinfo->bOperator = FALSE;
		pUserList->Add(pMyInfo->sNick,myinfo);
	}

	// don't send old data
	if ( myinfo->eAwayMode != pMyInfo->eAwayMode )
		res = TRUE;
	else if ( myinfo->lShared != pMyInfo->lShared )
		res = TRUE;
	else if ( myinfo->sComment != pMyInfo->sComment )
		res = TRUE;
	else if ( myinfo->sEMail != pMyInfo->sEMail )
		res = TRUE;
	else if ( myinfo->sNick != pMyInfo->sNick )
		res = TRUE;
	else if ( myinfo->sSpeed != pMyInfo->sSpeed )
		res = TRUE;
	else if ( myinfo->sUnknown != pMyInfo->sUnknown )
		res = TRUE;
	else if ( pMyInfo->bOperator != myinfo->bOperator )
		res = TRUE;

	if ( res == TRUE )
	{
		myinfo->eAwayMode  = pMyInfo->eAwayMode;
		myinfo->lShared    = pMyInfo->lShared;
		myinfo->sComment   = pMyInfo->sComment;
		myinfo->sEMail     = pMyInfo->sEMail;
		myinfo->sNick      = pMyInfo->sNick;
		myinfo->sSpeed     = pMyInfo->sSpeed;
		myinfo->sUnknown   = pMyInfo->sUnknown;
		pMyInfo->bOperator = myinfo->bOperator;
	}

	lHubShareSize += myinfo->lShared;

	return res;
}

/** */
bool CClient::IsUserOnline( CString nick )
{
	bool res = FALSE;
	CMessageMyInfo *myinfo=0;

	if (!pUserList)
		return res;

	return ( pUserList->Get( nick, (CObject*&)myinfo ) == 0 );
}
