/***************************************************************************
                           cbz.cpp  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#ifdef WIN32
#define HAVE_LIBBZ2 1
#endif

#ifdef HAVE_LIBBZ2
#define BZ_NO_STDIO
#include <bzlib.h>
#endif

#include "cbz.h"

/** */
CBZ::CBZ()
{
}

/** */
CBZ::~CBZ()
{
}

/** */
bool CBZ::Decompress( CByteArray * in, CByteArray * out )
{
	bool err = FALSE;
#ifdef HAVE_LIBBZ2
	int i;
	unsigned int inlen,outlen;
	char * buffer = 0;

	if ( (!in) || (!out) )
		return err;

	inlen  = in->Size();
	outlen = in->Size();

	out->SetSize(0);

	for(;;)
	{
		outlen *= 10;
		if(buffer)
			free(buffer);
		buffer = (char*) malloc(outlen);

		i = BZ2_bzBuffToBuffDecompress( buffer, &outlen, (char*)in->Data(), inlen, 0, 0);

		if( i == BZ_OK )
		{
			out->Append( (const unsigned char*)buffer, outlen );
			err = TRUE;
			break;
		}
		else if ( i == BZ_OUTBUFF_FULL )
		{
			continue;
		}
		else
		{
			break;
		}
	}

	if (buffer)
		free(buffer);
#else
	printf("CBZ::Decompress: No bz2 support\n");
#endif
	return err;
}
