/***************************************************************************
                          cbytearray.cpp  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dclib/cbytearray.h>

/** */
CByteArray::CByteArray()
{
	pData  = 0;
	lSize  = 0;
	lBSize = 0;
}

/** */
CByteArray::~CByteArray()
{
	if (pData)
	{
		free(pData);
	}
}

/** */
void CByteArray::SetSize( long size )
{
	if(pData)
	{
		free(pData);
		pData = 0;
	}

	lSize  = 0;
	lBSize = 0;

	if( size > 0 )
	{
		pData = (unsigned char*)malloc(size);

		if(pData==0)
		{
			printf("CByteArray::SetSize: internal memory error\n");
		}
		else
		{
			lBSize = lSize = size;
		}
	}
}

/** */
void CByteArray::Append( const unsigned char * b, long len )
{
	unsigned char *p;

	if(len<=0)
	{
		printf("CByteArray::Append: len: %ld\n",len);
		return;
	}

	if ( (lSize+len) > lBSize )
	{
		lBSize += len + 10000;
		p = (unsigned char*) realloc(pData,lBSize);
		if(p==0)
		{
			printf("CByteArray::Append: fatal error in cbytearray\n");
			return;
		}
		pData=p;
	}

	memcpy(pData+lSize,b,len);
	lSize += len;
}
