/***************************************************************************
                           casyncdns.h  -  description
                             -------------------
    begin                : Mon Jun 10 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CASYNCDNS_H
#define CASYNCDNS_H

/**
  *@author Mathias Kster
  */

typedef enum eAsyncDns {
	eadSUCCESS,
	eadERROR,
	eadAGAIN
} eAsyncDns;

#include <time.h>
#ifndef WIN32
#include <netinet/in.h>
#endif
#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/cstringlist.h>
#include <dclib/cthread.h>

class DLL_EXPORT CAsyncDnsEntry : public CObject {
public:
	/** */
	CAsyncDnsEntry() {};
	/** */
	virtual ~CAsyncDnsEntry() {};

	/** */
	CString sHost;
	/** */
	bool bError;
	/** */
	time_t tTimeout;
	/** */
	struct in_addr sin_addr;
};

class DLL_EXPORT CAsyncDns : public CThread {

public:
	/** */
	CAsyncDns();
	/** */
	virtual ~CAsyncDns();

	/** */
	eAsyncDns GetHostByName( CString host, struct in_addr * sin_addr );

	/** */
	virtual void Thread( CObject * Object );

private:
	/** */
	CStringList *pHostCache;
	/** */
	CStringList *pHostList;
};

extern CAsyncDns pAsyncDns;

#endif
