/***************************************************************************
                           casyncdns.cpp  -  description
                             -------------------
    begin                : Mon Jun 10 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WIN32
#include <unistd.h>
#include <netdb.h>
#endif

#include "casyncdns.h"

CAsyncDns pAsyncDns;

/** */
CAsyncDns::CAsyncDns()
{
	pHostCache = new CStringList(4);
	pHostList  = new CStringList(4);

	Start();
}

/** */
CAsyncDns::~CAsyncDns()
{
	Stop();

	Lock();

	if ( pHostCache )
	{
		delete pHostCache;
		pHostCache = 0;
	}

	if ( pHostList )
	{
		delete pHostList;
		pHostList = 0;
	}

	UnLock();
}

/** */
eAsyncDns CAsyncDns::GetHostByName( CString host, struct in_addr * sin_addr )
{
	if ( TryLock() == FALSE )
	{
		return eadAGAIN;
	}

	CAsyncDnsEntry * AsyncDnsEntry;
	eAsyncDns err = eadERROR;

	if ( pHostCache && pHostList && (host != "") && sin_addr )
	{
		if ( pHostCache->Get( host, (CObject*&)AsyncDnsEntry ) != -1 )
		{
			memcpy( sin_addr, &AsyncDnsEntry->sin_addr, sizeof(struct in_addr) );
			pHostCache->Del(host);
			err = eadSUCCESS;
		}

		if ( err == eadERROR )
		{
			if ( pHostList->Get( host, (CObject*&)AsyncDnsEntry ) == -1 )
			{
				AsyncDnsEntry = new CAsyncDnsEntry();

				AsyncDnsEntry->sHost  = host;
				AsyncDnsEntry->bError = FALSE;

				pHostList->Add( host, AsyncDnsEntry );

				err = eadAGAIN;
			}
			else if ( AsyncDnsEntry->bError == FALSE )
			{
				err = eadAGAIN;
			}
		}
	}

	UnLock();

	return err;
}

void CAsyncDns::Thread( CObject * )
{
	CAsyncDnsEntry * AsyncDnsEntry = 0;
	CString host = "";
	struct hostent *hp = 0;

	Lock();

	while ( pHostList->Next( (CObject*&)AsyncDnsEntry ) != 0 )
	{
		// no error
		if ( AsyncDnsEntry->bError == FALSE )
		{
			host = AsyncDnsEntry->sHost;
			break;
		}
		else if ( (time(0)-AsyncDnsEntry->tTimeout) >= 60 )
		{
			pHostList->Del(AsyncDnsEntry->sHost);
			break;
		}
	}

	UnLock();

	if ( host != "" )
	{
		hp = gethostbyname(host.Data());

		Lock();

		if ( pHostList->Get( host, (CObject*&)AsyncDnsEntry ) == 0 )
		{
			if ( hp == 0 )
			{
				AsyncDnsEntry->bError   = TRUE;
				AsyncDnsEntry->tTimeout = time(0);
			}
			else
			{
				AsyncDnsEntry = new CAsyncDnsEntry();

				AsyncDnsEntry->sHost    = host;
				AsyncDnsEntry->bError   = FALSE;
				AsyncDnsEntry->tTimeout = time(0);
				memcpy( &AsyncDnsEntry->sin_addr, hp->h_addr, hp->h_length);

				pHostList->Del(host);
				pHostCache->Add(host,AsyncDnsEntry);
			}
		}

		UnLock();
	}

#ifdef WIN32
	Sleep(100);
#else
	usleep(100);
#endif
}
