
#define GTK_DISABLE_DEPRECATED

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkcellrenderertext.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkframe.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkhbbox.h>
#include <gtk/gtkhpaned.h>
#include <gtk/gtkimage.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkliststore.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtkstock.h>
#include <gtk/gtktable.h>
#include <gtk/gtktogglebutton.h>
#include <gtk/gtktree.h>
#include <gtk/gtktreeselection.h>
#include <gtk/gtktreeview.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkwindow.h>

#include "../common/xchat.h"
#include "../common/xchatc.h"
#include "../common/server.h"
#include "../pixmaps/xchat.h"
#include "pixmaps.h"


static void servlist_servers_populate (GtkWidget *treeview, GSList *servlist, gboolean edit);


/* ==== common/ */

typedef struct ircserver
{
	char *hostname;
	char *comment;
	int port;
} ircserver;

typedef struct ircnet
{
	char *name;
	char *nick;
	char *user;
	char *real;
	char *pass;
	char *autojoin;
	char *command;
	GSList *servlist;
	guint32 flags;
	int rotary;
	int selected;
} ircnet;


/* servlistgui.c globals */

static GtkWidget *serverlist_win;
static GtkWidget *servers_tree;	/* list of servers */
static GtkWidget *networks_tree;	/* network TreeView */
static GtkWidget *connect_button;
static GtkWidget *connectnew_button;
static GtkWidget *entry_nick1;
static GtkWidget *entry_nick2;
static GtkWidget *entry_nick3;
static GtkWidget *entry_username;
static GtkWidget *entry_realname;
static GtkWidget *entry_netname;
static GtkWidget *editbox;	/* shown/hidden by "Edit Mode" checkbutton */
static ircnet *selected_net = NULL;
static session *servlist_sess;

/* ================== */


GSList *network_list = 0;

static void
servlist_connect (session *sess, ircnet *net)
{
	ircserver *serv;

	serv = net->servlist->data;

	server_connect (sess->server, serv->hostname, serv->port, FALSE);
}

static ircnet *
servlist_find_net (char *name)
{
	GSList *list = network_list;
	ircnet *net;

	while (list)
	{
		net = list->data;
		if (strcmp (net->name, name) == 0)
			return net;
		list = list->next;
	}

	return NULL;
}

static void
servlist_add_host (ircnet *net, char *name, int port, char *comment)
{
	ircserver *serv;

	serv = malloc (sizeof (ircserver));
	memset (serv, 0, sizeof (ircserver));
	serv->hostname = strdup (name);
	serv->port = port;
	if (comment)
		serv->comment = strdup (comment);

	net->servlist = g_slist_prepend (net->servlist, serv);
}

static ircnet *
servlist_add (char *name)
{
	ircnet *net;

	net = malloc (sizeof (ircnet));
	memset (net, 0, sizeof (ircnet));
	net->name = strdup (name);

	network_list = g_slist_prepend (network_list, net);

	return net;
}

int
servlist_load (void)
{
	FILE *fp;
	char buf[256];
	int port, len;
	ircnet *net = NULL;
	char *po;

	fp = fopen ("servlist.conf", "r");
	if (!fp)
		return FALSE;

	while (fgets (buf, sizeof (buf) - 1, fp))
	{
		len = strlen (buf);
		buf[len-1] = 0;	/* remove the trailing \n */
		switch (buf[0])
		{
			case 'N':
				net = servlist_add (buf + 2);
				break;
			case 'I':
				net->nick = strdup (buf + 2);
				break;
			case 'U':
				net->user = strdup (buf + 2);
				break;
			case 'R':
				net->real = strdup (buf + 2);
				break;
			case 'P':
				net->pass = strdup (buf + 2);
				break;
			case 'J':
				net->autojoin = strdup (buf + 2);
				break;
			case 'C':
				net->command = strdup (buf + 2);
				break;
			case 'F':
				net->flags = atoi (buf + 2);
				break;
			case 'S':	/* new server/hostname for this network */
				po = strchr (buf, ' ');
				if (po)
				{
					*po = 0;
					po++;
					port = atoi (po);
					po = strchr (po, ' ');
					if (po)
						po++;
					servlist_add_host (net, buf + 2, port, po);
				}
				break;
		}
	}
	fclose (fp);

{
	GSList *list;
	GSList *hlist;
	ircserver *serv;

	list = network_list;
	while (list)
	{
		net = list->data;
		printf("NETWORK: %s\n", net->name);
		hlist = net->servlist;
		while (hlist)
		{
			serv = hlist->data;
			printf("\t%s : %d : %s\n", serv->hostname, serv->port, serv->comment);
			hlist = hlist->next;
		}
		list = list->next;
	}
}

	return TRUE;
}

static void
servlist_toggles_populate (ircnet *net)
{

}

static void
servlist_entries_populate (ircnet *net)
{
	gtk_entry_set_text (GTK_ENTRY (entry_netname), net->name);
}

static void
servlist_populate (ircnet *net)
{
	servlist_servers_populate (servers_tree, net->servlist, FALSE);
	servlist_entries_populate (net);
	servlist_toggles_populate (net);
	gtk_widget_set_sensitive (connect_button, TRUE);
	gtk_widget_set_sensitive (connectnew_button, TRUE);
}

static void
servlist_network_row_cb (GtkTreeView *treeview, gpointer user_data)
{
	GtkTreeSelection *sel;
	GtkTreeModel *model;
	GtkTreeIter iter;
	ircnet *net;
	char *netname;

	selected_net = NULL;

	sel = gtk_tree_view_get_selection (treeview);
	if (gtk_tree_selection_get_selected (sel, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, 0, &netname, -1);
		net = servlist_find_net (netname);
		if (net)
		{
			servlist_populate (net);
			selected_net = net;
		}
	}
}

/* ============ */

GtkWidget *
gtkutil_create_list (GtkWidget *box, char *title, void *select_callback)
{
	GtkTreeModel *model;
	GtkWidget *treeview;
	GtkWidget *hbox, *sw;
	GtkCellRenderer *renderer;
	GtkListStore *store;

	hbox = gtk_hbox_new (0, 0);
	gtk_container_add (GTK_CONTAINER (box), hbox);

	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
													 GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
											  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (hbox), sw, TRUE, TRUE, 0);

	store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_BOOLEAN);

	model = GTK_TREE_MODEL (store);

	treeview = gtk_tree_view_new_with_model (model);
	if (select_callback)
		g_signal_connect (G_OBJECT (treeview), "cursor_changed",
								G_CALLBACK (select_callback), NULL);

	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview), -1,
						 		title, renderer,
						 		"text", 0,
								"editable", 1,
								NULL);
   gtk_container_add (GTK_CONTAINER (sw), treeview);
	g_object_unref (G_OBJECT (model));

	return treeview;
}

static void
servlist_servers_populate (GtkWidget *treeview, GSList *servlist, gboolean edit)
{
	GtkListStore *store;
	GtkTreeIter iter;
	int i;
	ircserver *serv;

	store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));

	gtk_list_store_clear (store);

	i = 0;
	while (servlist)
	{
		serv = servlist->data;
		gtk_list_store_prepend (store, &iter);
		gtk_list_store_set (store, &iter, 0, serv->hostname, 1, edit, -1);
		i++;
		servlist = servlist->next;
	}
}

static void
servlist_networks_populate (GtkWidget *treeview, GSList *netlist, gboolean edit)
{
	GtkListStore *store;
	GtkTreeIter iter;
	int i;
	ircnet *net;

	store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));

	gtk_list_store_clear (store);

	i = 0;
	while (netlist)
	{
		net = netlist->data;
		gtk_list_store_prepend (store, &iter);
		gtk_list_store_set (store, &iter, 0, net->name, 1, edit, -1);
		i++;
		netlist = netlist->next;
	}
}

static void
servlist_create_check (GtkWidget *table, int row, int col, char *labeltext)
{
	GtkWidget *but;

	but = gtk_check_button_new_with_label (labeltext);
	gtk_table_attach (GTK_TABLE (table), but, col, col+1, row, row+1,
						   GTK_FILL|GTK_EXPAND, 0, 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (but), TRUE);
}

static GtkWidget *
servlist_create_entry (GtkWidget *table, char *labeltext, int row, int active)
{
	GtkWidget *label, *entry;

	label = gtk_label_new (labeltext);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, row, row+1,
							GTK_FILL|GTK_SHRINK, GTK_FILL, 4, 1);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	entry = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, row, row+1,
							GTK_FILL|GTK_EXPAND, GTK_FILL, 0, 1);

	gtk_widget_set_sensitive (entry, active);
	gtk_widget_set_sensitive (label, active);

	return entry;
}

static void
servlist_create_infobox (GtkWidget *box)
{
	GtkWidget *frame, *table, *label, *entry, *img, *hbox;

	frame = gtk_frame_new ("Global User Info");

	table = gtk_table_new (2, 5, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);

	img = gtk_image_new_from_pixbuf (pix_xchat);
	gtk_table_attach (GTK_TABLE (table), img, 4, 5, 0, 2, 0, 0, 0, 0);

	label = gtk_label_new ("Nick Names:");
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
							GTK_FILL, 0, 1, 0);

	entry_nick1 = entry = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1,
							GTK_FILL|GTK_EXPAND, 0, 1, 0);
	gtk_entry_set_text (GTK_ENTRY (entry), prefs.nick1);

	entry_nick2 = entry = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 0, 1,
							GTK_FILL|GTK_EXPAND, 0, 1, 0);
	gtk_entry_set_text (GTK_ENTRY (entry), prefs.nick2);

	entry_nick3 = entry = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 0, 1,
							GTK_FILL|GTK_EXPAND, 0, 1, 0);
	gtk_entry_set_text (GTK_ENTRY (entry), prefs.nick3);

	label = gtk_label_new ("User Name:");
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
							GTK_FILL, 0, 1, 0);

	entry_username = entry = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2,
							GTK_FILL|GTK_EXPAND, 0, 1, 0);
	gtk_entry_set_text (GTK_ENTRY (entry), prefs.username);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_table_attach (GTK_TABLE (table), hbox, 2, 4, 1, 2,
							GTK_FILL|GTK_EXPAND, 0, 1, 0);

	label = gtk_label_new ("Real Name:");
	gtk_box_pack_start (GTK_BOX (hbox), label, 0, 0, 10);

	entry_realname = entry = gtk_entry_new ();
	gtk_container_add (GTK_CONTAINER (hbox), entry);
	gtk_entry_set_text (GTK_ENTRY (entry), prefs.realname);

	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_box_pack_start (GTK_BOX (box), frame, 0, 0, 0);
}

static void
servlist_save (void)
{
	strcpy (prefs.nick1, GTK_ENTRY (entry_nick1)->text);
	strcpy (prefs.nick2, GTK_ENTRY (entry_nick2)->text);
	strcpy (prefs.nick3, GTK_ENTRY (entry_nick3)->text);
	strcpy (prefs.username, GTK_ENTRY (entry_username)->text);
	strcpy (prefs.realname, GTK_ENTRY (entry_realname)->text);
}

static gint
servlist_delete_cb (GtkWidget *win, GdkEventAny *event, gpointer userdata)
{
	servlist_save ();
	return FALSE;
}

static void
servlist_close_cb (GtkWidget *button, gpointer userdata)
{
	servlist_save ();
	gtk_widget_destroy (serverlist_win);
}

static void
servlist_connect_cb (GtkWidget *button, gpointer userdata)
{
	if (is_session (servlist_sess))
	{
		servlist_connect (servlist_sess, selected_net);
		gtk_widget_destroy (serverlist_win);
	}
}

static void
servlist_connectnew_cb (GtkWidget *button, gpointer userdata)
{
	session *sess;

	sess = new_ircwindow (NULL, NULL, SESS_SERVER);
	servlist_connect (sess, selected_net);
	gtk_widget_destroy (serverlist_win);
}

static void
servlist_create_buttons (GtkWidget *box)
{
	GtkWidget *hbox, *but;

	hbox = gtk_hbutton_box_new ();
	gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_SPREAD);

	connect_button = but = gtk_button_new_with_mnemonic (_("C_onnect"));
	g_signal_connect (G_OBJECT (but), "clicked",
							G_CALLBACK (servlist_connect_cb), 0);
	gtk_widget_set_sensitive (but, FALSE);
	gtk_box_pack_start (GTK_BOX (hbox), but, 0, 0, 0);

	connectnew_button = but = gtk_button_new_with_mnemonic (_("Connect in a _new tab"));
	g_signal_connect (G_OBJECT (but), "clicked",
							G_CALLBACK (servlist_connectnew_cb), 0);
	gtk_widget_set_sensitive (but, FALSE);
	gtk_box_pack_start (GTK_BOX (hbox), but, 0, 0, 0);

	but = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	g_signal_connect (G_OBJECT (but), "clicked",
							G_CALLBACK (servlist_close_cb), 0);
	gtk_box_pack_start (GTK_BOX (hbox), but, 0, 0, 0);

	gtk_box_pack_end (GTK_BOX (box), hbox, 0, 0, 0);
}

static GtkWidget *
servlist_create_servlistbox (GtkWidget *box)
{
	GtkWidget *vbox, *tree;

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (box), vbox);

	tree = gtkutil_create_list (vbox, _("Servers"), NULL);
#if 0
	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_end (GTK_BOX (vbox), hbox, 0, 0, 0);

	but = gtk_button_new_with_label ("Add Server");
	gtk_container_add (GTK_CONTAINER (hbox), but);

	but = gtk_button_new_with_label ("Delete Server");
	gtk_container_add (GTK_CONTAINER (hbox), but);
#endif
	return tree;
}

static void
servlist_create_editbox (GtkWidget *box)
{
	GtkWidget *table, *vbox, *hbox, *frame;

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 3);

	hbox = gtk_hbox_new (FALSE, 3);
	gtk_container_add (GTK_CONTAINER (vbox), hbox);

	servers_tree = servlist_create_servlistbox (hbox);

	table = gtk_table_new (10, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);

	entry_netname = servlist_create_entry (table, _("Network Name:"), 0, TRUE);
	servlist_create_entry (table, _("Nick Name:"), 1, FALSE);
	servlist_create_entry (table, _("User Name:"), 2, FALSE);
	servlist_create_entry (table, _("Real Name:"), 3, FALSE);
	servlist_create_entry (table, _("Server Password:"), 4, TRUE);
	servlist_create_entry (table, _("Join Channels:"), 5, TRUE);
	servlist_create_entry (table, _("Connect Command:"), 6, TRUE);
	gtk_container_add (GTK_CONTAINER (hbox), table);

	table = gtk_table_new (2, 3, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	servlist_create_check (table, 7, 0, _("Cycle until connected"));
	servlist_create_check (table, 7, 1, _("Use global user info"));
	servlist_create_check (table, 7, 2, _("Use secure socket layer (SSL)"));
	servlist_create_check (table, 8, 0, _("Auto connect at startup"));
	servlist_create_check (table, 8, 1, _("Use a proxy server"));
	servlist_create_check (table, 8, 2, _("Accept invalid certificate"));
	gtk_box_pack_end (GTK_BOX (vbox), table, 0, 0, 0);

	editbox = frame = gtk_frame_new (_("Settings for Selected Network"));
	gtk_container_add (GTK_CONTAINER (frame), vbox);
	gtk_paned_add2 (GTK_PANED (box), frame);
}

static void
servlist_editmode_cb (GtkToggleButton *but, gpointer userdata)
{
	if (gtk_toggle_button_get_active (but))
	{
	  	servlist_networks_populate (networks_tree, network_list, TRUE);
		gtk_widget_show (editbox);
		return;
	}

	servlist_networks_populate (networks_tree, network_list, FALSE);
	gtk_widget_hide (editbox);
}

static GtkWidget *
servlist_create_list (GtkWidget *box)
{
	GtkWidget *vbox, *hbox, *pane, *tree, *but;

	pane = gtk_hpaned_new ();
	gtk_container_add (GTK_CONTAINER (box), pane);
	gtk_paned_set_position (GTK_PANED (pane), 120);

	hbox = gtk_hbox_new (FALSE, 3);
	gtk_paned_pack1 (GTK_PANED (pane), hbox, TRUE, TRUE);

	vbox = gtk_vbox_new (FALSE, 3);
	gtk_container_add (GTK_CONTAINER (hbox), vbox);

	but = gtk_check_button_new_with_label ("Edit mode");
	g_signal_connect (G_OBJECT (but), "toggled",
							G_CALLBACK (servlist_editmode_cb), 0);
	gtk_box_pack_end (GTK_BOX (vbox), but, 0, 0, 0);

	tree = gtkutil_create_list (vbox, _("Networks"), servlist_network_row_cb);
	servlist_networks_populate (tree, network_list, FALSE);

	servlist_create_editbox (pane);

	return tree;
}

void
servlist_open (session *sess)
{
	GtkWidget *win, *vbox;

	servlist_load ();
	
	servlist_sess = sess;

	serverlist_win = win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (win), _("X-Chat: Server List"));
	gtk_container_set_border_width (GTK_CONTAINER (win), 5);

	g_signal_connect (G_OBJECT (win), "delete_event",
						 	G_CALLBACK (servlist_delete_cb), 0);

	vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (win), vbox);

	servlist_create_infobox (vbox);
	networks_tree = servlist_create_list (vbox);
	servlist_create_buttons (vbox);

	gtk_widget_show_all (win);
	gtk_widget_hide (editbox);
}
