/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define GTK_DISABLE_DEPRECATED

#include <stdio.h>
#include <string.h>

#include "fe-gtk.h"
#include "../common/xchat.h"
#include "gtkutil.h"

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gdk-pixdata.h>

#include "../pixmaps/globe.h"
#include "../pixmaps/server.h"
#include "../pixmaps/admin.h"
#include "../pixmaps/op.h"
#include "../pixmaps/hop.h"
#include "../pixmaps/voice.h"
#include "../pixmaps/xchat.h"
#include "../pixmaps/book.h"

GdkPixbuf *pix_xchat;
GdkPixbuf *pix_book;
GdkPixbuf *pix_admin;
GdkPixbuf *pix_op;
GdkPixbuf *pix_hop;
GdkPixbuf *pix_voice;

GdkPixmap *pix_globe;
GdkPixmap *pix_server;

GdkBitmap *mask_globe;
GdkBitmap *mask_server;


static GdkPixmap *
pixmap_load_from_file_real (char *file)
{
	GdkPixbuf *img;
	GdkPixmap *pixmap;

	img = gdk_pixbuf_new_from_file(file, 0);
	if (!img)
		return NULL;
	gdk_pixbuf_render_pixmap_and_mask(img, &pixmap, NULL, 128);
	gdk_pixbuf_unref(img);

	return pixmap;
}

GdkPixmap *
pixmap_load_from_file (char *filename)
{
	char buf[256];
	GdkPixmap *pix;

	if (filename[0] == '\0')
		return NULL;

	pix = pixmap_load_from_file_real (filename);
	if (pix == NULL)
	{
		strcpy (buf, "Cannot open:\n\n");
		strcpy (buf + 14, filename);
		gtkutil_simpledialog (buf);
	}

	return pix;
}

static GdkPixmap *
pixmap_render (const guint8 *pixdata, GdkBitmap **mask)
{
	GdkPixbuf *pixbuf;
	GdkPixmap *pixmap;

	pixbuf = gdk_pixbuf_new_from_inline (-1, pixdata, FALSE, 0);
	gdk_pixbuf_render_pixmap_and_mask (pixbuf, &pixmap, mask, 128);
	gdk_pixbuf_unref (pixbuf);

	return pixmap;
}

void
pixmaps_init (void)
{
	pix_book = gdk_pixbuf_new_from_inline (-1, bookpng, FALSE, 0);
	pix_xchat = gdk_pixbuf_new_from_inline (-1, xchatpng, FALSE, 0);

	pix_admin = gdk_pixbuf_new_from_inline (-1, adminxpm, FALSE, 0);
	pix_op = gdk_pixbuf_new_from_inline (-1, opxpm, FALSE, 0);
	pix_hop = gdk_pixbuf_new_from_inline (-1, hopxpm, FALSE, 0);
	pix_voice = gdk_pixbuf_new_from_inline (-1, voicexpm, FALSE, 0);

	pix_globe = pixmap_render (globexpm, &mask_globe);
	pix_server = pixmap_render (serverxpm, &mask_server);
}
