/*
**  Sinek (Media Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  screen saver control
*/

#include "common.h"
#include <X11/extensions/XTest.h>
#include <X11/keysym.h>

static int disabled;
static int timeout, interval, prefer_blanking, allow_exposures;

#ifdef HAVE_XTEST
static int keycode;
static Bool xtest;

static gboolean fake_event(gpointer data)
{
	if(disabled)
	{
		XTestFakeKeyEvent(sinek.display, keycode, True, CurrentTime);
		XTestFakeKeyEvent(sinek.display, keycode, False, CurrentTime);
	}
	return TRUE;
}
#endif


void scrsaver_init(void)
{
#ifdef HAVE_XTEST
	int a, b, c, d;
	xtest = XTestQueryExtension(sinek.display, &a, &b, &c, &d);
	if(xtest == True)
	{
		keycode = XKeysymToKeycode(sinek.display, XK_Shift_L);
		g_timeout_add(15000, (GSourceFunc)fake_event, NULL);
	}
#endif
}


void scrsaver_disable(void)
{
#ifdef HAVE_XTEST
	if(xtest == True)
	{
		disabled = 1;
		return;
	}
#endif
	if(disabled == 0)
	{
		XGetScreenSaver(sinek.display, &timeout, &interval, &prefer_blanking, &allow_exposures);
		XSetScreenSaver(sinek.display, 0, 0, DontPreferBlanking, DontAllowExposures);
		disabled = 1;
	}
}


void scrsaver_enable(void)
{
#ifdef HAVE_XTEST
	if(xtest == True)
	{
		disabled = 0;
		return;
	}
#endif
	if(disabled)
	{
		XSetScreenSaver(sinek.display, timeout, interval, prefer_blanking, allow_exposures);
		disabled = 0;
	}
}
