/*
**  Sinek (Video Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  popup menu
*/

#include "common.h"

static GtkWidget *menu, *autoplay, *w_play, *w_pause, *w_stop;
static GtkWidget *w_repeat_one, *w_repeat_all;

static void popup_update(void);
static void create_list(GtkWidget *parent, char **ids, GCallback func);
static void cb_auto_browse(char *id);
static void cb_menu(GtkWidget *widget, guint action);
static void cb_popup(GtkWidget *widget, guint action);


void popup_init(void)
{
	GtkItemFactoryEntry menus[] =
	{
		{ _("/Sinek"), NULL, NULL, 0, "<Title>" },
		{ "/sep", NULL, NULL, 0, "<Separator>" },
		{ _("/Control"), NULL, NULL, 0, "<Branch>" },
		{ _("/Control/Open File..."), "", cb_popup, 17, "<StockItem>", GTK_STOCK_OPEN },
		{ _("/Control/Next"), NULL, cb_menu, CMD_NEXT, "<StockItem>", GTK_STOCK_GO_FORWARD },
		{ _("/Control/Previous"), NULL, cb_menu, CMD_PREVIOUS, "<StockItem>", GTK_STOCK_GO_BACK },
		{ _("/Control/Autoplay"), NULL, NULL, 0, "<Branch>" },
		{ _("/Control/sep"), NULL, NULL, 0, "<Separator>" },
		{ _("/Control/Play"), NULL, cb_menu, CMD_PLAY, "<RadioItem>" },
		{ _("/Control/Pause"), NULL, cb_menu, CMD_PAUSE, _("/Control/Play") },
		{ _("/Control/Stop"), NULL, cb_menu, CMD_STOP, _("/Control/Pause") },
		{ _("/Control/sep"), NULL, NULL, 0, "<Separator>" },
		{ _("/Control/Repeat Current"), NULL, cb_menu, CMD_TOGGLE_REPEAT, "<CheckItem>" },
		{ _("/Control/Repeat List"), NULL, cb_menu, CMD_TOGGLE_REPEAT_ALL, "<CheckItem>" },
		{ _("/Display"), NULL, NULL, 0, "<Branch>" },
		{ _("/Display/1x1 Size"), NULL, cb_menu, CMD_WINDOW_1x1, NULL },
		{ _("/Display/2x2 Size"), NULL, cb_menu, CMD_WINDOW_2x2, NULL },
		{ _("/Display/Full Screen"), NULL, cb_menu, CMD_WINDOW_FULLSCREEN, NULL },
		{ _("/Display/sep"), NULL, NULL, 0, "<Separator>" },
		{ _("/Display/Toggle Windows"), NULL, cb_menu, CMD_TOGGLE_GUI, NULL },
		{ _("/Display/Show Control Panel"), NULL, cb_menu, CMD_SHOW_CONTROLS, NULL },
		{ _("/Display/Show Video Output"), NULL, cb_menu, CMD_SHOW_VIDEO, NULL },
		{ _("/Display/Show Playlist"), NULL, cb_menu, CMD_SHOW_PLAYLIST, NULL },
		{ _("/Subtitle"), NULL, NULL, 0, "<Branch>" },
		{ _("/Subtitle/Open..."), "", cb_popup, 4, "<StockItem>", GTK_STOCK_OPEN },
		{ _("/Subtitle/Toggle"), NULL, cb_menu, CMD_TOGGLE_SUBTITLES, NULL },
		{ _("/Subtitle/Set Position"), NULL, cb_popup, 1, NULL },
		{ _("/Subtitle/Select Font..."), NULL, cb_popup, 0, NULL },
		{ _("/Subtitle/Editor"), NULL, cb_popup, 42, NULL },
#ifdef USE_GUILE
		{ _("/Scripts"), NULL, NULL, 0, "<Branch>" },
		{ _("/Scripts/Execute..."), "", cb_popup, 666, "<StockItem>", GTK_STOCK_EXECUTE },
#endif
		{ "/sep", NULL, NULL, 0, "<Separator>" },
		{ _("/Video Properties"), NULL, cb_menu, CMD_SHOW_TUNER, NULL },
		{ _("/Key Bindings"), NULL, cb_menu, CMD_SHOW_KEYS, NULL },
		{ _("/Settings"), NULL, cb_menu, CMD_SHOW_PREFS, NULL },
		{ "/sep", NULL, NULL, 0, "<Separator>" },
		{ _("/About"), NULL, cb_menu, CMD_SHOW_ABOUT, NULL },
		{ _("/Quit"), NULL, cb_menu, CMD_QUIT, NULL },
	};
	GtkItemFactory *fabrika;
	gint n = sizeof(menus) / sizeof(menus[0]);
	char **ids;

	fabrika = gtk_item_factory_new(GTK_TYPE_MENU, "<main>", NULL);
	gtk_item_factory_create_items(fabrika, n, menus, NULL);
	menu = gtk_item_factory_get_widget(fabrika, "<main>");

	autoplay = gtk_item_factory_get_widget(fabrika, _("/Control/Autoplay"));
	ids = xine_get_autoplay_input_plugin_ids(sinek.xine);
	create_list(autoplay, ids, GTK_SIGNAL_FUNC(cb_auto_browse));

	w_play = gtk_item_factory_get_widget(fabrika, _("/Control/Play"));
	w_pause = gtk_item_factory_get_widget(fabrika, _("/Control/Pause"));
	w_stop = gtk_item_factory_get_widget(fabrika, _("/Control/Stop"));

	w_repeat_one = gtk_item_factory_get_widget(fabrika, _("/Control/Repeat Current"));
	w_repeat_all = gtk_item_factory_get_widget(fabrika, _("/Control/Repeat List"));
}


void popup_pop(int time)
{
	int i = 0;

	popup_update();
	while(i < 25)
	{
		gdk_flush();
		gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, time);
		if(gdk_pointer_is_grabbed()) break;
		i++;
	}
}


static void popup_update(void)
{
	int b1 = FALSE, b2 = FALSE, b3 = FALSE;

	sinek.signal_fake = 1;

	if(sinek.playing && sinek.pause)
		b2 = TRUE;
	else if(sinek.playing)
		b1 = TRUE;
	else
		b3 = TRUE;

	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w_play), b1);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w_pause), b2);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w_stop), b3);

	if(sinek.repeat_one != GTK_CHECK_MENU_ITEM(w_repeat_one)->active)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w_repeat_one), sinek.repeat_one);
	}
	if(sinek.repeat_all != GTK_CHECK_MENU_ITEM(w_repeat_all)->active)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w_repeat_all), sinek.repeat_all);
	}

	sinek.signal_fake = 0;
}


static void cb_auto_browse(char *id)
{
	GtkWidget *popup;
	int num;
	char **mrls;

	mrls = xine_get_autoplay_mrls(sinek.xine, id, &num);
	if(!mrls) return;
	if(num == 1)
	{
		video_play(*mrls);
		return;
	}
	popup = gtk_menu_new();
	create_list(popup, mrls, G_CALLBACK(video_play));
	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 0, GDK_CURRENT_TIME);
}


static void cb_menu(GtkWidget *widget, guint action)
{
	if(sinek.signal_fake) return;
	execute_cmd((cmd_type)action);
}


static void cb_popup(GtkWidget *widget, guint action)
{
	switch(action)
	{
		case 0:
			osd_font_selection();
			break;
		case 1:
			sinek.osd_place = 1;
			break;
		case 4:
			select_file(osd_load, _("Select subtitle file..."));
			break;
		case 17:
			file_request(FALSE);
			break;
		case 42:
			wm_show(subtitle_build);
			break;
#ifdef USE_GUILE
		case 666:
			select_file(guile_execute, _("Select a Scheme script..."));
			break;
#endif
	}
}


static void create_list(GtkWidget *parent, char **ids, GCallback func)
{
	GtkWidget *item;
	char *id;

	id = *ids++;
	while(id)
	{
		item = gtk_menu_item_new_with_label(id);
		gtk_widget_show(item);
		gtk_menu_shell_append(GTK_MENU_SHELL(parent), item);
		g_signal_connect_swapped(G_OBJECT(item), "activate", func, (gpointer)id);
		id = *ids++;
	}
}
