/*
**  Sinek (Media Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  on screen display
*/

#include "common.h"

#include <gdk/gdkx.h>

static osd_renderer_t *osd_renderer;
static osd_object_t *osd;
static GC gc;
static Pixmap px;
static XImage *ximg;
static GdkFont *gdkfont;
static int osd_h, osd_w, osd_x, osd_y, osd_pos;

static char *placetext[] =
{
	N_("Move subtitles with mouse and,"),
	N_("click mouse button when they are in place"),
	NULL
};

static void show_subtitle(char **title);
static int fontsel_build(GtkWidget **win);


void osd_init(void)
{
	placetext[0] = gettext(placetext[0]);
	placetext[1] = gettext(placetext[1]);

	wm_build(fontsel_build);

	osd_pos = media->conf->register_range(media->conf, "sinek.subtitle_pos", 85, 0, 99, NULL, NULL, NULL, NULL);

	osd_renderer = xine_get_osd_renderer(sinek.xine);
	osd = osd_renderer->new_object(osd_renderer, 400, 100);

	gc = XCreateGC(sinek.display, sinek.video_win, 0, NULL);
	px = XCreatePixmap(sinek.display, sinek.video_win, 400, 100, sinek.depth);
}


void osd_show(void)
{
	sinek.osd_subtitles = 1;
	osd_update();
}


void osd_hide(void)
{
	sinek.osd_subtitles = 0;
	osd_update();
}


void osd_display(char **text)
{
	int i, j, tw = 0, th = 0, len;

	XSetBackground(sinek.display, gc, 0);
	XSetForeground(sinek.display, gc, 0);
	XFillRectangle(sinek.display, px, gc, 0, 0, 400, 100);
	XSetForeground(sinek.display, gc, 15);
	if(gdkfont)
	{
		int w, h;
		XSetFont(sinek.display, gc, gdk_font_id(gdkfont));
		for(i = 0; text[i]; i++)
		{
			len = strlen(text[i]);
			h = gdk_text_height(gdkfont, text[i], len);
			w = gdk_text_width(gdkfont, text[i], len);
			XDrawString(sinek.display, px, gc, 10, th + h + 2, text[i], len);
			th = th + h + 2;
			if(w > tw) tw = w;
		}
		th += 10;
		tw += 15;
	}
	if(tw > 398) tw = 398;
	if(th > 98) th = 98;
	osd_w = tw;
	osd_h = th;
	ximg = XGetImage(sinek.display, px, 0, 0, 400, 100, sinek.depth, 1);
	osd_renderer->clear(osd);
	osd_renderer->filled_rect(osd, 10, 2, tw, th, 3);
	for(i = 0; i < th; i++)
	{
		for(j = 0; j < tw; j++)
		{
			if(XGetPixel(ximg, j, i))
			{
				osd_renderer->line(osd, j, i, j+1, i+1, 10);
			}
		}
	}
	osd_renderer->line(osd, 0, 0, 1, 1, 0);
	osd_x = (sinek.vid_w - osd_w) / 2;
	osd_y = sinek.vid_h * osd_pos / 100;
	if(osd_y + osd_h > sinek.vid_h) osd_y = sinek.vid_h - osd_y;
	osd_renderer->set_position(osd, osd_x, osd_y);
	XDestroyImage(ximg);
}


static void show_subtitle(char **title)
{
	static int show = 0;

	if(title)
	{
		if(show) osd_renderer->hide(osd, 0);
		osd_display(title);
		osd_renderer->show(osd, 0);
		show = 1;
	}
	else
	{
		if(show)
		{
			osd_renderer->hide(osd, 0);
			show = 0;
		}
	}
}


void osd_update(void)
{
	static char **old = NULL;
	subtitle_t *sub;
	char **cur;
	unsigned long pos;

	if(sinek.osd_place)
	{
		if(old != placetext)
		{
			show_subtitle(placetext);
			old = placetext;
		}
		return;
	}
	if(sinek.osd_subtitles)
	{
		pos = xine_get_current_time(sinek.xine) * 100;
		sub = subtitle_find(pos);
		if(sub)
		{
			cur = sub->text;
			if(cur != old) show_subtitle(cur);
			old = cur;
		}
		else
		{
			show_subtitle(NULL);
			old = NULL;
		}
	}
	else
	{
		if(old != NULL)
		{
			show_subtitle(NULL);
			old = NULL;
		}
	}
}


void osd_position(int x, int y)
{
	osd_renderer->hide(osd, 0);
	if(sinek.vid_h) osd_pos = y * 100 / sinek.vid_h; else osd_pos = 0;
	osd_y = sinek.vid_h * osd_pos / 100;
	if(osd_y + osd_h > sinek.vid_h) osd_y = sinek.vid_h - osd_y;
	osd_renderer->set_position(osd, osd_x, osd_y);
	osd_renderer->show(osd, 0);
	media->conf->update_num(media->conf, "sinek.subtitle_pos", osd_pos);
}


void osd_load(char *filename)
{
	subtitle_delete();
	subtitle_load(filename);
	osd_show();
}


static void cb_font(GtkWidget *w, GtkFontSelectionDialog *fsd)
{
	GdkFont *font;

	font = gtk_font_selection_dialog_get_font(fsd);
	if(font && gdk_font_id(font))
	{
		gdkfont = font;
		media->conf->update_string(media->conf, "sinek.subtitle_font_name", gtk_font_selection_dialog_get_font_name(fsd));
	}
	gtk_widget_hide(GTK_WIDGET(fsd));
}


void osd_font_selection(void)
{
	wm_show(fontsel_build);
}


static int fontsel_build(GtkWidget **win)
{
	char *font;
	GtkWidget *fontreq, *but;

	fontreq = gtk_font_selection_dialog_new(_("Select Subtitle Font"));
	gtk_container_set_border_width(GTK_CONTAINER(fontreq), 4);
	gtk_window_set_wmclass(GTK_WINDOW(fontreq), "fontsel", "sinek");

	but = GTK_FONT_SELECTION_DIALOG(fontreq)->ok_button;
	gtk_widget_show(but);
	GTK_WIDGET_SET_FLAGS(but, GTK_CAN_DEFAULT);
	g_signal_connect(G_OBJECT(but), "clicked", G_CALLBACK(cb_font), (gpointer)fontreq);

	but = GTK_FONT_SELECTION_DIALOG(fontreq)->cancel_button;
	gtk_widget_show(but);
	GTK_WIDGET_SET_FLAGS(but, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(but), "clicked", G_CALLBACK(gtk_widget_hide), GTK_OBJECT(fontreq));

	font = media->conf->register_string(media->conf, "sinek.subtitle_font_name", "Sans 12", NULL, NULL, NULL, NULL);
	gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fontreq), font);
	gdkfont = gtk_font_selection_dialog_get_font(GTK_FONT_SELECTION_DIALOG(fontreq));

	*win = fontreq;
	return WM_AUTOHIDE;
}
