/*
**  Sinek (Media Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  control window
*/

#include "common.h"

#include "nextmrl.xpm"
#include "prevmrl.xpm"
#include "play.xpm"
#include "stop.xpm"
#include "pause.xpm"
#include "playlist.xpm"
#include "fullscreen.xpm"
#include "repeat.xpm"
#include "norepeat.xpm"
#include "mute.xpm"
#include "nomute.xpm"

#include <X11/Xlib.h>

static GtkWidget *mrl_wid, *time_wid, *info_wid, *vol_wid;
static GtkObject *time_adj, *vol_adj;
static GtkWidget *jump_win = NULL;
static GtkWidget *h_spin, *m_spin, *s_spin;
static int total_h = 0, total_m = 0, total_s = 0;
static int current_h = 0, current_m = 0, current_s = 0;

static void cb_jump(GtkWidget *w, gpointer data);
static void cb_browse(GtkWidget *w, gpointer data);
static void cb_seek(void);
static void cb_mrl(void);
static void cb_volume(GtkAdjustment *tadj);
static int cb_lala(GtkWidget *w, GdkEventButton *ev, gpointer data);


static void register_icons(void)
{
	static GtkStockItem items[] =
	{
		{ STOCK_PREV, NULL, 0, 0, NULL },
		{ STOCK_PLAY, NULL, 0, 0, NULL },
		{ STOCK_PAUSE, NULL, 0, 0, NULL },
		{ STOCK_STOP, NULL, 0, 0, NULL },
		{ STOCK_NEXT, NULL, 0, 0, NULL },
		{ STOCK_PLAYLIST, NULL, 0, 0, NULL },
		{ STOCK_FULLSCREEN, NULL, 0, 0, NULL },
		{ STOCK_REPEAT_ON, NULL, 0, 0, NULL },
		{ STOCK_REPEAT_OFF, NULL, 0, 0, NULL },
		{ STOCK_MUTE_ON, NULL, 0, 0, NULL },
		{ STOCK_MUTE_OFF, NULL, 0, 0, NULL },
	};
	GtkIconFactory *factory;
	GdkPixbuf *pb;
	GtkIconSet *icon;

	gtk_stock_add(items, G_N_ELEMENTS(items));
	factory = gtk_icon_factory_new();
	gtk_icon_factory_add_default(factory);

#define ADD_ICON(x,y) \
	pb = gdk_pixbuf_new_from_xpm_data( (const char **) (y) ); \
	icon = gtk_icon_set_new_from_pixbuf(pb); \
	gtk_icon_factory_add(factory, (x) , icon);

	ADD_ICON(STOCK_PREV, prevmrl_xpm);
	ADD_ICON(STOCK_PLAY, play_xpm);
	ADD_ICON(STOCK_PAUSE, pause_xpm);
	ADD_ICON(STOCK_STOP, stop_xpm);
	ADD_ICON(STOCK_NEXT, nextmrl_xpm);
	ADD_ICON(STOCK_PLAYLIST, playlist_xpm);
	ADD_ICON(STOCK_FULLSCREEN, fullscreen_xpm);
	ADD_ICON(STOCK_REPEAT_ON, repeat_xpm);
	ADD_ICON(STOCK_REPEAT_OFF, norepeat_xpm);
	ADD_ICON(STOCK_MUTE_ON, mute_xpm);
	ADD_ICON(STOCK_MUTE_OFF, nomute_xpm);
}


int control_build(GtkWidget **win)
{
	GtkWidget *control_win;
	GtkWidget *vb, *hb, *hb2, *bb;
	GtkWidget *lab, *b;

	register_icons();

	control_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(control_win), _("Sinek Media Player"));
	gtk_window_set_wmclass(GTK_WINDOW(control_win), "control", "sinek");

	vb = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vb);
	gtk_container_add(GTK_CONTAINER(control_win), vb);
	gtk_container_set_border_width(GTK_CONTAINER(vb), 5);

	hb = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hb);
	gtk_box_pack_start(GTK_BOX(vb), hb, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 2);

	lab = gtk_label_new(_("Media"));
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(hb), lab, FALSE, FALSE, 0);

	mrl_wid = gtk_entry_new();
	gtk_widget_show(mrl_wid);
	gtk_box_pack_start(GTK_BOX(hb), mrl_wid, TRUE, TRUE, 0);
	g_signal_connect(G_OBJECT(mrl_wid), "activate", G_CALLBACK(cb_mrl), NULL);
	add_tooltip(mrl_wid, _("Enter a media resource locator"));

	b = gtk_button_new_from_stock(GTK_STOCK_OPEN);
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(hb), b, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(b), "clicked", G_CALLBACK(cb_browse), NULL);
	add_tooltip(b, _("Open a video file"));

	time_adj = gtk_adjustment_new(0, 0, 0, 1, 0, 0);
	time_wid = gtk_hscale_new(GTK_ADJUSTMENT(time_adj));
	gtk_widget_show(time_wid);
	gtk_box_pack_start(GTK_BOX(vb), time_wid, TRUE, TRUE, 0);
	gtk_scale_set_draw_value(GTK_SCALE(time_wid), FALSE);
	g_signal_connect(G_OBJECT(time_adj), "value_changed", G_CALLBACK(cb_seek), NULL);
	g_signal_connect(G_OBJECT(time_wid), "button_release_event", G_CALLBACK(cb_lala), NULL);
	add_tooltip(time_wid, _("Seek a position"));

	hb2 = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hb2);
	gtk_box_pack_start(GTK_BOX(vb), hb2, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hb2), 1);

	b = gtk_button_new_from_stock(GTK_STOCK_JUMP_TO);
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(hb2), b, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(b), "clicked", G_CALLBACK(cb_jump), NULL);
	add_tooltip(b, _("Jump to a position"));

	info_wid = gtk_entry_new();
	gtk_widget_show(info_wid);
	gtk_box_pack_start(GTK_BOX(hb2), info_wid, FALSE, TRUE, 0);
	gtk_entry_set_width_chars(GTK_ENTRY(info_wid), 20);
	gtk_editable_set_editable(GTK_EDITABLE(info_wid), FALSE);
	GTK_WIDGET_UNSET_FLAGS(info_wid, GTK_CAN_FOCUS);

	lab = gtk_label_new(_("Volume"));
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(hb2), lab, FALSE, FALSE, 0);

	vol_adj = gtk_adjustment_new(audio_get_volume(), 0, 100, 1, 0, 0);
	vol_wid = gtk_hscale_new(GTK_ADJUSTMENT(vol_adj));
	gtk_widget_show(vol_wid);
	gtk_box_pack_start(GTK_BOX(hb2), vol_wid, TRUE, TRUE, 0);
	gtk_scale_set_draw_value(GTK_SCALE(vol_wid), FALSE);
	g_signal_connect(G_OBJECT(vol_adj), "value_changed", G_CALLBACK(cb_volume), NULL);
	add_tooltip(vol_wid, _("Adjust audio volume"));

	bb = gtk_hbox_new(TRUE, 5);
	gtk_widget_show(bb);
	gtk_box_pack_start(GTK_BOX(vb), bb, TRUE, TRUE, 2);
	gtk_container_set_border_width(GTK_CONTAINER(bb), 1);

	b = create_pix_button(STOCK_PREV, CMD_PREVIOUS, _("Previous mrl"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(STOCK_PLAY, CMD_PLAY, _("Play"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(STOCK_PAUSE, CMD_PAUSE, _("Pause"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(STOCK_STOP, CMD_STOP, _("Stop"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(STOCK_NEXT, CMD_NEXT, _("Next mrl"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(STOCK_PLAYLIST, CMD_SHOW_PLAYLIST, _("Open playlist window"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(STOCK_FULLSCREEN, CMD_TOGGLE_FULLSCREEN, _("Toggle fullscreen mode"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	sinek.repeat_tog = create_pix_toggle(STOCK_REPEAT_ON, STOCK_REPEAT_OFF, sinek.repeat_one, CMD_TOGGLE_REPEAT, _("Toggle repeat mode"));
	gtk_container_add(GTK_CONTAINER(bb), sinek.repeat_tog);
	sinek.mute_tog = create_pix_toggle(STOCK_MUTE_ON, STOCK_MUTE_OFF, sinek.mute, CMD_TOGGLE_MUTE, _("Toggle mute mode"));
	gtk_container_add(GTK_CONTAINER(bb), sinek.mute_tog);

	*win = control_win;
	return WM_NORMAL;
}


void control_update_slider(unsigned long cur, unsigned long total)
{
	static char buf[30];

	current_h = cur / 3600;
	current_m = (cur % 3600) / 60;
	current_s = cur % 60;

	total_h = total / 3600;
	total_m = (total % 3600) / 60;
	total_s = total % 60;

	GTK_ADJUSTMENT(time_adj)->upper = total;
	GTK_ADJUSTMENT(time_adj)->value = cur;
	gtk_adjustment_value_changed(GTK_ADJUSTMENT(time_adj));
	sinek.seeking = 0;

	sprintf(buf, "%02d:%02d:%02d of %02d:%02d:%02d", current_h, current_m, current_s, total_h, total_m, total_s);
	gtk_entry_set_text(GTK_ENTRY(info_wid), buf);
}


void control_mrl(char *mrl)
{
	gtk_entry_set_text(GTK_ENTRY(mrl_wid), mrl);
	gtk_editable_set_position(GTK_EDITABLE(mrl_wid), -1);
}


void control_volume(int value)
{
	GTK_ADJUSTMENT(vol_adj)->value = value;
	gtk_adjustment_value_changed(GTK_ADJUSTMENT(vol_adj));
}


static void cb_seek(void)
{
	static char buf[30];
	int secs, h, m, s;

	sinek.seeking = 1;

	secs = GTK_ADJUSTMENT(time_adj)->value;
	h = secs / 3600;
	m = (secs % 3600) / 60;
	s = secs % 60;

	sprintf(buf, "%02d:%02d:%02d of %02d:%02d:%02d", h, m, s, total_h, total_m, total_s);
	gtk_entry_set_text(GTK_ENTRY(info_wid), buf);
}


static void cb_volume(GtkAdjustment *vadj)
{
	audio_set_volume(vadj->value);
}


static int cb_lala(GtkWidget *w, GdkEventButton *ev, gpointer data)
{
	if(sinek.seeking)
	{
		video_seek(GTK_ADJUSTMENT(time_adj)->value);
		sinek.seeking = 0;
	}
	return FALSE;
}


static void cb_mrl(void)
{
	const gchar *mrl;

	mrl = gtk_entry_get_text(GTK_ENTRY(mrl_wid));
	if(!mrl || *mrl == 0) return;
	video_play((char *)mrl);
}


static void cb_browse(GtkWidget *w, gpointer data)
{
	file_request(FALSE);
}


static void cb_jump_go(GtkWidget *w, GtkWidget *win)
{
	int h, m, s, secs;

	h = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(h_spin));
	m = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(m_spin));
	s = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(s_spin));
	secs = h * 3600 + m * 60 + s;
	video_seek(secs);
	gtk_widget_hide(win);
}


static void cb_jump(GtkWidget *w, gpointer data)
{
	GtkObject *adj;
	GtkWidget *vb, *fr, *hb, *b;

	if(jump_win) goto out;

	jump_win = gtk_dialog_new();
	gtk_dialog_set_has_separator(GTK_DIALOG(jump_win), FALSE);
	gtk_window_set_title(GTK_WINDOW(jump_win), _("Go to..."));

	vb = GTK_DIALOG(jump_win)->vbox;
	gtk_widget_show(vb);
	fr = gtk_frame_new(NULL);
	gtk_widget_show(fr);
	gtk_box_pack_start(GTK_BOX(vb), fr, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(fr), 5);

	hb = gtk_hbox_new(TRUE, 0);
	gtk_widget_show(hb);
	gtk_container_add(GTK_CONTAINER(fr), hb);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 5);

	adj = gtk_adjustment_new(current_h, 0, 100, 1, 0, 0);
	h_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_widget_show(h_spin);
	gtk_box_pack_start(GTK_BOX(hb), h_spin, FALSE, FALSE, 0);

	adj = gtk_adjustment_new(current_m, 0, 60, 1, 0, 0);
	m_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_widget_show(m_spin);
	gtk_box_pack_start(GTK_BOX(hb), m_spin, FALSE, FALSE, 0);

	adj = gtk_adjustment_new(current_s, 0, 60, 1, 0, 0);
	s_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_widget_show(s_spin);
	gtk_box_pack_start(GTK_BOX(hb), s_spin, FALSE, FALSE, 0);

	hb = GTK_DIALOG(jump_win)->action_area;
	gtk_widget_show(hb);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 10);

	b = gtk_button_new_from_stock(GTK_STOCK_JUMP_TO);
	gtk_widget_show(b);
	gtk_container_add(GTK_CONTAINER(hb), b);
	g_signal_connect(G_OBJECT(b), "clicked", G_CALLBACK(cb_jump_go), jump_win);

	b = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_widget_show(b);
	gtk_container_add(GTK_CONTAINER(hb), b);
	g_signal_connect_swapped(G_OBJECT(b), "clicked", G_CALLBACK(gtk_widget_hide), GTK_OBJECT(jump_win));

	wm_manage(jump_win, WM_AUTOHIDE);
out:
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(h_spin), current_h);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(m_spin), current_m);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(s_spin), current_s);
	gtk_window_present(GTK_WINDOW(jump_win));
}
