/*
**  Sinek (Media Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  audio
*/

#include "common.h"

static int volume = 0;
static int mixercaps = 0;
static int mixer = 0;

int audio_init(void)
{
	sinek_audio_set_output(media);

	sinek.xine = media->xine;
	xine_select_audio_channel(sinek.xine, sinek.audio_channel);
	xine_select_spu_channel(sinek.xine, sinek.spu_channel);

	mixercaps = xine_get_audio_capabilities(sinek.xine);
	if(mixercaps & AO_CAP_PCM_VOL)
		mixer = AO_PROP_PCM_VOL;
	else if(mixercaps & AO_CAP_MIXER_VOL)
		mixer = AO_PROP_MIXER_VOL;

	if(mixercaps & (AO_CAP_PCM_VOL | AO_CAP_MIXER_VOL))
		volume = xine_get_audio_property(sinek.xine, mixer);

	return 1;
}


void audio_slide_volume(int value)
{
	audio_set_volume(volume + value);
	control_volume(volume);
}


void audio_set_volume(int value)
{
	volume = value;
	if(volume < 0) volume = 0;
	if(volume > 100) volume = 100;

	if(mixercaps & (AO_CAP_MIXER_VOL | AO_CAP_PCM_VOL))
	{
		xine_set_audio_property(sinek.xine, mixer, volume);
	}
}


int audio_get_volume(void)
{
	return volume;
}


void audio_toggle_mute(void)
{
	if(mixercaps & AO_CAP_MUTE_VOL)
	{
		sinek.mute = ~sinek.mute;
		xine_set_audio_property(sinek.xine, AO_PROP_MUTE_VOL, sinek.mute);
	}
}
