/*
**  Sinek (Media Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  about window
*/

#include "common.h"

#include "sinek.xpm"


int about_build(GtkWidget **win)
{
	GtkWidget *w, *vb, *vb2, *vb3, *lab, *hb, *b, *logo;
	GdkPixbuf *pb;
	char *tmp;

	w = gtk_dialog_new();
	gtk_dialog_set_has_separator(GTK_DIALOG(w), FALSE);
	gtk_window_set_title(GTK_WINDOW(w), _("About this fine product..."));
	gtk_window_set_position(GTK_WINDOW(w), GTK_WIN_POS_CENTER);

	vb = GTK_DIALOG(w)->vbox;

	b = gtk_frame_new(NULL);
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(vb), b, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(b), 5);

	vb2 = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vb2);
	gtk_container_add(GTK_CONTAINER(b), vb2);
	gtk_container_set_border_width(GTK_CONTAINER(vb2), 5);

	hb = gtk_hbox_new(TRUE, 0);
	gtk_widget_show(hb);
	gtk_box_pack_start(GTK_BOX(vb2), hb, FALSE, FALSE, 0);

	pb = gdk_pixbuf_new_from_xpm_data((const char **)sinek_xpm);
	logo = gtk_image_new_from_pixbuf(pb);
	gtk_widget_show(logo);
	gtk_box_pack_start(GTK_BOX(hb), logo, FALSE, FALSE, 0);

	vb3 = gtk_vbox_new(TRUE, 0);
	gtk_widget_show(vb3);
	gtk_box_pack_start(GTK_BOX(hb), vb3, TRUE, FALSE, 0);

	lab = gtk_label_new("");
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb3), lab, FALSE, FALSE, 0);

	tmp = g_strdup_printf(_("Media Player V%s "), VERSION);
	lab = gtk_label_new(tmp);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb3), lab, FALSE, FALSE, 0);

	lab = create_url("http://sinek.sourceforge.net");
	gtk_box_pack_start(GTK_BOX(vb3), lab, FALSE, FALSE, 0);

	lab = gtk_label_new("");
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb3), lab, FALSE, FALSE, 0);

	lab = gtk_label_new(_("Copyright (C) 2001-2002 Gürer Özen <madcat@users.sf.net>"));
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	tmp = g_strdup_printf(_("Powered by libxine v%d.%d.%d"), xine_get_major_version(), xine_get_minor_version(), xine_get_sub_version());
	lab = gtk_label_new(tmp);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	b = gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_widget_show(b);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(w)->action_area), b, FALSE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(b, GTK_CAN_DEFAULT);
	gtk_widget_grab_focus(b);
	g_signal_connect_swapped(G_OBJECT(b), "clicked", G_CALLBACK(gtk_widget_hide), G_OBJECT(w));

	*win = w;
	return WM_MENU;
}
