/*
** iksemel (XML Parser for Jabber)
** Copyright (C) 2000-2001 Gurer Ozen <palpa@jabber.org>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
**
** library API
*/

#ifndef IKSEMEL_H
#define IKSEMEL_H 1

#ifdef __cplusplus
extern "C" {
#endif

/*****  utility.c  *****/

typedef struct ikspool_s
{
	struct ikspool_s *next;
	int max;
	int len;
	char *data;
} ikspool;

struct ikstrnode
{
	struct ikstrnode *next;
	char *data;
	int len;
};

typedef struct ikstr_s
{
	struct ikstrnode *first;
	struct ikstrnode *last;
	ikspool *p;
	int flag;
	int len;
} ikstr;



/*****  iks.c  *****/

enum ikstype
{
	IKS_NONE,
	IKS_TAG,
	IKS_ATTRIBUTE,
	IKS_CDATA
};

typedef struct iks_s
{
	struct iks_s *next;
	struct iks_s *prev;
	struct iks_s *parent;
	struct iks_s *children;
	struct iks_s *lastchild;
	struct iks_s *attribs;
	struct iks_s *lastattrib;
	enum ikstype type;
	ikspool *p;
	char *name;
	char *cdata;
	int len;
} iks;


/*****  parser.c  *****/

enum iksrettype
{
	IKS_RET_OK,
	IKS_RET_NOMEM,
	IKS_RET_BADXML,
	IKS_RET_HOOK
};

#define IKS_DIR_IN 0
#define IKS_DIR_OUT 1

typedef void (iksTagStart)(void *udata, char *name, char **atts);
typedef void (iksTagEnd)(void *udata, char *name);
typedef void (iksCharData)(void *udata, char *data, int len);

typedef struct iksparser_s
{
	iks **iksptr;
	iksTagStart *tagStart;
	iksTagEnd *tagEnd;
	iksCharData *charData;
	void *udata;
	void *udata2;
	iks *current;
#ifdef IKSEMEL_EXPAT
	XML_Parser expat;
#else
	char *buffer;
	int buflen;
	int minpos;
	int context;
	int oldcontext;
	char *tagname;
	int tagflag;
	char **atts;
	int attcur;
	int attmax;
	int valflag;
	int entpos;
	char entity[8];
#endif
} iksparser;


/*****  prototypes  *****/

ikspool *iks_pool_new(int pagesize);
void *iks_pool_alloc(ikspool *p, int size);
char *iks_pool_strdup(ikspool *p, const char *src);
void iks_pool_delete(ikspool *p);
char *iks_strdup(const char *src);
char *iks_strcat(char *dest, const char *src);
int iks_strcmp(const char *a, const char *b);
int iks_strcasecmp(const char *a, const char *b);
int iks_strncmp(const char *a, const char *b, int n);
int iks_strncasecmp(const char *a, const char *b, int n);
int iks_strlen(const char *src);
ikstr *iks_str_new(ikspool *p);
void iks_str_add(ikstr *s, char *src);
void iks_spool(ikstr *s, ...);
char *iks_str_print(ikstr *s);
void iks_str_delete(ikstr *s);
char *iks_escape(ikspool *p, char *src, int len);
char *iks_unescape(ikspool *p, char *src, int len);


iks *iks_new(const char *name);
iks *iks_new_pool(ikspool *p, const char *name);
iks *iks_insert(iks *x, const char *name);
iks *iks_insert_cdata(iks *x, const char *data, int len);
iks *iks_insert_attrib(iks *x, const char *name, const char *value);
iks *iks_insert_node(iks *x, iks *y);
void iks_hide(iks *x);
void iks_delete(iks *x);
iks *iks_next(iks *x);
iks *iks_prev(iks *x);
iks *iks_parent(iks *x);
iks *iks_child(iks *x);
iks *iks_attrib(iks *x);
iks *iks_find(iks *x, const char *name);
char *iks_find_cdata(iks *x, const char *name);
char *iks_find_attrib(iks *x, const char *name);
ikspool *iks_pool(iks *x);
enum ikstype iks_type(iks *x);
char *iks_name(iks *x);
char *iks_cdata(iks *x);
int iks_cdata_size(iks *x);
int iks_has_children(iks *x);
int iks_has_attribs(iks *x);
ikstr *iks_string(ikspool *p, iks *x);
int iks_compare(iks *x, iks *y);
iks *iks_duplicate(iks *x);


iksparser *iks_dom_new(iks **iksptr);
iksparser *iks_sax_new(void *udata, iksTagStart *ts, iksTagEnd *te, iksCharData *cd);
void iks_parser_delete(iksparser *prs);
int iks_parse(iksparser *prs, char *data, int len, int finish);


iks *iks_load(char *fname);
int iks_save(char *fname, iks *x);



#ifdef __cplusplus
}
#endif

#endif  /* IKSEMEL_H */
