/*
**  Sinek (Media Player)
**  Copyright (c) 2001-2002 Gurer Ozen
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  future library API
*/

#ifndef SINEK_H
#define SINEK_H

#include <xine.h>


typedef struct sinek_x11_struct
{
	int frame_w, frame_h;
	int win_x, win_y, win_w, win_h;
	int out_x, out_y, out_w, out_h;
	Display *display;
	int screen;
	Drawable drawable;
	void (*frame_out_cb)(void *user_data, struct sinek_x11_struct *display_info);
	void *user_data;
} sinek_x11_type;

typedef struct sinek_struct
{
	xine_t *xine;
	config_values_t *conf;
	vo_driver_t *vd;
	ao_driver_t *ad;
	char *mrl;
	sinek_x11_type *display_info;
} sinek_type;


/* management of sinek objects */
sinek_type *sinek_new(void);
void sinek_delete(sinek_type *s);

/* video output */
int sinek_video_set_output(sinek_type *s, void *display_info);
void sinek_video_event(sinek_type *s, void *event);

/* audio output */
int sinek_audio_set_output(sinek_type *s);

/* player controls */
int sinek_open(sinek_type *s, const char *mrl);
void sinek_play(sinek_type *s);
void sinek_seek(sinek_type *s, unsigned long secs);
void sinek_stop(sinek_type *s);



#endif    /* SINEK_H */
