/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2019, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.undertow.session;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumSet;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.jboss.as.web.session.SharedSessionManagerConfig;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

/**
 * @author Paul Ferraro
 */
@RunWith(value = Parameterized.class)
public class SharedSessionConfigXMLReaderTestCase {

    @Parameters
    public static Iterable<SharedSessionConfigSchema> parameters() {
        return EnumSet.allOf(SharedSessionConfigSchema.class);
    }

    private final SharedSessionConfigSchema schema;

    public SharedSessionConfigXMLReaderTestCase(SharedSessionConfigSchema schema) {
        this.schema = schema;
    }

    @Test
    public void test() throws IOException, XMLStreamException {
        URL url = this.getClass().getResource(String.format("shared-session-config-%d.%d.xml", this.schema.major(), this.schema.minor()));
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.schema.getRoot(), new SharedSessionConfigXMLReader(this.schema, PropertyReplacers.noop()));
        try (InputStream input = url.openStream()) {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            SharedSessionManagerConfig config = new SharedSessionManagerConfig();
            mapper.parseDocument(config, reader);

            Assert.assertTrue(config.isDistributable());
            Assert.assertEquals(10, config.getMaxActiveSessions().intValue());
            Assert.assertEquals("/", config.getSessionConfig().getCookieConfig().getPath());
        } finally {
            mapper.unregisterRootAttribute(this.schema.getRoot());
        }
    }
}
