/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.manualmode.weld.extension;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;

/**
 * @author Ryan Emerson
 */
public class BeforeShutdownExtension implements Extension {

    private UserTransaction userTx = null;
    private TransactionSynchronizationRegistry txSynchRegistry = null;

    public void lookupBeforeShutdown(@Observes final BeforeShutdown beforeShutdown) throws Exception {
        try {
            userTx = lookup("java:jboss/UserTransaction");
            userTx.getStatus();

            txSynchRegistry = lookup("java:jboss/TransactionSynchronizationRegistry");
            txSynchRegistry.getTransactionStatus();
        } catch (Exception e) {
            writeOutput(e);
            throw e;
        }
        writeOutput(null);
    }

    private <T> T lookup(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            return (T) initialContext.lookup(jndiName);
        } catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    // Necessary so that BeforeShutdownJNDILookupTestCase can see the outcome of the BeforeShutdown JNDI lookups.
    private void writeOutput(Exception exception) throws Exception {
        File file = new File(BeforeShutdownJNDILookupTestCase.TEST_URL);
        File parent = file.getParentFile();
        if (!parent.exists())
            parent.mkdirs();

        PrintWriter writer = new PrintWriter(file, "UTF-8");
        try {
            if (exception != null) {
                writer.println("Exception");
                writer.println(exception + "," + Arrays.toString(exception.getStackTrace()));
            } else {
                writer.println("UserTransaction");
                writer.println(userTx.toString());
                writer.println("TransactionSynchronizationRegistry");
                writer.println(txSynchRegistry.toString());
            }
        } finally {
            writer.close();
        }
    }
}
