/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.manualmode.jca.moduledeployment;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

import javax.annotation.Resource;
import javax.resource.cci.ConnectionFactory;

/**
 * AS7-5768 -Support for RA module deployment
 *
 * @author <a href="vrastsel@redhat.com">Vladimir Rastseluev</a>
 *         <p/>
 *         Tests for module deployment of resource adapter archive in
 *         uncompressed form with classes in flat form (under package structure)
 *         <p/>
 *         Structure of module is:
 *         modulename
 *         modulename/main
 *         modulename/main/module.xml
 *         modulename/main/META-INF
 *         modulename/main/META-INF/ra.xml
 *         modulename/main/org
 *         modulename/main/org/jboss/
 *         modulename/main/org/jboss/package/
 *         modulename/main/org/jboss/package/First.class
 *         modulename/main/org/jboss/package/Second.class ...
 */
@RunWith(Arquillian.class)
public class TwoRaFlatTestCase extends AbstractModuleDeploymentTestCase {

    protected static final String CF = "java:/testMeRA";
    protected static final String CF1 = "java:/testMeRA1";

    protected static final String RA_FILENAME = "basic.xml";
    protected static final String RA_FILENAME1 = "second.xml";
    protected static final ModelNode ADDRESS = SUBSYSTEM_PATH.clone().add("resource-adapter", "basic");
    protected static final ModelNode ADDRESS1 = SUBSYSTEM_PATH.clone().add("resource-adapter", "second");

    static class ModuleAcDeploymentTestCaseSetup extends
            AbstractModuleDeploymentTestCaseSetup {

        @Override
        protected void doSetup(ManagementClient managementClient) throws Exception {
            addModule(DEFAULT_PATH);
            fillModuleWithFlatClasses(DEFAULT_PATH, "ra1.xml");
            setConfiguration(RA_FILENAME);
            setConfiguration(RA_FILENAME1);
        }

        @Override
        protected void doTearDown(ManagementClient managementClient) throws Exception {
            try {
                remove(ADDRESS);
            } finally {
                try {
                    remove(ADDRESS1);
                } finally {
                    removeModule(DEFAULT_PATH, true);
                }
            }
        }

        @Override
        protected String getSlot() {
            return TwoRaFlatTestCase.class.getSimpleName().toLowerCase();
        }
    }

    private final AbstractModuleDeploymentTestCaseSetup moduleAcDeploymentTestCaseSetup = new ModuleAcDeploymentTestCaseSetup();

    @Override
    protected void doPrepareServer(ManagementClient managementClient) throws Exception {
        moduleAcDeploymentTestCaseSetup.setup(managementClient, CONTAINER);
    }

    @Override
    protected void doTearDownServer(ManagementClient managementClient) throws Exception {
        moduleAcDeploymentTestCaseSetup.tearDown(managementClient, CONTAINER);
    }

    /**
     * Define the deployment
     *
     * @return The deployment archive
     */
    @Deployment(name = DEFAULT_DEPLOYMENT, managed = false)
    public static JavaArchive getDeployment() throws Exception {
        return createDeployment();
    }

    @Resource(mappedName = CF)
    private ConnectionFactory connectionFactory;
    @Resource(mappedName = CF1)
    private ConnectionFactory connectionFactory1;

    /**
     * Tests connection factory
     *
     * @throws Throwable in case of an error
     */
    @Test
    public void testConnectionFactory() throws Throwable {
        testConnectionFactory(connectionFactory);
    }

    /**
     * Tests connection factory
     *
     * @throws Throwable in case of an error
     */
    @Test
    public void testConnectionFactoryProperties() throws Throwable {
        testJndiObject(CF, "MultipleConnectionFactory1Impl", "name=MCF",
                "name=RA");
    }

    /**
     * Tests connection factory
     *
     * @throws Throwable in case of an error
     */
    @Test
    public void testConnectionFactory1() throws Throwable {
        testConnectionFactory(connectionFactory1);
    }

    /**
     * Tests connection factory
     *
     * @throws Throwable in case of an error
     */
    @Test
    public void testConnectionFactoryProperties1() throws Throwable {
        testJndiObject(CF1, "MultipleConnectionFactory1Impl", "name=MCF",
                "name=RA");
    }

    /**
     * Tests admin object
     *
     * @throws Exception
     */
    @Test
    public void testAdminObject() throws Exception {
        testJndiObject("java:/testAO", "MultipleAdminObject1Impl", "name=AO");
    }

    /**
     * Tests admin object
     *
     * @throws Exception
     */
    @Test
    public void testAdminObject1() throws Exception {
        testJndiObject("java:/testAO1", "MultipleAdminObject1Impl", "name=AO");
    }

    /**
     * Tests connection in pool
     *
     * @throws Exception in case of error
     */
    @Test
    @RunAsClient
    public void testConnection1() throws Exception {
        testConnection(ADDRESS, CF);
    }

    /**
     * Tests connection in pool
     *
     * @throws Exception in case of error
     */
    @Test
    @RunAsClient
    public void testConnection2() throws Exception {
        testConnection(ADDRESS1, CF1);
    }

}
