#!/bin/sh
set -e

SCRIPT_DIR=$(dirname $0)
ADDED_DIR=${SCRIPT_DIR}/added

# Create a user and group used to launch processes
# We use the ID 185 fot the group as well as for the user.
# This ID is registered static ID for the JBoss EAP product
# on RHEL which makes it safe to use.
groupadd -r jboss -g 185 && useradd -u 185 -r -g jboss -m -d /home/jboss -s /sbin/nologin -c "JBoss user" jboss

# Create location and set permissions for configuration files
mkdir -p ${AMQ_HOME}/etc/configmap
chown -R jboss:root ${AMQ_HOME}/etc
chmod -R ug+rwx ${AMQ_HOME}/etc

# Copy launch OpenShift scripts to container
mkdir -p ${AMQ_HOME}/bin
cp -r ${ADDED_DIR}/* ${AMQ_HOME}/bin

chown -R jboss:root ${AMQ_HOME}/bin
chmod -R ug+rx ${AMQ_HOME}/bin
