#


#############################################################
#
# main.sh  (for OpenRDA DBServer DDK)
#
#############################################################


#############################################################
#
#  Platform specific things
#
#############################################################

oa_platform=$PLATFORM

oa_version="v5.6"
oa_version_id="5.6"

dirfile=`pwd`


#############################################################
#
#  Splash screen
#
#############################################################

echo ""

if test $INSTALL = "odbc" 
then
    if test $PLATFORM = "ssunos5" || test $PLATFORM = "ilinux" || test $PLATFORM = "raix" || (test $PLATFORM = "phpux" && test $SUB_PLATFORM = "11")
    then
		echo "Beginning installation of the DataDirect OpenAccess ODBC and JDBC Drivers"
	else
		echo "Beginning installation of the DataDirect OpenAccess ODBC Driver"
	fi
fi

echo "    - Platform: $oa_platform"
echo "    - Version:  $oa_version"
echo ""

#############################################################
#	Display License information
#############################################################
echo "Do you want to continue (Y/N) ? [Y]"
read oa_continue_prompt
if test $oa_continue_prompt = 'Y'
then
	break
elif test $oa_continue_prompt = 'y'
then
	break
else   
	echo "Installation ABORTED by user."   
	exit
fi

more ../../file_set/config/$oa_platform/license.txt
echo "Enter 'YES' to accept the terms of the license or 'NO' to reject the terms of the license (YES/NO):"
read oa_license_reply         # to read from the keyboard input
if  test $oa_license_reply = "YES"  
then
	break
elif test $oa_license_reply = "yes"  
then
	break
else      
	echo "License terms not accepted by user. "
	exit
fi


#############################################################
#
#  Get installation directory
#
#############################################################

inst_dir=""
. ./getdir.sh


#############################################################
#
#  Get overwrite confirmation if already installed
#
#############################################################

junkfile=/dev/null

oa_update="n"
oa_copy_schema="y"
. ./chkupd.sh


#############################################################
#
#  Get the server configuration information
#
#############################################################

oa_server_name=""
oa_server_ip=""
oa_server_port=""
oa_server_descrip=""
oa_client_key=""
#oa_server_key=""

. ./srvrinfo.sh


#############################################################
#
# Create the master list of files to install
#
#############################################################

if test ! -d $inst_dir 
then
	mkdir $inst_dir
	if test ! -d $inst_dir 
	then
		echo "ERROR: Could not create installation directory."
		exit
	fi
elif test ! -w $inst_dir 
then
	echo "ERROR: Insufficient rights (write) for installation directory."
	exit
fi

lstfile=$inst_dir/copy.lst
rm -f $lstfile
touch $lstfile
./file_set.sh $lstfile list $INSTALL


#############################################################
#
# Create directories (using list file for entries)
#
#############################################################

echo "	- Creating general directories..."

filterfile=$inst_dir/filter.sed
mkdirfile=$inst_dir/mkdir.sh
rawfile=$inst_dir/rawfile.lst

# create the sed script to only keep directory portions of files

rm -f $filterfile
touch $filterfile
echo "s#^.\(.*\)/\([A-Za-z0-9\._][A-Za-z0-9\._]*\)#mkdir -p $inst_dir\1#" >> $filterfile

# Filter, then sort (to get unique entries), the list file to get
# the directories to create.

rm -f $rawfile
touch $rawfile
sed -f $filterfile $lstfile >> $rawfile
rm -f $filterfile

rm -f $mkdirfile
touch $mkdirfile
echo "#\!/bin/csh" >> $mkdirfile
sort -u $rawfile >> $mkdirfile
rm -f $rawfile

chmod +x $mkdirfile
. $mkdirfile
rm -f $mkdirfile

if test $INSTALL = "odbc" 
then
	echo "	- Creating $oa_platform specific directories..."
	
	mkdir -p $inst_dir/schema 2>> $junkfile
	mkdir -p $inst_dir/sdk/oaodbc 2>> $junkfile
	mkdir -p $inst_dir/sdk/odbcsamp/bin 2>> $junkfile
	mkdir -p $inst_dir/sdk/odbcsamp/bin/$oa_platform 2>> $junkfile
	mkdir -p $inst_dir/sdk/odbcsamp/obj 2>> $junkfile
	mkdir -p $inst_dir/sdk/odbcsamp/obj/$oa_platform 2>> $junkfile

    if test $PLATFORM = "ssunos5" || test $PLATFORM = "ilinux" || test $PLATFORM = "raix" || (test $PLATFORM = "phpux" && test $SUB_PLATFORM = "11")
    then
        rmdir $inst_dir/jdbc/$PLATFORM 2>> $junkfile
	    mkdir -p $inst_dir/jdbc 2>> $junkfile
    fi
fi

#############################################################
#
# Create the shell files
#
#############################################################

echo "	- Creating shell files..."

if test $INSTALL = "db" 
then
	echo '#\!/bin/csh -f' > $inst_dir/export.sh
	echo '#\!/usr/bin/csh -f' >> $inst_dir/export.sh
	echo "export OPENRDA_INI $inst_dir/config/$PLATFORM/openrda.ini" >> $inst_dir/export.sh

	echo '#\!/bin/csh -f' > $inst_dir/rdastart.sh
	echo '#\!/usr/bin/csh -f' >> $inst_dir/rdastart.sh
	echo "export OPENRDA_INI=$inst_dir/config/$PLATFORM/openrda.ini" >> $inst_dir/rdastart.sh
	echo "nohup $inst_dir/bin/$PLATFORM/oaserver" '&' >> $inst_dir/rdastart.sh
	chmod u+rx $inst_dir/rdastart.sh

	echo '#\!/bin/csh -f' > $inst_dir/showserver.sh
	echo '#\!/usr/bin/csh -f' >> $inst_dir/showserver.sh
	echo "ps -ef | grep oaserver" >> $inst_dir/showserver.sh
	chmod u+rx $inst_dir/showserver.sh
fi

#############################################################
#
# Copy the needed files
#
#############################################################

echo "	- Copying files..."

 cpfile=$inst_dir/cp.sh

# create the sed script to copy files
rm -f $filterfile
touch $filterfile
echo 's#^\(.*\)$#cp \1#' >> $filterfile

rm -f $lstfile
touch $lstfile
./file_set.sh $lstfile setup $INSTALL $inst_dir

rm -f $cpfile
touch $cpfile
echo "#\!/bin/csh" >> $cpfile
sed -f $filterfile $lstfile >> $cpfile
rm -f $filterfile
rm -f $lstfile

chmod +x $cpfile
 olddir=`pwd`
cd ../../file_set
. $cpfile	
cd $olddir
rm -f $cpfile

#############################################################
#
# Copy Client and Server keys
#
#############################################################

echo "	- Copying license files..."

cp $oa_client_key $inst_dir/config/$oa_platform/oaclientkey.lic
#cp $oa_server_key $inst_dir/config/$oa_platform/oaserverkey.lic


#############################################################
#
# Create the INI files
#
#############################################################

echo "	- Creating INI files..."

# create OPENRDA.INI
. ./open_ini.sh

# create OADRD.INI
. ./oadr_ini.sh

# create .ODBC.INI
if test $PLATFORM = "ssunos5"  || test $PLATFORM = "phpux" || test $PLATFORM = "ilinux" || test $PLATFORM = "raix" || test $PLATFORM = "aunix"
then
. ./odbc_ini.sh
fi


#############################################################
#
# Set the initial file rights
#
#############################################################

echo "	- Setting rights on files..."

find $inst_dir/bin -depth -type f -exec chmod 755 {} \; 
find $inst_dir/config -depth -type f -exec chmod 644 {} \; 
find $inst_dir/schema -depth -type f -exec chmod 666 {} \; 
find $inst_dir/bin -depth -type d -exec chmod 755 {} \; 
find $inst_dir/config -depth -type d -exec chmod 755 {} \; 
find $inst_dir/schema -depth -type d -exec chmod 777 {} \; 

if test $INSTALL = "odbc" 
then
	find $inst_dir/inc -depth -type f -exec chmod 644 {} \; 
	find $inst_dir/lib -depth -type f -exec chmod 644 {} \; 
	find $inst_dir/sdk -depth -type f -exec chmod 666 {} \; 
	find $inst_dir/inc -depth -type d -exec chmod 755 {} \; 
	find $inst_dir/lib -depth -type d -exec chmod 755 {} \; 
	find $inst_dir/sdk -depth -type d -exec chmod 777 {} \; 
fi

if test $PLATFORM = "phpux" && test $INSTALL = "odbc" 
then
    if (test $OA_ARCHITECTURE = "_ia64")
	then
		# files with 64-bit install
		chmod +x $inst_dir/lib/$PLATFORM/liboajdbc.so
		chmod +x $inst_dir/lib/$PLATFORM/oaodbc.so
		chmod +x $inst_dir/lib/$PLATFORM/libodbc*.so
		chmod +x $inst_dir/lib/$PLATFORM/libddicu23.so
		chmod +x $inst_dir/lib/$PLATFORM/odbccurs.so
		chmod +x $inst_dir/lib/$PLATFORM/odbctrac.so
		chmod +x $inst_dir/lib/$PLATFORM/vscnctdlg.so
	else
		# files with 32-bit install
		chmod +x $inst_dir/lib/$PLATFORM/liboajdbc.sl
		chmod +x $inst_dir/lib/$PLATFORM/oaodbc.sl
		chmod +x $inst_dir/lib/$PLATFORM/libodbc*.sl
		chmod +x $inst_dir/lib/$PLATFORM/libivicu23.sl
		chmod +x $inst_dir/lib/$PLATFORM/odbccurs.sl
		chmod +x $inst_dir/lib/$PLATFORM/odbctrac.sl
		chmod +x $inst_dir/lib/$PLATFORM/vscnctdlg.sl
	fi
fi

###########################################################
#  Copy DataDirect Driver Manager message files
###########################################################
if test $PLATFORM = "ssunos5" || test $PLATFORM = "ilinux" || test $PLATFORM = "raix" || (test $PLATFORM = "phpux")
then
echo "	- Installing message files..."
olddir=`pwd`
cd $inst_dir
tar xf lib/$PLATFORM/dd_locale.tar 
cd $olddir
fi

#############################################################
#
# Validate Client and Server keys
#
#############################################################

#echo "-----------------------------------------------"
#echo "             Validating keys                   "
#echo "-----------------------------------------------"

#oa_rdaadm=$inst_dir/bin/$PLATFORM/rdaadmin

#if test $oa_rdaadm = ""
#then
#	echo "       ***  Installation is not successful  ***        "
#else
#	if test $oa_client_key
#	then
#		echo " "
#		echo " "
#		echo "*** Validating Client key...."
#		$oa_rdaadm -c $oa_client_key
#	fi


#	if test $oa_server_key
#	then
#		echo " "	
#		echo " "
#		echo "*** Validating server key...."
#		$oa_rdaadm -s $oa_server_key
#	fi
#fi	

####################################################################################################
echo ""
echo "Thank you.  Installation successfully completed. "
echo ""
echo ""
#####################################################################################################

