/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import jdbc.sql.oautilobj;

public class oabasedatasource
extends oautilobj
implements Referenceable,
ObjectFactory,
Serializable {
    private String _dataSourceName = null;
    private String _databaseName = null;
    private String _user = null;
    private String _password = null;
    private String _description = null;
    private Integer _portNumber = null;
    private String _serverName = null;
    private String _serverType = null;
    private String _schemaPath = null;
    private String _connectString = null;
    private String _customOptions = null;
    private Integer _loginTimeout = null;
    private Boolean _trace = null;
    private Boolean _readOnly = null;
    private Integer _queryTimeout = null;
    private Integer _isolationLevel = null;
    private PrintWriter _logWriter = null;
    private Integer _xaOptions = null;
    static final int PORTNUMBER_SET = 1;
    static final int LOGINTIMEOUT_SET = 2;
    static final int TRACE_SET = 4;
    static final int READONLY_SET = 8;
    static final int QUERYTIMEOUT_SET = 16;
    static final int ISOLATIONLEVEL_SET = 32;

    oabasedatasource() {
    }

    int getDefinedNumericOptions() {
        int n = 0;
        if (this._portNumber != null) {
            n |= 1;
        }
        if (this._loginTimeout != null) {
            n |= 2;
        }
        if (this._trace != null) {
            n |= 4;
        }
        if (this._readOnly != null) {
            n |= 8;
        }
        if (this._queryTimeout != null) {
            n |= 0x10;
        }
        if (this._isolationLevel != null) {
            n |= 0x20;
        }
        return n;
    }

    public void setDataSourceName(String string) {
        this._dataSourceName = string;
    }

    public String getDataSourceName() {
        return this._dataSourceName;
    }

    public void setDatabaseName(String string) {
        this._databaseName = string;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public String getUser() {
        return this._user;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPortNumber(int n) {
        this._portNumber = new Integer(n);
    }

    public int getPortNumber() {
        if (this._portNumber == null) {
            return 0;
        }
        return this._portNumber;
    }

    public void setXaOptions(int n) {
        this._xaOptions = new Integer(n);
    }

    public int getXaOptions() {
        if (this._xaOptions == null) {
            return 0;
        }
        return this._xaOptions;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setServerName(String string) {
        this._serverName = string;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerType(String string) {
        this._serverType = string;
    }

    public String getServerType() {
        return this._serverType;
    }

    public void setSchemaPath(String string) {
        this._schemaPath = string;
    }

    public String getSchemaPath() {
        return this._schemaPath;
    }

    public void setConnectString(String string) {
        this._connectString = string;
    }

    public String getConnectString() {
        return this._connectString;
    }

    public void setCustomOptions(String string) {
        string = oabasedatasource.replaceAll(string, "[[EQ]]", "=");
        string = oabasedatasource.replaceAll(string, "[[SEMI]]", ";");
        this._customOptions = oabasedatasource.replaceAll(string, "[[QUOTE]]", "\"");
    }

    public String getCustomOptions() {
        return this._customOptions;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this._logWriter = printWriter;
        if (this._logWriter != null) {
            this._logWriter.println("No logging done by this driver");
        }
    }

    public void setLoginTimeout(int n) throws SQLException {
        this._loginTimeout = new Integer(n);
    }

    public int getLoginTimeout() throws SQLException {
        if (this._loginTimeout == null) {
            return 0;
        }
        return this._loginTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this._queryTimeout = new Integer(n);
    }

    public int getQueryTimeout() throws SQLException {
        if (this._queryTimeout == null) {
            return 0;
        }
        return this._queryTimeout;
    }

    public void setIsolationLevel(int n) throws SQLException {
        this._isolationLevel = new Integer(n);
    }

    public int getIsolationLevel() throws SQLException {
        if (this._isolationLevel == null) {
            return 0;
        }
        return this._isolationLevel;
    }

    public void setTrace(boolean bl) throws SQLException {
        this._trace = new Boolean(bl);
    }

    public boolean getTrace() throws SQLException {
        if (this._trace == null) {
            return false;
        }
        return this._trace;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this._readOnly = new Boolean(bl);
    }

    public boolean getReadOnly() throws SQLException {
        if (this._readOnly == null) {
            return false;
        }
        return this._readOnly;
    }

    protected void validateConnectOptions() throws SQLException {
        if (this._databaseName == null && (this._portNumber == null || this._serverName == null || this._serverType == null)) {
            throw new SQLException("You must specify portNumber, serverName & serverType when databaseName is omitted", "01S00");
        }
    }

    protected String getCompleteConnectString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.appendOption(stringBuffer, "ADDRESS", this._serverName);
        this.appendOption(stringBuffer, "PORT", this._portNumber);
        this.appendOption(stringBuffer, "TYPE", this._serverType);
        this.appendOption(stringBuffer, "SCHEMA_PATH", this._schemaPath);
        this.appendOption(stringBuffer, "CONNECT_STRING", this._connectString);
        this.appendOption(stringBuffer, null, this._customOptions);
        return stringBuffer.toString();
    }

    String getConnectionId() {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.appendOption(stringBuffer, "DATABASE", this._databaseName);
        this.appendOption(stringBuffer, "ADDRESS", this._serverName);
        this.appendOption(stringBuffer, "PORT", this._portNumber);
        this.appendOption(stringBuffer, "TYPE", this._serverType);
        return stringBuffer.toString().toUpperCase();
    }

    private void appendOption(StringBuffer stringBuffer, String string, Object object) {
        if (object == null) {
            return;
        }
        if (string == null) {
            stringBuffer.append(object.toString()).append(";");
        } else {
            stringBuffer.append(string).append("=").append(object.toString()).append(";");
        }
    }

    private void addStringToRef(Reference reference, String string, Object object) {
        if (object == null) {
            return;
        }
        reference.add(new StringRefAddr(string, object.toString()));
    }

    private String readStringFromRef(Reference reference, String string) {
        RefAddr refAddr = reference.get(string);
        if (refAddr != null) {
            return (String)refAddr.getContent();
        }
        return null;
    }

    public String toString() {
        if (this._dataSourceName != null && this._dataSourceName.length() > 0) {
            return this.getClass().getName() + ":" + this._dataSourceName + "@" + Integer.toHexString(this.hashCode());
        }
        return this.getClass().getName() + ":" + this.getCompleteConnectString() + "@" + Integer.toHexString(this.hashCode());
    }

    public synchronized Reference getReference() {
        if (oabasedatasource.traceOn()) {
            oabasedatasource.trace("getReference() invoked for " + this);
        }
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        this.addStringToRef(reference, "dataSourceName", this._dataSourceName);
        this.addStringToRef(reference, "databaseName", this._databaseName);
        this.addStringToRef(reference, "user", this._user);
        this.addStringToRef(reference, "password", this._password);
        this.addStringToRef(reference, "description", this._description);
        this.addStringToRef(reference, "portNumber", this._portNumber);
        this.addStringToRef(reference, "serverName", this._serverName);
        this.addStringToRef(reference, "serverType", this._serverType);
        this.addStringToRef(reference, "schemaPath", this._schemaPath);
        this.addStringToRef(reference, "connectString", this._connectString);
        this.addStringToRef(reference, "customOptions", this._customOptions);
        this.addStringToRef(reference, "loginTimeout", this._loginTimeout);
        this.addStringToRef(reference, "trace", this._trace);
        this.addStringToRef(reference, "readOnly", this._readOnly);
        this.addStringToRef(reference, "queryTimeout", this._queryTimeout);
        this.addStringToRef(reference, "isolationLevel", this._isolationLevel);
        this.addStringToRef(reference, "xaOptions", this._xaOptions);
        if (oabasedatasource.traceOn()) {
            oabasedatasource.trace("getReference() returning " + reference);
        }
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (oabasedatasource.traceOn()) {
            oabasedatasource.trace("getObjectInstance() invoked for " + this);
        }
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if (reference.getClassName().equals(this.getClass().getName())) {
                oabasedatasource oabasedatasource2;
                try {
                    oabasedatasource2 = (oabasedatasource)Class.forName(reference.getClassName()).newInstance();
                }
                catch (Exception exception) {
                    throw new NamingException(exception.toString());
                }
                oabasedatasource2._databaseName = this.readStringFromRef(reference, "databaseName");
                oabasedatasource2._dataSourceName = this.readStringFromRef(reference, "dataSourceName");
                oabasedatasource2._user = this.readStringFromRef(reference, "user");
                oabasedatasource2._password = this.readStringFromRef(reference, "password");
                oabasedatasource2._description = this.readStringFromRef(reference, "description");
                String string = this.readStringFromRef(reference, "portNumber");
                oabasedatasource2._portNumber = string == null ? null : new Integer(string);
                oabasedatasource2._serverName = this.readStringFromRef(reference, "serverName");
                oabasedatasource2._serverType = this.readStringFromRef(reference, "serverType");
                oabasedatasource2._schemaPath = this.readStringFromRef(reference, "schemaPath");
                oabasedatasource2._connectString = this.readStringFromRef(reference, "connectString");
                oabasedatasource2._customOptions = this.readStringFromRef(reference, "customOptions");
                string = this.readStringFromRef(reference, "loginTimeout");
                oabasedatasource2._loginTimeout = string == null ? null : new Integer(string);
                string = this.readStringFromRef(reference, "trace");
                oabasedatasource2._trace = string == null ? null : new Boolean(string);
                string = this.readStringFromRef(reference, "readOnly");
                oabasedatasource2._readOnly = string == null ? null : new Boolean(string);
                string = this.readStringFromRef(reference, "queryTimeout");
                oabasedatasource2._queryTimeout = string == null ? null : new Integer(string);
                string = this.readStringFromRef(reference, "isolationLevel");
                oabasedatasource2._isolationLevel = string == null ? null : new Integer(string);
                string = this.readStringFromRef(reference, "xaOptions");
                Integer n = oabasedatasource2._xaOptions = string == null ? null : new Integer(string);
                if (oabasedatasource.traceOn()) {
                    oabasedatasource.trace("getObjectInstance() returns " + oabasedatasource2);
                }
                return oabasedatasource2;
            }
            throw new NamingException("DataSource: Reference not constructed from class " + this.getClass().getName());
        }
        if (oabasedatasource.traceOn()) {
            oabasedatasource.trace("getObjectInstance() returns null");
        }
        return null;
    }
}

