/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jdbc.sql.cli.oacli;
import jdbc.sql.cli.oacliwarning;
import jdbc.sql.oabasedatasource;
import jdbc.sql.oacallablestatement;
import jdbc.sql.oadatabasemetadata;
import jdbc.sql.oaprepstatement;
import jdbc.sql.oastatement;
import jdbc.sql.oautilobj;

public abstract class oabaseconnection
extends oautilobj {
    private oacli _oaCLI = null;
    private String _savedUser = "N/A";
    private String _savedDatabase = "N/A";
    private String _savedCustomConnectString = "N/A";
    private String _connectionId;
    Connection _currentConnection = null;
    int _xaOptions;
    public static final int DAM_XA_OPTION_AUTOFORGET_HEUR_DTC = 1;
    public static final int DAM_XA_OPTION_PERMIT_XARB_FROM_END = 2;
    public static final int DAM_XA_OPTION_STRICT_ROLLBACK_SEMANTICS = 4;
    public static final int DAM_XA_OPTION_FORCE_SEPARATE_CONNECTON = 8;

    protected oabaseconnection(String string, String string2, String string3) throws SQLException {
        this(string, string2, string3, null);
    }

    protected oabaseconnection(String string, String string2, String string3, StringBuffer stringBuffer) throws SQLException {
        try {
            if (oabaseconnection.traceOn()) {
                oabaseconnection.trace("oabaseconnection() called");
            }
            this._oaCLI = new oacli(0, false);
            String string4 = stringBuffer == null ? null : stringBuffer.toString();
            this._oaCLI.openConnectionInt(string, string2, string3, string4, "", false, false, false, false, false, 0, false, 0, false, 0);
            this._connectionId = null;
            if (string != null) {
                this._savedUser = string;
            }
            if (string3 != null) {
                this._savedDatabase = string3;
            }
            if (stringBuffer != null) {
                this._savedCustomConnectString = stringBuffer.toString();
            }
            this._oaCLI.saveState();
            if (oabaseconnection.traceOn()) {
                oabaseconnection.trace("oabaseconnection() returns");
            }
        }
        catch (SQLException sQLException) {
            this._oaCLI = null;
            throw sQLException;
        }
        catch (Exception exception) {
            this._oaCLI = null;
            throw new SQLException("oacli exception: " + exception.getMessage());
        }
    }

    protected oabaseconnection(String string, String string2, oabasedatasource oabasedatasource2) throws SQLException {
        try {
            if (oabaseconnection.traceOn()) {
                oabaseconnection.trace("oabaseconnection() called");
            }
            this._xaOptions = oabasedatasource2.getXaOptions();
            this._oaCLI = new oacli(this._xaOptions, false);
            if (string == null) {
                string = oabasedatasource2.getUser();
            }
            if (string2 == null) {
                string2 = oabasedatasource2.getPassword();
            }
            int n = oabasedatasource2.getDefinedNumericOptions();
            this._oaCLI.openConnectionInt(string, string2, oabasedatasource2.getDatabaseName(), oabasedatasource2.getCompleteConnectString(), oabasedatasource2.getConnectionId(), (n & 4) != 0, oabasedatasource2.getTrace(), (n & 8) != 0, oabasedatasource2.getReadOnly(), (n & 0x10) != 0, oabasedatasource2.getQueryTimeout(), (n & 2) != 0, oabasedatasource2.getLoginTimeout(), (n & 0x20) != 0, oabasedatasource2.getIsolationLevel());
            this._connectionId = oabasedatasource2.getConnectionId();
            if (string != null) {
                this._savedUser = string;
            }
            if (oabasedatasource2.getDatabaseName() != null) {
                this._savedDatabase = oabasedatasource2.getDatabaseName();
            }
            if (oabasedatasource2.getCustomOptions() != null) {
                this._savedCustomConnectString = oabasedatasource2.getCustomOptions();
            }
            this._oaCLI.saveState();
            if (oabaseconnection.traceOn()) {
                oabaseconnection.trace("oabaseconnection() returns");
            }
        }
        catch (SQLException sQLException) {
            this._oaCLI = null;
            throw sQLException;
        }
        catch (Exception exception) {
            this._oaCLI = null;
            throw new SQLException("oacli exception: " + exception.getMessage());
        }
    }

    oabaseconnection() {
    }

    String getConnectionId() {
        return this._connectionId;
    }

    public String toString() {
        String string = this.getClass().getName() + " :";
        if (this._savedDatabase != null && !this._savedDatabase.equals("")) {
            string = string + " database=" + this._savedDatabase;
        }
        if (this._savedUser != null && !this._savedUser.equals("")) {
            string = string + " user=" + this._savedUser;
        }
        if (this._savedCustomConnectString != null && !this._savedCustomConnectString.equals("")) {
            string = string + " customConnectString=" + this._savedCustomConnectString;
        }
        return string + " @" + Integer.toHexString(this.hashCode());
    }

    protected void throwErrorWhenClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection closed", "08003");
        }
        if (!this.isConnected()) {
            throw new SQLException("Connection lost", "08S01");
        }
    }

    oacli getoacli() {
        return this._oaCLI;
    }

    void reset(boolean bl) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.restoreState(bl);
    }

    public String nativeSQL(String string) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("nativeSQL(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        return this._oaCLI.nativeSql(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.setAutoCommit(bl, false);
    }

    public boolean getAutoCommit() throws SQLException {
        this.throwErrorWhenClosed();
        if (this._oaCLI.inXATransaction()) {
            return false;
        }
        return this._oaCLI.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.commit();
    }

    public void rollback() throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.rollback();
    }

    protected void internalClose() throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("internalClose: called, closing oacli " + this._oaCLI);
        }
        if (this._oaCLI != null) {
            this._oaCLI.close();
            this._oaCLI = null;
        }
    }

    public boolean isClosed() throws SQLException {
        return this._oaCLI == null;
    }

    boolean isConnected() {
        if (this._oaCLI == null) {
            return false;
        }
        return this._oaCLI.isConnected();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        this.throwErrorWhenClosed();
        return this._oaCLI.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        this.throwErrorWhenClosed();
        return this._oaCLI.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.throwErrorWhenClosed();
        this._oaCLI.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        this.throwErrorWhenClosed();
        return this._oaCLI.getTransactionIsolation();
    }

    public void setAutoClose(boolean bl) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setAutoClose() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("oaconnection.setAutoClose is not yet supported.");
    }

    public boolean getAutoClose() throws SQLException {
        this.throwErrorWhenClosed();
        return this._oaCLI.getAutoClose();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("getWarnings() called");
        }
        this.throwErrorWhenClosed();
        oacliwarning oacliwarning2 = this._oaCLI.getWarnings();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("getWarnings() returns " + oacliwarning2);
        }
        return oacliwarning2;
    }

    public void clearWarnings() throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("clearWarnings() called");
        }
        this.throwErrorWhenClosed();
        this._oaCLI.clearWarnings();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("clearWarnings() returns");
        }
    }

    public Map getTypeMap() throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("getTypeMap() called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getTypeMap() is not yet supported.");
    }

    public void setTypeMap(Map map) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setTypeMap(" + map + ") called");
        }
        this.throwErrorWhenClosed();
        throw new SQLException("getTypeMap(Map) is not yet supported.");
    }

    public Statement createStatement() throws SQLException {
        this.throwErrorWhenClosed();
        return new oastatement(this._currentConnection, this.getoacli(), this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement() called");
        }
        this.throwErrorWhenClosed();
        return new oaprepstatement(this._currentConnection, string, this.getoacli(), this);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareCall() called");
        }
        this.throwErrorWhenClosed();
        return new oacallablestatement(this._currentConnection, string, this.getoacli(), this);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.throwErrorWhenClosed();
        return new oadatabasemetadata(this.getoacli(), this._currentConnection);
    }

    private void addWarningForUnsupportedResultSet(int n, int n2) {
        if (n != 1003) {
            this._oaCLI.setNextWarning(new oacliwarning("Only FORWARD_ONLY resultsets supported", "01S02"));
        }
        if (n2 != 1007) {
            this._oaCLI.setNextWarning(new oacliwarning("Only CONCUR_READ_ONLY resultsets supported", "01S02"));
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = this.createStatement();
        this.addWarningForUnsupportedResultSet(n, n2);
        return statement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        this.addWarningForUnsupportedResultSet(n, n2);
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement = this.prepareCall(string);
        this.addWarningForUnsupportedResultSet(n, n2);
        return callableStatement;
    }

    public void setHoldability(int n) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setHoldability(" + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setHoldability() returns");
        }
    }

    public int getHoldability() throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("getHoldability() called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("getHoldability() returns 0");
        }
        return 0;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setSavepoint() called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setSavepoint() returns null");
        }
        return null;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setSavepoint(" + string + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("setSavepoint(" + string + ") returns null");
        }
        return null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("rollback() called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("rollback() returns");
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("releaseSavepoint() called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("releaseSavepoint() returns");
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("createStatement(" + n + "," + n2 + "," + n3 + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("createStatement() returns null");
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement(" + string + "," + n + "," + n2 + "," + n3 + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement() returns null");
        }
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareCall(" + string + "," + n + "," + n2 + "," + n3 + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareCall() returns null");
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement(" + string + "," + n + ") called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement() returns null");
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement(" + string + ", columnIndexes[]) called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement() returns null");
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement(" + string + ", columnNames[]) called");
        }
        this.throwErrorWhenClosed();
        this.throwNotImplementedError();
        if (oabaseconnection.traceOn()) {
            oabaseconnection.trace("prepareStatement() returns null");
        }
        return null;
    }
}

