/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.optimizer.relational.rules.RulePlaceAccess;
import com.metamatrix.query.optimizer.relational.rules.RulePushLimit;
import com.metamatrix.query.optimizer.relational.rules.RulePushSelectCriteria;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class RuleRaiseAccess
implements OptimizerRule {
    private static final String AUTO_EXRESSION_ALIAS = "EXPR";

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean afterJoinPlanning = !rules.contains(RuleConstants.PLAN_JOINS);
        boolean raisedNode = true;
        while (raisedNode) {
            raisedNode = false;
            List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)3);
            for (PlanNode accessNode : nodes) {
                PlanNode newRoot = this.raiseAccessNode(plan, accessNode, metadata, capFinder, afterJoinPlanning);
                if (newRoot == null) continue;
                raisedNode = true;
                plan = newRoot;
            }
        }
        return plan;
    }

    PlanNode raiseAccessNode(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean afterJoinPlanning) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode parentNode = accessNode.getParent();
        if (parentNode == null) {
            return null;
        }
        switch (parentNode.getType()) {
            case 7: {
                Object modelID = this.canRaiseOverJoin(parentNode, metadata, capFinder, afterJoinPlanning);
                if (modelID != null) {
                    RuleRaiseAccess.raiseAccessOverJoin(parentNode, modelID, true);
                    return rootNode;
                }
                return null;
            }
            case 11: {
                Object modelID;
                List projectCols = (List)parentNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                HashSet exprSymbols = (HashSet)accessNode.getProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED);
                if (exprSymbols == null) {
                    exprSymbols = new HashSet();
                }
                if ((modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata)) == null) {
                    return null;
                }
                for (int i = 0; i < projectCols.size(); ++i) {
                    Expression expr;
                    SingleElementSymbol symbol = (SingleElementSymbol)projectCols.get(i);
                    if (!RuleRaiseAccess.canPushSymbol(symbol, true, exprSymbols, modelID, metadata, capFinder)) {
                        return null;
                    }
                    boolean hasAlias = false;
                    if (symbol instanceof AliasSymbol) {
                        symbol = ((AliasSymbol)symbol).getSymbol();
                        hasAlias = true;
                    }
                    if (!(symbol instanceof ExpressionSymbol) || symbol instanceof AggregateSymbol || (expr = ((ExpressionSymbol)symbol).getExpression()) == null || expr instanceof Constant || !EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)expr)) continue;
                    if (!hasAlias) {
                        return null;
                    }
                    exprSymbols.add(projectCols.get(i));
                }
                if (exprSymbols.size() > 0) {
                    accessNode.setProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED, exprSymbols);
                }
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 5: {
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                if (CapabilitiesUtil.supportsSelectDistinct(modelID, metadata, capFinder)) {
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 17: {
                if (RuleRaiseAccess.canRaiseOverSort(accessNode, metadata, capFinder, parentNode)) {
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 23: {
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                List groupCols = (List)parentNode.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                if (CapabilitiesUtil.supportsAggregates(groupCols, modelID, metadata, capFinder) && this.checkParentAggregates(parentNode.getParent(), modelID, metadata, capFinder)) {
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 29: {
                if (accessNode.getParent() == null) {
                    return rootNode;
                }
                List nodes = this.canRaiseOverUnion(parentNode, metadata, capFinder);
                if (nodes == null) {
                    return null;
                }
                ArrayList oldChildren = new ArrayList(parentNode.getChildren());
                rootNode = RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                for (PlanNode node : oldChildren) {
                    if (node == accessNode) continue;
                    NodeEditor.removeChildNode((PlanNode)parentNode, (PlanNode)node);
                    node.setParent(null);
                    accessNode.addGroups((Collection)node.getGroups());
                }
                return rootNode;
            }
            case 13: {
                if (!parentNode.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) {
                    if (RuleRaiseAccess.canRaiseOverSelect(accessNode, metadata, capFinder, parentNode)) {
                        RulePushSelectCriteria.satisfyAccessPatterns(parentNode, accessNode);
                        return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                    }
                    if (parentNode.getParent() != null) {
                        PlanNode selectRoot = parentNode;
                        while (selectRoot.getParent() != null && selectRoot.getParent().getType() == 13) {
                            selectRoot = selectRoot.getParent();
                        }
                        if (selectRoot.getParent() == null || selectRoot.getParent().getType() == 11 || selectRoot.getParent().getType() == 23) {
                            return null;
                        }
                        PlanNode grandParent = selectRoot.getParent();
                        boolean isLeft = false;
                        if (grandParent != null) {
                            JoinType jt;
                            boolean bl = isLeft = grandParent.getFirstChild() == selectRoot;
                            if (grandParent.getType() == 7 && ((jt = (JoinType)grandParent.getProperty((Object)NodeConstants.Info.JOIN_TYPE)) == JoinType.JOIN_FULL_OUTER || jt == JoinType.JOIN_LEFT_OUTER && !isLeft)) {
                                return null;
                            }
                            grandParent.removeChild(selectRoot);
                            if (isLeft) {
                                grandParent.addFirstChild(accessNode);
                            } else {
                                grandParent.addLastChild(accessNode);
                            }
                            accessNode.setParent(grandParent);
                        }
                        PlanNode newParent = grandParent.getParent();
                        PlanNode newRoot = this.raiseAccessNode(rootNode, accessNode, metadata, capFinder, afterJoinPlanning);
                        if (newRoot == null) {
                            accessNode.setParent(parentNode);
                            if (grandParent != null) {
                                grandParent.removeChild(accessNode);
                                if (isLeft) {
                                    grandParent.addFirstChild(selectRoot);
                                } else {
                                    grandParent.addLastChild(selectRoot);
                                }
                                selectRoot.setParent(grandParent);
                            }
                        } else {
                            accessNode = grandParent.getParent();
                            if (newParent != null) {
                                isLeft = newParent.getFirstChild() == accessNode;
                                newParent.removeChild(accessNode);
                                if (isLeft) {
                                    newParent.addFirstChild(selectRoot);
                                } else {
                                    newParent.addLastChild(selectRoot);
                                }
                                selectRoot.setParent(newParent);
                            } else {
                                newRoot = selectRoot;
                            }
                            parentNode.getChildren().clear();
                            parentNode.addFirstChild(accessNode);
                            accessNode.setParent(parentNode);
                            return newRoot;
                        }
                    }
                }
                return null;
            }
            case 19: {
                List limitNodes;
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                if (parentNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
                    return null;
                }
                if (!CapabilitiesUtil.supportsInlineView(modelID, metadata, capFinder)) {
                    return null;
                }
                if (!(parentNode.getProperty((Object)NodeConstants.Info.NESTED_COMMAND) instanceof QueryCommand)) {
                    return null;
                }
                if (FrameUtil.getNonQueryCommand(accessNode) != null || FrameUtil.getNestedPlan(accessNode) != null) {
                    return null;
                }
                for (PlanNode ancestor = parentNode.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                    if (ancestor.getType() != 11) continue;
                    if (ancestor.getProperty((Object)NodeConstants.Info.INTO_GROUP) == null) break;
                    return null;
                }
                if ((limitNodes = NodeEditor.findAllNodes((PlanNode)accessNode, (int)41)) != null && !limitNodes.isEmpty()) {
                    return null;
                }
                PlanNode parentProject = parentNode.getParent();
                if (parentProject.getType() == 11 && parentProject.getParent() == null && !this.raiseOverParentProject(parentProject)) {
                    return null;
                }
                parentNode.setProperty((Object)NodeConstants.Info.INLINE_VIEW, (Object)Boolean.TRUE);
                accessNode.getGroups().clear();
                accessNode.addGroups((Collection)parentNode.getGroups());
                RulePlaceAccess.copyDependentHints((PlanNode)parentNode, (PlanNode)accessNode);
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 41: {
                return RulePushLimit.raiseAccessOverLimit((PlanNode)rootNode, (PlanNode)accessNode, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (PlanNode)parentNode);
            }
        }
        return null;
    }

    static boolean canRaiseOverSort(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        List sortCols = (List)parentNode.getProperty((Object)NodeConstants.Info.SORT_ORDER);
        ArrayList expressionsCreated = new ArrayList();
        for (int i = 0; i < sortCols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)sortCols.get(i);
            if (RuleRaiseAccess.canPushSymbol(symbol, true, expressionsCreated, modelID, metadata, capFinder)) continue;
            return false;
        }
        if (accessNode.getLastChild() != null) {
            if (accessNode.getLastChild().getType() == 29) {
                return CapabilitiesUtil.supportsUnionOrderBy(modelID, metadata, capFinder);
            }
            if (accessNode.getLastChild().getType() == 41) {
                return false;
            }
        }
        return CapabilitiesUtil.supportsOrderBy(modelID, metadata, capFinder) && RuleRaiseAccess.handleOrderBy(accessNode, parentNode, metadata);
    }

    private boolean raiseOverParentProject(PlanNode parentProject) {
        List projectCols = (List)parentProject.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        boolean shouldRaise = false;
        for (Expression column : projectCols) {
            if (column instanceof AliasSymbol) {
                column = ((AliasSymbol)column).getSymbol();
            }
            if (column instanceof ElementSymbol) continue;
            shouldRaise = true;
            break;
        }
        return shouldRaise;
    }

    static boolean canRaiseOverSelect(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        if (parentNode.hasBooleanProperty((Object)NodeConstants.Info.IS_PHANTOM)) {
            return true;
        }
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        List limits = NodeEditor.findAllNodes((PlanNode)accessNode, (int)41, (int)19);
        if (!limits.isEmpty()) {
            return false;
        }
        if (parentNode.hasBooleanProperty((Object)NodeConstants.Info.IS_HAVING)) {
            if (!CapabilitiesUtil.supportsAggregates(null, modelID, metadata, capFinder)) {
                return false;
            }
            Criteria crit = (Criteria)parentNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            Collection aggregates = AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)crit, (boolean)true);
            for (AggregateSymbol aggregate : aggregates) {
                if (CapabilitiesUtil.supportsAggregateFunction(modelID, aggregate, metadata, capFinder)) continue;
                return false;
            }
            return true;
        }
        Criteria crit = (Criteria)parentNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        boolean hasSubquery = FrameUtil.hasSubquery(parentNode);
        if (hasSubquery && !CapabilitiesUtil.isEligibleSubquery(parentNode, metadata, capFinder)) {
            return false;
        }
        return CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)crit, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
    }

    private static boolean handleOrderBy(PlanNode accessNode, PlanNode sortNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        SingleElementSymbol symbol;
        HashSet<Object> expressionsCreated;
        List projectSymbols = null;
        List projectNodes = NodeEditor.findAllNodes((PlanNode)accessNode, (int)11, (int)19);
        if (projectNodes.size() > 1) {
            return false;
        }
        if (projectNodes.size() == 1) {
            PlanNode projectNode = (PlanNode)projectNodes.get(0);
            projectSymbols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        }
        if (projectSymbols == null) {
            try {
                projectSymbols = ResolverUtil.getElementSybmolsFromGroups((Set)accessNode.getGroups(), (QueryMetadataInterface)metadata);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixComponentException((Throwable)err);
            }
        }
        if ((expressionsCreated = (HashSet<Object>)accessNode.getProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED)) == null) {
            expressionsCreated = new HashSet<Object>();
            accessNode.setProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED, expressionsCreated);
        }
        List orderBySymbols = (List)sortNode.getProperty((Object)NodeConstants.Info.SORT_ORDER);
        HashSet<SingleElementSymbol> uniqueOrderBy = new HashSet<SingleElementSymbol>();
        HashSet<String> uniqueOrderByNames = new HashSet<String>();
        int i = 0;
        while (i < orderBySymbols.size()) {
            symbol = (SingleElementSymbol)orderBySymbols.get(i);
            uniqueOrderByNames.add(symbol.getShortCanonicalName());
            if (symbol instanceof AliasSymbol && projectSymbols.contains(symbol = ((AliasSymbol)symbol).getSymbol())) {
                orderBySymbols.set(i, symbol);
                uniqueOrderByNames.add(symbol.getShortCanonicalName());
            }
            if (!uniqueOrderBy.add(symbol)) {
                orderBySymbols.remove(i);
                continue;
            }
            ++i;
        }
        for (i = 0; i < orderBySymbols.size(); ++i) {
            symbol = (SingleElementSymbol)orderBySymbols.get(i);
            if (symbol instanceof AliasSymbol) {
                AliasSymbol aliasSymbol = (AliasSymbol)symbol;
                expressionsCreated.add(aliasSymbol);
                continue;
            }
            if (!(symbol instanceof ExpressionSymbol)) continue;
            RuleRaiseAccess.processOrderBySymbol((ExpressionSymbol)symbol, expressionsCreated, orderBySymbols, projectSymbols);
        }
        for (i = 0; i < projectSymbols.size(); ++i) {
            SingleElementSymbol actualSymbol;
            SingleElementSymbol selectSymbol = (SingleElementSymbol)projectSymbols.get(i);
            if (expressionsCreated.contains(selectSymbol) || uniqueOrderBy.contains(selectSymbol) || !(selectSymbol instanceof AliasSymbol) || uniqueOrderBy.contains(actualSymbol = ((AliasSymbol)selectSymbol).getSymbol()) || !uniqueOrderByNames.contains(actualSymbol.getShortCanonicalName())) continue;
            expressionsCreated.add(selectSymbol);
        }
        return true;
    }

    private static void processOrderBySymbol(ExpressionSymbol symbol, Set expressionsCreated, List orderBySymbols, List projectSymbols) {
        String aliasName = RuleRaiseAccess.generateUniqueAlias(orderBySymbols, projectSymbols);
        AliasSymbol alias = new AliasSymbol(aliasName, (SingleElementSymbol)symbol);
        int orderByIndex = orderBySymbols.indexOf(symbol);
        if (orderByIndex != -1) {
            orderBySymbols.remove(orderByIndex);
            orderBySymbols.add(orderByIndex, alias);
        }
        AliasSymbol selectAlias = new AliasSymbol(aliasName, (SingleElementSymbol)symbol);
        expressionsCreated.remove(symbol);
        expressionsCreated.add(selectAlias);
        int projIndex = projectSymbols.indexOf(symbol);
        if (projIndex != -1) {
            projectSymbols.remove(projIndex);
            projectSymbols.add(projIndex, selectAlias);
        }
    }

    private static String generateUniqueAlias(List orderBySymbols, List expressionsCreated) {
        if (orderBySymbols.isEmpty() || expressionsCreated.isEmpty()) {
            return AUTO_EXRESSION_ALIAS;
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Symbol next : orderBySymbols) {
            existingNames.add(next.getName().toUpperCase());
            if (!(next instanceof AliasSymbol)) continue;
            existingNames.add(((AliasSymbol)next).getSymbol().getName().toUpperCase());
        }
        for (Symbol next : expressionsCreated) {
            existingNames.add(next.getName().toUpperCase());
            if (!(next instanceof AliasSymbol)) continue;
            existingNames.add(((AliasSymbol)next).getSymbol().getName().toUpperCase());
        }
        String tmpName = AUTO_EXRESSION_ALIAS;
        int incr = 1;
        while (existingNames.contains(tmpName)) {
            int index = tmpName.lastIndexOf("_" + (incr - 1));
            if (index != -1) {
                tmpName = tmpName.substring(0, index);
                tmpName = tmpName + "_" + incr;
            } else {
                tmpName = tmpName + "_" + incr;
            }
            ++incr;
        }
        return tmpName;
    }

    static boolean canPushSymbol(SingleElementSymbol symbol, boolean inSelectClause, Collection createdExpressions, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws MetaMatrixComponentException, QueryMetadataException {
        Expression expr;
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
        }
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)symbol, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            return false;
        }
        if (symbol instanceof ExpressionSymbol && (expr = ((ExpressionSymbol)symbol).getExpression()) != null && inSelectClause) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)expr).size() > 0) {
                return false;
            }
            if ((expr instanceof Constant || EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)expr)) && !CapabilitiesUtil.supportsSelectLiterals(modelID, metadata, capFinder)) {
                return false;
            }
            if (!(expr instanceof Reference)) {
                createdExpressions.add(symbol);
            }
        }
        return true;
    }

    static PlanNode performRaise(PlanNode rootNode, PlanNode accessNode, PlanNode parentNode) {
        NodeEditor.removeChildNode((PlanNode)parentNode, (PlanNode)accessNode);
        accessNode.setParent(null);
        PlanNode grandparentNode = parentNode.getParent();
        if (grandparentNode != null) {
            NodeEditor.insertNode((PlanNode)parentNode.getParent(), (PlanNode)parentNode, (PlanNode)accessNode);
            return rootNode;
        }
        NodeEditor.attachLast((PlanNode)accessNode, (PlanNode)parentNode);
        return accessNode;
    }

    boolean checkParentAggregates(PlanNode node, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        while (node != null && node.getType() != 19) {
            if (node.getType() == 13) {
                if (!node.hasBooleanProperty((Object)NodeConstants.Info.IS_HAVING)) {
                    node = node.getParent();
                    continue;
                }
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)crit, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
                    return false;
                }
            } else if (node.getType() == 11) {
                List selectElements = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                for (SingleElementSymbol element : selectElements) {
                    if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)element, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) continue;
                    return false;
                }
            }
            node = node.getParent();
        }
        return true;
    }

    Object canRaiseOverJoin(PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean afterJoinPlanning) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        JoinType jt;
        List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        JoinType type = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (!afterJoinPlanning && type == JoinType.JOIN_CROSS && joinNode.getParent().getType() == 7 && !(jt = (JoinType)joinNode.getParent().getProperty((Object)NodeConstants.Info.JOIN_TYPE)).isOuter()) {
            return null;
        }
        if (joinNode.getProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null) {
            return null;
        }
        if (joinNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            return null;
        }
        return RuleRaiseAccess.canRaiseOverJoin(joinNode.getChildren(), metadata, capFinder, crits, type);
    }

    static Object canRaiseOverJoin(List children, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, List crits, JoinType type) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        HashSet<Object> groupIDs = new HashSet<Object>();
        for (PlanNode childNode : children) {
            if (childNode.getType() != 3) {
                return null;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(childNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            boolean supportsSelfJoins = CapabilitiesUtil.supportsSelfJoins(accessModelID, metadata, capFinder);
            if (!supportsSelfJoins) {
                for (GroupSymbol groupSymbol : childNode.getGroups()) {
                    Object groupID = groupSymbol.getMetadataID();
                    if (groupIDs.add(groupID)) continue;
                    return null;
                }
            }
            if (modelID == null) {
                if (CapabilitiesUtil.supportsJoins(accessModelID, metadata, capFinder)) {
                    if (type.isOuter() && !CapabilitiesUtil.supportsOuterJoin(accessModelID, type, metadata, capFinder)) {
                        return null;
                    }
                    if (crits != null && !crits.isEmpty()) {
                        boolean hasExpression = false;
                        for (Criteria crit : crits) {
                            if (FunctionCollectorVisitor.getFunctions((LanguageObject)crit, (boolean)false).size() <= 0) continue;
                            hasExpression = true;
                            break;
                        }
                        if (hasExpression && !CapabilitiesUtil.supportsJoinExpression(accessModelID, crits, metadata, capFinder)) {
                            return null;
                        }
                    }
                    if (metadata.modelSupports(accessModelID, 10)) {
                        return null;
                    }
                    if (metadata.modelSupports(accessModelID, 11)) {
                        return null;
                    }
                } else {
                    return null;
                }
                modelID = accessModelID;
            } else if (!CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) {
                return null;
            }
            if (!childNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) continue;
            return null;
        }
        return modelID;
    }

    static PlanNode raiseAccessOverJoin(PlanNode joinNode, Object modelID, boolean insert) {
        PlanNode leftAccess = joinNode.getFirstChild();
        PlanNode rightAccess = joinNode.getLastChild();
        NodeEditor.removeChildNode((PlanNode)joinNode, (PlanNode)leftAccess);
        NodeEditor.removeChildNode((PlanNode)joinNode, (PlanNode)rightAccess);
        joinNode.setProperty((Object)NodeConstants.Info.MODEL_ID, modelID);
        PlanNode newAccess = NodeFactory.getNewNode((int)3);
        newAccess.setProperty((Object)NodeConstants.Info.MODEL_ID, modelID);
        newAccess.addGroups((Collection)rightAccess.getGroups());
        newAccess.addGroups((Collection)leftAccess.getGroups());
        Object leftHint = leftAccess.getProperty((Object)NodeConstants.Info.MAKE_DEP);
        if (leftHint != null) {
            newAccess.setProperty((Object)NodeConstants.Info.MAKE_DEP, leftHint);
        } else {
            Object rightHint = rightAccess.getProperty((Object)NodeConstants.Info.MAKE_DEP);
            if (rightHint != null) {
                newAccess.setProperty((Object)NodeConstants.Info.MAKE_DEP, rightHint);
            }
        }
        RulePlaceAccess.copyDependentHints((PlanNode)leftAccess, (PlanNode)newAccess);
        RulePlaceAccess.copyDependentHints((PlanNode)rightAccess, (PlanNode)newAccess);
        RulePlaceAccess.copyDependentHints((PlanNode)joinNode, (PlanNode)newAccess);
        leftAccess.setParent(null);
        rightAccess.setParent(null);
        if (insert) {
            PlanNode parent = joinNode.getParent();
            NodeEditor.insertNode((PlanNode)parent, (PlanNode)joinNode, (PlanNode)newAccess);
        } else {
            newAccess.addFirstChild(joinNode);
            joinNode.setParent(newAccess);
        }
        return newAccess;
    }

    static Object getModelIDFromAccess(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object accessModelID = accessNode.getProperty((Object)NodeConstants.Info.MODEL_ID);
        if (accessModelID == null) {
            GroupSymbol group = (GroupSymbol)accessNode.getGroups().iterator().next();
            if (metadata.isVirtualGroup(group.getMetadataID())) {
                return null;
            }
            accessModelID = metadata.getModelID(group.getMetadataID());
            if (accessModelID == null) {
                return null;
            }
            accessNode.setProperty((Object)NodeConstants.Info.MODEL_ID, accessModelID);
        }
        return accessModelID;
    }

    private List canRaiseOverUnion(PlanNode unionNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        List childNodes = unionNode.getChildren();
        ArrayList<PlanNode> accessNodes = new ArrayList<PlanNode>(childNodes.size());
        Iterator childIter = childNodes.iterator();
        while (childIter.hasNext()) {
            PlanNode accessNode = null;
            PlanNode childNode = (PlanNode)childIter.next();
            if (childNode.getType() != 3) {
                return null;
            }
            accessNode = childNode;
            if (FrameUtil.getNonQueryCommand(accessNode) != null || FrameUtil.getNestedPlan(accessNode) != null) {
                return null;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            if (modelID == null) {
                modelID = accessModelID;
                if (!CapabilitiesUtil.supportsUnion(accessModelID, metadata, capFinder)) {
                    return null;
                }
            } else if (!CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) {
                return null;
            }
            accessNodes.add(accessNode);
        }
        return accessNodes;
    }

    public String toString() {
        return "RaiseAccess";
    }
}

