/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.Drop;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import com.metamatrix.query.validator.AggregateValidationVisitor;
import com.metamatrix.query.validator.ValidatorReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ValidationVisitor
extends AbstractValidationVisitor {
    private boolean isXML = false;
    private CreateUpdateProcedureCommand updateProc;
    private Command transCommand;

    public void reset() {
        super.reset();
        this.transCommand = null;
        this.isXML = false;
        this.updateProc = null;
    }

    public void visit(BatchedUpdateCommand obj) {
        List commands = obj.getUpdateCommands();
        Command command = null;
        int type = 0;
        for (int i = 0; i < commands.size(); ++i) {
            Into into;
            command = (Command)commands.get(i);
            type = command.getType();
            if (type != 2 && type != 3 && type != 4 && type != 1) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), (LanguageObject)command);
                continue;
            }
            if (type != 1 || (into = ((Query)command).getInto()) != null) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), (LanguageObject)command);
        }
    }

    public void visit(JoinPredicate obj) {
        if (!obj.getJoinType().isOuter()) {
            return;
        }
        for (Criteria criteria : obj.getJoinCriteria()) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)criteria).isEmpty()) continue;
            HashSet leftGroups = new HashSet();
            obj.getLeftClause().collectGroups(leftGroups);
            HashSet rightGroups = new HashSet();
            obj.getRightClause().collectGroups(rightGroups);
            HashSet correlationGroups = new HashSet(leftGroups);
            correlationGroups.addAll(rightGroups);
            Collection critGroups = GroupCollectorVisitor.getGroups((LanguageObject)criteria, (boolean)true);
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)criteria, (boolean)true, (boolean)true);
            for (ElementSymbol element : elements) {
                if (!element.isExternalReference() || !correlationGroups.contains(element.getGroupSymbol())) continue;
                critGroups.add(element.getGroupSymbol());
            }
            if (obj.getJoinType() == JoinType.JOIN_LEFT_OUTER && rightGroups.containsAll(critGroups) || obj.getJoinType() == JoinType.JOIN_RIGHT_OUTER && leftGroups.containsAll(critGroups)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_on_subquery", (Object)criteria), (LanguageObject)obj);
        }
    }

    public void visit(CompareCriteria obj) {
        if (this.isXML) {
            ArrayList rowLimitFunctions = new ArrayList();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Function rightExpr;
                Function leftExpr;
                Function function = null;
                Expression expr = null;
                if (obj.getLeftExpression() instanceof Function && ((leftExpr = (Function)obj.getLeftExpression()).getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || leftExpr.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception"))) {
                    function = leftExpr;
                    expr = obj.getRightExpression();
                }
                if (function == null && obj.getRightExpression() instanceof Function && ((rightExpr = (Function)obj.getRightExpression()).getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || rightExpr.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception"))) {
                    function = rightExpr;
                    expr = obj.getLeftExpression();
                }
                if (function == null) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.0"), (LanguageObject)obj);
                } else if (expr instanceof Constant) {
                    Constant constant = (Constant)expr;
                    if (constant.getValue() instanceof Integer) {
                        Integer integer = (Integer)constant.getValue();
                        if (integer < 0) {
                            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), (LanguageObject)obj);
                        }
                    } else {
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), (LanguageObject)obj);
                    }
                } else {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), (LanguageObject)obj);
                }
            }
        }
    }

    public void visit(Delete obj) {
        this.validateNoXMLUpdates((Command)obj);
        this.validateHasProjectedSymbols((Command)obj);
        this.validateGroupUpdatable((Command)obj);
        if (obj.getGroup().isTempTable()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.update_temp", (Object)obj.getGroup()), (LanguageObject)obj.getGroup());
        }
    }

    public void visit(GroupBy obj) {
        List groupBySymbols = obj.getSymbols();
        this.validateSortable(groupBySymbols);
        for (SingleElementSymbol symbol : groupBySymbols) {
            ExpressionSymbol exprSymbol;
            Expression expr;
            if (!(symbol instanceof ExpressionSymbol) || (expr = (exprSymbol = (ExpressionSymbol)symbol).getExpression()) instanceof Function || expr instanceof AbstractCaseExpression) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Expr_in_GROUP_BY_must_be_elem_func_case", (Object)expr), (LanguageObject)expr);
        }
    }

    public void visit(Insert obj) {
        this.validateNoXMLUpdates((Command)obj);
        this.validateHasProjectedSymbols((Command)obj);
        this.validateGroupUpdatable((Command)obj);
        this.validateInsert(obj);
    }

    public void visit(Limit obj) {
        Expression limitExpr;
        Expression offsetExpr = obj.getOffset();
        if (offsetExpr instanceof Reference) {
            offsetExpr = ((Reference)offsetExpr).getExpression();
        }
        if (offsetExpr instanceof Constant) {
            Integer offset = (Integer)((Constant)offsetExpr).getValue();
            if (offset == null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badoffset1"), (LanguageObject)obj);
            } else if (offset < 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badoffset2"), (LanguageObject)obj);
            }
        }
        if ((limitExpr = obj.getRowLimit()) != null) {
            if (limitExpr instanceof Reference) {
                limitExpr = ((Reference)limitExpr).getExpression();
            }
            if (limitExpr instanceof Constant) {
                Integer limit = (Integer)((Constant)limitExpr).getValue();
                if (limit == null) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit1"), (LanguageObject)obj);
                } else if (limit < 0) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit2"), (LanguageObject)obj);
                }
            }
        }
    }

    public void visit(OrderBy obj) {
        this.validateSortable(obj.getVariables());
    }

    public void visit(Query obj) {
        this.validateHasProjectedSymbols((Command)obj);
        if (this.isXMLCommand((Command)obj)) {
            if (obj.getInto() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0069"), (LanguageObject)obj);
            }
            this.isXML = true;
            this.validateXMLQuery(obj);
        } else {
            this.validateAggregates(obj);
            if (obj.getSelect() != null && obj.getFrom() == null && !CommandCollectorVisitor.getCommands((LanguageObject)obj).isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0067"), (LanguageObject)obj);
            }
            if (obj.getInto() != null) {
                this.validateSelectInto(obj);
            }
        }
    }

    public void visit(Select obj) {
        this.validateSelectElements(obj);
        if (obj.isDistinct()) {
            this.validateSortable(obj.getProjectedSymbols());
        }
    }

    public void visit(SubquerySetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        List projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0011"), (LanguageObject)obj);
        }
    }

    public void visit(DependentSetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(SetQuery obj) {
        this.validateHasProjectedSymbols((Command)obj);
        this.validateSetQuery(obj);
    }

    public void visit(Update obj) {
        this.validateNoXMLUpdates((Command)obj);
        this.validateHasProjectedSymbols((Command)obj);
        this.validateGroupUpdatable((Command)obj);
        this.validateUpdate(obj);
    }

    public void visit(Into obj) {
        Object groupID = obj.getGroup().getMetadataID();
        try {
            if (!obj.getGroup().isTempGroupSymbol() && this.getMetadata().isVirtualGroup(groupID)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0070"), (LanguageObject)obj);
            } else {
                this.validateGroupSupportsUpdate(obj.getGroup());
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    public void visit(Function obj) {
        if (obj.getFunctionDescriptor().getName().equalsIgnoreCase("lookup")) {
            Expression[] args = obj.getArgs();
            String elementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[2]).getValue();
            try {
                this.getMetadata().getElementID(elementName);
            }
            catch (QueryMetadataException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
        } else if (obj.getFunctionDescriptor().getName().equalsIgnoreCase("context")) {
            if (!this.isXML) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_context_function_cannot_be_used_in_a_non-XML_command"), (LanguageObject)obj);
            } else {
                if (!(obj.getArg(0) instanceof ElementSymbol)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.004.0036"), (LanguageObject)obj);
                }
                for (Function function : FunctionCollectorVisitor.getFunctions((LanguageObject)obj.getArg(1), (boolean)false)) {
                    if (!function.getFunctionDescriptor().getName().equalsIgnoreCase("context")) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Context_function_nested"), (LanguageObject)obj);
                }
            }
        } else if (obj.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || obj.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception")) {
            if (this.isXML) {
                if (!(obj.getArg(0) instanceof ElementSymbol)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.2"), (LanguageObject)obj);
                }
            } else {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_rowlimit_function_cannot_be_used_in_a_non-XML_command"), (LanguageObject)obj);
            }
        }
    }

    public void visit(AssignmentStatement obj) {
        ElementSymbol variable = obj.getVariable();
        String groupName = variable.getGroupSymbol().getCanonicalName();
        if (groupName.equals("INPUT") || groupName.equals("CHANGING")) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0012", new Object[]{"INPUT", "CHANGING"}), (LanguageObject)obj);
        }
        if (obj.hasCommand()) {
            this.transCommand = obj.getCommand();
            List projSymbols = this.transCommand.getProjectedSymbols();
            if (projSymbols.size() != 1) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0013"), (LanguageObject)obj);
            } else {
                SingleElementSymbol value = (SingleElementSymbol)projSymbols.iterator().next();
                Class valueType = value.getType();
                Class varType = variable.getType();
                if (!varType.equals(valueType)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0014"), (LanguageObject)obj);
                }
            }
        } else if (obj.hasExpression() && !CommandCollectorVisitor.getCommands((LanguageObject)obj.getExpression()).isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.assignment_subquery"), (LanguageObject)obj);
        }
    }

    public void visit(CommandStatement obj) {
        this.transCommand = obj.getCommand();
    }

    public void visit(CreateUpdateProcedureCommand obj) {
        if (!obj.isUpdateProcedure()) {
            if (CommandCollectorVisitor.getCommands((LanguageObject)obj).isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Procedure_should_have_query"), (LanguageObject)obj);
            }
            if (GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true).contains(obj.getVirtualGroup())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Procedure_has_group_self_reference"), (LanguageObject)obj);
            }
            return;
        }
        this.updateProc = obj;
        this.validateContainsRowsUpdatedVariable(obj);
        this.validateCursorNotSelected(obj);
    }

    public void visit(DeclareStatement obj) {
        ElementSymbol variable = obj.getVariable();
        String elementname = variable.getShortName().toUpperCase();
        if (elementname.equals("INPUT") || elementname.equals("CHANGING") || elementname.equals("ROWS_UPDATED")) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0017", new Object[]{"INPUT", "CHANGING", "ROWS_UPDATED"}), (LanguageObject)obj);
        }
        this.visit((AssignmentStatement)obj);
    }

    public void visit(IfStatement obj) {
        Criteria criteria = obj.getCondition();
        this.validatorCriteriaStatement((LanguageObject)obj, criteria);
    }

    public void visit(WhileStatement obj) {
        Criteria criteria = obj.getCondition();
        this.validatorCriteriaStatement((LanguageObject)obj, criteria);
    }

    private void validatorCriteriaStatement(LanguageObject obj, Criteria criteria) {
        for (Criteria predicateCriteria : PredicateCollectorVisitor.getPredicates((LanguageObject)criteria)) {
            Iterator elmntIter = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, (boolean)true).iterator();
            if (predicateCriteria instanceof TranslateCriteria) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0019"), obj);
                continue;
            }
            if (predicateCriteria instanceof HasCriteria) continue;
            while (elmntIter.hasNext()) {
                ElementSymbol element = (ElementSymbol)elmntIter.next();
                if (element.isExternalReference()) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0020"), obj);
            }
        }
        if (!CommandCollectorVisitor.getCommands((LanguageObject)criteria).isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.if_subquery"), obj);
        }
    }

    public void visit(TranslateCriteria obj) {
        if (obj.hasTranslations()) {
            List selectElmnts = null;
            if (obj.getSelector().hasElements()) {
                selectElmnts = obj.getSelector().getElements();
            }
            for (CompareCriteria transCrit : obj.getTranslations()) {
                if (!(transCrit.getLeftExpression() instanceof ElementSymbol)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.translate_wrong_type", (Object)transCrit.getRightExpression(), (Object)transCrit.getLeftExpression()), (LanguageObject)transCrit.getLeftExpression());
                    return;
                }
                ElementSymbol leftExpr = (ElementSymbol)transCrit.getLeftExpression();
                if (selectElmnts == null || selectElmnts.contains(leftExpr)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0021"), (LanguageObject)leftExpr);
            }
        }
        this.validateTranslateCriteria(obj);
    }

    public void visit(CompoundCriteria obj) {
        if (this.isXML) {
            ArrayList rowLimitFunctions = new ArrayList();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Iterator conjunctIter = Criteria.separateCriteriaByAnd((Criteria)obj).iterator();
                int i = 0;
                while (conjunctIter.hasNext() && i < functionCount) {
                    CompareCriteria crit;
                    Object conjunct = conjunctIter.next();
                    if (!(conjunct instanceof CompareCriteria) || !rowLimitFunctions.contains((crit = (CompareCriteria)conjunct).getLeftExpression()) && !rowLimitFunctions.contains(crit.getRightExpression())) continue;
                    ++i;
                }
                if (i < functionCount) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), (LanguageObject)obj);
                }
            }
        }
    }

    protected void validateTranslateCriteria(TranslateCriteria obj) {
        if (this.transCommand == null) {
            return;
        }
        List symbolMaps = this.updateProc.getSymbolMaps();
        if (symbolMaps == null) {
            return;
        }
        Map symbolMap = (Map)symbolMaps.get(0);
        Command userCommand = this.updateProc.getUserCommand();
        Criteria userCrit = null;
        int userCmdType = userCommand.getType();
        switch (userCmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
        }
        if (userCrit == null) {
            return;
        }
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)this.transCommand, (boolean)true);
        int selectType = obj.getSelector().getSelectorType();
        List selectElmnts = null;
        if (obj.getSelector().hasElements()) {
            selectElmnts = obj.getSelector().getElements();
        }
        HashMap<ElementSymbol, Expression> mappings = new HashMap<ElementSymbol, Expression>();
        if (obj.hasTranslations()) {
            for (CompareCriteria crit : obj.getTranslations()) {
                mappings.put((ElementSymbol)crit.getLeftExpression(), crit.getRightExpression());
            }
        }
        for (Criteria predCrit : PredicateCollectorVisitor.getPredicates((LanguageObject)userCrit)) {
            CompareCriteria ccCrit;
            if (selectType != 0 && (predCrit instanceof CompareCriteria ? selectType != (ccCrit = (CompareCriteria)predCrit).getOperator() : (predCrit instanceof MatchCriteria ? selectType != 7 : (predCrit instanceof IsNullCriteria ? selectType != 9 : (predCrit instanceof SetCriteria ? selectType != 8 : predCrit instanceof BetweenCriteria && selectType != 10))))) continue;
            boolean validate = false;
            Collection critEmlnt = ElementCollectorVisitor.getElements((LanguageObject)predCrit, (boolean)true);
            if (selectElmnts != null) {
                for (ElementSymbol symbol : critEmlnt) {
                    if (!selectElmnts.contains(symbol)) continue;
                    validate = true;
                    break;
                }
            }
            if (!validate) continue;
            for (ElementSymbol criteriaElement : critEmlnt) {
                Expression mappedExpr = (Expression)mappings.get(criteriaElement);
                if (mappedExpr != null) continue;
                mappedExpr = (Expression)symbolMap.get(criteriaElement);
                if (mappedExpr instanceof AggregateSymbol) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0022", (Object)criteriaElement), (LanguageObject)criteriaElement);
                }
                Iterator mapElmntIter = ElementCollectorVisitor.getElements((LanguageObject)mappedExpr, (boolean)true).iterator();
                boolean groupMatch = false;
                while (mapElmntIter.hasNext()) {
                    ElementSymbol mapElement = (ElementSymbol)mapElmntIter.next();
                    GroupSymbol mapGrp = mapElement.getGroupSymbol();
                    if (!groups.contains(mapGrp)) continue;
                    groupMatch = true;
                }
                if (groupMatch) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0023", (Object)criteriaElement), (LanguageObject)criteriaElement);
            }
        }
    }

    protected void validateSelectElements(Select obj) {
        if (this.isXML) {
            return;
        }
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)true);
        Collection cantSelect = this.validateElementsSupport(elements, 0);
        if (cantSelect != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0024", (Object)cantSelect), cantSelect);
        }
    }

    protected void validateHasProjectedSymbols(Command obj) {
        if (obj.getProjectedSymbols().size() == 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0025"), (LanguageObject)obj);
        }
    }

    protected void validateSortable(List symbols) {
        for (SingleElementSymbol symbol : symbols) {
            if (!ValidationVisitor.isNonComparable((Expression)symbol)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0026", (Object)symbol), (LanguageObject)symbol);
        }
    }

    public static boolean isNonComparable(Expression symbol) {
        Class type = symbol.getType();
        return DataTypeManager.DefaultDataClasses.OBJECT.equals(type) || DataTypeManager.DefaultDataClasses.BLOB.equals(type) || DataTypeManager.DefaultDataClasses.CLOB.equals(type) || DataTypeManager.DefaultDataClasses.XML.equals(type);
    }

    protected void validateNoXMLUpdates(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0029"), (LanguageObject)obj);
        }
    }

    protected void validateNoXMLProcedures(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0030"), (LanguageObject)obj);
        }
    }

    private void validateXMLQuery(Query obj) {
        if (obj.getGroupBy() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0031"), (LanguageObject)obj);
        }
        if (obj.getHaving() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0032"), (LanguageObject)obj);
        }
    }

    protected void validateGroupSupportsUpdate(GroupSymbol groupSymbol) throws QueryMetadataException, MetaMatrixComponentException {
        if (!this.getMetadata().groupSupports(groupSymbol.getMetadataID(), 0)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0033", (Object)SQLStringVisitor.getSQLString((LanguageObject)groupSymbol)), (LanguageObject)groupSymbol);
        }
    }

    protected void validateGroupUpdatable(Command obj) {
        try {
            Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true);
            this.validateGroupSupportsUpdate((GroupSymbol)groups.iterator().next());
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    protected void validateSetQuery(SetQuery query) {
        for (QueryCommand subQuery : query.getQueries()) {
            if (!this.isXMLCommand((Command)subQuery)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0034"), (LanguageObject)query);
        }
        boolean notAll = false;
        for (Boolean value : query.getUseAllFlags()) {
            if (value.booleanValue()) continue;
            notAll = true;
            break;
        }
        if (notAll) {
            this.validateSortable(query.getProjectedSymbols());
        }
    }

    private void validateAggregates(Query query) {
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        Criteria having = query.getHaving();
        if (groupBy != null || having != null || AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)query, (boolean)false).size() > 0) {
            List groupSymbols = null;
            if (groupBy != null) {
                groupSymbols = groupBy.getSymbols();
            }
            AggregateValidationVisitor visitor = new AggregateValidationVisitor(groupSymbols);
            if (having != null) {
                AggregateValidationVisitor.validate((LanguageObject)having, (AggregateValidationVisitor)visitor);
            }
            List projectedSymbols = select.getProjectedSymbols();
            for (SingleElementSymbol symbol : projectedSymbols) {
                if (symbol instanceof AliasSymbol) {
                    symbol = ((AliasSymbol)symbol).getSymbol();
                }
                if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                    if (groupSymbols != null && groupSymbols.contains(symbol)) continue;
                    AggregateValidationVisitor.validate((LanguageObject)((ExpressionSymbol)symbol).getExpression(), (AggregateValidationVisitor)visitor);
                    continue;
                }
                AggregateValidationVisitor.validate((LanguageObject)symbol, (AggregateValidationVisitor)visitor);
            }
            ValidatorReport report = visitor.getReport();
            Collection items = report.getItems();
            super.getReport().addItems(items);
        }
    }

    protected void validateInsert(Insert obj) {
        List vars = obj.getVariables();
        Iterator varIter = vars.iterator();
        List values = obj.getValues();
        Iterator valIter = values.iterator();
        GroupSymbol insertGroup = obj.getGroup();
        try {
            for (ElementSymbol insertElem : vars) {
                if (this.getMetadata().elementSupports(insertElem.getMetadataID(), 5)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0052", (Object)insertElem), (LanguageObject)insertElem);
            }
            LinkedList insertElmnts = new LinkedList(ResolverUtil.resolveElementsInGroup((GroupSymbol)insertGroup, (QueryMetadataInterface)this.getMetadata()));
            insertElmnts.removeAll(vars);
            for (ElementSymbol nextElmnt : insertElmnts) {
                if (this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 7) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 4) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 8)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0053", new Object[]{insertGroup, nextElmnt}), (LanguageObject)nextElmnt);
            }
            if (obj.getQuery() != null) {
                return;
            }
            if (vars.size() != values.size()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0051"), (LanguageObject)obj);
            }
            while (valIter.hasNext() && varIter.hasNext()) {
                Expression nextValue = (Expression)valIter.next();
                ElementSymbol nextVar = (ElementSymbol)varIter.next();
                if (!EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)nextValue, (boolean)true)) continue;
                try {
                    Object evaluatedValue = ExpressionEvaluator.evaluate((Expression)nextValue, null, null);
                    if (evaluatedValue != null || this.getMetadata().elementSupports(nextVar.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", (Object)SQLStringVisitor.getSQLString((LanguageObject)nextVar)), (LanguageObject)nextVar);
                }
                catch (ExpressionEvaluationException e) {}
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (QueryResolverException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validateUpdate(Update update) {
        try {
            List changeList = update.getChangeList();
            HashSet<ElementSymbol> changeVars = new HashSet<ElementSymbol>(changeList.size());
            for (CompareCriteria cc : changeList) {
                Collection elements;
                void var7_9;
                if (!(cc.getLeftExpression() instanceof ElementSymbol)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0057", (Object)SQLStringVisitor.getSQLString((LanguageObject)cc)), (LanguageObject)cc);
                    continue;
                }
                ElementSymbol elementID = (ElementSymbol)cc.getLeftExpression();
                if (elementID.isExternalReference()) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0058", (Object)SQLStringVisitor.getSQLString((LanguageObject)elementID)), (LanguageObject)elementID);
                }
                if (!this.getMetadata().elementSupports(elementID.getMetadataID(), 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0059", (Object)elementID), (LanguageObject)elementID);
                }
                changeVars.add(elementID);
                Expression expression = cc.getRightExpression();
                if (EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)expression, (boolean)true)) {
                    try {
                        Constant constant = new Constant(ExpressionEvaluator.evaluate((Expression)expression, null, null));
                    }
                    catch (ExpressionEvaluationException err) {
                        // empty catch block
                    }
                }
                if (var7_9 instanceof Constant) {
                    if (!((Constant)var7_9).isNull() || this.getMetadata().elementSupports(elementID.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0060", (Object)SQLStringVisitor.getSQLString((LanguageObject)elementID)), (LanguageObject)elementID);
                    continue;
                }
                if (var7_9 instanceof Reference) {
                    if (var7_9.getType() != null) continue;
                    ((Reference)var7_9).setExpression((Expression)new Constant(null, cc.getLeftExpression().getType()));
                    continue;
                }
                if (var7_9 instanceof Function) {
                    Function function = (Function)var7_9;
                    if (!FunctionLibrary.isConvert((Function)function) || !function.isImplicit() || DataTypeManager.isImplicitConversion((String)DataTypeManager.getDataTypeName((Class)function.getArg(0).getType()), (String)DataTypeManager.getDataTypeName((Class)function.getType()))) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0057", (Object)SQLStringVisitor.getSQLString((LanguageObject)cc)), (LanguageObject)cc);
                    continue;
                }
                if (EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)var7_9)) continue;
                GroupSymbol group = update.getGroup();
                if (!this.getMetadata().isVirtualGroup(group.getMetadataID()) || (elements = ElementCollectorVisitor.getElements((LanguageObject)var7_9, (boolean)false)).size() <= 0) continue;
                for (ElementSymbol element : elements) {
                    if (element.isExternalReference()) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0061", (Object)SQLStringVisitor.getSQLString((LanguageObject)var7_9)), (LanguageObject)var7_9);
                }
            }
            if (changeVars.size() < changeList.size()) {
                ArrayList dupList = new ArrayList();
                for (Object e : changeVars) {
                    int counter = 0;
                    Iterator changeIter = changeList.iterator();
                    while (changeIter.hasNext()) {
                        if (!((CompareCriteria)changeIter.next()).getLeftExpression().equals(e)) continue;
                        ++counter;
                    }
                    if (counter <= true) continue;
                    dupList.add(e);
                }
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0062", dupList), dupList);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)update);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)update);
        }
        if (update.getGroup().isTempTable()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.update_temp", (Object)update.getGroup()), (LanguageObject)update.getGroup());
        }
    }

    protected void validateSelectInto(Query query) {
        List symbols = query.getSelect().getProjectedSymbols();
        GroupSymbol intoGroup = query.getInto().getGroup();
        this.validateInto((LanguageObject)query, query.getOrderBy(), symbols, intoGroup);
    }

    private void validateInto(LanguageObject query, OrderBy orderBy, List symbols, GroupSymbol intoGroup) {
        try {
            List elementIDs = this.getMetadata().getElementIDsInGroupID(intoGroup.getMetadataID());
            if (symbols.size() != elementIDs.size()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_wrong_elements", new Object[]{new Integer(elementIDs.size()), new Integer(symbols.size())}), query);
                return;
            }
            for (int symbolNum = 0; symbolNum < symbols.size(); ++symbolNum) {
                Object[] params;
                String targetTypeName;
                Class symbolType;
                String symbolTypeName;
                SingleElementSymbol symbol = (SingleElementSymbol)symbols.get(symbolNum);
                Object elementID = elementIDs.get(symbolNum);
                if (!this.getMetadata().elementSupports(elementID, 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.element_updates_not_allowed", (Object)this.getMetadata().getFullName(elementID)), (LanguageObject)intoGroup);
                }
                if ((symbolTypeName = DataTypeManager.getDataTypeName((Class)(symbolType = symbol.getType()))).equals(targetTypeName = this.getMetadata().getElementType(elementID))) continue;
                if (!DataTypeManager.isImplicitConversion((String)symbolTypeName, (String)targetTypeName)) {
                    params = new Object[]{symbolTypeName, targetTypeName, new Integer(symbolNum + 1), query};
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_no_implicit_conversion", params), query);
                    continue;
                }
                if (orderBy == null || !orderBy.getResolvedVariables().contains(symbol)) continue;
                params = new Object[]{symbolTypeName, targetTypeName, symbol, query};
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_type_conversion", params), query);
            }
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), query);
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), query);
        }
    }

    protected void validateContainsRowsUpdatedVariable(CreateUpdateProcedureCommand obj) {
        final ArrayList assignVars = new ArrayList();
        LanguageVisitor visitor = new LanguageVisitor(){

            public void visit(AssignmentStatement obj) {
                assignVars.add(obj.getVariable());
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        boolean foundVar = false;
        for (ElementSymbol variable : assignVars) {
            if (!variable.getShortName().equalsIgnoreCase("ROWS_UPDATED")) continue;
            foundVar = true;
            break;
        }
        if (!foundVar) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0016", (Object)"ROWS_UPDATED"), (LanguageObject)obj);
        }
    }

    protected void validateCursorNotSelected(CreateUpdateProcedureCommand obj) {
        final ArrayList cursors = new ArrayList();
        LanguageVisitor cursorVisitor = new LanguageVisitor(){

            public void visit(LoopStatement obj) {
                cursors.add(obj.getCursorName().toUpperCase());
            }

            public void visit(GroupSymbol obj) {
                if (obj.getMetadataID() instanceof TempMetadataID && !obj.isTempGroupSymbol() && cursors.contains(obj.getName().toUpperCase())) {
                    ValidationVisitor.this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_cursor_reference", (Object)obj), (LanguageObject)obj);
                }
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)cursorVisitor);
    }

    private void validateRowLimitFunctionNotInInvalidCriteria(Criteria obj) {
        ArrayList rowLimitFunctions = new ArrayList();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        if (rowLimitFunctions.size() > 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), (LanguageObject)obj);
        }
    }

    public void visit(BetweenCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(IsNullCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(MatchCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(NotCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(SetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(SubqueryCompareCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
    }

    public void visit(Option obj) {
        List dep = obj.getDependentGroups();
        List notDep = obj.getNotDependentGroups();
        if (dep != null && !dep.isEmpty() && notDep != null && !notDep.isEmpty()) {
            String groupName2 = null;
            String notDepGroup2 = null;
            for (String groupName2 : dep) {
                for (String notDepGroup2 : notDep) {
                    if (!notDepGroup2.equalsIgnoreCase(groupName2)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.group_in_both_dep", (Object)groupName2), (LanguageObject)obj);
                    return;
                }
            }
        }
    }

    public void visit(DynamicCommand obj) {
        if (obj.getIntoGroup() != null) {
            this.validateInto((LanguageObject)obj, null, obj.getAsColumns(), obj.getIntoGroup());
        }
        if (!CommandCollectorVisitor.getCommands((LanguageObject)obj).isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.assignment_subquery"), (LanguageObject)obj);
        }
    }

    public void visit(Drop obj) {
        Drop drop = obj;
        if (!drop.getTable().isTempTable()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.drop_of_nontemptable", (Object)drop.getTable()), (LanguageObject)obj);
        }
    }
}

