/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.util.Permutation;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinRegion;
import com.metamatrix.query.optimizer.relational.rules.NewCalculateCostUtil;
import com.metamatrix.query.optimizer.relational.rules.RulePlanUnions;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.resolver.util.AccessPattern;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RulePlanJoins
implements OptimizerRule {
    public static final int EXHAUSTIVE_SEARCH_GROUPS = 6;

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        JoinRegion joinRegion2;
        ArrayList joinRegions = new ArrayList();
        RulePlanJoins.findJoinRegions(plan, null, joinRegions);
        Iterator joinRegionIter = joinRegions.iterator();
        while (joinRegionIter.hasNext()) {
            joinRegion2 = (JoinRegion)joinRegionIter.next();
            if (joinRegion2.getJoinSourceNodes().size() + joinRegion2.getDependentJoinSourceNodes().size() < 2) {
                joinRegionIter.remove();
                continue;
            }
            joinRegion2.initializeJoinInformation();
            if (joinRegion2.getUnsatisfiedAccessPatterns().isEmpty()) continue;
            if (!joinRegion2.isSatisfiable()) {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("RulePlanJoins.cantSatisfy", joinRegion2.getUnsatisfiedAccessPatterns()));
            }
            this.planForDependencies(joinRegion2);
        }
        for (JoinRegion joinRegion2 : joinRegions) {
            this.groupJoinsForPushing(metadata, capabilitiesFinder, joinRegion2, context);
        }
        joinRegionIter = joinRegions.iterator();
        while (joinRegionIter.hasNext()) {
            joinRegion2 = (JoinRegion)joinRegionIter.next();
            joinRegion2.getJoinSourceNodes().putAll(joinRegion2.getDependentJoinSourceNodes());
            joinRegion2.getCriteriaNodes().addAll(joinRegion2.getDependentCriteriaNodes());
            joinRegion2.getDependentJoinSourceNodes().clear();
            joinRegion2.getDependentCriteriaNodes().clear();
            if (joinRegion2.getJoinSourceNodes().size() < 2) {
                joinRegion2.reconstructJoinRegoin();
                joinRegionIter.remove();
                continue;
            }
            joinRegion2.initializeCostingInformation(metadata);
            Object[] bestOrder = this.findBestJoinOrder(joinRegion2, metadata);
            if (bestOrder == null) continue;
            joinRegion2.changeJoinOrder(bestOrder);
            joinRegion2.reconstructJoinRegoin();
        }
        return plan;
    }

    private void groupJoinsForPushing(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, JoinRegion joinRegion, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        Map accessMap = this.getAccessMap(metadata, capFinder, joinRegion);
        boolean structureChanged = false;
        for (Map.Entry entry : accessMap.entrySet()) {
            List accessNodes = (List)entry.getValue();
            if (accessNodes.size() < 2) continue;
            block1: for (int i = accessNodes.size() - 1; i >= 0; --i) {
                PlanNode accessNode1 = (PlanNode)accessNodes.get(i);
                for (int k = accessNodes.size() - 1; k >= 0; --k) {
                    if (k == i) continue;
                    PlanNode accessNode2 = (PlanNode)accessNodes.get(k);
                    List criteriaNodes = joinRegion.getCriteriaNodes();
                    LinkedList<PlanNode> joinCriteriaNodes = new LinkedList<PlanNode>();
                    boolean hasJoinCriteria = false;
                    for (PlanNode critNode : criteriaNodes) {
                        Set sources = (Set)joinRegion.getCritieriaToSourceMap().get(critNode);
                        if (sources == null || !sources.contains(accessNode1)) continue;
                        if (sources.contains(accessNode2) && sources.size() == 2) {
                            hasJoinCriteria = true;
                            if (!RuleRaiseAccess.canRaiseOverSelect(accessNode2, metadata, capFinder, critNode)) continue;
                            joinCriteriaNodes.add(critNode);
                            continue;
                        }
                        if (accessNodes.containsAll(sources)) continue;
                        hasJoinCriteria = true;
                    }
                    if ((!hasJoinCriteria || hasJoinCriteria && joinCriteriaNodes.isEmpty()) && !this.canPushCrossJoin(metadata, context, accessNode1, accessNode2)) continue;
                    ArrayList<PlanNode> toTest = new ArrayList<PlanNode>(2);
                    toTest.add(accessNode1);
                    toTest.add(accessNode2);
                    if (RuleRaiseAccess.canRaiseOverJoin(toTest, metadata, capFinder, Collections.EMPTY_LIST, JoinType.JOIN_CROSS) == null) continue;
                    structureChanged = true;
                    joinRegion.getCritieriaToSourceMap().keySet().removeAll(joinCriteriaNodes);
                    joinRegion.getCriteriaNodes().removeAll(joinCriteriaNodes);
                    joinRegion.getJoinSourceNodes().remove(accessNode1);
                    joinRegion.getJoinSourceNodes().remove(accessNode2);
                    accessNodes.remove(i);
                    accessNodes.remove(k < i ? k : k - 1);
                    PlanNode joinNode = RulePlanJoins.createJoinNode();
                    joinNode.getGroups().addAll(accessNode1.getGroups());
                    joinNode.getGroups().addAll(accessNode2.getGroups());
                    accessNode1.setParent(joinNode);
                    accessNode2.setParent(joinNode);
                    joinNode.addFirstChild(accessNode2);
                    joinNode.addLastChild(accessNode1);
                    PlanNode newAccess = RuleRaiseAccess.raiseAccessOverJoin(joinNode, entry.getKey(), false);
                    for (PlanNode critNode : joinCriteriaNodes) {
                        critNode.setProperty((Object)NodeConstants.Info.IS_COPIED, (Object)Boolean.FALSE);
                        critNode.setProperty((Object)NodeConstants.Info.IS_PUSHED, (Object)Boolean.FALSE);
                        NodeEditor.insertNode((PlanNode)newAccess, (PlanNode)newAccess.getFirstChild(), (PlanNode)critNode);
                    }
                    for (Set source : joinRegion.getCritieriaToSourceMap().values()) {
                        if (!source.remove(accessNode1) && !source.remove(accessNode2)) continue;
                        source.add(newAccess);
                    }
                    joinRegion.getJoinSourceNodes().put(newAccess, newAccess);
                    accessNodes.add(newAccess);
                    i = accessNodes.size();
                    k = accessNodes.size();
                    continue block1;
                }
            }
        }
        if (structureChanged) {
            joinRegion.reconstructJoinRegoin();
        }
    }

    private boolean canPushCrossJoin(QueryMetadataInterface metadata, CommandContext context, PlanNode accessNode1, PlanNode accessNode2) throws QueryMetadataException, MetaMatrixComponentException {
        float cost1 = NewCalculateCostUtil.computeCostForTree((PlanNode)accessNode1, (QueryMetadataInterface)metadata);
        float cost2 = NewCalculateCostUtil.computeCostForTree((PlanNode)accessNode2, (QueryMetadataInterface)metadata);
        float acceptableCost = context == null ? 45.0f : (float)Math.sqrt(context.getProcessorBatchSize());
        return !(cost1 == -1.0f || cost2 == -1.0f || cost1 > acceptableCost && cost2 > acceptableCost);
    }

    private Map getAccessMap(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, JoinRegion joinRegion) throws QueryMetadataException, MetaMatrixComponentException {
        HashMap accessMap = new HashMap();
        for (PlanNode node : joinRegion.getJoinSourceNodes().values()) {
            Object accessModelID;
            if (node.getType() != 3 || (accessModelID = RuleRaiseAccess.getModelIDFromAccess(node, metadata)) == null || !CapabilitiesUtil.supportsJoins((Object)accessModelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) continue;
            RulePlanUnions.buildModelMap((QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, accessMap, (PlanNode)node, (Object)accessModelID);
        }
        return accessMap;
    }

    private void planForDependencies(JoinRegion joinRegion) throws QueryPlannerException {
        if (joinRegion.getJoinSourceNodes().isEmpty()) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("RulePlanJoins.cantSatisfy", joinRegion.getUnsatisfiedAccessPatterns()));
        }
        HashSet currentGroups = new HashSet();
        for (PlanNode joinSource : joinRegion.getJoinSourceNodes().keySet()) {
            currentGroups.addAll(joinSource.getGroups());
        }
        HashMap dependentNodes = new HashMap(joinRegion.getDependentJoinSourceNodes());
        boolean satisfiedAP = true;
        while (!dependentNodes.isEmpty() && satisfiedAP) {
            satisfiedAP = false;
            Iterator joinSources = dependentNodes.entrySet().iterator();
            block2: while (joinSources.hasNext()) {
                Map.Entry entry = joinSources.next();
                PlanNode joinSource = (PlanNode)entry.getKey();
                Collection accessPatterns = (Collection)joinSource.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
                for (AccessPattern ap : accessPatterns) {
                    boolean foundGroups = true;
                    HashSet allRequiredGroups = new HashSet();
                    for (ElementSymbol symbol : ap.getUnsatisfied()) {
                        Collection requiredGroupsSet = (Collection)joinRegion.getDependentCriteriaElements().get(symbol);
                        boolean elementSatisfied = false;
                        if (requiredGroupsSet != null) {
                            for (Collection requiredGroups : requiredGroupsSet) {
                                if (!currentGroups.containsAll(requiredGroups)) continue;
                                elementSatisfied = true;
                                allRequiredGroups.addAll(requiredGroups);
                                break;
                            }
                        }
                        if (elementSatisfied) continue;
                        foundGroups = false;
                        break;
                    }
                    if (!foundGroups) continue;
                    joinSources.remove();
                    satisfiedAP = true;
                    joinSource.setProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED, ap.clone());
                    joinSource.setProperty((Object)NodeConstants.Info.REQUIRED_ACCESS_PATTERN_GROUPS, allRequiredGroups);
                    continue block2;
                }
            }
        }
        if (!dependentNodes.isEmpty()) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("RulePlanJoins.cantSatisfy", joinRegion.getUnsatisfiedAccessPatterns()));
        }
    }

    static PlanNode createJoinNode() {
        PlanNode joinNode = NodeFactory.getNewNode((int)7);
        joinNode.setProperty((Object)NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_CROSS);
        joinNode.setProperty((Object)NodeConstants.Info.JOIN_STRATEGY, (Object)JoinStrategyType.NESTED_LOOP);
        return joinNode;
    }

    static void findJoinRegions(PlanNode root, JoinRegion currentRegion, List joinRegions) {
        switch (root.getType()) {
            case 7: {
                JoinType jt;
                boolean treatJoinAsSource;
                if (currentRegion == null) {
                    currentRegion = new JoinRegion();
                    joinRegions.add(currentRegion);
                }
                boolean bl = treatJoinAsSource = (jt = (JoinType)root.getProperty((Object)NodeConstants.Info.JOIN_TYPE)).isOuter() || root.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS) != null || root.hasProperty((Object)NodeConstants.Info.MAKE_DEP);
                if (treatJoinAsSource) {
                    currentRegion.addJoinSourceNode(root);
                } else {
                    currentRegion.addParentCriteria(root);
                    currentRegion.addJoinCriteriaList((List)root.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA));
                }
                for (PlanNode child : root.getChildren()) {
                    RulePlanJoins.findJoinRegions(child, treatJoinAsSource ? null : currentRegion, joinRegions);
                }
                return;
            }
            case 19: {
                if (currentRegion != null) {
                    currentRegion.addJoinSourceNode(root);
                }
                currentRegion = null;
                break;
            }
            case 3: 
            case 31: {
                if (currentRegion != null) {
                    currentRegion.addJoinSourceNode(root);
                }
                return;
            }
        }
        if (root.getChildCount() == 0) {
            return;
        }
        for (PlanNode child : root.getChildren()) {
            RulePlanJoins.findJoinRegions(child, (JoinRegion)(root.getChildCount() == 1 ? currentRegion : null), joinRegions);
        }
    }

    Object[] findBestJoinOrder(JoinRegion region, QueryMetadataInterface metadata) {
        int regionCount = region.getJoinSourceNodes().size();
        ArrayList<Integer> orderList = new ArrayList<Integer>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            orderList.add(new Integer(i));
        }
        double bestSubScore = Double.MAX_VALUE;
        Object[] bestSubOrder = null;
        Permutation perms = new Permutation(orderList.toArray());
        int exhaustive = regionCount;
        if (regionCount > 6) {
            exhaustive = Math.max(2, 6 - (int)Math.ceil(Math.sqrt(regionCount - 6)));
        }
        Iterator permIter = perms.generate(exhaustive);
        while (permIter.hasNext()) {
            Object[] order = (Object[])permIter.next();
            double score = region.scoreRegion(order, metadata);
            if (!(score < bestSubScore)) continue;
            bestSubScore = score;
            bestSubOrder = order;
        }
        if (bestSubOrder == null) {
            return null;
        }
        if (regionCount <= exhaustive) {
            return bestSubOrder;
        }
        Object[] result = new Integer[regionCount];
        for (int i = 0; i < bestSubOrder.length; ++i) {
            orderList.remove(bestSubOrder[i]);
            result[i] = (Integer)bestSubOrder[i];
        }
        while (!orderList.isEmpty()) {
            double bestPartialScore = Double.MAX_VALUE;
            ArrayList<Object> bestOrder = null;
            for (int i = 0; i < orderList.size(); ++i) {
                Integer index = (Integer)orderList.get(i);
                ArrayList<Object> order = new ArrayList<Object>(Arrays.asList(bestSubOrder));
                order.add(index);
                double partialScore = region.scoreRegion(order.toArray(), metadata);
                if (!(partialScore < bestPartialScore)) continue;
                bestPartialScore = partialScore;
                bestOrder = order;
            }
            if (bestOrder == null) {
                return null;
            }
            Integer next = (Integer)bestOrder.get(bestOrder.size() - 1);
            result[regionCount - orderList.size()] = next;
            orderList.remove(next);
            bestSubOrder = bestOrder.toArray();
        }
        return result;
    }

    public String toString() {
        return "PlanJoins";
    }
}

