/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.aspects.sql;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.MappingClassSetContainer;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.xml.ChoiceOption;
import com.metamatrix.metamodels.xml.ValueType;
import com.metamatrix.metamodels.xml.XmlAll;
import com.metamatrix.metamodels.xml.XmlAttribute;
import com.metamatrix.metamodels.xml.XmlChoice;
import com.metamatrix.metamodels.xml.XmlComment;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentEntity;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlNamespace;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xml.XmlSequence;
import com.metamatrix.metamodels.xml.XmlValueHolder;
import com.metamatrix.metamodels.xml.namespace.NamespaceContext;
import com.metamatrix.metamodels.xml.util.XmlDocumentUtil;
import com.metamatrix.metamodels.xml.util.XmlNamespaceComparator;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspectHelper;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.xml.aspects.sql.MappingContext;
import com.metamatrix.modeler.internal.xml.aspects.sql.XmlDocumentMappingHelper;
import com.metamatrix.modeler.xml.PluginConstants;
import com.metamatrix.query.mapping.xml.MappingAllNode;
import com.metamatrix.query.mapping.xml.MappingAttribute;
import com.metamatrix.query.mapping.xml.MappingBaseNode;
import com.metamatrix.query.mapping.xml.MappingChoiceNode;
import com.metamatrix.query.mapping.xml.MappingCommentNode;
import com.metamatrix.query.mapping.xml.MappingCriteriaNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingElement;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.mapping.xml.MappingNodeConstants;
import com.metamatrix.query.mapping.xml.MappingOutputter;
import com.metamatrix.query.mapping.xml.MappingRecursiveElement;
import com.metamatrix.query.mapping.xml.MappingSequenceNode;
import com.metamatrix.query.mapping.xml.Namespace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;

public class MappingDocumentFormatter {
    static final String XSI_TYPE_ATTRIBUTE_NAME = "type";
    private boolean includeSoapDefaultEncoding = false;
    private final XmlDocument xmlDoc;
    private final MappingContext mappingContext;
    private final List treeMappingRoots;
    private final XmlDocumentMappingHelper helper;
    private boolean indent;
    private boolean newlines;

    public static MappingDocumentFormatter create(XmlDocument xmlDoc, MappingContext mappingContext) {
        MappingClassSet mappingClassSet;
        List treeMappingRoots = MappingDocumentFormatter.findTreeMappingRoot(xmlDoc);
        if (treeMappingRoots != null && treeMappingRoots.size() != 0 && (mappingClassSet = MappingDocumentFormatter.findMappingClassSet(xmlDoc)) != null) {
            MappingDocumentFormatter formatter = new MappingDocumentFormatter(xmlDoc, treeMappingRoots, mappingClassSet, mappingContext);
            return formatter;
        }
        return null;
    }

    protected static MappingClassSet findMappingClassSet(XmlDocument xmlDoc) {
        Resource resource = xmlDoc.eResource();
        if (resource == null) {
            return null;
        }
        for (Object rootObj : resource.getContents()) {
            if (!(rootObj instanceof MappingClassSetContainer)) continue;
            MappingClassSetContainer container = (MappingClassSetContainer)rootObj;
            for (MappingClassSet mcSet : container.getMappingClassSets()) {
                EObject target = mcSet.getTarget();
                if (target != xmlDoc) continue;
                return mcSet;
            }
        }
        return null;
    }

    protected static List findTreeMappingRoot(XmlDocument xmlDoc) {
        Resource resource = xmlDoc.eResource();
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<TransformationMappingRoot> treeMappingRoots = new LinkedList<TransformationMappingRoot>();
        for (Object rootObj : resource.getContents()) {
            if (!(rootObj instanceof TransformationContainer)) continue;
            TransformationContainer container = (TransformationContainer)rootObj;
            for (TransformationMappingRoot tmroot : container.getTransformationMappings()) {
                EObject target;
                if (!(tmroot instanceof TreeMappingRoot) || (target = tmroot.getTarget()) != xmlDoc) continue;
                treeMappingRoots.add(tmroot);
            }
        }
        return treeMappingRoots;
    }

    static String getNamespacePrefix(XmlDocumentNode elementOrAttribute, NamespaceContext context, MappingContext mappingContext) {
        if (elementOrAttribute == null) {
            return null;
        }
        XSDComponent xsdComponent = elementOrAttribute.getXsdComponent();
        XSDSchema startingSchema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        String defaultTargetNamespace = MappingDocumentFormatter.getTargetNamespace(startingSchema, elementOrAttribute, context, mappingContext);
        String prefix = MappingDocumentFormatter.getNamespacePrefix(xsdComponent, context, mappingContext, defaultTargetNamespace, true, true);
        return prefix;
    }

    static String getNamespacePrefix(XmlNamespace ns) {
        String prefix = ns.getPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = XmlDocumentUtil.createXmlPrefixFromUri((String)ns.getUri());
        }
        return prefix;
    }

    private static String getNamespacePrefix(XSDComponent xsdComponent, NamespaceContext context, MappingContext mappingContext, String defaultTargetNamespace, boolean checkWhetherPrefixIsRequired, boolean addIfMissing) {
        String prefix;
        if (xsdComponent == null) {
            return null;
        }
        XSDSchema schema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        if (schema == null) {
            return null;
        }
        String uri = schema.getTargetNamespace() == null ? defaultTargetNamespace : schema.getTargetNamespace();
        XmlNamespace namespace = context.getBestNamespace(uri);
        if (namespace == null) {
            if (XsdUtil.isBuiltInDatatype((XSDComponent)xsdComponent)) {
                String prefix2 = MappingDocumentFormatter.getSchemaNamespacePrefix(context);
                if (!checkWhetherPrefixIsRequired || MappingDocumentFormatter.isPrefixRequired(xsdComponent, schema, uri)) {
                    return prefix2;
                }
                return null;
            }
            if (uri != null && addIfMissing) {
                XmlNamespace newNs = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
                prefix = XmlDocumentUtil.createXmlPrefixFromUri((String)uri);
                if (prefix == null) {
                    prefix = "nspace";
                }
                newNs.setPrefix(prefix);
                newNs.setUri(uri);
                int counter = 0;
                while (!context.addXmlNamespace(newNs)) {
                    newNs.setPrefix(prefix + ++counter);
                }
                namespace = newNs;
            }
        }
        if (namespace != null) {
            String actualPrefix = namespace.getPrefix();
            if (actualPrefix == null || actualPrefix.trim().length() == 0) {
                return null;
            }
            prefix = MappingDocumentFormatter.getNamespacePrefix(namespace);
            if (!checkWhetherPrefixIsRequired || MappingDocumentFormatter.isPrefixRequired(xsdComponent, schema, uri)) {
                return prefix;
            }
            return null;
        }
        return null;
    }

    private static String getSchemaInstanceNamespacePrefix(NamespaceContext context) {
        for (XmlNamespace nsDecl : context.getAllXmlNamespaces()) {
            String uri = nsDecl.getUri();
            if (uri == null || !uri.startsWith("http://www.w3.org/") || !uri.endsWith("/XMLSchema-instance")) continue;
            return MappingDocumentFormatter.getNamespacePrefix(nsDecl);
        }
        String defaultPrefix = "xsi";
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("xsi");
        newNsDecl.setUri("http://www.w3.org/2001/XMLSchema-instance");
        context.addXmlNamespace(newNsDecl);
        return "xsi";
    }

    public static String getSchemaNamespacePrefix(NamespaceContext context) {
        for (XmlNamespace nsDecl : context.getAllXmlNamespaces()) {
            String uri = nsDecl.getUri();
            if (uri == null || !uri.startsWith("http://www.w3.org/") || !uri.endsWith("/XMLSchema")) continue;
            return MappingDocumentFormatter.getNamespacePrefix(nsDecl);
        }
        String defaultPrefix = "xsd";
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("xsd");
        newNsDecl.setUri("http://www.w3.org/2001/XMLSchema");
        context.addXmlNamespace(newNsDecl);
        return "xsd";
    }

    protected static String getSoapArrayType(XmlElement element, NamespaceContext context, MappingContext mappingContext) {
        XSDComponent xsdComponent = element.getXsdComponent();
        while (xsdComponent != null) {
            if (xsdComponent instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition complexTypeDefn = (XSDComplexTypeDefinition)xsdComponent;
                if (XSDConstants.isAnyType((XSDTypeDefinition)complexTypeDefn)) {
                    return null;
                }
                String name = complexTypeDefn.getName();
                if ("Array".equals(name)) {
                    XSDSchema schema = complexTypeDefn.getSchema();
                    String targetNS = schema.getTargetNamespace();
                    if ("http://schemas.xmlsoap.org/soap/encoding/".equals(targetNS)) {
                        XSDTypeDefinition schemaCompOfChildren = XsdUtil.getCommonBaseTypeForContained((XSDComponent)element.getXsdComponent());
                        if (schemaCompOfChildren == null) {
                            String namespacePrefix = MappingDocumentFormatter.getSchemaNamespacePrefix(context);
                            return namespacePrefix + ":anyType[]";
                        }
                        String namespacePrefix = MappingDocumentFormatter.getNamespacePrefix((XSDComponent)schemaCompOfChildren, context, mappingContext, null, false, true);
                        if (namespacePrefix == null && XsdUtil.isBuiltInDatatype((XSDComponent)schemaCompOfChildren)) {
                            namespacePrefix = MappingDocumentFormatter.getSchemaNamespacePrefix(context);
                        }
                        String result = null;
                        result = namespacePrefix != null && namespacePrefix.trim().length() != 0 ? namespacePrefix + ":" + schemaCompOfChildren.getName() + "[]" : schemaCompOfChildren.getName() + "[]";
                        return result;
                    }
                } else {
                    xsdComponent = complexTypeDefn.getBaseTypeDefinition();
                }
            }
            if (xsdComponent instanceof XSDSimpleTypeDefinition) {
                return null;
            }
            if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration elmDeclaration = (XSDElementDeclaration)xsdComponent;
                xsdComponent = elmDeclaration.getTypeDefinition();
            }
            if (xsdComponent instanceof XSDComplexTypeDefinition || xsdComponent instanceof XSDSimpleTypeDefinition || xsdComponent instanceof XSDElementDeclaration) continue;
            return null;
        }
        return null;
    }

    private static String getSoapEncodingNamespacePrefix(NamespaceContext context) {
        XmlNamespace namespace = context.getBestNamespace("http://schemas.xmlsoap.org/soap/encoding/");
        if (namespace != null) {
            String prefix = MappingDocumentFormatter.getNamespacePrefix(namespace);
            return prefix;
        }
        String defaultPrefix = "soap-enc";
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("soap-enc");
        newNsDecl.setUri("http://schemas.xmlsoap.org/soap/encoding/");
        context.addXmlNamespace(newNsDecl);
        return "soap-enc";
    }

    private static String getTargetNamespace(XSDSchema startingSchema, XmlDocumentNode element, NamespaceContext context, MappingContext mappingContext) {
        String targetNS;
        String resolvedTNS;
        XSDFeature resolvedComponent;
        if (element == null) {
            return null;
        }
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent instanceof XSDFeature && (resolvedComponent = XsdUtil.getResolved((XSDFeature)((XSDFeature)xsdComponent))) != null && resolvedComponent != xsdComponent && !StringUtil.isEmpty((String)(resolvedTNS = resolvedComponent.getTargetNamespace()))) {
            return resolvedTNS;
        }
        XSDSchema schema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        String string = targetNS = schema == null ? null : schema.getTargetNamespace();
        if (!StringUtil.isEmpty((String)targetNS)) {
            if (startingSchema != null && startingSchema.getTargetNamespace() == null) {
                if (MappingDocumentFormatter.hasMatchingIncludeDirective(schema, startingSchema)) {
                    return targetNS;
                }
                return null;
            }
            return targetNS;
        }
        XmlElement owner = MappingDocumentFormatter.getXmlElementContainer(element);
        return MappingDocumentFormatter.getTargetNamespace(startingSchema, (XmlDocumentNode)owner, context, mappingContext);
    }

    private static XSDSchema getTargetNamespaceSchema(XSDComponent xsdComponent, NamespaceContext context, MappingContext mappingContext) {
        XSDFeature resolvedComponent;
        if (xsdComponent == null) {
            return null;
        }
        XSDSchema schema = xsdComponent.getSchema();
        if (schema == null && xsdComponent.eIsProxy() && (schema = (xsdComponent = (XSDComponent)EcoreUtil.resolve((EObject)xsdComponent, (ResourceSet)mappingContext.getResourceSet())).getSchema()) == null) {
            URI componentURi = ModelerCore.getModelEditor().getUri((EObject)xsdComponent);
            String msg = PluginConstants.Util.getString("MappingDocumentFormatter.Unable_to_determine_schema_in_the_workspace_for_XsdComponent_{0}_when_deriving_Namespace_Prefix_1", (Object)componentURi);
            PluginConstants.Util.log(4, msg);
            return null;
        }
        if (xsdComponent instanceof XSDFeature && (resolvedComponent = XsdUtil.getResolved((XSDFeature)((XSDFeature)xsdComponent))) != null && resolvedComponent != xsdComponent) {
            XSDSchema resolvedSchema = resolvedComponent.getSchema();
            String resolvedTNS = resolvedComponent.getTargetNamespace();
            if (StringUtil.isEmpty((String)resolvedTNS)) {
                resolvedTNS = resolvedSchema.getTargetNamespace();
            }
            if (resolvedTNS != null && resolvedTNS.trim().length() != 0) {
                if (resolvedSchema != null && resolvedSchema.eIsProxy()) {
                    XSDResourceImpl resource;
                    URI proxyURI = ((InternalEObject)resolvedSchema).eProxyURI();
                    if (proxyURI != null && (resource = (XSDResourceImpl)mappingContext.getResourceSet().getResource(proxyURI.trimFragment(), true)) != null) {
                        schema = resource.getSchema();
                    }
                } else {
                    schema = resolvedSchema;
                }
            }
        }
        return schema;
    }

    private static XmlElement getXmlElementContainer(XmlDocumentNode element) {
        EObject owner;
        if (element == null) {
            return null;
        }
        for (owner = element.eContainer(); owner != null && !(owner instanceof XmlElement); owner = owner.eContainer()) {
        }
        return owner instanceof XmlElement ? (XmlElement)owner : null;
    }

    private static boolean hasMatchingIncludeDirective(XSDSchema schemaWithDirectives, XSDSchema schemaToCheck) {
        if (schemaWithDirectives != null && schemaToCheck != null) {
            for (Object content : schemaWithDirectives.eContents()) {
                XSDInclude includeDeclaration;
                XSDSchema resolvedSchema;
                String includeSchemaLocation;
                if (!(content instanceof XSDInclude) || (includeSchemaLocation = (resolvedSchema = (includeDeclaration = (XSDInclude)content).getResolvedSchema()).getSchemaLocation()) == null || !includeSchemaLocation.equals(schemaToCheck.getSchemaLocation())) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isPrefixRequired(XSDComponent component, XSDSchema schema, String schemaNamespaceUri) {
        boolean global = XsdUtil.isGlobal((XSDComponent)component);
        if (global) {
            return schemaNamespaceUri != null && schemaNamespaceUri.trim().length() != 0;
        }
        if (component instanceof XSDFeature) {
            XSDFeature feature = (XSDFeature)component;
            XSDFeature resolvedFeature = XsdUtil.getResolved((XSDFeature)feature);
            if (resolvedFeature != null && resolvedFeature != feature) {
                XSDSchema schemaForResolved = resolvedFeature.getSchema();
                String uri = schemaForResolved.getTargetNamespace();
                return MappingDocumentFormatter.isPrefixRequired((XSDComponent)resolvedFeature, resolvedFeature.getSchema(), uri);
            }
            XSDForm form = null;
            if (feature.isSetForm()) {
                form = feature.getForm();
            } else if (component instanceof XSDElementDeclaration) {
                form = schema.isSetElementFormDefault() ? schema.getElementFormDefault() : XSDForm.UNQUALIFIED_LITERAL;
            } else if (component instanceof XSDAttributeDeclaration) {
                form = schema.isSetAttributeFormDefault() ? schema.getAttributeFormDefault() : XSDForm.UNQUALIFIED_LITERAL;
            }
            if (form != null) {
                switch (form.getValue()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public MappingDocumentFormatter(XmlDocument xmlDoc, List treeMappingRoots, MappingClassSet mappingClassSet, MappingContext mappingContext) {
        ArgCheck.isNotNull((Object)xmlDoc);
        ArgCheck.isNotNull((Object)treeMappingRoots);
        ArgCheck.isNotNull((Object)mappingClassSet);
        this.includeSoapDefaultEncoding = false;
        this.xmlDoc = xmlDoc;
        this.treeMappingRoots = treeMappingRoots;
        this.mappingContext = mappingContext;
        this.helper = new XmlDocumentMappingHelper(this.treeMappingRoots);
    }

    protected void createAttributeNode(MappingElement parent, XmlAttribute element, ElementInfo elementInfo, MappingContext mappingContext) {
        String name = element.getName();
        String nsPrefix = MappingDocumentFormatter.getNamespacePrefix((XmlDocumentNode)element, elementInfo.getNamespaceContext(), mappingContext);
        MappingAttribute attribute = null;
        Namespace namespace = this.getNamespace(nsPrefix);
        if (nsPrefix != null && nsPrefix.equalsIgnoreCase("xmlns")) {
            namespace = new Namespace("", this.getFixedValue((XmlValueHolder)element));
            parent.addNamespace(namespace);
        } else if (name != null && nsPrefix != null && nsPrefix.equalsIgnoreCase("xmlns")) {
            namespace = new Namespace(name, this.getFixedValue((XmlValueHolder)element));
            parent.addNamespace(namespace);
        } else {
            attribute = new MappingAttribute(name, namespace);
            attribute.setNameInSource(this.getNameInSource((XmlDocumentEntity)element));
            attribute.setDefaultValue(this.getDefaultValue((XmlValueHolder)element));
            attribute.setValue(this.getFixedValue((XmlValueHolder)element));
            attribute.setExclude(element.isExcludeFromDocument());
            attribute.setNormalizeText(this.getXsiTypeTextNormalization((XmlDocumentNode)element, mappingContext));
            if (parent != null) {
                parent.addAttribute(attribute);
            }
        }
    }

    protected MappingNode createChoiceNode(MappingBaseNode parent, XmlChoice choice, ElementInfo elementInfo) {
        MappingCriteriaNode criteria = this.createCriteriaNode((ChoiceOption)choice);
        if (parent != null && parent instanceof MappingChoiceNode && criteria != null) {
            parent = ((MappingChoiceNode)parent).addCriteriaNode(criteria);
        }
        MappingChoiceNode choiceNode = new MappingChoiceNode(choice.getDefaultErrorMode().getValue() == 0);
        choiceNode.setExclude(choice.isExcludeFromDocument());
        choiceNode.setSource(this.getSource((XmlContainerNode)choice));
        parent.addChoiceNode(choiceNode);
        choiceNode.addStagingTable(this.getStagingTable((XmlDocumentEntity)choice));
        return choiceNode;
    }

    protected MappingNode createCommentNode(MappingElement parent, XmlComment comment, ElementInfo elementInfo) {
        String text = comment.getText();
        if (text != null && text.trim().length() > 0 && parent != null) {
            parent.addCommentNode(new MappingCommentNode(text));
        }
        return null;
    }

    MappingCriteriaNode createCriteriaNode(ChoiceOption element) {
        boolean defalt;
        String criteria = this.getCriteria(element);
        boolean bl = defalt = element.getDefaultFor() != null;
        if (criteria == null && !defalt) {
            criteria = "TRUE = FALSE";
        }
        return new MappingCriteriaNode(criteria, defalt);
    }

    protected MappingDocument createDocumentNode(XmlRoot xmlRoot, ElementInfo rootElementInfo, MappingContext mappingContext) {
        this.includeSoapDefaultEncoding = this.xmlDoc.getSoapEncoding().getValue() == 1;
        MappingDocument doc = new MappingDocument(this.xmlDoc.getEncoding(), this.xmlDoc.isFormatted());
        MappingElement rootNode = this.processElementNode((XmlElement)xmlRoot, rootElementInfo, mappingContext);
        doc.addChildElement(rootNode);
        return doc;
    }

    protected MappingNode createElementNode(MappingBaseNode parent, XmlElement element, ElementInfo elementInfo, MappingContext mappingContext) {
        MappingCriteriaNode criteria = this.createCriteriaNode((ChoiceOption)element);
        if (parent != null && parent instanceof MappingChoiceNode && criteria != null) {
            parent = ((MappingChoiceNode)parent).addCriteriaNode(criteria);
        }
        MappingElement node = this.processElementNode(element, elementInfo, mappingContext);
        if (parent != null) {
            parent.addChildElement(node);
        }
        return node;
    }

    public MappingDocument createMapping() {
        this.helper.initialize();
        XmlRoot xmlRootElement = this.xmlDoc.getRoot();
        NamespaceContext nsContext = new NamespaceContext((XmlElement)xmlRootElement, null);
        ElementInfo elementInfo = new ElementInfo(nsContext, null);
        MappingDocument docMappingNode = this.createDocumentNode(xmlRootElement, elementInfo, this.mappingContext);
        MappingElement rootNode = (MappingElement)docMappingNode.getRootNode();
        this.processNamespaces((List)xmlRootElement.getDeclaredNamespaces(), (MappingNode)rootNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getAttributes(), (MappingNode)rootNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getComments(), (MappingNode)rootNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getEntities(), (MappingNode)rootNode, nsContext, elementInfo);
        this.processChildren((List)xmlRootElement.getProcessingInstructions(), (MappingNode)rootNode, nsContext, elementInfo);
        return docMappingNode;
    }

    protected void createMapping(XmlDocumentEntity entity, MappingNode parent, NamespaceContext namespaceContext, MappingContext mappingContext, ElementInfo parentInfo) {
        int classifierId = entity.eClass().getClassifierID();
        MappingNode entityMappingNode = null;
        ElementInfo entityInfo = parentInfo;
        NamespaceContext entityNamespaceContext = namespaceContext;
        switch (classifierId) {
            case 3: {
                XmlElement element = (XmlElement)entity;
                entityNamespaceContext = new NamespaceContext(element, namespaceContext);
                entityInfo = new ElementInfo(entityNamespaceContext, parentInfo);
                entityMappingNode = this.createElementNode((MappingBaseNode)parent, element, entityInfo, mappingContext);
                this.processNamespaces((List)element.getDeclaredNamespaces(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getAttributes(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getComments(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getEntities(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getProcessingInstructions(), entityMappingNode, entityNamespaceContext, entityInfo);
                break;
            }
            case 4: {
                this.createAttributeNode((MappingElement)parent, (XmlAttribute)entity, entityInfo, mappingContext);
                break;
            }
            case 8: {
                this.createNamespaceAttribute((MappingElement)parent, (XmlNamespace)entity, entityInfo);
                break;
            }
            case 10: 
            case 11: {
                XmlContainerNode container = (XmlContainerNode)entity;
                entityMappingNode = this.createSequenceNode((MappingBaseNode)parent, container, entityInfo);
                EList kids = container.eContents();
                this.processChildren((List)kids, entityMappingNode, namespaceContext, parentInfo);
                break;
            }
            case 12: {
                XmlChoice choiceNode = (XmlChoice)entity;
                entityMappingNode = this.createChoiceNode((MappingBaseNode)parent, choiceNode, entityInfo);
                List optionsInOrder = choiceNode.getOrderedChoiceOptions();
                this.processChildren(optionsInOrder, entityMappingNode, namespaceContext, parentInfo);
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                this.createCommentNode((MappingElement)parent, (XmlComment)entity, entityInfo);
                break;
            }
        }
    }

    public String createMappingString() throws Exception {
        MappingDocument mapping = this.createMapping();
        String result = null;
        ByteArrayOutputStream moStream = null;
        try {
            moStream = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(moStream, true);
            MappingOutputter outputter = new MappingOutputter();
            outputter.write(mapping, pw, this.isNewlines(), this.isIndent());
            pw.flush();
            result = ((Object)moStream).toString();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (moStream != null) {
                try {
                    ((OutputStream)moStream).close();
                }
                catch (IOException e1) {
                    PluginConstants.Util.log((Throwable)e1);
                }
                moStream = null;
            }
        }
        return result;
    }

    protected void createNamespaceAttribute(MappingElement parent, XmlNamespace ns, ElementInfo elementInfo) {
        Namespace namespace = new Namespace(ns.getPrefix(), ns.getUri());
        parent.addNamespace(namespace);
    }

    protected MappingNode createSequenceNode(MappingBaseNode parent, XmlContainerNode compositor, ElementInfo elementInfo) {
        MappingCriteriaNode criteria = this.createCriteriaNode((ChoiceOption)compositor);
        if (parent != null && parent instanceof MappingChoiceNode && criteria != null) {
            parent = ((MappingChoiceNode)parent).addCriteriaNode(criteria);
        }
        MappingSequenceNode seqNode = null;
        if (compositor instanceof XmlSequence) {
            seqNode = parent.addSequenceNode(new MappingSequenceNode());
        } else if (compositor instanceof XmlAll) {
            seqNode = parent.addAllNode(new MappingAllNode());
        }
        seqNode.setExclude(compositor.isExcludeFromDocument());
        seqNode.setSource(this.getSource(compositor));
        seqNode.addStagingTable(this.getStagingTable((XmlDocumentEntity)compositor));
        return seqNode;
    }

    protected MappingNode createSoapArrayTypeAttribute(MappingElement parent, ElementInfo elementInfo) {
        String value = elementInfo.getSoapArrayType();
        if (value == null) {
            return null;
        }
        NamespaceContext context = elementInfo.getNamespaceContext();
        String prefix = MappingDocumentFormatter.getSoapEncodingNamespacePrefix(context);
        Namespace namespace = this.getNamespace(prefix);
        MappingAttribute attribute = new MappingAttribute("arrayType", namespace);
        attribute.setValue(value);
        attribute.setOptional(true);
        attribute.setAlwaysInclude(true);
        parent.addAttribute(attribute);
        return attribute;
    }

    protected MappingAttribute createXsiTypeAttribute(MappingElement parent, ElementInfo elementInfo) {
        String value = elementInfo.getXsiType();
        if (value == null) {
            return null;
        }
        NamespaceContext context = elementInfo.getNamespaceContext();
        String prefix = MappingDocumentFormatter.getSchemaInstanceNamespacePrefix(context);
        Namespace namespace = this.getNamespace(prefix);
        MappingAttribute attribute = new MappingAttribute(XSI_TYPE_ATTRIBUTE_NAME, namespace);
        attribute.setValue(value);
        attribute.setOptional(true);
        attribute.setAlwaysInclude(true);
        parent.addAttribute(attribute);
        return attribute;
    }

    String getBuitInType(XmlElement element) {
        MappingClassColumn mappingClassColumn = this.helper.getMappingClassColumn((XmlDocumentEntity)element);
        if (mappingClassColumn != null) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)mappingClassColumn);
            EObject dataType = columnAspect.getDatatype((EObject)mappingClassColumn);
            DatatypeManager dtm = ModelerCore.getBuiltInTypesManager();
            ArgCheck.isNotNull((Object)dtm);
            try {
                dataType = dtm.getDatatypeForXsdType(dataType);
            }
            catch (ModelerCoreException err) {
                PluginConstants.Util.log((Throwable)err);
            }
            if (dataType != null && dtm.isBuiltInDatatype(dataType)) {
                return dtm.getName(dataType);
            }
        }
        return "";
    }

    String getCriteria(ChoiceOption element) {
        String choiceCriteria = element.getChoiceCriteria();
        if (choiceCriteria != null && choiceCriteria.indexOf("mmuuid") >= 0) {
            choiceCriteria = SqlConverter.convertUUIDsToFullNames((String)choiceCriteria, (Container)ModelerCore.getContainer((EObject)element));
        }
        return choiceCriteria;
    }

    String getDefaultValue(XmlValueHolder valueHolder) {
        ValueType valueType;
        String value = valueHolder.getValue();
        if (value != null && (valueType = valueHolder.getValueType()).getValue() == 1) {
            return value;
        }
        return null;
    }

    String getFixedValue(XmlValueHolder valueHolder) {
        ValueType valueType;
        String value = valueHolder.getValue();
        if (value != null && (valueType = valueHolder.getValueType()).getValue() == 2) {
            return value;
        }
        return null;
    }

    protected String getFullName(EObject object) {
        SqlAspect sqlAspect = (SqlAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect(object, SqlAspect.class);
        if (sqlAspect != null) {
            return sqlAspect.getFullName(object);
        }
        return null;
    }

    int getMaxOccurrences(XmlElement element) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null) {
            return XsdUtil.getMaxOccurs((XSDComponent)xsdComponent);
        }
        return MappingNodeConstants.Defaults.DEFAULT_CARDINALITY_MAXIMUM_BOUND;
    }

    int getMinOccurrences(XmlElement element) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null) {
            return XsdUtil.getMinOccurs((XSDComponent)xsdComponent);
        }
        return MappingNodeConstants.Defaults.DEFAULT_CARDINALITY_MINIMUM_BOUND;
    }

    String getNameInSource(XmlDocumentEntity element) {
        MappingClassColumn mappingClassColumn = this.helper.getMappingClassColumn(element);
        if (mappingClassColumn != null) {
            return this.getFullName((EObject)mappingClassColumn);
        }
        return null;
    }

    Namespace getNamespace(String prefix) {
        if (prefix != null) {
            return new Namespace(prefix);
        }
        return MappingNodeConstants.NO_NAMESPACE;
    }

    String getRecursionCriteria(XmlElement element) {
        String criteria = null;
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive() && !StringUtil.isEmpty((String)(criteria = mappingClass.getRecursionCriteria()))) {
            criteria = StringUtil.replaceAll((String)criteria, (String)this.getFullName((EObject)mappingClass), (String)this.getRecursionMappingClass(element));
        }
        return criteria;
    }

    int getRecursionLimit(XmlElement element) {
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            return mappingClass.getRecursionLimit();
        }
        return MappingNodeConstants.Defaults.DEFAULT_RECURSION_LIMIT;
    }

    String getRecursionMappingClass(XmlElement element) {
        MappingClass rootMappingClass = this.helper.getRecusionRootMappingClass(element);
        if (rootMappingClass != null) {
            return this.getFullName((EObject)rootMappingClass);
        }
        return null;
    }

    private String getSource(XmlContainerNode compositor) {
        String fullName;
        String source = null;
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)compositor);
        if (mappingClass != null && (fullName = this.getFullName((EObject)mappingClass)) != null) {
            source = fullName;
        }
        return source;
    }

    String getSource(XmlDocumentEntity element) {
        MappingClass mappingClass = this.helper.getMappingClass(element);
        if (mappingClass != null) {
            return this.getFullName((EObject)mappingClass);
        }
        return null;
    }

    private String getStagingTable(XmlDocumentEntity compositor) {
        String stagingTable = null;
        StagingTable[] tempGroups = this.helper.getStagingTables(compositor);
        if (tempGroups != null && tempGroups.length != 0) {
            for (StagingTable st : tempGroups) {
                String fullName = this.getFullName((EObject)st);
                if (fullName == null) continue;
                stagingTable = fullName;
            }
        }
        return stagingTable;
    }

    protected String getXsiType(XmlElement element, NamespaceContext context, MappingContext mappingContext) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent == null) {
            return null;
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        String typeName = typeDefn.getName();
        String nsPrefix = MappingDocumentFormatter.getNamespacePrefix((XSDComponent)typeDefn, context, mappingContext, null, false, true);
        return nsPrefix == null ? typeName : nsPrefix + ":" + typeName;
    }

    protected String getXsiTypeTextNormalization(XmlDocumentNode node, MappingContext mappingContext) {
        XSDWhiteSpace whiteSpaceEnum;
        XSDSimpleTypeDefinition simpleTypeDefn;
        XSDWhiteSpaceFacet facet;
        XSDComponent xsdComponent = node.getXsdComponent();
        if (xsdComponent == null) {
            return "preserve";
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        if (typeDefn instanceof XSDSimpleTypeDefinition && (facet = (simpleTypeDefn = (XSDSimpleTypeDefinition)typeDefn).getEffectiveWhiteSpaceFacet()) != null && (whiteSpaceEnum = facet.getValue()) != null) {
            switch (whiteSpaceEnum.getValue()) {
                case 0: {
                    return "preserve";
                }
                case 1: {
                    return "replace";
                }
                case 2: {
                    return "collapse";
                }
            }
        }
        return "preserve";
    }

    public boolean isIndent() {
        return this.indent;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    boolean isNillable(XmlElement element) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null && xsdComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
            return xsdElement.isNillable();
        }
        return MappingNodeConstants.Defaults.DEFAULT_IS_NILLABLE;
    }

    boolean isRecursive(XmlElement element) {
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            return mappingClass.isRecursive();
        }
        return false;
    }

    protected void processChildren(List children, MappingNode parentMappingNode, NamespaceContext namespaceContext, ElementInfo parentInfo) {
        for (Object child : children) {
            if (!(child instanceof XmlDocumentEntity)) continue;
            this.createMapping((XmlDocumentEntity)child, parentMappingNode, namespaceContext, this.mappingContext, parentInfo);
        }
    }

    protected MappingElement processElementNode(XmlElement element, ElementInfo elementInfo, MappingContext mappingContext) {
        MappingElement node = null;
        String name = element.getName();
        String nsPrefix = MappingDocumentFormatter.getNamespacePrefix((XmlDocumentNode)element, elementInfo.getNamespaceContext(), mappingContext);
        Namespace namespace = this.getNamespace(nsPrefix);
        if (this.isRecursive(element)) {
            MappingRecursiveElement elem = new MappingRecursiveElement(name, namespace, this.getRecursionMappingClass(element));
            elem.setCriteria(this.getRecursionCriteria(element));
            elem.setRecursionLimit(this.getRecursionLimit(element), this.throwExceptionOnRecursionLimit(element));
            node = elem;
        } else {
            node = new MappingElement(name, namespace);
        }
        node.setMinOccurrs(this.getMinOccurrences(element));
        node.setMaxOccurrs(this.getMaxOccurrences(element));
        node.setNameInSource(this.getNameInSource((XmlDocumentEntity)element));
        node.setSource(this.getSource((XmlDocumentEntity)element));
        node.setDefaultValue(this.getDefaultValue((XmlValueHolder)element));
        node.setValue(this.getFixedValue((XmlValueHolder)element));
        node.setNillable(this.isNillable(element));
        node.setExclude(element.isExcludeFromDocument());
        node.setType(this.getBuitInType(element));
        node.setNormalizeText(this.getXsiTypeTextNormalization((XmlDocumentNode)element, mappingContext));
        node.addStagingTable(this.getStagingTable((XmlDocumentEntity)element));
        if (this.includeSoapDefaultEncoding) {
            String soapArrayType = MappingDocumentFormatter.getSoapArrayType(element, elementInfo.getNamespaceContext(), mappingContext);
            if (soapArrayType != null) {
                elementInfo.setSoapArrayType(soapArrayType);
                this.createSoapArrayTypeAttribute(node, elementInfo);
            }
            if (elementInfo.isXsiTypeRequired()) {
                String xsiTypeValue = this.getXsiType(element, elementInfo.getNamespaceContext(), mappingContext);
                elementInfo.setXsiType(xsiTypeValue);
                this.createXsiTypeAttribute(node, elementInfo);
            }
        }
        return node;
    }

    protected void processNamespaces(List children, MappingNode parentMappingNode, NamespaceContext namespaceContext, ElementInfo parentInfo) {
        LinkedList orderedNamespaces = new LinkedList(children);
        XmlNamespaceComparator comparator = new XmlNamespaceComparator();
        Collections.sort(orderedNamespaces, comparator);
        this.processChildren(orderedNamespaces, parentMappingNode, namespaceContext, parentInfo);
    }

    public void setIndent(boolean b) {
        this.indent = b;
    }

    public void setNewlines(boolean b) {
        this.newlines = b;
    }

    boolean throwExceptionOnRecursionLimit(XmlElement element) {
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            return mappingClass.getRecursionLimitErrorMode().getValue() == 0;
        }
        return MappingNodeConstants.Defaults.DEFAULT_EXCEPTION_ON_RECURSION_LIMIT;
    }

    static final class Soap {
        public static final String ARRAY_TYPE_XML_ATTRIBUTE_NAME = "arrayType";
        public static final String ARRAY_TYPE_NAME = "Array";
        public static final String TARGET_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/encoding/";
        public static final String DEFAULT_NAMESPACE_PREFIX = "soap-enc";

        Soap() {
        }
    }

    protected class ElementInfo {
        private String soapArrayType;
        private String xsiType;
        private final ElementInfo parentInfo;
        private final NamespaceContext namespaceContext;

        protected ElementInfo(NamespaceContext namespaceContext, ElementInfo parentInfo) {
            this.parentInfo = parentInfo;
            this.namespaceContext = namespaceContext;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public String getSoapArrayType() {
            return this.soapArrayType;
        }

        public XmlElement getXmlElement() {
            return this.namespaceContext.getXmlElement();
        }

        public String getXsiType() {
            return this.xsiType;
        }

        public boolean isXsiTypeRequired() {
            if (this.soapArrayType != null) {
                return true;
            }
            return this.parentInfo != null && this.parentInfo.getSoapArrayType() != null;
        }

        public void setSoapArrayType(String soapArrayType) {
            this.soapArrayType = soapArrayType;
        }

        public void setXsiType(String xsiType) {
            this.xsiType = xsiType;
        }
    }
}

