/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.exception.ConnectorException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class DocumentBuilder {
    public static final String PARM_INPUT_XPATH_TABLE_PROPERTY_NAME = "XPathRootForInput";
    private Map m_namespaceMap = new HashMap();
    private boolean m_useTypeAttributes = false;

    private Map getNamespaces() {
        return this.m_namespaceMap;
    }

    public String buildDocumentString(List contents, String topLevelXPath, String nsDecl) throws ConnectorException {
        Document doc = this.buildDocument(contents, topLevelXPath, nsDecl);
        return DocumentBuilder.outputDocToString(doc);
    }

    public Document buildDocument(List contents, String topLevelXPath, String nsDecl) throws ConnectorException {
        Document doc = null;
        this.setNamespaces(nsDecl);
        Element curElement = null;
        try {
            curElement = this.makeElement(curElement, topLevelXPath, false);
        }
        catch (IllegalNameException ex) {
            ConnectorException ce = new ConnectorException(topLevelXPath + " is not a valid XPath for the root request node." + "Change the Request table " + PARM_INPUT_XPATH_TABLE_PROPERTY_NAME);
            throw ce;
        }
        if (curElement == null) {
            throw new ConnectorException(Messages.getString((String)"HTTPExecutor.root.element.required"));
        }
        doc = this.makeTableLevelElements(curElement);
        Iterator iter = contents.iterator();
        this.processParameters(iter, curElement);
        Element nsHolder = doc.getRootElement();
        this.addAllNamespaces(nsHolder);
        return doc;
    }

    private void addAllNamespaces(Element nsHolder) {
        Map namespaceMap = this.getNamespaces();
        Iterator nsIter = namespaceMap.values().iterator();
        while (nsIter.hasNext()) {
            nsHolder.addNamespaceDeclaration((Namespace)nsIter.next());
        }
    }

    private Document makeTableLevelElements(Element curElement) throws ConnectorException {
        Element parentElement;
        Element walkupElement = curElement;
        while ((parentElement = (Element)walkupElement.getParent()) != null) {
            walkupElement = parentElement;
        }
        Document document = new Document(walkupElement);
        return document;
    }

    private void setNamespaces(String nsDecl) throws ConnectorException {
        if (nsDecl != null && nsDecl.trim().length() > 0) {
            String[] nsPairs = nsDecl.trim().replace('\"', '\u0000').replace('\'', '\u0000').split("xmlns:");
            for (int i = 1; i < nsPairs.length; ++i) {
                String[] nsSplit;
                if (nsPairs[i].startsWith(":")) {
                    nsPairs[i] = nsPairs[i].substring(1);
                }
                if ((nsSplit = nsPairs[i].split("=")).length != 2) {
                    throw new ConnectorException(Messages.getString((String)"DocumentBuilder.could.not.parse.namespaces"));
                }
                Namespace ns = Namespace.getNamespace((String)nsSplit[0].trim(), (String)nsSplit[1].trim());
                this.m_namespaceMap.put(nsSplit[0], ns);
            }
        }
    }

    private Element makeElement(Element colElement, String inputXPath, boolean dupLastElement) throws ConnectorException {
        if (inputXPath == null || inputXPath.trim().length() == 0) {
            return colElement;
        }
        Element tempElement = colElement;
        String tempXPath = inputXPath.trim();
        tempElement = this.visitXPath(colElement, tempXPath, dupLastElement);
        return tempElement;
    }

    private Element visitXPath(Element elem, String tempXPath, boolean dupLastElement) throws ConnectorException {
        int startParmIndx = 0;
        int endParmIndx = tempXPath.indexOf("/", startParmIndx);
        int endOfTempXPath = tempXPath.length() - 1;
        while (endParmIndx >= 0 && endParmIndx < endOfTempXPath) {
            elem = this.setElement(elem, tempXPath, startParmIndx, endParmIndx);
            startParmIndx = endParmIndx + 1;
            endParmIndx = this.checkForIndexEnd(tempXPath, startParmIndx);
        }
        String finalXpath = this.getFinalXPath(tempXPath, startParmIndx, endParmIndx);
        if (finalXpath != null) {
            elem = this.addOneElement(elem, finalXpath, dupLastElement);
        }
        return elem;
    }

    private int checkForIndexEnd(String tempXPath, int startParmIndx) {
        int endParmIndx = startParmIndx < tempXPath.length() - 1 ? tempXPath.indexOf("/", startParmIndx) : -1;
        return endParmIndx;
    }

    private String getFinalXPath(String tempXPath, int startParmIndx, int endParmIndx) {
        String finalXpath = null;
        if (endParmIndx > 0) {
            finalXpath = tempXPath.substring(startParmIndx, endParmIndx);
        } else if (startParmIndx <= tempXPath.length() - 1) {
            finalXpath = tempXPath.substring(startParmIndx);
        }
        return finalXpath;
    }

    private Element setElement(Element element, String tempXPath, int startParmIndx, int endParmIndx) throws ConnectorException {
        Element tempElement = element;
        if (endParmIndx > 0) {
            String tempXP = tempXPath.substring(startParmIndx, endParmIndx);
            if (tempXP.indexOf("..") >= 0) {
                throw new ConnectorException(Messages.getString((String)"HTTPExecutor.dot.notation.not.allowed"));
            }
            if (tempXP != null && tempXP.trim().length() > 0) {
                tempElement = this.addOneElement(tempElement, tempXP, false);
            }
        }
        return tempElement;
    }

    private void processParameters(Iterator iter, Element curElement) throws ConnectorException {
        CriteriaDesc parmCriteria = null;
        while (iter.hasNext()) {
            try {
                parmCriteria = (CriteriaDesc)iter.next();
                boolean isAutoIncrement = parmCriteria.isAutoIncrement();
                this.createParameterXML(curElement, parmCriteria, isAutoIncrement);
            }
            catch (Exception ex) {
                throw new ConnectorException(Messages.getString((String)"HTTPExecutor.error.building.column") + parmCriteria.getColumnName() + ": " + ex.toString());
            }
        }
    }

    private void createParameterXML(Element curElement, CriteriaDesc parmCriteria, boolean isAutoIncrement) throws ConnectorException {
        if (parmCriteria.isParentAttribute()) {
            curElement.setAttribute(parmCriteria.getInputXpath(), parmCriteria.getCurrentIndexValue());
        } else if (parmCriteria.isUnlimited() && !parmCriteria.isEnumeratedAttribute()) {
            this.createMultipleElementXML(curElement, parmCriteria, isAutoIncrement);
        } else {
            this.createSingleElementXML(curElement, parmCriteria, isAutoIncrement);
        }
    }

    private void createSingleElementXML(Element curElement, CriteriaDesc parmCriteria, boolean isAutoIncrement) throws ConnectorException {
        Element colElement = null;
        if (parmCriteria.isDataInAttribute()) {
            colElement = this.makeElement(curElement, parmCriteria.getInputXpath(), false);
            String attName = parmCriteria.getDataAttributeName();
            String namePart = this.getNamePart(attName);
            String nsPart = this.getNamespacePart(attName);
            Namespace attNS = Namespace.NO_NAMESPACE;
            if (nsPart != null) {
                attNS = (Namespace)this.m_namespaceMap.get(nsPart);
                colElement.setAttribute(namePart, parmCriteria.getCurrentIndexValue(), attNS);
            } else {
                colElement.setAttribute(attName, parmCriteria.getCurrentIndexValue());
            }
        } else {
            colElement = this.makeElement(curElement, parmCriteria.getInputXpath(), false);
            colElement.addContent(parmCriteria.getCurrentIndexValue());
        }
        if (isAutoIncrement) {
            String subscrValue = "[0]";
            colElement.setAttribute("SUBSCR", subscrValue);
        }
        if (this.useTypeAttributes()) {
            String xsdType = parmCriteria.getElement().getNativeType();
            if (xsdType == null) {
                try {
                    Method method = parmCriteria.getElement().getClass().getMethod("getModeledType", new Class[0]);
                    String type = parmCriteria.getElement().getModeledType();
                    String nsPart = type.substring(0, type.indexOf(35));
                    String namePart = type.substring(type.indexOf(35) + 1);
                    Iterator nsIter = this.getNamespaces().values().iterator();
                    String prefix = null;
                    while (nsIter.hasNext()) {
                        Namespace ns = (Namespace)nsIter.next();
                        if (!ns.getURI().equals(nsPart)) continue;
                        prefix = ns.getPrefix();
                    }
                    if (prefix == null) {
                        int prefixInt = 0;
                        while (this.getNamespaces().get("ns" + prefixInt) != null) {
                            ++prefixInt;
                        }
                        prefix = "ns" + prefixInt;
                        Namespace newNS = Namespace.getNamespace((String)prefix, (String)nsPart);
                        this.getNamespaces().put(prefix, newNS);
                    }
                    xsdType = prefix + ":" + namePart;
                }
                catch (NoSuchMethodException nme) {
                    throw new ConnectorException("column " + colElement.getName() + Messages.getString((String)"DocumentBuilder.encoding.type.required"));
                }
            }
            String xsiType = "type";
            String xsiNS = "http://www.w3.org/1999/XMLSchema-instance";
            String xsiPrefix = "xsi";
            Attribute type = new Attribute("type", xsdType, Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/1999/XMLSchema-instance"));
            colElement.setAttribute(type);
        }
    }

    private void createMultipleElementXML(Element curElement, CriteriaDesc parmCriteria, boolean isAutoIncrement) throws ConnectorException {
        if (parmCriteria.isSOAPArrayElement()) {
            this.createSOAPArrayElement(curElement, parmCriteria);
        } else {
            parmCriteria.resetIndex();
            boolean moreParms = true;
            boolean isDataInAttribute = parmCriteria.isDataInAttribute();
            String inputXpath = parmCriteria.getInputXpath();
            int x = 0;
            while (moreParms) {
                Element colElement = this.makeElement(curElement, inputXpath, true);
                if (isAutoIncrement) {
                    String subscrValue = "[" + Integer.toString(x) + "]";
                    colElement.setAttribute("SUBSCR", subscrValue);
                }
                if (isDataInAttribute) {
                    colElement.setAttribute(parmCriteria.getDataAttributeName(), parmCriteria.getCurrentIndexValue());
                } else {
                    colElement.setText(parmCriteria.getCurrentIndexValue());
                }
                moreParms = parmCriteria.incrementIndex();
                ++x;
            }
        }
    }

    private void createSOAPArrayElement(Element curElement, CriteriaDesc parmCriteria) throws ConnectorException {
        String inputXpath = parmCriteria.getInputXpath();
        curElement = this.visitXPath(curElement, inputXpath, false);
        parmCriteria.resetIndex();
        boolean moreParms = true;
        String nativeTypeInfo = parmCriteria.getNativeType();
        StringTokenizer tokenizer = new StringTokenizer(nativeTypeInfo, ";");
        String xsdTypeString = tokenizer.nextToken();
        int start = xsdTypeString.indexOf("\"");
        int end = xsdTypeString.indexOf("\"", start + 1);
        String xsdTypeValue = xsdTypeString.substring(start + 1, end);
        String arrayType = tokenizer.nextToken();
        start = arrayType.indexOf("\"");
        end = arrayType.indexOf("\"", start + 1);
        String arrayTypeValue = arrayType.substring(start + 1, end);
        end = arrayType.indexOf(":");
        String soapEncodingPrefix = arrayType.substring(0, end);
        String arrayNamespace = tokenizer.nextToken();
        start = arrayNamespace.indexOf(":");
        end = arrayNamespace.indexOf("=", start + 1);
        String arrayNamespacePrefixValue = arrayNamespace.substring(start + 1, end);
        start = arrayNamespace.indexOf("\"");
        String arrayNamespaceURIValue = arrayNamespace.substring(start + 1, arrayNamespace.length());
        arrayTypeValue = arrayTypeValue + "[" + parmCriteria.getNumberOfValues() + "]";
        if (!parmCriteria.isSimpleSoapElement()) {
            Element arrayElement = curElement.getParentElement();
            if (null == arrayElement.getAttribute("type", Namespace.XML_NAMESPACE)) {
                arrayElement.setAttribute("type", xsdTypeValue, Namespace.XML_NAMESPACE);
                Namespace soapEncodingNamespace = Namespace.getNamespace((String)soapEncodingPrefix, (String)"http://schemas.xmlsoap.org/soap/encoding/");
                arrayElement.setAttribute("arrayType", arrayTypeValue, soapEncodingNamespace);
            }
            curElement.detach();
            Element itemElement = arrayElement.getChild("item");
            if (null == itemElement) {
                itemElement = this.makeElement(arrayElement, "item", true);
            }
            itemElement.addContent((Content)curElement);
            curElement.setText(parmCriteria.getCurrentIndexValue());
        } else {
            if (null == curElement.getAttribute("type", Namespace.XML_NAMESPACE)) {
                curElement.setAttribute("type", xsdTypeValue, Namespace.XML_NAMESPACE);
                Namespace soapEncodingNamespace = Namespace.getNamespace((String)soapEncodingPrefix, (String)"http://schemas.xmlsoap.org/soap/encoding/");
                curElement.setAttribute("arrayType", arrayTypeValue, soapEncodingNamespace);
            }
            int x = 0;
            while (moreParms) {
                Element itemElement = this.makeElement(curElement, "item", true);
                itemElement.setText(parmCriteria.getCurrentIndexValue());
                moreParms = parmCriteria.incrementIndex();
                ++x;
            }
        }
    }

    private Element addOneElement(Element colElement, String inputXPath, boolean allowDup) throws ConnectorException {
        String tempXPath = inputXPath.trim();
        String elementName = this.getElementName(tempXPath);
        String nsPart = this.getNamespacePart(elementName);
        String namePart = this.getNamePart(elementName);
        Namespace elemNS = Namespace.NO_NAMESPACE;
        if (nsPart != null) {
            elemNS = (Namespace)this.getNamespaces().get(nsPart);
        }
        Element childElement = null;
        if (colElement != null && !allowDup) {
            childElement = colElement.getChild(namePart, elemNS);
        }
        if (childElement == null) {
            childElement = new Element(namePart, elemNS);
            if (colElement != null) {
                colElement.addContent((Content)childElement);
            }
        }
        this.addAttributes(childElement, tempXPath);
        return childElement;
    }

    private String getNamespacePart(String elemName) {
        int colonIndex = elemName.indexOf(58);
        if (colonIndex < 0) {
            return null;
        }
        return elemName.substring(0, colonIndex);
    }

    private String getNamePart(String elemName) {
        int colonIndex = elemName.indexOf(58);
        if (colonIndex < 0) {
            return elemName;
        }
        return elemName.substring(colonIndex + 1);
    }

    private void addAttributes(Element childElement, String tempXPath) throws ConnectorException {
        int startAttIndx = tempXPath.indexOf("[");
        while (startAttIndx > 0) {
            Namespace attNS;
            String namePart;
            int equalIndx = tempXPath.indexOf("=", startAttIndx);
            int endAttIndx = tempXPath.indexOf("]", startAttIndx);
            if (equalIndx > 0 && equalIndx < endAttIndx) {
                String attName = tempXPath.substring(startAttIndx + 1, equalIndx);
                namePart = this.getNamePart(attName);
                String nsPart = this.getNamespacePart(attName);
                attNS = Namespace.NO_NAMESPACE;
                if (nsPart != null) {
                    attNS = (Namespace)this.m_namespaceMap.get(nsPart);
                }
            } else {
                throw new ConnectorException(Messages.getString((String)"HTTPExecutor.bad.attribute.def"));
            }
            String attValue = tempXPath.substring(equalIndx + 1, endAttIndx);
            childElement.setAttribute(namePart, attValue, attNS);
            startAttIndx = tempXPath.indexOf("[", endAttIndx);
        }
    }

    private String getElementName(String tempXPath) {
        int startAttIndx = tempXPath.indexOf("[");
        String elementName = startAttIndx > 0 ? tempXPath.substring(0, startAttIndx).trim() : tempXPath;
        return elementName;
    }

    public static String outputDocToString(Document doc) {
        XMLOutputter out = new XMLOutputter();
        return out.outputString(doc).trim();
    }

    public void setUseTypeAttributes(boolean m_useTypeAttributes) {
        this.m_useTypeAttributes = m_useTypeAttributes;
    }

    private boolean useTypeAttributes() {
        return this.m_useTypeAttributes;
    }
}

