/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.membership.service;

import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.MembershipServiceException;
import com.metamatrix.api.exception.security.UnsupportedCredentialException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.model.ComponentCryptoUtil;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.membership.BasicMetaMatrixPrincipal;
import com.metamatrix.platform.security.membership.service.FailedAuthenticationToken;
import com.metamatrix.platform.security.membership.service.SuccessfulAuthenticationToken;
import com.metamatrix.platform.security.membership.spi.MembershipDomain;
import com.metamatrix.platform.security.membership.spi.MembershipSourceException;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.controller.AbstractService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class MembershipServiceImpl
extends AbstractService
implements MembershipServiceInterface {
    private List domains = new ArrayList();
    private String adminUsername = "metamatrixadmin";
    private String adminCredentials;
    private Pattern allowedAddresses;
    private boolean isSecurityEnabled = true;

    protected void initService(Properties env) throws ServiceException {
        this.adminUsername = env.getProperty("security.membership.admin.username", "metamatrixadmin");
        this.adminCredentials = env.getProperty("security.membership.admin.password");
        if (this.adminCredentials == null || this.adminCredentials.length() == 0) {
            throw new ServiceException(PlatformPlugin.Util.getString("MembershipServiceImpl.Root_password_required"));
        }
        String property = env.getProperty("metamatrix.security.admin.allowedHosts");
        if (property != null && property.length() > 0) {
            this.allowedAddresses = Pattern.compile(property);
        }
        this.isSecurityEnabled = Boolean.valueOf(env.getProperty("security.membership.security.enabled"));
        LogManager.logDetail((String)"MEMBERSHIP", (String)("Security Enabled: " + this.isSecurityEnabled));
        try {
            this.adminCredentials = new String(CryptoUtil.stringDecrypt((char[])this.adminCredentials.toCharArray()));
        }
        catch (CryptoException err) {
            LogManager.logCritical((String)"MEMBERSHIP", (Throwable)err, (String)PlatformPlugin.Util.getString("MembershipServiceImpl.Root_password_decryption_failed"));
            throw new ServiceException((Throwable)err);
        }
        String domainNameOrder = env.getProperty("security.membership.DomainOrder");
        if (domainNameOrder == null || domainNameOrder.trim().length() == 0) {
            return;
        }
        List domainNames = StringUtil.split((String)domainNameOrder, (String)",");
        Iterator domainNameItr = domainNames.iterator();
        while (domainNameItr.hasNext()) {
            String domainName = ((String)domainNameItr.next()).trim();
            MembershipDomain newDomain = null;
            try {
                AuthenticationProvider provider = CurrentConfiguration.getConfiguration().getAuthenticationProvider(domainName);
                if (provider != null) {
                    Properties props = ComponentCryptoUtil.getDecryptedProperties((ComponentDefn)provider);
                    if (!Boolean.valueOf(props.getProperty("activate")).booleanValue()) {
                        LogManager.logDetail((String)"MEMBERSHIP", (String)("Skipping initilization of inactive domain " + domainName));
                        continue;
                    }
                    newDomain = this.createDomain(domainName, props);
                }
                LogManager.logInfo((String)"MEMBERSHIP", (String)PlatformPlugin.Util.getString("MSG.014.407.0005", (Object)domainName));
                if (newDomain == null) continue;
                this.domains.add(new MembershipDomainHolder(newDomain, domainName));
            }
            catch (Throwable e) {
                String msg = PlatformPlugin.Util.getString("ERR.014.407.0021", (Object)domainName);
                LogManager.logCritical((String)"MEMBERSHIP", (Throwable)e, (String)msg);
                this.setInitException(new ServiceException(e, msg));
            }
        }
    }

    protected void closeService() throws Exception {
        String instanceName = this.getInstanceName();
        LogManager.logInfo((String)"MEMBERSHIP", (String)PlatformPlugin.Util.getString("MSG.014.407.0001", (Object)instanceName));
        this.shutdownDomains();
        LogManager.logInfo((String)"MEMBERSHIP", (String)PlatformPlugin.Util.getString("MSG.014.407.0002", (Object)instanceName));
    }

    private MembershipDomain createDomain(String domainName, Properties properties) throws ServiceException {
        MembershipDomain domain = null;
        String className = properties.getProperty("AuthDomainClass");
        if (className != null && className.length() > 0) {
            try {
                domain = (MembershipDomain)Class.forName(className).newInstance();
            }
            catch (Throwable e) {
                String msg = PlatformPlugin.Util.getString("ERR.014.407.0023", (Object)className);
                throw new ServiceException(e, "ERR.014.407.0023", msg);
            }
        } else {
            String msg = PlatformPlugin.Util.getString("ERR.014.407.0024", (Object)domainName);
            throw new ServiceException("ERR.014.407.0024", msg);
        }
        properties.setProperty("domainName", domainName);
        String propsString = properties.getProperty("propertiesFile");
        if (propsString != null) {
            Properties customProps = MembershipServiceImpl.loadFile(propsString, domain.getClass());
            properties.putAll((Map<?, ?>)customProps);
        }
        domain.initialize(properties);
        return domain;
    }

    private void shutdownDomains() {
        if (!this.isClosed()) {
            for (MembershipDomainHolder domainHolder : this.domains) {
                try {
                    domainHolder.getMembershipDomain().shutdown();
                }
                catch (Exception e) {
                    LogManager.logError((String)"MEMBERSHIP", (Throwable)e, (String)"ERR.014.407.0026");
                }
            }
            this.domains.clear();
        }
    }

    protected void waitForServiceToClear() throws Exception {
        this.shutdownDomains();
    }

    protected void killService() {
        this.shutdownDomains();
    }

    void setAllowedAddresses(Pattern allowedAddresses) {
        this.allowedAddresses = allowedAddresses;
    }

    void setAdminCredentials(String adminCredentials) {
        this.adminCredentials = adminCredentials;
    }

    public Serializable authenticateUser(String username, Credentials credential, Serializable trustedPayload, String applicationName) throws ServiceException {
        String msg;
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"authenticateUser", username, applicationName});
        if (credential != null) {
            String password = new String(credential.getCredentialsAsCharArray());
            if (CryptoUtil.isEncryptionEnabled() && CryptoUtil.isValueEncrypted((String)password)) {
                try {
                    credential = new Credentials(CryptoUtil.stringDecrypt((char[])password.toCharArray()));
                }
                catch (CryptoException err) {
                    msg = PlatformPlugin.Util.getString("MembershipServiceImpl.Decrypt_failed", (Object)username);
                    LogManager.logWarning((String)"MEMBERSHIP", (Throwable)err, (String)msg);
                }
            }
        }
        if (this.isSuperUser(username) || !this.isSecurityEnabled) {
            if (this.isSecurityEnabled && this.allowedAddresses != null) {
                SocketAddress address = MetaMatrixSessionInfo.getRemoteSocketAddress();
                if (!(address instanceof InetSocketAddress)) {
                    LogManager.logWarning((String)"MEMBERSHIP", (String)PlatformPlugin.Util.getString("MembershipServiceImpl.unknown_host"));
                    return new FailedAuthenticationToken();
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                InetAddress inetAddress = inetSocketAddress.getAddress();
                if (!this.allowedAddresses.matcher(inetAddress.getHostAddress()).matches()) {
                    LogManager.logWarning((String)"MEMBERSHIP", (String)PlatformPlugin.Util.getString("MembershipServiceImpl.invalid_host", (Object)inetAddress.getHostAddress(), (Object)this.allowedAddresses.pattern()));
                    return new FailedAuthenticationToken();
                }
            }
            if (!this.isSecurityEnabled || credential != null && this.adminCredentials.equals(String.valueOf(credential.getCredentialsAsCharArray()))) {
                return new SuccessfulAuthenticationToken(trustedPayload, username);
            }
            return new FailedAuthenticationToken();
        }
        String baseUsername = MembershipServiceImpl.getBaseUsername(username);
        for (MembershipDomainHolder entry : this.getDomainsForUser(username)) {
            String msg2;
            try {
                SuccessfulAuthenticationToken auth = entry.getMembershipDomain().authenticateUser(baseUsername, credential, trustedPayload, applicationName);
                if (auth != null) {
                    baseUsername = MembershipServiceImpl.escapeName(auth.getUserName());
                    String domain = entry.getDomainName();
                    if (auth.getDomainName() != null) {
                        domain = auth.getDomainName();
                    }
                    return new SuccessfulAuthenticationToken(auth.getPayload(), baseUsername + "@" + domain);
                }
                msg2 = PlatformPlugin.Util.getString("MembershipServiceImpl.Null_authentication", (Object)entry.getDomainName(), (Object)username);
                LogManager.logError((String)"MEMBERSHIP", (String)msg2);
                return new FailedAuthenticationToken();
            }
            catch (LogonException le) {
                msg2 = PlatformPlugin.Util.getString("MembershipServiceImpl.Logon_failed", (Object)entry.getDomainName(), (Object)username);
                LogManager.logWarning((String)"MEMBERSHIP", (Throwable)le, (Object[])new Object[]{msg2});
                return new FailedAuthenticationToken();
            }
            catch (InvalidUserException e) {
                msg2 = PlatformPlugin.Util.getString("MembershipServiceImpl.Invalid_user", (Object)entry.getDomainName(), (Object)username);
                LogManager.logDetail((String)"MEMBERSHIP", (Throwable)e, (String)msg2);
            }
            catch (UnsupportedCredentialException e) {
                msg2 = PlatformPlugin.Util.getString("MembershipServiceImpl.Unsupported_credentials", (Object)entry.getDomainName(), (Object)username);
                LogManager.logDetail((String)"MEMBERSHIP", (Throwable)e, (String)msg2);
            }
            catch (MembershipSourceException e) {
                msg2 = PlatformPlugin.Util.getString("MembershipServiceImpl.source_exception", (Object)entry.getDomainName());
                LogManager.logError((String)"MEMBERSHIP", (Throwable)e, (String)msg2);
            }
        }
        msg = PlatformPlugin.Util.getString("MembershipServiceImpl.Failed_authentication", (Object)username);
        LogManager.logDetail((String)"MEMBERSHIP", (String)msg);
        return new FailedAuthenticationToken();
    }

    static String getBaseUsername(String username) {
        if (username == null) {
            return username;
        }
        int index = MembershipServiceImpl.getQualifierIndex(username);
        String result = username;
        if (index != -1) {
            result = username.substring(0, index);
        }
        return result.replaceAll("\\\\@", "@");
    }

    static String escapeName(String name) {
        if (name == null) {
            return name;
        }
        return name.replaceAll("@", "\\\\@");
    }

    static String getDomainName(String username) {
        if (username == null) {
            return username;
        }
        int index = MembershipServiceImpl.getQualifierIndex(username);
        if (index != -1) {
            return username.substring(index + 1);
        }
        return null;
    }

    static int getQualifierIndex(String username) {
        block1: {
            int index = username.length();
            do {
                --index;
                if ((index = username.lastIndexOf("@", index)) == -1) break block1;
            } while (index <= 0 || username.charAt(index - 1) == '\\');
            return index;
        }
        return -1;
    }

    private Collection getDomainsForUser(String username) throws ServiceException {
        if (username == null) {
            return this.domains;
        }
        if (this.isSuperUser(username) || !this.isSecurityEnabled) {
            return Collections.EMPTY_LIST;
        }
        String domain = MembershipServiceImpl.getDomainName(username);
        if (domain == null) {
            return this.domains;
        }
        MembershipDomainHolder domainHolder = null;
        for (MembershipDomainHolder currentHolder : this.domains) {
            if (!domain.equalsIgnoreCase(currentHolder.getDomainName())) continue;
            domainHolder = currentHolder;
            break;
        }
        if (domainHolder == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<MembershipDomainHolder> result = new LinkedList<MembershipDomainHolder>();
        result.add(domainHolder);
        return result;
    }

    public MetaMatrixPrincipal getPrincipalForUser(String userName) throws MembershipServiceException, ServiceException, InvalidUserException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"getPrincipalForUser", userName});
        if (this.isSuperUser(userName) || !this.isSecurityEnabled) {
            return new BasicMetaMatrixPrincipal(userName, 2, Collections.EMPTY_SET);
        }
        String baseUsername = MembershipServiceImpl.getBaseUsername(userName);
        Collection userDomains = this.getDomainsForUser(userName);
        if (baseUsername == null || userDomains.size() != 1) {
            throw new InvalidUserException("ERR.014.407.0031", PlatformPlugin.Util.getString("ERR.014.407.0031", (Object)userName));
        }
        MembershipDomainHolder domain = (MembershipDomainHolder)userDomains.iterator().next();
        try {
            Set results = this.getDomainSpecificGroups(domain.getMembershipDomain().getGroupNamesForUser(baseUsername), domain.getDomainName());
            BasicMetaMatrixPrincipal result = new BasicMetaMatrixPrincipal(userName, 0, results);
            LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"The user \"", userName, "\" was obtained from domain \"", domain.getDomainName(), "\""});
            return result;
        }
        catch (InvalidUserException e) {
            String msg = PlatformPlugin.Util.getString("MembershipServiceImpl.User_does_not_exist", (Object)userName, (Object)domain.getDomainName());
            LogManager.logError((String)"MEMBERSHIP", (Throwable)e, (String)msg);
            throw new InvalidUserException(msg);
        }
        catch (Throwable e) {
            String msg = PlatformPlugin.Util.getString("MembershipServiceImpl.source_exception", (Object)domain.getDomainName());
            LogManager.logError((String)"MEMBERSHIP", (Throwable)e, (String)msg);
            throw new MembershipServiceException(msg);
        }
    }

    private Set getDomainSpecificGroups(Set groups, String domainName) {
        if (groups == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> results = new HashSet<String>();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            results.add(MembershipServiceImpl.escapeName((String)i.next()) + "@" + domainName);
        }
        return results;
    }

    public Set getGroupsForUser(String userName) throws MembershipServiceException, InvalidUserException, ServiceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"getGroupsForUser", userName});
        MetaMatrixPrincipal pricipal = this.getPrincipalForUser(userName);
        return pricipal.getGroupNames();
    }

    public String toString() {
        StringBuffer membershipDomains = new StringBuffer();
        membershipDomains.append("\n*** MembershipService: " + super.getInstanceName() + " ***\n");
        Iterator domainItr = this.domains.iterator();
        while (domainItr.hasNext()) {
            membershipDomains.append(domainItr.next().toString());
        }
        return membershipDomains.toString();
    }

    public Set getGroupNames() throws ServiceException, RemoteException, MembershipServiceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"getGroupNames"});
        HashSet result = new HashSet();
        for (MembershipDomainHolder domain : this.domains) {
            try {
                result.addAll(this.getDomainSpecificGroups(domain.getMembershipDomain().getGroupNames(), domain.getDomainName()));
            }
            catch (Throwable e) {
                String msg = PlatformPlugin.Util.getString("MembershipServiceImpl.source_exception", (Object)domain.getDomainName());
                LogManager.logError((String)"MEMBERSHIP", (Throwable)e, (String)msg);
                throw new MembershipServiceException(msg);
            }
        }
        return result;
    }

    protected List getDomains() {
        return this.domains;
    }

    public List getDomainNames() throws ServiceException, RemoteException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"getDomainNames"});
        ArrayList<String> names = new ArrayList<String>();
        for (MembershipDomainHolder domainHolder : this.domains) {
            String domainName = domainHolder.getDomainName();
            if (domainName == null) continue;
            names.add(domainName);
        }
        return names;
    }

    public Set getGroupsForDomain(String domainName) throws ServiceException, RemoteException, MembershipServiceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{"getGroupsForDomain", domainName});
        MembershipDomainHolder dHolder = null;
        for (MembershipDomainHolder domainHolder : this.domains) {
            String holderName = domainHolder.getDomainName();
            if (holderName == null || !holderName.equalsIgnoreCase(domainName)) continue;
            dHolder = domainHolder;
        }
        if (dHolder == null) {
            return Collections.EMPTY_SET;
        }
        try {
            return dHolder.getMembershipDomain().getGroupNames();
        }
        catch (Throwable e) {
            String msg = PlatformPlugin.Util.getString("MembershipServiceImpl.source_exception", (Object)dHolder.getDomainName());
            LogManager.logError((String)"MEMBERSHIP", (Throwable)e, (String)msg);
            throw new MembershipServiceException(msg);
        }
    }

    public boolean isSuperUser(String username) throws ServiceException {
        return this.adminUsername.equalsIgnoreCase(username);
    }

    public boolean isSecurityEnabled() throws MembershipServiceException, ServiceException, RemoteException {
        return this.isSecurityEnabled;
    }

    public static Properties loadFile(String fileName, Class clazz) throws ServiceStateException {
        Properties result = new Properties();
        InputStream is = clazz.getResourceAsStream(fileName);
        if (is == null) {
            try {
                is = new FileInputStream(fileName);
            }
            catch (FileNotFoundException err) {
                try {
                    is = new URL(fileName).openStream();
                }
                catch (MalformedURLException err1) {
                    throw new ServiceStateException((Throwable)err, PlatformPlugin.Util.getString("MembershipServiceImpl.load_error", (Object)fileName));
                }
                catch (IOException err1) {
                    throw new ServiceStateException((Throwable)err1, PlatformPlugin.Util.getString("MembershipServiceImpl.load_error", (Object)fileName));
                }
            }
        }
        try {
            result.load(is);
        }
        catch (IOException err) {
            throw new ServiceStateException((Throwable)err, PlatformPlugin.Util.getString("MembershipServiceImpl.load_error", (Object)fileName));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException err) {}
        }
        return result;
    }

    static class MembershipDomainHolder {
        private MembershipDomain membershipDomain;
        private String domainName;

        public MembershipDomainHolder(MembershipDomain domain, String domainName) {
            this.membershipDomain = domain;
            this.domainName = domainName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public MembershipDomain getMembershipDomain() {
            return this.membershipDomain;
        }
    }
}

