/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import com.metamatrix.internal.core.text.MessageFormat;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class SQLConversionVisitor
extends SQLStringVisitor {
    private static DecimalFormat decimalFormatter = new DecimalFormat("#############################0.0#############################");
    private static double SCIENTIC_LOW = Math.pow(10.0, -3.0);
    private static double SCIENTIC_HIGH = Math.pow(10.0, 7.0);
    private static final MessageFormat COMMENT = new MessageFormat("/*metamatrix sessionid:{0}, requestid:{1}.{2}*/ ");
    private boolean useComment = false;
    private Map modifiers;
    private ExecutionContext context;
    private ILanguageFactory languageFactory;
    private TimeZone databaseTimeZone;
    private int execType = 0;
    private int stmtType = 0;
    private List preparedValues = new ArrayList();
    private List preparedTypes = new ArrayList();
    static final FieldPosition FIELD_ZERO = new FieldPosition(0);

    public void visit(IInsert obj) {
        this.execType = 1;
        super.visit(obj);
    }

    public void visit(IBulkInsert obj) {
        this.stmtType = 1;
        super.visit(obj);
        for (int i = 0; i < obj.getElements().size(); ++i) {
            IElement element = (IElement)obj.getElements().get(i);
            this.preparedTypes.add(element.getType());
        }
        this.preparedValues = obj.getRows();
    }

    private void translateSQLType(Class type, Object obj, StringBuffer valuesbuffer) {
        if (obj == null) {
            valuesbuffer.append("NULL");
        } else if (Number.class.isAssignableFrom(type)) {
            boolean useFormatting = false;
            if (Double.class.isAssignableFrom(type)) {
                double value = (Double)obj;
                useFormatting = value <= SCIENTIC_LOW || value >= SCIENTIC_HIGH;
            } else if (Float.class.isAssignableFrom(type)) {
                float value = ((Float)obj).floatValue();
                boolean bl = useFormatting = (double)value <= SCIENTIC_LOW || (double)value >= SCIENTIC_HIGH;
            }
            if (useFormatting) {
                valuesbuffer.append(decimalFormatter.format(obj));
            } else {
                valuesbuffer.append(obj);
            }
        } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            valuesbuffer.append(this.translateLiteralBoolean((Boolean)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            valuesbuffer.append(this.translateLiteralTimestamp((Timestamp)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            valuesbuffer.append(this.translateLiteralTime((Time)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            valuesbuffer.append(this.translateLiteralDate((Date)obj));
        } else {
            valuesbuffer.append("'").append(this.escapeString(obj.toString())).append("'");
        }
    }

    public void visit(IUpdate obj) {
        this.execType = 1;
        super.visit(obj);
    }

    public void visit(IQuery obj) {
        this.execType = 0;
        super.visit(obj);
    }

    public void visit(IProcedure obj) {
        this.execType = 2;
        this.stmtType = 2;
        this.preparedValues = obj.getParameters();
        this.buffer.append(this.generateSqlForStoredProcedure(obj));
    }

    public void visit(IDelete obj) {
        this.execType = 1;
        super.visit(obj);
    }

    public void visit(IFunction obj) {
        List parts;
        FunctionModifier functionModifier;
        if (this.modifiers != null && (functionModifier = (FunctionModifier)this.modifiers.get(obj.getName().toLowerCase())) != null && (parts = functionModifier.translate(obj)) != null) {
            for (Object part : parts) {
                if (part instanceof String) {
                    this.buffer.append(part);
                    continue;
                }
                this.append((ILanguageObject)part);
            }
            return;
        }
        super.visit(obj);
    }

    public void visit(ILiteral obj) {
        if (this.stmtType == 1 && obj.isBindValue()) {
            this.buffer.append("?");
            this.preparedValues.add(obj.getValue());
            this.preparedTypes.add(obj.getType());
        } else {
            this.translateSQLType(obj.getType(), obj.getValue(), this.buffer);
        }
    }

    protected String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "1";
        }
        return "0";
    }

    protected String translateLiteralDate(Date dateValue) {
        return "{d'" + this.formatDateValue(dateValue) + "'}";
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{t'" + this.formatDateValue(timeValue) + "'}";
    }

    protected String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts'" + this.formatDateValue(timestampValue) + "'}";
    }

    protected String formatDateValue(Object dateObject) {
        if (this.databaseTimeZone == null) {
            int idx;
            Timestamp ts;
            String tsStr = dateObject.toString();
            if (dateObject instanceof Timestamp && (ts = (Timestamp)dateObject).getNanos() == 0 && (idx = tsStr.lastIndexOf(".")) > -1) {
                tsStr = tsStr.substring(0, idx);
            }
            return tsStr;
        }
        if (dateObject instanceof Timestamp) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            timestampFormatter.setTimeZone(this.databaseTimeZone);
            Timestamp ts = (Timestamp)dateObject;
            String tsStr = null;
            String nanoStr = null;
            if (ts.getNanos() > 0) {
                nanoStr = "" + (1000000000L + (long)ts.getNanos());
                while (nanoStr.length() > 2 && nanoStr.charAt(nanoStr.length() - 1) == '0') {
                    nanoStr = nanoStr.substring(0, nanoStr.length() - 1);
                }
            }
            tsStr = timestampFormatter.format(ts) + (nanoStr != null ? "." + nanoStr.substring(1) : "");
            return tsStr;
        }
        if (dateObject instanceof Date) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            dateFormatter.setTimeZone(this.databaseTimeZone);
            return dateFormatter.format((Date)dateObject);
        }
        if (dateObject instanceof Time) {
            SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
            timeFormatter.setTimeZone(this.databaseTimeZone);
            return timeFormatter.format((Time)dateObject);
        }
        return dateObject.toString();
    }

    public void setFunctionModifiers(Map modifiers) {
        this.modifiers = modifiers;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    protected ExecutionContext getExecutionContext() {
        return this.context;
    }

    public void setProperties(Properties props) {
        String useCommentInSource;
        String useBindVariables = props.getProperty("UseBindVariables", Boolean.FALSE.toString());
        if (useBindVariables.equals(Boolean.TRUE.toString())) {
            this.stmtType = 1;
        }
        if ((useCommentInSource = props.getProperty("UseCommentsInSourceQuery")) != null) {
            this.useComment = Boolean.valueOf(useCommentInSource);
        }
    }

    protected boolean supportsComments() {
        return this.useComment;
    }

    protected String addProcessComment() {
        if (this.supportsComments() && this.context != null) {
            return COMMENT.format((Object)new Object[]{this.context.getConnectionIdentifier(), this.context.getRequestIdentifier(), this.context.getPartIdentifier()});
        }
        return super.addProcessComment();
    }

    protected String generateSqlForStoredProcedure(IProcedure exec) {
        StringBuffer prepareCallBuffer = new StringBuffer();
        prepareCallBuffer.append("{ ");
        List params = exec.getParameters();
        boolean needQuestionMark = false;
        for (IParameter param : params) {
            if (param.getDirection() != 3) continue;
            needQuestionMark = true;
            break;
        }
        prepareCallBuffer.append(this.addProcessComment());
        if (needQuestionMark) {
            prepareCallBuffer.append("?=");
        }
        prepareCallBuffer.append(" call ");
        prepareCallBuffer.append(exec.getMetadataID() != null ? this.getName(exec.getMetadataID()) : exec.getProcedureName());
        prepareCallBuffer.append("(");
        int numberOfParameters = 0;
        for (IParameter param : params) {
            if (param.getDirection() != 0 && param.getDirection() != 1 && param.getDirection() != 2) continue;
            if (numberOfParameters > 0) {
                prepareCallBuffer.append(",");
            }
            prepareCallBuffer.append("?");
            ++numberOfParameters;
        }
        prepareCallBuffer.append(")");
        prepareCallBuffer.append("}");
        return prepareCallBuffer.toString();
    }

    public void setLanguageFactory(ILanguageFactory factory) {
        this.languageFactory = factory;
    }

    public ILanguageFactory getLanguageFactory() {
        return this.languageFactory;
    }

    public void setDatabaseTimeZone(TimeZone zone) {
        this.databaseTimeZone = zone;
    }

    protected TimeZone getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }

    protected int getExecType() {
        return this.execType;
    }

    List getPreparedValues() {
        return this.preparedValues;
    }

    List getPreparedTypes() {
        return this.preparedTypes;
    }

    int getStmtType() {
        return this.stmtType;
    }

    protected void setStmtType(int stmtType) {
        this.stmtType = stmtType;
    }
}

