/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.validation;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.internal.core.index.ModelResourceIndexSelector;
import com.metamatrix.modeler.internal.core.index.NullIndexSelector;
import com.metamatrix.modeler.internal.core.index.TargetLocationIndexSelector;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFacade;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.transformation.metadata.VdbMetadata;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidationResult;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.StoredProcedureInfo;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.report.ReportItem;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.QueryValidationResult;
import com.metamatrix.query.resolver.util.QueryValidator;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.validator.Validator;
import com.metamatrix.query.validator.ValidatorReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class TransformationValidator
implements QueryValidator {
    private static final boolean DEFAULT_USE_CACHING = true;
    public static final String QUERY_METADATA_INTERFACE = ClassUtil.getSimpleClassName(TransformationValidator.class) + ".QUERY_METADATA_INTERFACE";
    private QueryMetadataInterface metadata;
    private final boolean restrictSearch;
    private final SqlTransformationMappingRoot mappingRoot;
    private final EObject targetGroup;
    private final ValidationContext validationContext;
    private static final String XML_URI = "http://www.metamatrix.com/metamodels/XmlDocument";

    public TransformationValidator(SqlTransformationMappingRoot eObject) {
        this(eObject, null, true, false);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, boolean useCaching) {
        this(eObject, null, useCaching, false);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, boolean useCaching, boolean restrictSearch) {
        this(eObject, null, useCaching, restrictSearch);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, ValidationContext context, boolean useCaching, boolean restrictSearch) {
        this.restrictSearch = restrictSearch;
        this.mappingRoot = eObject;
        this.targetGroup = eObject.getTarget();
        this.validationContext = context;
    }

    public TransformationValidationResult validateTransformation() {
        EmfResource emfResource = (EmfResource)this.mappingRoot.eResource();
        if (emfResource.getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && XML_URI.equals(stringURI)) {
                return new TransformationValidationResult();
            }
        }
        SqlTransformation sqlTrans = (SqlTransformation)this.mappingRoot.getHelper();
        String objectPath = TransformationHelper.getSqlEObjectPath(this.targetGroup);
        if (sqlTrans == null) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.Error_in_the_Sql_tranformation_for_1", (Object)objectPath);
            ArrayList<Status> statuses = new ArrayList<Status>(1);
            statuses.add(new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null));
            return new TransformationValidationResult(statuses);
        }
        TransformationValidationResult transformResult = new TransformationValidationResult();
        SqlTransformationResult selectStatus = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.mappingRoot, (int)0, (int)SqlMappingRootCache.EITHER_STATUS, (boolean)this.restrictSearch, (ValidationContext)this.validationContext);
        if (selectStatus == null) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.Found_problems_validating_transformation_defining_{0},_re-validate_in_the_transformation_editor._1", (Object)objectPath);
            ArrayList<Status> statuses = new ArrayList<Status>(1);
            statuses.add(new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null));
            return new TransformationValidationResult(statuses);
        }
        transformResult.setSelectResult(selectStatus);
        if (transformResult.isValid() && SqlAspectHelper.isUpdatableGroup((EObject)this.targetGroup)) {
            if (sqlTrans.isInsertAllowed()) {
                transformResult.setInsertResult(SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.mappingRoot, (int)1, (int)SqlMappingRootCache.EITHER_STATUS, (boolean)this.restrictSearch, (ValidationContext)this.validationContext));
                transformResult.setInsertAllowed(true);
            }
            if (sqlTrans.isUpdateAllowed()) {
                transformResult.setUpdateResult(SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.mappingRoot, (int)2, (int)SqlMappingRootCache.EITHER_STATUS, (boolean)this.restrictSearch, (ValidationContext)this.validationContext));
                transformResult.setUpdateAllowed(true);
            }
            if (sqlTrans.isDeleteAllowed()) {
                transformResult.setDeleteResult(SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.mappingRoot, (int)3, (int)SqlMappingRootCache.EITHER_STATUS, (boolean)this.restrictSearch, (ValidationContext)this.validationContext));
                transformResult.setDeleteAllowed(true);
            }
        }
        return transformResult;
    }

    public boolean isValidRoot() {
        return this.mappingRoot != null && this.mappingRoot.eResource() != null;
    }

    public QueryValidationResult validateSql(String sql, int transformType, boolean isUUIDSql, boolean cacheResult) {
        Command command;
        if (!this.isValidRoot()) {
            return null;
        }
        SqlTransformationResult commandValidationResult = null;
        commandValidationResult = TransformationValidator.parseSQL(sql);
        if (commandValidationResult.isParsable() && transformType != -1 && (commandValidationResult = this.resolveCommand(command = commandValidationResult.getCommand(), transformType)).isResolvable()) {
            commandValidationResult = this.validateCommand(command);
            commandValidationResult.setResolvable(true);
        }
        commandValidationResult.setSqlString(sql);
        commandValidationResult.setSourceGroups((Collection)this.mappingRoot.getInputs());
        commandValidationResult.setUUIDStatus(isUUIDSql);
        if (cacheResult) {
            SqlMappingRootCache.setStatus((EObject)this.mappingRoot, (int)transformType, (SqlTransformationResult)commandValidationResult);
        }
        return commandValidationResult;
    }

    public static SqlTransformationResult parseSQL(String sqlString) {
        Command command = null;
        Status status = null;
        try {
            QueryParser parser = new QueryParser();
            command = parser.parseCommand(sqlString);
        }
        catch (Exception e) {
            status = new Status(4, "com.metamatrix.modeler.transformation", 0, e.getMessage(), (Throwable)e);
        }
        SqlTransformationResult result = new SqlTransformationResult(command, (IStatus)status);
        if (status != null && !status.isOK()) {
            result.setParsable(false);
        }
        return result;
    }

    public SqlTransformationResult resolveCommand(Command command, int transformType) {
        IStatus status = TransformationValidator.checkCommandType(command, transformType, this.targetGroup);
        if (status != null && status.getSeverity() != 0) {
            SqlTransformationResult resolverResult = new SqlTransformationResult(command, status);
            resolverResult.setTargetValidStatus(status);
            return resolverResult;
        }
        Map externalMetadata = Collections.EMPTY_MAP;
        try {
            CreateUpdateProcedureCommand procCommand;
            externalMetadata = TransformationHelper.getExternalMetadataMap(command, this.mappingRoot, this.getQueryMetadata());
            if (command.getType() == 7 && !(procCommand = (CreateUpdateProcedureCommand)command).isUpdateProcedure() && this.targetGroup instanceof Procedure) {
                ArrayList<ElementSymbol> parentProjectColumns = new ArrayList<ElementSymbol>();
                procCommand.setParentProjectSymbols(parentProjectColumns);
                String targetProcFullName = TransformationHelper.getSqlEObjectFullName(this.targetGroup);
                GroupSymbol gSymbol = new GroupSymbol(targetProcFullName);
                StoredProcedureInfo info = this.metadata.getStoredProcedureInfoForProcedure(gSymbol.getName());
                if (info != null) {
                    gSymbol.setMetadataID(info.getProcedureID());
                    List paramList = info.getParameters();
                    for (SPParameter param : paramList) {
                        if (param.getParameterType() == 2 || param.getParameterType() == 3 || param.getParameterType() == 4) {
                            parentProjectColumns.add(param.getParameterSymbol());
                            continue;
                        }
                        if (param.getParameterType() != 5) continue;
                        parentProjectColumns.addAll(param.getResultSetColumns());
                    }
                }
            }
        }
        catch (QueryMetadataException e) {
            Status errorStatus = new Status(4, "com.metamatrix.modeler.transformation", 0, e.getMessage(), (Throwable)e);
            return new SqlTransformationResult(command, (IStatus)errorStatus);
        }
        catch (MetaMatrixComponentException e) {
            Status errorStatus = new Status(4, "com.metamatrix.modeler.transformation", 0, e.getMessage(), (Throwable)e);
            return new SqlTransformationResult(command, (IStatus)errorStatus);
        }
        return this.resolveCommand(command, externalMetadata);
    }

    public SqlTransformationResult validateCommand(Command command) {
        ArgCheck.isNotNull((Object)command);
        Collection statusList = null;
        try {
            ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)this.getQueryMetadata(), (boolean)false);
            if (!report.hasItems()) {
                statusList = this.validateSources(command, statusList);
                statusList = this.validateReferences(command, statusList);
            } else {
                statusList = this.createStatusList(report);
            }
        }
        catch (MetaMatrixComponentException e) {
            statusList = statusList != null ? statusList : new ArrayList<Status>(1);
            statusList.add(new Status(4, "com.metamatrix.modeler.transformation", 0, e.getMessage(), (Throwable)e));
        }
        SqlTransformationResult result = new SqlTransformationResult(command, statusList);
        if (statusList == null || statusList.isEmpty()) {
            result.setValidatable(true);
            result.setResolvable(true);
        }
        return result;
    }

    public QueryMetadataInterface getQueryMetadata() {
        if (this.metadata == null && this.mappingRoot.eResource() != null) {
            boolean useServerMetadata;
            TransformationMetadataFactory factory = TransformationMetadataFactory.getInstance();
            boolean bl = useServerMetadata = this.validationContext != null && this.validationContext.useServerIndexes();
            if (!useServerMetadata) {
                ModelResourceIndexSelector selector = new ModelResourceIndexSelector(this.mappingRoot.eResource());
                QueryMetadataContext queryContext = new QueryMetadataContext((IndexSelector)selector);
                queryContext.setRestrictedSearch(this.restrictSearch);
                if (this.validationContext != null) {
                    queryContext.setContainer(this.validationContext.getResourceContainer());
                    if (!this.validationContext.useIndexesToResolve()) {
                        queryContext.setIndexSelector((IndexSelector)new NullIndexSelector());
                    }
                    queryContext.setResources(Arrays.asList(this.validationContext.getResourcesInScope()));
                } else {
                    try {
                        queryContext.setContainer(ModelerCore.getModelContainer());
                        try {
                            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
                            queryContext.setResources(Arrays.asList(workspace.getEmfResources()));
                        }
                        catch (RuntimeException e) {
                            queryContext.setResources((Collection)this.mappingRoot.eResource().getResourceSet().getResources());
                        }
                    }
                    catch (CoreException e) {
                        TransformationPlugin.Util.log((Throwable)e);
                    }
                }
                this.metadata = factory.getModelerMetadata(queryContext);
            } else {
                Assertion.isNotNull((Object)this.validationContext);
                NullIndexSelector selector = null;
                if (this.validationContext.useIndexesToResolve()) {
                    if (this.validationContext.getData(QUERY_METADATA_INTERFACE) != null) {
                        this.metadata = (QueryMetadataInterface)this.validationContext.getData(QUERY_METADATA_INTERFACE);
                        if (!(this.metadata instanceof VdbMetadata) && this.metadata instanceof TransformationMetadataFacade && !(((TransformationMetadataFacade)this.metadata).getDelegate() instanceof VdbMetadata)) {
                            throw new MetaMatrixRuntimeException(TransformationPlugin.Util.getString("TransformationValidator.QMI_of_unexpected_type"));
                        }
                    } else {
                        selector = new TargetLocationIndexSelector(this.validationContext.getIndexLocation());
                    }
                } else {
                    selector = new NullIndexSelector();
                }
                if (this.metadata == null) {
                    QueryMetadataContext queryContext = new QueryMetadataContext((IndexSelector)selector);
                    queryContext.setContainer(this.validationContext.getResourceContainer());
                    queryContext.setResources(Arrays.asList(this.validationContext.getResourcesInScope()));
                    queryContext.setRestrictedSearch(this.restrictSearch);
                    this.metadata = factory.getVdbMetadata(queryContext);
                    this.validationContext.setData(QUERY_METADATA_INTERFACE, (Object)this.metadata);
                }
            }
        }
        return this.metadata;
    }

    public static IStatus checkCommandType(Command command, int transformType, Object targetGroup) {
        ArgCheck.isNotNull((Object)command);
        ArgCheck.isNotNull((Object)targetGroup);
        int cmdType = command.getType();
        switch (transformType) {
            case 0: {
                if (targetGroup instanceof Table) {
                    if (cmdType == 1 || cmdType == 6) break;
                    String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_a_virtual_group_can_only_be_of_type_Select_or_Exec._1");
                    return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
                }
                if (targetGroup instanceof Procedure) {
                    if (cmdType == 7 && !((CreateUpdateProcedureCommand)command).isUpdateProcedure()) break;
                    String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_a_virtual_procedure_can_only_be_of_type_Virtual_procedure._2");
                    return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
                }
                if (!(targetGroup instanceof Operation) || cmdType == 7) break;
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_an_operation_can_only_be_of_type_Virtual_procedure._1");
                return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
            }
            case 1: 
            case 2: 
            case 3: {
                if (cmdType == 7 && ((CreateUpdateProcedureCommand)command).isUpdateProcedure()) break;
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Only_update_procedures_are_allowed_in_the_INSERT/UPDATE/DELETE_tabs._1");
                return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
            }
            default: {
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Invalid_transformation_type,_only_allowed_transformations_are_select,_insert,_update,_delete_transforms._1");
                return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
            }
        }
        return null;
    }

    protected List createStatusList(ValidatorReport report) {
        if (report != null && report.hasItems()) {
            Collection items = report.getItems();
            ArrayList<Status> statusList = new ArrayList<Status>(items.size());
            for (ReportItem item : items) {
                Status status = new Status(4, "com.metamatrix.modeler.transformation", 0, item.toString(), null);
                statusList.add(status);
            }
            return statusList;
        }
        return Collections.EMPTY_LIST;
    }

    protected SqlTransformationResult resolveCommand(Command command, Map externalMetadata) {
        Status status = null;
        ArgCheck.isNotNull((Object)command);
        String commandSQL = command.toString();
        try {
            QueryMetadataInterface metadata = this.getQueryMetadata();
            QueryResolver.resolveCommand((Command)command, (Map)externalMetadata, (boolean)false, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        }
        catch (MetaMatrixComponentException e) {
            status = new Status(4, "com.metamatrix.modeler.transformation", 0, e.getMessage(), (Throwable)e);
        }
        catch (QueryResolverException e) {
            status = new Status(4, "com.metamatrix.modeler.transformation", 0, e.getMessage(), (Throwable)e);
        }
        if (status != null && status.getSeverity() == 4) {
            return new SqlTransformationResult(TransformationValidator.parseSQL(commandSQL).getCommand(), (IStatus)status);
        }
        SqlTransformationResult resolverResult = new SqlTransformationResult(command, (IStatus)status);
        resolverResult.setExternalMetadataMap(externalMetadata);
        if (status == null) {
            resolverResult.setResolvable(true);
        }
        return resolverResult;
    }

    protected Collection validateReferences(Command command, Collection statusList) {
        List references = ReferenceCollectorVisitor.getReferences((LanguageObject)command);
        if (!references.isEmpty()) {
            statusList = statusList != null ? statusList : new ArrayList(1);
            Status status = new Status(4, "com.metamatrix.modeler.transformation", 0, TransformationPlugin.Util.getString("TransformationValidator.The_transformation_contains_Reference_Symbols_(_),_which_is_not_allowed,_replace___with_a_constant,_element,_or_parameter_name._1"), null);
            statusList.add(status);
        }
        return statusList;
    }

    protected Collection validateSources(Command command, Collection statusList) {
        if (this.isTargetASourceInCommand(command)) {
            statusList = statusList != null ? statusList : new ArrayList(1);
            String message = TransformationPlugin.Util.getString("TransformationValidator.errorTargetIsSourceMsg", (Object)ModelerCore.getModelEditor().getName(this.targetGroup));
            Status status = new Status(4, "com.metamatrix.modeler.transformation", 0, message, null);
            statusList.add(status);
        }
        return statusList;
    }

    protected boolean isTargetASourceInCommand(Command command) {
        boolean result = false;
        Collection sourceSymbols = TransformationSqlHelper.getGroupSymbols((Command)command);
        List sourceEObjects = TransformationSqlHelper.getGroupSymbolEObjects((Collection)sourceSymbols);
        if (!sourceEObjects.isEmpty() && this.mappingRoot != null) {
            EObject tRootTarget = this.mappingRoot.getTarget();
            Iterator iter = sourceEObjects.iterator();
            Object nextObj = null;
            while (iter.hasNext() && !result) {
                nextObj = iter.next();
                if (!nextObj.equals(tRootTarget)) continue;
                result = true;
            }
        }
        return result;
    }
}

