/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.api.ClientConnectionWithConnectionIdObject;
import com.metamatrix.common.comm.api.ClientConnectionWithSessionId;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.server.SocketClientInstance;
import com.metamatrix.common.comm.service.ClientConnectionWithConnectionId;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

public class SocketClientConnection
implements ClientConnectionWithConnectionIdObject,
ClientConnectionWithConnectionId,
ClientConnectionWithSessionId {
    private SocketClientInstance clientInstance;
    private int virtualSocketId;
    private Map properties;
    private MetaMatrixSessionID sessionId;

    public SocketClientConnection(SocketClientInstance clientInstance, int virtualSocketId, Map properties) {
        this.clientInstance = clientInstance;
        this.virtualSocketId = virtualSocketId;
        this.properties = properties == null ? new HashMap() : properties;
        this.setSessionID();
    }

    public void setVDBVersion(String vdbVersion) {
        String existingVersion;
        if (this.properties != null && vdbVersion != null && ((existingVersion = (String)this.properties.get("vdbVersion")) == null || existingVersion.length() == 0)) {
            this.properties.put("vdbVersion", vdbVersion);
        }
    }

    public Object getConnectionProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void send(Message message, String messageKey) throws CommunicationException {
        this.clientInstance.send(this.virtualSocketId, message, messageKey);
    }

    public void shutdown() throws CommunicationException {
    }

    public MetaMatrixSessionID getSessionId() {
        return this.sessionId;
    }

    public Object getConnectionIdObject() {
        return this.getSessionId();
    }

    public void sendSynchronousResponse(Integer synchRequestId, Message result) throws CommunicationException {
        this.clientInstance.sendSynchronousResponse(this.virtualSocketId, synchRequestId, result);
    }

    public synchronized void setSessionId(Object sessionIdObject) {
        this.sessionId = (MetaMatrixSessionID)sessionIdObject;
        this.properties.put("connectionID", this.sessionId.toString());
        this.properties.put("user", this.sessionId.getUserName());
        String vdbVersion = this.sessionId.getProductInfo(1);
        this.setVDBVersion(vdbVersion);
    }

    private synchronized void setSessionID() {
        Object sessionIDProperty = this.properties.get("connectionID");
        if (sessionIDProperty != null) {
            String userName = (String)this.properties.get("user");
            String vdbName = (String)this.properties.get("VirtualDatabaseName");
            String vdbVers = (String)this.properties.get("VirtualDatabaseVersion");
            this.sessionId = new MetaMatrixSessionID(Long.parseLong((String)sessionIDProperty), userName, vdbName, vdbVers);
        }
    }

    public String getConnectionId() {
        MetaMatrixSessionID sessionID = this.getSessionId();
        if (sessionID != null) {
            return String.valueOf(sessionID.getValue());
        }
        return null;
    }

    public void setSessionPayload(Serializable payload) {
        if (payload != null) {
            this.properties.put("trustedPayload", payload);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.clientInstance.getRemoteAddress();
    }
}

