/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.core.util.LRUCache;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.lang.Command;
import java.util.List;

public class PreparedPlanCache {
    public static int DEFAULT_MAX_SIZE_TOTAL = 100;
    private LRUCache cache = new LRUCache();

    PreparedPlanCache() {
        this(DEFAULT_MAX_SIZE_TOTAL);
    }

    PreparedPlanCache(int maxSize) {
        if (maxSize < 0) {
            maxSize = DEFAULT_MAX_SIZE_TOTAL;
        }
        this.cache.setSpaceLimit(maxSize);
    }

    public synchronized PreparedPlan getPreparedPlan(ClientConnection clientConn, String sql, int preparedBatchCount) {
        ArgCheck.isNotNull((Object)clientConn);
        ArgCheck.isNotNull((Object)sql);
        CacheID cID = new CacheID(clientConn, sql, preparedBatchCount);
        return (PreparedPlan)this.cache.get((Object)cID);
    }

    public synchronized PreparedPlan createPreparedPlan(ClientConnection clientConn, String sql, int preparedBatchCount) {
        ArgCheck.isNotNull((Object)clientConn);
        ArgCheck.isNotNull((Object)sql);
        CacheID cID = new CacheID(clientConn, sql, preparedBatchCount);
        PreparedPlan preparedPlan = (PreparedPlan)this.cache.get((Object)cID);
        if (preparedPlan == null) {
            preparedPlan = new PreparedPlan();
            this.cache.put((Object)cID, (Object)preparedPlan);
        }
        return preparedPlan;
    }

    public synchronized void clear(ClientConnection clientConn) {
        ArgCheck.isNotNull((Object)clientConn);
    }

    public synchronized void clearAll() {
        this.cache.flush();
    }

    int getSpaceUsed() {
        return this.cache.getCurrentSpace();
    }

    int getSpaceAllowed() {
        return this.cache.getSpaceLimit();
    }

    static class PreparedPlan {
        private ProcessorPlan plan;
        private Command command;
        private List refs;
        private AnalysisRecord analysisRecord;

        PreparedPlan() {
        }

        public ProcessorPlan getPlan() {
            return this.plan;
        }

        public AnalysisRecord getAnalysisRecord() {
            return this.analysisRecord;
        }

        public Command getCommand() {
            return this.command;
        }

        public List getReferences() {
            return this.refs;
        }

        public void setPlan(ProcessorPlan planValue) {
            this.plan = planValue;
        }

        public void setAnalysisRecord(AnalysisRecord analysisRecord) {
            this.analysisRecord = analysisRecord;
        }

        public void setCommand(Command commandValue) {
            this.command = commandValue;
        }

        public void setReferences(List refsValue) {
            this.refs = refsValue;
        }
    }

    static class CacheID {
        private ClientConnection clientConn;
        private String sql;
        private int preparedBatchCount;
        int hashCode;

        CacheID(ClientConnection clientConn, String sql, int preparedBatchCount) {
            this.clientConn = clientConn;
            this.sql = sql;
            this.preparedBatchCount = preparedBatchCount;
            this.hashCode = HashCodeUtil.hashCode((int)HashCodeUtil.hashCode((int)0, (Object)clientConn), (Object)sql);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof CacheID)) {
                return false;
            }
            CacheID that = (CacheID)obj;
            return this.clientConn.equals(that.clientConn) && this.preparedBatchCount == that.preparedBatchCount && this.sql.equals(that.sql);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

