/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.salesforce;

import com.metamatrix.modeler.compare.DifferenceProcessor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.MergeProcessor;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import com.metamatrix.modeler.compare.util.CompareUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.modelgenerator.salesforce.BindingGenerator;
import com.metamatrix.modeler.modelgenerator.salesforce.Messages;
import com.metamatrix.modeler.modelgenerator.salesforce.RelationalModelgenerator;
import com.metamatrix.modeler.modelgenerator.salesforce.connection.SalesforceConnection;
import com.metamatrix.modeler.modelgenerator.salesforce.connection.impl.Connection;
import com.metamatrix.modeler.modelgenerator.salesforce.model.DataModel;
import com.metamatrix.modeler.modelgenerator.salesforce.model.impl.DataModelImpl;
import com.metamatrix.modeler.modelgenerator.salesforce.util.ModelBuildingException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class SalesforceImportWizardManager {
    public static final int WORKSPACE_SOURCE = 0;
    public static final int FILESYSTEM_SOURCE = 1;
    public static final int URL_SOURCE = 2;
    private DataModel dataModel;
    private String targetModelName;
    private IContainer targetModelLocation;
    private String username;
    private String password;
    private URL connectionURL;
    private boolean supressAuditFields;
    private boolean credentialsValid;
    private boolean hasCredentialChanges;
    private ModelResource updateModel;
    private boolean canFinish = false;
    private DifferenceReport diffReport;
    private DifferenceProcessor diffProcessor;
    private ModelResource tempModel;

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public IContainer getTargetModelLocation() {
        return this.targetModelLocation;
    }

    public void setTargetModelLocation(IContainer targetModelLocation) {
        this.targetModelLocation = targetModelLocation;
    }

    public String getTargetModelName() {
        return this.targetModelName;
    }

    public void setTargetModelName(String targetModelName) {
        this.targetModelName = targetModelName;
    }

    public URL getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(URL connectionURL) {
        this.connectionURL = connectionURL;
        this.setCredentialChanges(true);
    }

    public void setUsername(String username) {
        this.username = username;
        this.setCredentialChanges(true);
    }

    public void setPassword(String password) {
        this.password = password;
        this.setCredentialChanges(true);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void clear() {
        this.dataModel = null;
        this.targetModelName = null;
        this.targetModelLocation = null;
        this.username = null;
        this.password = null;
    }

    public boolean validateCredentials(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.getString((String)"SalesforceImportWizardManager.validating.credentials"), -1);
        SalesforceConnection conn = this.getConnection();
        return null != conn;
    }

    private SalesforceConnection getConnection() throws Exception {
        Connection conn = new Connection();
        conn.login(this.username, this.password, this.connectionURL);
        return conn;
    }

    public void runFinish(IProgressMonitor monitor) throws Exception {
        if (this.diffReport != null) {
            EObject[] externalReferences = ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
            MergeProcessor mergeProc = ModelerComparePlugin.createMergeProcessor((DifferenceProcessor)this.diffProcessor, (EObject[])externalReferences, (boolean)true);
            IStatus mergeStatus = mergeProc.execute(monitor);
            this.tempModel = null;
        } else {
            ModelResource modelResource = this.createModel(monitor, this.targetModelName);
            try {
                modelResource.save(monitor, false);
            }
            catch (ModelWorkspaceException e) {
                ModelBuildingException mbe = new ModelBuildingException();
                mbe.initCause((Throwable)e);
                throw mbe;
            }
            BindingGenerator.createConnectorBinding((SalesforceImportWizardManager)this);
        }
    }

    private ModelResource createModel(IProgressMonitor monitor, String modelName) throws ModelBuildingException, Exception {
        Resource resource;
        monitor.beginTask(Messages.getString((String)"SalesforceImportWizardManager.creating.salesforce.model"), -1);
        Path path = new Path(modelName);
        IFile iFile = this.targetModelLocation.getFile((IPath)path);
        ModelResource modelResource = ModelerCore.create((IFile)iFile);
        try {
            resource = modelResource.getEmfResource();
        }
        catch (ModelWorkspaceException e) {
            throw new ModelBuildingException((Throwable)e);
        }
        RelationalModelgenerator builder = new RelationalModelgenerator(this.targetModelLocation, monitor, this.dataModel, this.getConnection(), this.isSupressAuditFields());
        builder.createRelationalModel(resource);
        return modelResource;
    }

    public DataModel createDataModel(IProgressMonitor monitor) throws Exception {
        if (null == this.dataModel || this.hasCredentialChanges()) {
            SalesforceConnection conn = this.getConnection();
            this.dataModel = new DataModelImpl();
            monitor.setTaskName(Messages.getString((String)"SalesforceImportWizardManager.gathering.metadata"));
            this.dataModel.load(conn, monitor);
            this.hasCredentialChanges = false;
        }
        return this.dataModel;
    }

    public boolean isSupressAuditFields() {
        return this.supressAuditFields;
    }

    public void setSupressAuditFields(boolean supressAuditFields) {
        this.supressAuditFields = supressAuditFields;
    }

    public void setCredentialsValid(boolean valid) {
        this.credentialsValid = valid;
    }

    public boolean hasValidCredentials() {
        return this.credentialsValid;
    }

    public boolean hasCredentialChanges() {
        return this.hasCredentialChanges;
    }

    private void setCredentialChanges(boolean changed) {
        this.hasCredentialChanges = changed;
    }

    public DifferenceReport getDifferenceReport(IProgressMonitor monitor) throws ModelBuildingException, Exception {
        String tempName = Long.toString(System.currentTimeMillis()) + "_temp.xmi";
        this.tempModel = this.createModel(monitor, tempName);
        this.diffProcessor = ModelerComparePlugin.createDifferenceProcessor((ModelResource)this.updateModel, (ModelResource)this.tempModel);
        this.diffProcessor.execute(monitor);
        this.diffReport = this.diffProcessor.getDifferenceReport();
        CompareUtil.skipDeletesOfStandardContainers((DifferenceReport)this.diffReport);
        return this.diffReport;
    }

    public void setUpdatedModel(ModelResource model) {
        this.updateModel = model;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }
}

