/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConnection;
import com.metamatrix.jdbcspy.SpyInputStream;
import com.metamatrix.jdbcspy.SpyLogger;
import com.metamatrix.jdbcspy.SpyResultSetMetaData;
import com.metamatrix.jdbcspy.SpyStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class SpyResultSet
implements ResultSet {
    private static String footprint = "$Revision:   1.2.2.0  $";
    ResultSet realResultSet;
    private SpyLogger spyLogger;
    private SpyConnection spyConnection;
    private SpyStatement spyStatement;
    private boolean spyStatementSet;
    private int id;
    private static int Id = 0;

    SpyResultSet(ResultSet resultSet, SpyLogger spyLogger, SpyConnection spyConnection) throws SQLException {
        this.realResultSet = resultSet;
        this.spyConnection = spyConnection;
        this.spyLogger = spyLogger;
        this.id = ++Id;
    }

    SpyResultSet(SpyStatement spyStatement, ResultSet resultSet, SpyLogger spyLogger, SpyConnection spyConnection) throws SQLException {
        this(resultSet, spyLogger, spyConnection);
        this.spyStatement = spyStatement;
        this.spyStatementSet = true;
    }

    public final boolean next() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".next()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.next();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void close() throws SQLException {
        this.spyLogger.println("\n" + this + ".close()");
        this.spyLogger.enter();
        try {
            this.realResultSet.close();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean wasNull() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".wasNull()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.wasNull();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final String getString(int n) throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getString(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            string = this.realResultSet.getString(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public final int getInt(int n) throws SQLException {
        int n2;
        this.spyLogger.println("\n" + this + ".getInt(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            n2 = this.realResultSet.getInt(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n2 + ")");
        return n2;
    }

    public final double getDouble(int n) throws SQLException {
        double d;
        this.spyLogger.println("\n" + this + ".getDouble(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            d = this.realResultSet.getDouble(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + d + ")");
        return d;
    }

    public final byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        this.spyLogger.println("\n" + this + ".getBytes(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            byArray = this.realResultSet.getBytes(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + this.spyLogger.bytesToString(byArray) + ")");
        return byArray;
    }

    public final boolean getBoolean(int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getBoolean(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.getBoolean(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final byte getByte(int n) throws SQLException {
        byte by;
        this.spyLogger.println("\n" + this + ".getByte(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            by = this.realResultSet.getByte(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + by + ")");
        return by;
    }

    public final short getShort(int n) throws SQLException {
        short s;
        this.spyLogger.println("\n" + this + ".getShort(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            s = this.realResultSet.getShort(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + s + ")");
        return s;
    }

    public final long getLong(int n) throws SQLException {
        long l;
        this.spyLogger.println("\n" + this + ".getLong(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            l = this.realResultSet.getLong(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l + ")");
        return l;
    }

    public final float getFloat(int n) throws SQLException {
        float f;
        this.spyLogger.println("\n" + this + ".getFloat(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            f = this.realResultSet.getFloat(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + f + ")");
        return f;
    }

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(int columnIndex, int scale)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("scale = " + n2);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realResultSet.getBigDecimal(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final Date getDate(int n) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            date = this.realResultSet.getDate(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(int n) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            time = this.realResultSet.getTime(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            timestamp = this.realResultSet.getTimestamp(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getAsciiStream(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            inputStream = this.realResultSet.getAsciiStream(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        inputStream = (InputStream)this.spyLogger.loggedRetrievedObject(inputStream);
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getUnicodeStream(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            inputStream = this.realResultSet.getUnicodeStream(n);
            if (this.spyLogger.logIS && inputStream != null) {
                inputStream = new SpyInputStream(inputStream, this.spyLogger);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getBinaryStream(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            inputStream = this.realResultSet.getBinaryStream(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        inputStream = (InputStream)this.spyLogger.loggedRetrievedObject(inputStream);
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final Object getObject(int n) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            object = this.realResultSet.getObject(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final String getString(String string) throws SQLException {
        String string2;
        this.spyLogger.println("\n" + this + ".getString(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            string2 = this.realResultSet.getString(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string2 + ")");
        return string2;
    }

    public final boolean getBoolean(String string) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getBoolean(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.getBoolean(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final byte getByte(String string) throws SQLException {
        byte by;
        this.spyLogger.println("\n" + this + ".getByte(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            by = this.realResultSet.getByte(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + by + ")");
        return by;
    }

    public final short getShort(String string) throws SQLException {
        short s;
        this.spyLogger.println("\n" + this + ".getShort(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            s = this.realResultSet.getShort(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + s + ")");
        return s;
    }

    public final int getInt(String string) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getInt(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            n = this.realResultSet.getInt(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final long getLong(String string) throws SQLException {
        long l;
        this.spyLogger.println("\n" + this + ".getLong(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            l = this.realResultSet.getLong(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l + ")");
        return l;
    }

    public final float getFloat(String string) throws SQLException {
        float f;
        this.spyLogger.println("\n" + this + ".getFloat(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            f = this.realResultSet.getFloat(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + f + ")");
        return f;
    }

    public final double getDouble(String string) throws SQLException {
        double d;
        this.spyLogger.println("\n" + this + ".getDouble(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            d = this.realResultSet.getDouble(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + d + ")");
        return d;
    }

    public final BigDecimal getBigDecimal(String string, int n) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(String columnName, int scale)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("scale = " + n);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realResultSet.getBigDecimal(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final byte[] getBytes(String string) throws SQLException {
        byte[] byArray;
        this.spyLogger.println("\n" + this + ".getBytes(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            byArray = this.realResultSet.getBytes(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + this.spyLogger.bytesToString(byArray) + ")");
        return byArray;
    }

    public final Date getDate(String string) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            date = this.realResultSet.getDate(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(String string) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            time = this.realResultSet.getTime(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            timestamp = this.realResultSet.getTimestamp(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final InputStream getAsciiStream(String string) throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getAsciiStream(int columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            inputStream = this.realResultSet.getAsciiStream(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        inputStream = (InputStream)this.spyLogger.loggedRetrievedObject(inputStream);
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final InputStream getUnicodeStream(String string) throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getUnicodeStream(int columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            inputStream = this.realResultSet.getUnicodeStream(string);
            if (this.spyLogger.logIS && inputStream != null) {
                inputStream = new SpyInputStream(inputStream, this.spyLogger);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final InputStream getBinaryStream(String string) throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getBinaryStream(int columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            inputStream = this.realResultSet.getBinaryStream(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        inputStream = (InputStream)this.spyLogger.loggedRetrievedObject(inputStream);
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        this.spyLogger.println("\n" + this + ".getWarnings()");
        this.spyLogger.enter();
        try {
            sQLWarning = this.realResultSet.getWarnings();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.printSqlWarning(sQLWarning);
        this.spyLogger.println("OK");
        return sQLWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.spyLogger.println("\n" + this + ".clearWarnings()");
        this.spyLogger.enter();
        try {
            this.realResultSet.clearWarnings();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final String getCursorName() throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getCursorName()");
        this.spyLogger.enter();
        try {
            string = this.realResultSet.getCursorName();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        this.spyLogger.println("\n" + this + ".getMetaData()");
        this.spyLogger.enter();
        try {
            resultSetMetaData = this.realResultSet.getMetaData();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyResultSetMetaData spyResultSetMetaData = new SpyResultSetMetaData(resultSetMetaData, this.spyLogger);
        this.spyLogger.println("OK (" + spyResultSetMetaData + ")");
        return spyResultSetMetaData;
    }

    public final Object getObject(String string) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            object = this.realResultSet.getObject(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final int findColumn(String string) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".findColumn(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            n = this.realResultSet.findColumn(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final Reader getCharacterStream(int n) throws SQLException {
        Reader reader;
        this.spyLogger.println("\n" + this + ".getCharacterStream(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            reader = this.realResultSet.getCharacterStream(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        reader = (Reader)this.spyLogger.loggedRetrievedObject(reader);
        this.spyLogger.println("OK (" + reader + ")");
        return reader;
    }

    public final Reader getCharacterStream(String string) throws SQLException {
        Reader reader;
        this.spyLogger.println("\n" + this + ".getCharacterStream(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            reader = this.realResultSet.getCharacterStream(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        reader = (Reader)this.spyLogger.loggedRetrievedObject(reader);
        this.spyLogger.println("OK (" + reader + ")");
        return reader;
    }

    public final BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realResultSet.getBigDecimal(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal;
        this.spyLogger.println("\n" + this + ".getBigDecimal(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            bigDecimal = this.realResultSet.getBigDecimal(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bigDecimal + ")");
        return bigDecimal;
    }

    public final boolean isBeforeFirst() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isBeforeFirst()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.isBeforeFirst();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean isAfterLast() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isAfterLast()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.isAfterLast();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean isFirst() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isFirst()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.isFirst();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean isLast() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isLast()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.isLast();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void beforeFirst() throws SQLException {
        this.spyLogger.println("\n" + this + ".beforeFirst()");
        this.spyLogger.enter();
        try {
            this.realResultSet.beforeFirst();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void afterLast() throws SQLException {
        this.spyLogger.println("\n" + this + ".afterLast()");
        this.spyLogger.enter();
        try {
            this.realResultSet.afterLast();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final boolean first() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".first()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.first();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean last() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".last()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.last();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final int getRow() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getRow()");
        this.spyLogger.enter();
        try {
            n = this.realResultSet.getRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final boolean absolute(int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".absolute(int row)");
        this.spyLogger.println("row = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.absolute(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean relative(int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".relative(int rows)");
        this.spyLogger.println("rows = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.relative(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean previous() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".previous()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.previous();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void setFetchDirection(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setFetchDirection(int direction)");
        this.spyLogger.println("direction = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.setFetchDirection(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getFetchDirection() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getFetchDirection()");
        this.spyLogger.enter();
        try {
            n = this.realResultSet.getFetchDirection();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void setFetchSize(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setFetchSize(int rows)");
        this.spyLogger.println("rows = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.setFetchSize(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getFetchSize() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getFetchSize()");
        this.spyLogger.enter();
        try {
            n = this.realResultSet.getFetchSize();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int getType() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getType()");
        this.spyLogger.enter();
        try {
            n = this.realResultSet.getType();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int getConcurrency() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getConcurrency()");
        this.spyLogger.enter();
        try {
            n = this.realResultSet.getConcurrency();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final boolean rowUpdated() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".rowUpdated()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.rowUpdated();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean rowInserted() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".rowInserted()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.rowInserted();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean rowDeleted() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".rowDeleted()");
        this.spyLogger.enter();
        try {
            bl = this.realResultSet.rowDeleted();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void updateNull(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateNull(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateNull(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBoolean(int n, boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateBoolean(int columnIndex, boolean x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + bl);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBoolean(n, bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateByte(int n, byte by) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateByte(int columnIndex, byte x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + by);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateByte(n, by);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateShort(int n, short s) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateShort(int columnIndex, short x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + s);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateShort(n, s);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateInt(int n, int n2) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateInt(int columnIndex, int x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + n2);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateInt(n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateLong(int n, long l) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateLong(int columnIndex, long x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + l);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateLong(n, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateFloat(int n, float f) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateFloat(int columnIndex, float x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + f);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateFloat(n, f);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateDouble(int n, double d) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateDouble(int columnIndex, double x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + d);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateDouble(n, d);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateBigDecimal(int columnIndex, BigDecimal x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + bigDecimal);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBigDecimal(n, bigDecimal);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateString(int n, String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateString(int columnIndex, String x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + string);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateString(n, string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBytes(int n, byte[] byArray) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateBytes(int columnIndex, byte[] x");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBytes(n, byArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateDate(int n, Date date) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateDate(int columnIndex, java.sql.Date x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + date);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateDate(n, date);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateTime(int n, Time time) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateTime(int columnIndex, java.sql.Time x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + time);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateTime(n, time);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateTimestamp(int columnIndex, java.sql.Timestamp x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + timestamp);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateTimestamp(n, timestamp);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".updateAsciiStream(int columnIndex, java.io.InputStream x, int length)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateAsciiStream(n, inputStream, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".updateBinaryStream(int columnIndex, java.io.InputStream x, int length)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBinaryStream(n, inputStream, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        reader = (Reader)this.spyLogger.loggedInputObject(reader);
        this.spyLogger.println("\n" + this + ".updateCharacterStream(int columnIndex, java.io.Reader x, int length)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + reader);
        this.spyLogger.println("length = " + n2);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateCharacterStream(n, reader, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateObject(int n, Object object, int n2) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".updateObject(int columnIndex, Object x, int scale)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + object);
        this.spyLogger.println("scale = " + n2);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateObject(n, object, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateObject(int n, Object object) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".updateObject(int columnIndex, Object x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + object);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateObject(n, object);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateNull(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateNull(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateNull(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBoolean(String string, boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateBoolean(String columnName, boolean x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + bl);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBoolean(string, bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateByte(String string, byte by) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateByte(String columnName, byte x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + by);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateByte(string, by);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateShort(String string, short s) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateShort(String columnName, short x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + s);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateShort(string, s);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateInt(String string, int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateInt(String columnName, int x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateInt(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateLong(String string, long l) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateLong(String columnName, long x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + l);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateLong(string, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateFloat(String string, float f) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateFloat(String columnName, float x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + f);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateFloat(string, f);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateDouble(String string, double d) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateDouble(String columnName, double x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + d);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateDouble(string, d);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateBigDecimal(String columnName, BigDecimal x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + bigDecimal);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBigDecimal(string, bigDecimal);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateString(String string, String string2) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateString(String columnName, String x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + string2);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateString(string, string2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBytes(String string, byte[] byArray) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateBytes(String columnName, byte[] x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + this.spyLogger.bytesToString(byArray));
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBytes(string, byArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateDate(String string, Date date) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateDate(String columnName, java.sql.Date x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + date);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateDate(string, date);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateTime(String string, Time time) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateTime(String columnName, java.sql.Time x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + time);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateTime(string, time);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.spyLogger.println("\n" + this + ".updateTimestamp(String columnName, java.sql.Timestamp x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + timestamp);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateTimestamp(string, timestamp);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".updateAsciiStream(String columnName, java.io.InputStream x, int length)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateAsciiStream(string, inputStream, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        inputStream = (InputStream)this.spyLogger.loggedInputObject(inputStream);
        this.spyLogger.println("\n" + this + ".updateBinaryStream(String columnName, java.io.InputStream x, int length)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + inputStream);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBinaryStream(string, inputStream, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        reader = (Reader)this.spyLogger.loggedInputObject(reader);
        this.spyLogger.println("\n" + this + ".updateCharacterStream(String columnName, java.io.Reader x, int length)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + reader);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateCharacterStream(string, reader, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateObject(String string, Object object, int n) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".updateObject(String columnName, Object x, int scale)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + object);
        this.spyLogger.println("scale = " + n);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateObject(string, object, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateObject(String string, Object object) throws SQLException {
        object = this.spyLogger.loggedInputObject(object);
        this.spyLogger.println("\n" + this + ".updateObject(String columnName, Object x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + object);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateObject(string, object);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void insertRow() throws SQLException {
        this.spyLogger.println("\n" + this + ".insertRow()");
        this.spyLogger.enter();
        try {
            this.realResultSet.insertRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateRow() throws SQLException {
        this.spyLogger.println("\n" + this + ".updateRow()");
        this.spyLogger.enter();
        try {
            this.realResultSet.updateRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void deleteRow() throws SQLException {
        this.spyLogger.println("\n" + this + ".deleteRow()");
        this.spyLogger.enter();
        try {
            this.realResultSet.deleteRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void refreshRow() throws SQLException {
        this.spyLogger.println("\n" + this + ".refreshRow()");
        this.spyLogger.enter();
        try {
            this.realResultSet.refreshRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void cancelRowUpdates() throws SQLException {
        this.spyLogger.println("\n" + this + ".cancelRowUpdates()");
        this.spyLogger.enter();
        try {
            this.realResultSet.cancelRowUpdates();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void moveToInsertRow() throws SQLException {
        this.spyLogger.println("\n" + this + ".moveToInsertRow()");
        this.spyLogger.enter();
        try {
            this.realResultSet.moveToInsertRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void moveToCurrentRow() throws SQLException {
        this.spyLogger.println("\n" + this + ".moveToCurrentRow()");
        this.spyLogger.enter();
        try {
            this.realResultSet.moveToCurrentRow();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final Statement getStatement() throws SQLException {
        this.spyLogger.println("\n" + this + ".getStatement()");
        if (!this.spyStatementSet) {
            Statement statement = this.realResultSet.getStatement();
            if (statement != null) {
                this.spyStatement = new SpyStatement(statement, this.spyLogger, this.spyConnection);
            }
            this.spyStatementSet = true;
        }
        this.spyLogger.println("OK (" + this.spyStatement + ")");
        return this.spyStatement;
    }

    public final Object getObject(int n, Map map) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(int columnIndex, java.util.Map map)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("map = " + map);
        this.spyLogger.enter();
        try {
            object = this.realResultSet.getObject(n, map);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final Ref getRef(int n) throws SQLException {
        Ref ref;
        this.spyLogger.println("\n" + this + ".getRef(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            ref = this.realResultSet.getRef(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        ref = (Ref)this.spyLogger.loggedRetrievedObject(ref);
        this.spyLogger.println("OK (" + ref + ")");
        return ref;
    }

    public final Blob getBlob(int n) throws SQLException {
        Blob blob;
        this.spyLogger.println("\n" + this + ".getBlob(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            blob = this.realResultSet.getBlob(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        blob = (Blob)this.spyLogger.loggedRetrievedObject(blob);
        this.spyLogger.println("OK (" + blob + ")");
        return blob;
    }

    public final Clob getClob(int n) throws SQLException {
        Clob clob;
        this.spyLogger.println("\n" + this + ".getClob(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            clob = this.realResultSet.getClob(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        clob = (Clob)this.spyLogger.loggedRetrievedObject(clob);
        this.spyLogger.println("OK (" + clob + ")");
        return clob;
    }

    public final Array getArray(int n) throws SQLException {
        Array array;
        this.spyLogger.println("\n" + this + ".getArray(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            array = this.realResultSet.getArray(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        array = (Array)this.spyLogger.loggedRetrievedObject(array);
        this.spyLogger.println("OK (" + array + ")");
        return array;
    }

    public final Object getObject(String string, Map map) throws SQLException {
        Object object;
        this.spyLogger.println("\n" + this + ".getObject(String columnName, java.util.Map map)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("map = " + map);
        this.spyLogger.enter();
        try {
            object = this.realResultSet.getObject(string, map);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        object = this.spyLogger.loggedRetrievedObject(object);
        this.spyLogger.println("OK (" + object + ")");
        return object;
    }

    public final Ref getRef(String string) throws SQLException {
        Ref ref;
        this.spyLogger.println("\n" + this + ".getRef(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            ref = this.realResultSet.getRef(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        ref = (Ref)this.spyLogger.loggedRetrievedObject(ref);
        this.spyLogger.println("OK (" + ref + ")");
        return ref;
    }

    public final Blob getBlob(String string) throws SQLException {
        Blob blob;
        this.spyLogger.println("\n" + this + ".getBlob(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            blob = this.realResultSet.getBlob(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        blob = (Blob)this.spyLogger.loggedRetrievedObject(blob);
        this.spyLogger.println("OK (" + blob + ")");
        return blob;
    }

    public final Clob getClob(String string) throws SQLException {
        Clob clob;
        this.spyLogger.println("\n" + this + ".getClob(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            clob = this.realResultSet.getClob(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        clob = (Clob)this.spyLogger.loggedRetrievedObject(clob);
        this.spyLogger.println("OK (" + clob + ")");
        return clob;
    }

    public final Array getArray(String string) throws SQLException {
        Array array;
        this.spyLogger.println("\n" + this + ".getArray(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            array = this.realResultSet.getArray(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        array = (Array)this.spyLogger.loggedRetrievedObject(array);
        this.spyLogger.println("OK (" + array + ")");
        return array;
    }

    public final Date getDate(int n, Calendar calendar) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(int columnIndex, java.util.Calendar cal)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            date = this.realResultSet.getDate(n, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Date getDate(String string, Calendar calendar) throws SQLException {
        Date date;
        this.spyLogger.println("\n" + this + ".getDate(String columnName, java.util.Calendar cal)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            date = this.realResultSet.getDate(string, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + date + ")");
        return date;
    }

    public final Time getTime(int n, Calendar calendar) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(int columnIndex, java.util.Calendar cal)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            time = this.realResultSet.getTime(n, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Time getTime(String string, Calendar calendar) throws SQLException {
        Time time;
        this.spyLogger.println("\n" + this + ".getTime(String columnName, java.util.Calendar cal)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            time = this.realResultSet.getTime(string, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + time + ")");
        return time;
    }

    public final Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(int columnIndex, java.util.Calendar cal)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            timestamp = this.realResultSet.getTimestamp(n, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        this.spyLogger.println("\n" + this + ".getTimestamp(String columnName, java.util.Calendar cal)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("cal = " + calendar);
        this.spyLogger.enter();
        try {
            timestamp = this.realResultSet.getTimestamp(string, calendar);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + timestamp + ")");
        return timestamp;
    }

    public final URL getURL(int n) throws SQLException {
        URL uRL;
        this.spyLogger.println("\n" + this + ".getURL(int columnIndex)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.enter();
        try {
            uRL = this.realResultSet.getURL(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + uRL + ")");
        return uRL;
    }

    public final URL getURL(String string) throws SQLException {
        URL uRL;
        this.spyLogger.println("\n" + this + ".getURL(String columnName)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.enter();
        try {
            uRL = this.realResultSet.getURL(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + uRL + ")");
        return uRL;
    }

    public final void updateRef(int n, Ref ref) throws SQLException {
        ref = (Ref)this.spyLogger.loggedInputObject(ref);
        this.spyLogger.println("\n" + this + ".updateRef(int columnIndex, java.sql.Ref x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + ref);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateRef(n, ref);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateRef(String string, Ref ref) throws SQLException {
        ref = (Ref)this.spyLogger.loggedInputObject(ref);
        this.spyLogger.println("\n" + this + ".updateRef(String columnName, java.sql.Ref x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + ref);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateRef(string, ref);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBlob(int n, Blob blob) throws SQLException {
        blob = (Blob)this.spyLogger.loggedInputObject(blob);
        this.spyLogger.println("\n" + this + ".updateBlob(int columnIndex, java.sql.Blob x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + blob);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBlob(n, blob);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateBlob(String string, Blob blob) throws SQLException {
        blob = (Blob)this.spyLogger.loggedInputObject(blob);
        this.spyLogger.println("\n" + this + ".updateBlob(String columnName, java.sql.Blob x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + blob);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateBlob(string, blob);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateClob(int n, Clob clob) throws SQLException {
        clob = (Clob)this.spyLogger.loggedInputObject(clob);
        this.spyLogger.println("\n" + this + ".updateClob(int columnIndex, java.sql.Clob x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + clob);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateClob(n, clob);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateClob(String string, Clob clob) throws SQLException {
        clob = (Clob)this.spyLogger.loggedInputObject(clob);
        this.spyLogger.println("\n" + this + ".updateClob(String columnName, java.sql.Clob x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + clob);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateClob(string, clob);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateArray(int n, Array array) throws SQLException {
        array = (Array)this.spyLogger.loggedInputObject(array);
        this.spyLogger.println("\n" + this + ".updateArray(int columnIndex, java.sql.Array x)");
        this.spyLogger.println("columnIndex = " + n);
        this.spyLogger.println("x = " + array);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateArray(n, array);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void updateArray(String string, Array array) throws SQLException {
        array = (Array)this.spyLogger.loggedInputObject(array);
        this.spyLogger.println("\n" + this + ".updateArray(String columnName, java.sql.Array x)");
        this.spyLogger.println("columnName = " + string);
        this.spyLogger.println("x = " + array);
        this.spyLogger.enter();
        try {
            this.realResultSet.updateArray(string, array);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final String toString() {
        return "ResultSet[" + this.id + "]";
    }
}

