/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.oracle.OracleConnection;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOBOPS;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilTransliterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class OracleImplBlob
extends BaseImplBlob {
    private static String footprint = "$Revision:   3.30.1.1  $";
    public byte[] bloblocator;
    private OracleImplStatement implstmt;
    private boolean IsBFILE = false;
    private boolean IsBFILEOpen = false;
    private long cachedCurrentLength = 0L;
    private boolean cachedCurrentLengthIsCorrect = false;
    private OracleInternalParameterSet paramSet = null;
    static final int ValueInLocatorOffset = 102;
    private int m_numBytesEmbeddedWithinLocator;

    public OracleImplBlob(byte[] byArray, OracleImplStatement oracleImplStatement) {
        super(oracleImplStatement.comm.exceptions);
        this.IsBFILE = false;
        this.cachedCurrentLengthIsCorrect = false;
        this.IsBFILEOpen = false;
        this.implstmt = oracleImplStatement;
        this.setLocator(byArray);
    }

    public OracleImplBlob(byte[] byArray, OracleImplStatement oracleImplStatement, boolean bl) {
        super(oracleImplStatement.comm.exceptions);
        this.IsBFILE = bl;
        this.cachedCurrentLengthIsCorrect = false;
        this.IsBFILEOpen = false;
        this.implstmt = oracleImplStatement;
        this.setLocator(byArray);
    }

    public OracleImplBlob(OracleImplStatement oracleImplStatement, BaseParameter baseParameter, byte[] byArray) throws SQLException {
        super(oracleImplStatement.comm.exceptions);
        this.implstmt = oracleImplStatement;
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        this.bloblocator = new byte[86];
        this.bloblocator[1] = 84;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(272, this.implstmt.implConn);
        tTIFUN_OLOBOPS.SourceLobLocator = this.bloblocator;
        tTIFUN_OLOBOPS.DestinationLength = 10;
        tTIFUN_OLOBOPS.SourceOffset = 1;
        tTIFUN_OLOBOPS.DestinationOffset = 113;
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = 2L;
        tTIFUN_OLOBOPS.brequestIfnull = true;
        tTIFUN_OLOBOPS.CharSet = 1;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
        int n = 1;
        if (byArray == null) {
            InputStream inputStream = baseParameter.getType() == 10 ? new ByteArrayInputStream(BaseParameter.stringToBytes((String)((String)baseParameter.getObject()), (UtilTransliterator)baseParameter.transliterator, (BaseExceptions)this.implstmt.comm.exceptions)) : baseParameter.getBinaryStream(-1, (BaseConnection)this.implstmt.implConn.connection, this.implstmt.comm.exceptions);
            byte[] byArray2 = new byte[(int)this.getMaxChunkSize()];
            int n2 = 0;
            try {
                while ((n2 = inputStream.read(byArray2)) > 0) {
                    this.writeData(n, byArray2, 0, n2);
                    n += n2;
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = this.implstmt.comm.exceptions.getException((Exception)iOException);
                throw sQLException;
            }
            this.cachedCurrentLength = n - 1;
            this.cachedCurrentLengthIsCorrect = true;
        } else if (byArray.length != 0) {
            int n3 = (int)this.getMaxChunkSize();
            int n4 = 0;
            for (int i = byArray.length; i > 0; i -= n3) {
                n3 = Math.min(n3, i);
                this.writeData(n, byArray, n4, n3);
                n4 += n3;
                n += n3;
            }
            this.cachedCurrentLength = n - 1;
            this.cachedCurrentLengthIsCorrect = true;
        }
    }

    private void setLocator(byte[] byArray) {
        this.bloblocator = byArray;
        this.processLocatorForEmbeddedData();
    }

    protected void processLocatorForEmbeddedData() {
        if (this.implstmt.getSQL().hasForUpdate()) {
            this.m_numBytesEmbeddedWithinLocator = 0;
            return;
        }
        if (this.bloblocator.length < 102) {
            this.m_numBytesEmbeddedWithinLocator = 0;
            return;
        }
        if (this.bloblocator[101] != 1) {
            this.m_numBytesEmbeddedWithinLocator = 0;
            return;
        }
        this.m_numBytesEmbeddedWithinLocator = (this.bloblocator[94] << 8) + (this.bloblocator[95] & 0xFF);
        UtilDebug.assert((String)"unexpected embedded LOB length", (this.m_numBytesEmbeddedWithinLocator <= this.bloblocator.length - 102 ? 1 : 0) != 0);
    }

    public long getMaxChunkSize() {
        return 32512L;
    }

    public boolean getCloseImplBlobOnBinaryStreamClose() {
        return true;
    }

    public boolean CheckIsBFILE() {
        return this.IsBFILE;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(byte[] byArray, long l) throws SQLException {
        int n;
        int n2 = (int)l;
        int n3 = n = byArray.length > 4096 ? 4096 : byArray.length;
        if (this.IsBFILE) {
            this.checkBFILEOpen();
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implstmt.implConn);
        tTIFUN_OALL8.setOptions(1065);
        tTIFUN_OALL8.setCommandText("begin :rslt := dbms_lob.instr(:lctr,:ptrn,:offset,:occ); end;");
        tTIFUN_OALL8.setCursorID(this.implstmt.implConn.getCursorID());
        if (this.paramSet == null) {
            this.paramSet = new OracleInternalParameterSet();
        } else {
            this.paramSet.reset();
        }
        int n4 = 0;
        OracleInternalParameter oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        if (this.IsBFILE) {
            oracleInternalParameter.setInfo(114, 0, 0, this.bloblocator.length, 0, 0, this.implstmt.comm.transliterator);
        } else {
            oracleInternalParameter.setInfo(113, 0, 0, this.bloblocator.length, 0, 0, this.implstmt.comm.transliterator);
        }
        oracleInternalParameter.m_nativeDataIn = this.bloblocator;
        oracleInternalParameter.m_nativeDataInLength = this.bloblocator.length;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(23, 0, 0, n, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = byArray;
        oracleInternalParameter.m_nativeDataInLength = n;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        byte[] byArray2 = new byte[22];
        n4 = OracleVNU.convertIntToVNU(byArray2, n2);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = n4;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        byte[] byArray3 = new byte[22];
        n4 = OracleVNU.convertIntToVNU(byArray3, 1);
        oracleInternalParameter.m_nativeDataIn = byArray3;
        oracleInternalParameter.m_nativeDataInLength = n4;
        oracleInternalParameter.m_direction = 32;
        tTIFUN_OALL8.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implstmt.implConn);
        tTIRXDDataPacket.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(null, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        oracleNet8NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
        oracleInternalParameter = this.paramSet.paramSet[0];
        BaseExceptions baseExceptions = this.implstmt.comm.exceptions;
        long l2 = OracleVNU.convertVNUToLong(oracleInternalParameter.getSingleOutputValue(baseExceptions), oracleInternalParameter.getSingleOutputValueLength(baseExceptions), baseExceptions);
        return l2 == 0L ? -1L : l2;
    }

    public long getLength() throws SQLException {
        if (this.m_numBytesEmbeddedWithinLocator > 0) {
            return this.m_numBytesEmbeddedWithinLocator;
        }
        if (this.cachedCurrentLengthIsCorrect) {
            return this.cachedCurrentLength;
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(1, this.bloblocator, this.implstmt.implConn);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.cachedCurrentLength = tTIFUN_OLOBOPS.LobAmt;
        this.cachedCurrentLengthIsCorrect = true;
        return this.cachedCurrentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.IsBFILE && this.IsBFILEOpen) {
            OracleConnection oracleConnection = this.implstmt.implConn.connection;
            synchronized (oracleConnection) {
                OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
                TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(512, this.bloblocator, this.implstmt.implConn);
                oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
                oracleNet8NSPTDAPacket.sendRequest();
                oracleNet8NSPTDAPacket.receiveReply();
                TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
                this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
                if (tTIOERDataPacket.retCode != 0) {
                    String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
                    SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
                    throw sQLException;
                }
                this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
                this.IsBFILEOpen = false;
            }
        }
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        String[] stringArray;
        if (this.m_numBytesEmbeddedWithinLocator > 0) {
            System.arraycopy(this.bloblocator, (int)(101L + l), byArray, n, n2);
            return n2;
        }
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(2, this.implstmt.implConn);
        int n3 = 0;
        if (this.IsBFILE) {
            this.checkBFILEOpen();
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        tTIFUN_OLOBOPS.SourceLobLocator = this.bloblocator;
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = n2;
        tTIFUN_OLOBOPS.SourceOffset = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        int n4 = this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray2 = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray2, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        if (n4 == 14) {
            stringArray = new TTIRXDDataPacket(this.implstmt.implConn);
            oracleNet8NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)stringArray);
            stringArray.setBaseExceptions(this.exceptions);
            n3 = stringArray.readRXDDataInBuffer(byArray, n, this.exceptions);
        }
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        return n3;
    }

    public void truncate(long l) throws SQLException {
        if (this.IsBFILE) {
            throw this.implstmt.comm.exceptions.getException(7008, "S1000");
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(32, this.bloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
        this.cachedCurrentLengthIsCorrect = false;
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.IsBFILE) {
            throw this.implstmt.comm.exceptions.getException(7008, "S1000");
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(64, this.bloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.SourceLobLocator = this.bloblocator;
        tTIFUN_OLOBOPS.SourceOffset = (int)l;
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = n2;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        if (this.paramSet == null) {
            this.paramSet = new OracleInternalParameterSet();
        } else {
            this.paramSet.reset();
        }
        OracleInternalParameter oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(23, 0, 0, 0, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = byArray;
        oracleInternalParameter.m_nativeDataInOffset = n;
        oracleInternalParameter.m_nativeDataInLength = n2;
        oracleInternalParameter.m_direction = 32;
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implstmt.implConn, 14);
        tTIRXDDataPacket.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
        this.cachedCurrentLengthIsCorrect = false;
        return (int)tTIFUN_OLOBOPS.LobAmt;
    }

    private boolean checkBFILEOpen() throws SQLException {
        if (!this.IsBFILE) {
            return false;
        }
        if (this.IsBFILEOpen) {
            return true;
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(256, this.bloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = 11L;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
        this.IsBFILEOpen = true;
        return true;
    }
}

