/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.ConnectionStrategy;
import com.metamatrix.connector.jdbc.JDBCConnector;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCProcedureExecution;
import com.metamatrix.connector.jdbc.JDBCQueryExecution;
import com.metamatrix.connector.jdbc.JDBCUpdateExecution;
import com.metamatrix.connector.jdbc.SQLTranslatorWrapper;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.SourceConnection;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCSourceConnection
implements Connection,
SourceConnection {
    protected java.sql.Connection physicalConnection;
    private ConnectionPool pool;
    protected ConnectorEnvironment environment;
    private ConnectorLogger logger;
    private ConnectorCapabilities capabilities;
    private SQLTranslator sqlTranslator;
    private ResultsTranslator resultsTranslator;
    private ConnectionStrategy connectionStrategy;
    private ConnectionListener connectionListener;

    public JDBCSourceConnection(java.sql.Connection connection, ConnectorEnvironment environment, ConnectionStrategy connectionStrategy) throws ConnectorException {
        this(connection, environment, connectionStrategy, null);
    }

    public JDBCSourceConnection(java.sql.Connection connection, ConnectorEnvironment environment, ConnectionStrategy connectionStrategy, ConnectionListener connectionListener) throws ConnectorException {
        this.physicalConnection = connection;
        this.environment = environment;
        this.logger = environment.getLogger();
        this.connectionStrategy = connectionStrategy;
        this.connectionListener = connectionListener;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Properties connectorProps = environment.getProperties();
            String className = connectorProps.getProperty("ExtensionSQLTranslationClass");
            if (className == null) {
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnection.Property_{0}_is_required,_but_not_defined_1", (Object)"ExtensionSQLTranslationClass"));
            }
            Class<?> sqlTransClass = loader.loadClass(className);
            this.sqlTranslator = (SQLTranslator)sqlTransClass.newInstance();
            this.sqlTranslator = new SQLTranslatorWrapper(this.sqlTranslator);
            className = connectorProps.getProperty("ExtensionResultsTranslationClass");
            if (className == null) {
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnection.Property_{0}_is_required,_but_not_defined_1", (Object)"ExtensionResultsTranslationClass"));
            }
            Class<?> resultsTransClass = loader.loadClass(className);
            this.resultsTranslator = (ResultsTranslator)resultsTransClass.newInstance();
            this.resultsTranslator.initialize(environment);
            this.capabilities = JDBCConnector.createCapabilities(loader, connectorProps);
        }
        catch (ClassNotFoundException e1) {
            throw new ConnectorException((Throwable)e1);
        }
        catch (InstantiationException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (IllegalAccessException e3) {
            throw new ConnectorException((Throwable)e3);
        }
        if (this.connectionListener != null) {
            this.connectionListener.afterConnectionCreation(this.getPhysicalConnection(), this.environment);
        }
    }

    public ConnectorCapabilities getCapabilities() {
        return this.capabilities;
    }

    public Execution createExecution(int executionMode, ExecutionContext executionContext, RuntimeMetadata metadata) throws ConnectorException {
        this.sqlTranslator.initialize(this.environment, metadata);
        switch (executionMode) {
            case 0: {
                return new JDBCQueryExecution(this.getPhysicalConnection(), this.sqlTranslator, this.resultsTranslator, this.logger, this.environment.getProperties(), executionContext);
            }
            case 1: 
            case 3: 
            case 4: {
                return new JDBCUpdateExecution(this.getPhysicalConnection(), this.sqlTranslator, this.resultsTranslator, this.logger, this.environment.getProperties(), executionContext);
            }
            case 2: {
                return new JDBCProcedureExecution(this.getPhysicalConnection(), this.sqlTranslator, this.resultsTranslator, this.logger, this.environment.getProperties(), metadata, executionContext);
            }
        }
        throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnection.Execution_mode_not_supported__{0}_1", (Object)("" + executionMode)));
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
        this.pool.release((SourceConnection)this);
    }

    public boolean isAlive() {
        if (this.connectionStrategy == null) {
            try {
                return !this.getPhysicalConnection().isClosed();
            }
            catch (SQLException e) {
                return false;
            }
            catch (ConnectorException err) {
                return false;
            }
        }
        try {
            return this.connectionStrategy.isConnectionAlive(this.getPhysicalConnection());
        }
        catch (ConnectorException err) {
            return false;
        }
    }

    public boolean isFailed() {
        if (this.connectionStrategy == null) {
            return false;
        }
        try {
            return this.connectionStrategy.isConnectionFailed(this.getPhysicalConnection());
        }
        catch (ConnectorException err) {
            return true;
        }
    }

    public void setConnectionPool(ConnectionPool pool) {
        this.pool = pool;
    }

    public void closeSource() throws ConnectorException {
        if (this.physicalConnection == null) {
            return;
        }
        try {
            if (this.connectionListener != null) {
                this.connectionListener.beforeConnectionClose(this.physicalConnection, this.environment);
            }
            this.physicalConnection.close();
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e), e.getMessage());
        }
    }

    protected java.sql.Connection getPhysicalConnection() throws ConnectorException {
        return this.physicalConnection;
    }
}

