/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.ServerSessionService;
import com.metamatrix.platform.security.audit.AuditManager;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.rmi.RemoteException;

public class AdminHelper
implements IAdminHelper {
    private static final String SESSION_SERVICE_DOWN_MSG = PlatformPlugin.Util.getString("ERR.014.001.0010");
    private AuthorizationServiceInterface authAdmin = PlatformProxyHelper.getAuthorizationServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
    private ServerSessionService sessionAdmin = PlatformProxyHelper.getSessionServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
    RolePermissionFactory roleFactory = new RolePermissionFactory();

    public void checkForRequiredRole(SessionToken adminToken, String roleName, String methodName) throws AuthorizationException, ComponentNotFoundException {
        LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Checking owner of session token ", adminToken, " for membership in role: ", roleName});
        boolean isAuthorized = false;
        AuditManager.record((String)"ADMIN_API", (String)(roleName + "-request"), (String)adminToken.getUsername(), (String)methodName);
        try {
            isAuthorized = this.authAdmin.isCallerInRole(adminToken, roleName);
        }
        catch (MetaMatrixSecurityException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.001.0009", (Object)adminToken);
            I18nLogManager.logError((String)"ADMIN_API", (String)"ERR.014.001.0009", (Throwable)e);
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0009", msg);
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.001.0009", (Object)adminToken);
            I18nLogManager.logError((String)"ADMIN_API", (String)"ERR.014.001.0009", (Throwable)e);
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0009", msg);
        }
        catch (RemoteException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.001.0009", (Object)adminToken);
            I18nLogManager.logError((String)"ADMIN_API", (String)"ERR.014.001.0009", (Throwable)e);
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0009", msg);
        }
        if (!isAuthorized) {
            String msg = PlatformPlugin.Util.getString("ERR.014.001.0008", (Object)adminToken, (Object)roleName.toString());
            LogManager.logError((String)"ADMIN_API", (String)"ERR.014.001.0008");
            AuditManager.record((String)"ADMIN_API", (String)(roleName + "-denied"), (String)adminToken.getUsername(), (String)methodName);
            throw new AuthorizationException("ERR.014.001.0008", msg);
        }
        LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Verified owner of session token ", adminToken, " is in role: ", roleName});
    }

    public SessionToken validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Validating user session with session ID \"", sessionID, "\""});
        SessionToken token = null;
        try {
            token = this.sessionAdmin.validateSession(sessionID);
        }
        catch (InvalidSessionException e) {
            I18nLogManager.logError((String)"ADMIN_API", (String)"ERR.014.001.0012", (Throwable)e);
            throw e;
        }
        catch (SessionServiceException e) {
            I18nLogManager.logError((String)"ADMIN_API", (String)"ERR.014.001.0010", (Throwable)e);
            throw new ComponentNotFoundException((Throwable)e, "ERR.014.001.0010", SESSION_SERVICE_DOWN_MSG);
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.001.0013");
            LogManager.logError((String)"ADMIN_API", (Throwable)e, (String)msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        catch (RemoteException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.001.0013");
            LogManager.logError((String)"ADMIN_API", (Throwable)e, (String)msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        LogManager.logTrace((String)"ADMIN_API", (Object[])new Object[]{"Validated user session with session ID \"", sessionID, "\""});
        return token;
    }
}

