/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseClob;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.util.UtilDebug;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class BaseClobReader
extends Reader {
    private static String footprint = "$Revision:   1.0.1.0  $";
    private long currentPosition;
    private long dataLength;
    private BaseImplClob implClob;
    private BaseClob clob;
    BaseExceptions exceptions;
    public boolean closeImplClobOnClose;

    public BaseClobReader(BaseClob baseClob, BaseImplClob baseImplClob, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supplay a BaseImplClob derivative", baseImplClob != null);
        UtilDebug.assert("Must supply an exception generator", baseExceptions != null);
        this.clob = baseClob;
        this.currentPosition = 0L;
        this.implClob = baseImplClob;
        this.exceptions = baseExceptions;
        this.dataLength = baseImplClob.getLength();
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        try {
            int n = this.implClob.readData(cArray, 0, this.currentPosition + 1L, 1);
            int n2 = n == 0 ? -1 : cArray[0] & 0xFF;
            if (n2 != -1) {
                ++this.currentPosition;
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        long l = this.dataLength - this.currentPosition;
        if (l < Integer.MAX_VALUE && n2 > (n3 = new Long(l).intValue())) {
            n2 = n3;
        }
        try {
            int n4 = n2;
            long l2 = this.currentPosition + 1L;
            int n5 = this.implClob.readData(cArray, n, l2, n4);
            this.currentPosition += (long)n5;
            return n5;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new IOException(sQLException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            if (this.closeImplClobOnClose) {
                this.implClob.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

