/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import com.metamatrix.util.UtilByteArray;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public final class TDSLoginRequest
extends TDSRequest {
    private static String footprint = "$Revision:   3.15.1.4  $";
    private String username;
    private String password;
    private String databaseName;
    private String programName;
    private String hostProcess;
    private String netAddress;
    private String WSID;
    private byte[] sspiToken;
    private BaseWarnings warnings;
    private int TDS_LOGIN_REQUEST_BASE_LEN = 86;
    private static int ORDER_X86 = 0;
    private static int ORDER_68000 = 1;
    private static int CHARSET_ASCII = 0;
    private static int CHARSET_EBCDIC = 1;
    private static int FLOAT_IEEE_754 = 0;
    private static int FLOAT_VAX = 1;
    private static int FLOAT_ND5000 = 2;
    private static int DUMPLOAD_OFF = 0;
    private static int DUMPLOAD_ON = 1;
    private static int USE_DB_OFF = 0;
    private static int USE_DB_ON = 1;
    private static int INIT_DB_WARN = 0;
    private static int INIT_DB_FATAL = 1;
    private static int SET_LANG_OFF = 0;
    private static int SET_LANG_ON = 1;
    private static int INIT_LANG_WARN = 0;
    private static int INIT_LANG_FATAL = 1;
    private static int ODBC_OFF = 0;
    private static int ODBC_ON = 1;
    private static int TRAN_BOUNDARY_OFF = 0;
    private static int TRAN_BOUNDARY_ON = 1;
    private static int CACHE_CONNECTION_OFF = 0;
    private static int CACHE_CONNECTION_ON = 1;
    private static int USER_NORMAL = 0;
    private static int USER_SERVER = 1;
    private static int USER_REMUSER = 2;
    private static int USER_SQLREPL = 3;
    private static int INTEGRATED_SECURITY_OFF = 0;
    private static int INTEGRATED_SECURITY_ON = 1;
    private static int SQL_DFLT = 0;
    private static int SQL_TSQL = 1;
    private static int SQL_ANSI_V1 = 2;
    private static int SQL_ANSI89_L1 = 3;
    private static int SQL_ANSI89_L2 = 4;
    private static int SQL_ANSI89_IEF = 5;
    private static int SQL_ANSI92_ENTRY = 6;
    private static int SQL_ANSI92_TRANS = 7;
    private static int SQL_ANSI92_INTER = 8;
    private static int SQL_ANSI92_FULL = 9;
    private static int MAXNICSIZE = 6;
    private boolean loginAckProcessed = false;

    public TDSLoginRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, BaseWarnings baseWarnings, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter, 16);
        this.warnings = baseWarnings;
        this.username = string;
        this.password = string2;
        this.databaseName = string3;
        this.programName = string4;
        this.hostProcess = string5;
        this.netAddress = string6;
        this.WSID = string7;
        this.sspiToken = null;
    }

    public void submitRequest(SQLServerImplStatement sQLServerImplStatement) throws SQLException {
        try {
            this.clearReplyChannel();
            this.setupLoginRecord();
            this.writer.send();
            if (this.conn.serverEncryptMode == 0) {
                this.reader.setSocket(this.conn.socket);
                this.writer.setSocket(this.conn.socket);
                this.conn.sslSocket = null;
            }
            this.reader.receive();
            this.processReply(3, this.warnings);
            while (this.sspiToken != null) {
                this.sspiToken = this.conn.getSecurityToken(this.sspiToken);
                if (this.sspiToken == null || this.sspiToken.length <= 0) continue;
                this.clearReplyChannel();
                this.conn.setMessageType(17);
                this.writer.writeBytes(this.sspiToken);
                this.writer.send();
                this.reader.receive();
                this.processReply(3, this.warnings);
            }
            while (!this.loginAckProcessed) {
                this.reader.receive();
                this.processReply(3, this.warnings);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
    }

    private static byte[] encryptPassword(String string) {
        int n = string == null ? 0 : string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)c;
            byArray[i * 2] = (byte)((by << 4 | by >> 4 & 0xF) ^ 0xA5);
            by = (byte)(c >> 8);
            byArray[i * 2 + 1] = (byte)((by << 4 | by >> 4 & 0xF) ^ 0xA5);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupLoginRecord() throws SQLException {
        if (this.conn.getTDSVersion() > 2) {
            this.TDS_LOGIN_REQUEST_BASE_LEN = 94;
            this.writer.setTDSVersion(1913192450);
        }
        int n = 0;
        try {
            String string = null;
            string = this.WSID.length() == 0 ? this.conn.getLocalHostname() : this.WSID;
            byte[] byArray = this.conn.unicodeTransliterator.encode(string);
            byte[] byArray2 = this.conn.unicodeTransliterator.encode(this.username);
            byte[] byArray3 = TDSLoginRequest.encryptPassword(this.password);
            byte[] byArray4 = this.conn.unicodeTransliterator.encode(this.programName);
            String string2 = this.conn.getServerHostname();
            byte[] byArray5 = this.conn.unicodeTransliterator.encode(string2);
            byte[] byArray6 = this.conn.unicodeTransliterator.encode(this.databaseName);
            if (this.conn.securityContext != null) {
                this.sspiToken = this.conn.getSecurityToken(null);
            }
            int n2 = this.TDS_LOGIN_REQUEST_BASE_LEN + byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length + (this.sspiToken == null ? 0 : this.sspiToken.length);
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                this.writer.messageType = 16;
                this.writer.writeInt32(n2);
                if (this.conn.getTDSVersion() == 3) {
                    this.writer.writeInt32(1913192450);
                } else {
                    this.writer.writeInt32(0x71000000);
                }
                if (this.conn.sslSocket != null && (this.conn.serverEncryptMode & 1) != 0) {
                    this.writer.writeInt32(0);
                } else if (this.conn.hasZeroPacketSize) {
                    this.writer.writeInt32(0);
                } else {
                    this.writer.writeInt32(this.conn.packetSize);
                }
                this.writer.writeInt32(0);
                try {
                    this.writer.writeInt32(Integer.decode(this.hostProcess));
                }
                catch (NumberFormatException numberFormatException) {
                    this.writer.writeInt32(0);
                }
                this.writer.writeInt32(0);
                this.writer.writeInt8(SET_LANG_ON << 7 | INIT_DB_FATAL << 6 | USE_DB_ON << 5 | DUMPLOAD_OFF << 4 | FLOAT_IEEE_754 << 2 | CHARSET_ASCII << 1 | ORDER_X86);
                if (this.conn.securityContext == null) {
                    this.writer.writeInt8(INTEGRATED_SECURITY_OFF << 7 | USER_NORMAL << 4 | CACHE_CONNECTION_OFF << 3 | TRAN_BOUNDARY_OFF << 2 | ODBC_ON << 1 | INIT_LANG_FATAL);
                } else {
                    this.writer.writeInt8(INTEGRATED_SECURITY_ON << 7 | USER_NORMAL << 4 | CACHE_CONNECTION_OFF << 3 | TRAN_BOUNDARY_OFF << 2 | ODBC_ON << 1 | INIT_LANG_FATAL);
                }
                this.writer.writeInt8(SQL_DFLT);
                this.writer.writeInt8(0);
                this.writer.writeInt32(0);
                this.writer.writeInt32(0);
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN);
                this.writer.writeInt16(string.length());
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray.length));
                this.writer.writeInt16(this.username.length());
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray2.length));
                this.writer.writeInt16(this.password.length());
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray3.length));
                this.writer.writeInt16(this.programName.length());
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray4.length));
                this.writer.writeInt16(string2.length());
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray5.length));
                this.writer.writeInt16(0);
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + n);
                this.writer.writeInt16(0);
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + n);
                this.writer.writeInt16(0);
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + n);
                this.writer.writeInt16(this.databaseName.length());
                this.writer.writeBytes(this.encodeNetAddress());
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray6.length));
                this.writer.writeInt16(this.sspiToken == null ? 0 : this.sspiToken.length);
                this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + (n += this.sspiToken == null ? 0 : this.sspiToken.length));
                this.writer.writeInt16(0);
                if (this.conn.getTDSVersion() > 2) {
                    this.writer.writeInt16(this.TDS_LOGIN_REQUEST_BASE_LEN + n);
                    this.writer.writeInt16(0);
                    this.writer.writeInt32(0);
                }
                this.writer.writeBytes(byArray);
                this.writer.writeBytes(byArray2);
                this.writer.writeBytes(byArray3);
                this.writer.writeBytes(byArray4);
                this.writer.writeBytes(byArray5);
                this.writer.writeBytes(byArray6);
                this.writer.writeBytes(this.sspiToken);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            this.sspiToken = null;
            switch (by) {
                case -3: {
                    int n = this.reader.readUnsignedInt16();
                    int n2 = this.reader.readUnsignedInt16();
                    if (this.conn.getTDSVersion() > 2) {
                        int n3 = (int)this.reader.readInt64();
                    } else {
                        int n4 = this.reader.readInt32();
                    }
                    if ((n & 2) == 0) break;
                    this.exception = this.conn.exceptions.getException(this.exception, 1, 7002, "08001");
                    break;
                }
                case -83: {
                    this.loginAckProcessed = true;
                    int n = this.reader.readUnsignedInt16();
                    byte by2 = this.reader.readInt8();
                    this.conn.setTDSVersion(this.reader.readBigEndianInt32());
                    String string = this.reader.readString(this.reader.readInt8() * 2);
                    this.conn.setDatabaseMajorVersion(this.reader.readInt8());
                    this.conn.setDatabaseMinorVersion(this.reader.readInt8());
                    this.reader.readBigEndianInt16();
                    break;
                }
                case -19: {
                    int n = this.reader.readUnsignedInt16();
                    this.sspiToken = new byte[n];
                    this.reader.getArrayOfBytes(this.sspiToken, 0, n);
                    break;
                }
                default: {
                    super.processReplyToken(by, baseWarnings);
                }
            }
            return true;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
        catch (Exception exception) {
            throw this.conn.exceptions.getException(exception);
        }
    }

    private byte[] encodeNetAddress() {
        byte[] byArray = new byte[6];
        boolean bl = false;
        if (this.netAddress.length() == MAXNICSIZE * 2) {
            try {
                int n;
                for (int i = 0; i < MAXNICSIZE && (n = Integer.parseInt(this.netAddress.substring(i * 2, i * 2 + 2), 16)) >= 0; ++i) {
                    byArray[i] = (byte)n;
                }
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            UtilByteArray.fill(byArray, 0);
        }
        return byArray;
    }
}

