/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.file;

import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.NamedDocumentExecutor;
import com.metamatrix.connector.xml.SAXFilterProvider;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.base.BaseResultsProducer;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.LoggingInputStreamFilter;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.QueryAnalyzer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLConnectionImpl;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.base.XMLExecutionImpl;
import com.metamatrix.connector.xml.base.XMLExtractor;
import com.metamatrix.connector.xml.file.FileConnectorState;
import com.metamatrix.connector.xml.file.Messages;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Document;

public class FileExecutionImpl
extends XMLExecutionImpl
implements DocumentProducer,
NamedDocumentExecutor {
    private String[] docs;
    private String directory;
    private XMLExtractor xmlExtractor;
    private FileConnectorState state;
    private ConnectorLogger logger;
    public static final String PARM_FILE_NAME_TABLE_PROPERTY_NAME = "FileName";
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$com$metamatrix$data$api$ConnectorLogger;

    public FileExecutionImpl(XMLConnectionImpl conn, RuntimeMetadata metadata, ExecutionContext exeContext, ConnectorEnvironment connectorEnv) throws ConnectorException {
        super(conn, metadata, exeContext, connectorEnv);
        this.state = (FileConnectorState)conn.getState();
        this.logger = this.getConnection().getState().getLogger();
        this.xmlExtractor = new XMLExtractor(this.state.getMaxInMemoryStringSize(), this.state.isPreprocess(), this.state.isLogRequestResponse(), null, this.state.getLogger());
    }

    private void init() throws ConnectorException {
        String tableFileName = this.getTableFileName();
        String xmlFileName = this.state.getFileName();
        if (tableFileName != null && tableFileName.trim().length() == 0) {
            tableFileName = null;
        }
        if (xmlFileName.trim().length() == 0) {
            xmlFileName = null;
        }
        String xmlFileDir = this.state.getDirectoryPath();
        this.directory = this.normalizePath(xmlFileDir);
        if (tableFileName == null && xmlFileName == null) {
            this.validateDirectory();
        } else {
            this.validateFile(tableFileName, xmlFileName, xmlFileDir);
        }
    }

    private void validateParams() throws ConnectorException {
        for (int i = 0; i < this.m_info.getRequestedColumns().size(); ++i) {
            OutputXPathDesc xPath = (OutputXPathDesc)this.m_info.getRequestedColumns().get(i);
            if (!xPath.isParameter()) continue;
            throw new ConnectorException(Messages.getString("FileExecutor.input.not.supported.on.files"));
        }
    }

    public void execute(IQuery query, int maxBatchSize) throws ConnectorException {
        try {
            List columnResult;
            XMLConnectorState state = this.getConnection().getState();
            this.m_maxBatch = maxBatchSize;
            QueryAnalyzer analyzer = new QueryAnalyzer(query, this.m_metadata, state.getPreprocessor(), this.m_logger, this.exeContext, this.connectorEnv);
            this.m_info = analyzer.getExecutionInfo();
            this.init();
            this.validateParams();
            List requestPerms = analyzer.getRequestPerms();
            if (requestPerms.size() > 1) {
                throw new AssertionError((Object)"The QueryAnalyzer produced > 1 request permutation");
            }
            List<CriteriaDesc> criteriaList = Arrays.asList((CriteriaDesc[])requestPerms.get(0));
            this.m_info.setParameters(criteriaList);
            BaseResultsProducer resProducer = new BaseResultsProducer(this.getConnection().getConnector().getStatementCache(), this.getLogger());
            this.m_resultList = new ArrayList();
            int documentCount = this.getDocumentCount();
            XMLDocument[] docs = new XMLDocument[documentCount];
            for (int docNumber = 0; docNumber < documentCount; ++docNumber) {
                Response response = this.getXMLResponse(docNumber);
                this.logger.logTrace("getting results for " + docNumber);
                List resultList = resProducer.getResult(this.m_info, response);
                this.logger.logTrace("combining results for " + docNumber);
                this.m_resultList = BaseResultsProducer.combineResults(resultList, this.m_resultList);
            }
            if (!this.m_resultList.isEmpty() && !(columnResult = (List)this.m_resultList.get(0)).isEmpty()) {
                this.resultSize = columnResult.size();
            }
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public int getDocumentCount() throws ConnectorException {
        return this.docs.length;
    }

    public InputStream getDocumentStream(int i) throws ConnectorException {
        try {
            String xmlFileName = this.directory + this.docs[i];
            File xmlFile = new File(xmlFileName);
            this.logger.logTrace("XML Connector Framework: retrieving document from " + xmlFileName);
            FileInputStream retval = new FileInputStream(xmlFile);
            this.logger.logTrace("XML Connector Framework: retrieved file " + xmlFileName);
            return retval;
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
    }

    public InputStream addStreamFilters(InputStream response, ConnectorLogger logger) throws ConnectorException {
        if (this.getConnection().getState().isLogRequestResponse()) {
            response = new LoggingInputStreamFilter(response, logger);
        }
        InputStream filter = null;
        try {
            Class<?> pluggableFilter = Class.forName(this.getConnection().getState().getPluggableInputStreamFilterClass());
            Constructor<?> ctor = pluggableFilter.getConstructor(class$java$io$InputStream == null ? (class$java$io$InputStream = FileExecutionImpl.class$("java.io.InputStream")) : class$java$io$InputStream, class$com$metamatrix$data$api$ConnectorLogger == null ? (class$com$metamatrix$data$api$ConnectorLogger = FileExecutionImpl.class$("com.metamatrix.data.api.ConnectorLogger")) : class$com$metamatrix$data$api$ConnectorLogger);
            filter = (InputStream)ctor.newInstance(response, logger);
        }
        catch (Exception cnf) {
            throw new ConnectorException((Throwable)cnf);
        }
        return filter;
    }

    private String getTableFileName() {
        String retval = this.m_info.getLocation();
        if (retval == null) {
            retval = this.m_info.getOtherProperties().getProperty(PARM_FILE_NAME_TABLE_PROPERTY_NAME);
        }
        return retval;
    }

    private void validateDirectory() throws ConnectorException {
        File dirFile = new File(this.directory);
        String[] files = dirFile.list();
        ArrayList<String> xmlFiles = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            boolean valid = this.validateFile(files[i], this.directory, true);
            if (!valid) continue;
            xmlFiles.add(files[i]);
        }
        files = new String[xmlFiles.size()];
        xmlFiles.toArray(files);
        this.docs = files;
        if (this.docs.length <= 0) {
            throw new ConnectorException(Messages.getString("FileExecutor.empty.directory"));
        }
    }

    private boolean validateFile(String fileName, String directory, boolean validateExtension) {
        boolean result = false;
        String myXmlFileName = this.normalizePath(directory) + fileName;
        File xmlFile = new File(myXmlFileName);
        if (xmlFile.isFile()) {
            if (validateExtension) {
                if (myXmlFileName.toLowerCase().endsWith(".xml")) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private void validateFile(String tableFileName, String xmlFileName, String xmlFileDir) throws ConnectorException {
        this.docs = new String[1];
        this.docs[0] = tableFileName == null ? xmlFileName : tableFileName;
        boolean valid = this.validateFile(this.docs[0], xmlFileDir, false);
        if (!valid) {
            throw new ConnectorException(Messages.getString("FileExecutor.not.file"));
        }
    }

    private String normalizePath(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return new String(path + File.separator);
    }

    public String getCacheKey(int i) throws ConnectorException {
        return this.directory + this.docs[i];
    }

    public Serializable getRequestObject(int i) throws ConnectorException {
        return this.docs[i];
    }

    public Response getXMLResponse(int docNumber) throws ConnectorException {
        String documentDistinguishingId = "";
        if (this.getDocumentCount() > 1) {
            documentDistinguishingId = this.getDocumentName(docNumber);
        }
        SAXFilterProvider provider = null;
        provider = this.getConnection().getState().getSAXFilterProvider();
        InputStream responseBody = this.getDocumentStream(docNumber);
        InputStream filteredStream = this.addStreamFilters(responseBody, this.logger);
        DocumentInfo info = this.xmlExtractor.createDocumentFromStream(filteredStream, documentDistinguishingId, provider);
        Document domDoc = info.m_domDoc;
        XMLDocument doc = new XMLDocument(domDoc, info.m_externalFiles);
        String[] cacheKeys = new String[1];
        return new Response(new XMLDocument[]{doc}, cacheKeys, this, null, true, null);
    }

    public XMLDocument recreateDocument(Serializable requestObject) throws ConnectorException {
        return null;
    }

    public String getDocumentName(int i) throws ConnectorException {
        return this.docs[i];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

