/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.ParameterDescriptor;
import com.metamatrix.connector.xml.base.XMLExtractor;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public abstract class RequestResponseDocumentProducer
implements DocumentProducer {
    public static final String NAMESPACE_PREFIX_PROPERTY_NAME = "NamespacePrefixes";
    private XMLConnectorState m_state;
    private XMLExecution m_execution;
    protected XMLExtractor xmlExtractor;

    protected RequestResponseDocumentProducer(XMLConnectorState state, XMLExecution execution) throws ConnectorException {
        this.m_state = state;
        this.m_execution = execution;
        String cacheLocation = this.m_state.getCacheLocation();
        File cacheFolder = cacheLocation == null || cacheLocation.trim().length() == 0 ? null : new File(cacheLocation);
        this.xmlExtractor = new XMLExtractor(state.getMaxInMemoryStringSize(), state.isPreprocess(), state.isLogRequestResponse(), cacheFolder, state.getLogger());
        this.processOutputXPathDescs(this.m_execution.getInfo().getRequestedColumns(), this.m_execution.getInfo().getParameters());
    }

    public boolean cannotProjectParameter(CriteriaDesc parmCriteria) {
        return false;
    }

    protected XMLConnectorState getState() {
        return this.m_state;
    }

    protected ExecutionInfo getExecutionInfo() {
        return this.m_execution.getInfo();
    }

    protected XMLExecution getExecution() {
        return this.m_execution;
    }

    protected ConnectorLogger getLogger() {
        return this.m_state.getLogger();
    }

    protected XMLExtractor getExtractor() {
        return this.xmlExtractor;
    }

    private void processOutputXPathDescs(List requestedColumns, List parameterPairs) throws ConnectorException {
        for (int i = 0; i < requestedColumns.size(); ++i) {
            OutputXPathDesc xPath = (OutputXPathDesc)requestedColumns.get(i);
            if (!xPath.isParameter() || xPath.getXPath() != null) continue;
            this.setOutputValues(parameterPairs, xPath);
        }
    }

    private void setOutputValues(List parameterPairs, OutputXPathDesc xPath) throws ConnectorException {
        int colNum = xPath.getColumnNumber();
        for (int x = 0; x < parameterPairs.size(); ++x) {
            CriteriaDesc parmCriteria = (CriteriaDesc)parameterPairs.get(x);
            if (parmCriteria.getColumnNumber() != colNum) continue;
            if (this.cannotProjectParameter(parmCriteria)) {
                throw new ConnectorException(Messages.getString("HTTPExecutor.cannot.project.repeating.values"));
            }
            xPath.setCurrentValue(parmCriteria.getCurrentIndexValue());
            break;
        }
    }

    public static boolean checkIfRequestIsNeeded(ExecutionInfo info) throws ConnectorException {
        List cols = info.getRequestedColumns();
        boolean retVal = true;
        Iterator paramIter = cols.iterator();
        while (paramIter.hasNext()) {
            ParameterDescriptor desc = (ParameterDescriptor)paramIter.next();
            if (!desc.getRole().equalsIgnoreCase("Response In")) continue;
            retVal = false;
            break;
        }
        return retVal;
    }
}

