/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.testing.tools;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.jdbc.api.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DQPManager {
    private static final String URL_PREFIX = "jdbc:metamatrix:";
    private Connection connection;
    private Admin admin;
    private String dqpPath;

    public DQPManager(String dqpPath) throws Exception {
        this.dqpPath = dqpPath.replace('\\', '/');
        this.connection = this.getConnection("Admin");
        this.admin = this.connection.getAdminAPI();
        this.admin.getLogConfiguration().setLogLevel(6);
    }

    public Connection getQueryConnection(String vdbName) throws Exception {
        return this.getConnection(vdbName);
    }

    private Connection getConnection(String vdbName) throws Exception {
        String url = this.concatURL(vdbName, this.dqpPath);
        try {
            Class.forName("com.metamatrix.jdbc.EmbeddedDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Unable to load MetaMatrix JDBC driver - check class path for MetaMatrix jar files.");
            throw e;
        }
        System.out.println("connection url = " + url);
        Connection ret = (Connection)DriverManager.getConnection(url);
        return ret;
    }

    private String concatURL(String VDBName, String DQPAbsolutePath) throws Exception {
        if (VDBName == null || VDBName.length() == 0) {
            throw new Exception("VDB Name cannot be null");
        }
        if (DQPAbsolutePath == null || DQPAbsolutePath.length() == 0) {
            throw new Exception("DQP Path cannot be null");
        }
        StringBuffer url = new StringBuffer(100);
        url.append(URL_PREFIX);
        url.append(VDBName);
        url.append('@');
        url.append(DQPAbsolutePath);
        return url.toString();
    }

    public void disconnect() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
            this.connection = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

