/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.jdbc.Column;
import com.metamatrix.modeler.schema.tools.model.jdbc.DataType;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.ColumnImpl;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.SoapDataTypeImpl;
import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SOAPArrayDefinition;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SOAPElement;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class SoapArrayColumn
extends BaseColumn
implements Column {
    SchemaObject soapElement;

    public SoapArrayColumn(boolean pk, XSDSimpleTypeDefinition type, SchemaObject element) {
        super(pk, type);
        this.soapElement = element;
    }

    public String getXpath() {
        return this.getType().getName() + "/text()";
    }

    public String getSimpleName() {
        return this.getType().getName();
    }

    public Column copy() {
        return new SoapArrayColumn(this.pk, this.getType(), this.soapElement);
    }

    public void printDebug() {
    }

    protected DataType getDataType() {
        String arrayNamespace;
        String arrayName;
        if (this.soapElement instanceof SOAPArrayDefinition) {
            SOAPArrayDefinition arrayDef = (SOAPArrayDefinition)this.soapElement;
            arrayName = arrayDef.type.getName();
            arrayNamespace = arrayDef.type.getTargetNamespace();
        } else if (this.soapElement instanceof SOAPElement) {
            SOAPElement elem = (SOAPElement)this.soapElement;
            arrayName = elem.getName();
            arrayNamespace = elem.getNamespace();
        } else {
            throw new RuntimeException("Error: SoapArrayColumn.getDataType() soapElement not correct type");
        }
        return new SoapDataTypeImpl(this.type.getName(), this.type.getTargetNamespace(), arrayName, arrayNamespace);
    }

    public com.metamatrix.modeler.schema.tools.model.jdbc.Column getColumnImplementation() {
        ColumnImpl newColumn = new ColumnImpl();
        newColumn.setDataAttributeName(this.getSimpleName());
        newColumn.setDataType(this.getDataType());
        newColumn.setIsAttributeOfParent(false);
        newColumn.setIsInputParameter(false);
        newColumn.setName(this.getSimpleName());
        newColumn.setOutputXPath(this.getXpath());
        newColumn.setRole(Column.Role.DATA);
        newColumn.setMultipleValues(Column.MultipleValues.SIMPLE_SOAP_ARRAY_ELEMENT);
        return newColumn;
    }
}

