/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.jdbc.Table;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.TableImpl;
import com.metamatrix.modeler.schema.tools.model.schema.ComplexSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.RootElement;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObjectKey;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelCopyTraversalContext;
import com.metamatrix.modeler.schema.tools.processing.SchemaProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Namespace;

public class SchemaModelImpl
implements SchemaModel {
    private List elements;
    private List defaultNamespaces;
    private Map namespaces;
    private Map tableRelationships;
    private Set rootElements;
    private HashMap tableImplementations = new HashMap();
    private boolean typeAware = false;
    private static String separator;

    public SchemaModelImpl(List elements, List defaultNamespaces, Map namespaces, String sep) {
        this.elements = elements;
        this.defaultNamespaces = defaultNamespaces;
        this.namespaces = namespaces;
        separator = null == sep ? "_" : sep;
    }

    public List getPotentialRootElements() {
        ArrayList<RootElement> roots = new ArrayList<RootElement>();
        for (SchemaObject element : this.elements) {
            roots.add(element.getRootRepresentation());
        }
        return roots;
    }

    public void setTypeAsRoot(String typeName, String namespace) throws SchemaProcessingException {
        if (!this.typeAware) {
            throw new SchemaProcessingException("This SchemaModel is not type aware");
        }
        for (Object next : this.elements) {
            ComplexSchemaObject type;
            if (!(next instanceof ComplexSchemaObject) || !(type = (ComplexSchemaObject)next).getSimpleName().equals(typeName) || !type.getNamespace().equals(namespace)) continue;
            HashSet<RootElement> roots = new HashSet<RootElement>();
            roots.add(type.getRootRepresentation());
            try {
                this.setSelectedRootElements(roots);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return;
        }
        throw new SchemaProcessingException("Type " + typeName + " in namespace " + namespace + " was not found");
    }

    public SchemaModel copy() {
        SchemaModelCopyTraversalContext ctx = new SchemaModelCopyTraversalContext(this.elements, this.rootElements);
        List modelClone = ctx.getCopiedElements();
        Set rootsCopy = ctx.getCopiedRoots();
        SchemaModelImpl copy = new SchemaModelImpl(modelClone, this.defaultNamespaces, this.namespaces, separator);
        copy.typeAware = this.typeAware;
        try {
            copy.setSelectedRootElements(rootsCopy);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return copy;
    }

    public List getElements() {
        return this.elements;
    }

    public List getDefaultNamespaces() {
        return this.defaultNamespaces;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public void setSelectedRootElements(Set roots) {
        if (null == roots) {
            this.rootElements = null;
        } else {
            this.rootElements = new HashSet(roots.size());
            for (Object obj : roots) {
                SchemaObjectKey key;
                if (obj instanceof SchemaObjectKey) {
                    key = (SchemaObjectKey)obj;
                } else if (obj instanceof RootElement) {
                    RootElement root = (RootElement)obj;
                    key = root.getKey();
                } else {
                    throw new RuntimeException("Invalid type in root selection");
                }
                this.rootElements.add(key);
                for (SchemaObject element : this.elements) {
                    if (!element.getKey().equals(key)) continue;
                    element.cascadeRootSelection(true);
                }
            }
        }
    }

    public boolean isSelectedRootElement(SchemaObject element) {
        boolean result = null == this.rootElements ? true : this.rootElements.contains(element.getKey());
        return result;
    }

    public void setElements(List nonMergedTables) {
        this.elements = nonMergedTables;
    }

    public List getTables() {
        List tableNamespaces = this.getNamespacePrefixesValue();
        ArrayList<TableImpl> result = new ArrayList<TableImpl>();
        for (SchemaObject element : this.elements) {
            if (!element.isWithinSelectedHierarchy()) continue;
            TableImpl table = new TableImpl(element.getSimpleName(), element.getCatalog(), element.getInputXPath(), element.getOutputXPath());
            Iterator nsIter = tableNamespaces.iterator();
            while (nsIter.hasNext()) {
                table.addNamespace((Namespace)nsIter.next());
            }
            table.setElement(element);
            table.setSchemaModel(this);
            this.tableImplementations.put(element.getSimpleName(), table);
            result.add(table);
        }
        return result;
    }

    private List getNamespacePrefixesValue() {
        ArrayList<Namespace> result = new ArrayList<Namespace>(this.namespaces.size());
        for (String prefix : this.namespaces.keySet()) {
            String namespaceURI = (String)this.namespaces.get(prefix);
            result.add(Namespace.getNamespace((String)prefix, (String)namespaceURI));
        }
        return result;
    }

    public Map getNamespacePrefixes() {
        Map nsMap = this.getNamespaces();
        HashMap returnMap = new HashMap();
        for (String key : nsMap.keySet()) {
            returnMap.put(nsMap.get(key), key);
        }
        return returnMap;
    }

    public Table findTable(String simpleName) {
        return (Table)this.tableImplementations.get(simpleName);
    }

    public int getRelationToParent(String lookupKey) {
        Integer result = new Integer(-1);
        if (null != this.tableRelationships && this.tableRelationships.containsKey(lookupKey)) {
            result = (Integer)this.tableRelationships.get(lookupKey);
        }
        return result;
    }

    public void setTableRelationships(Map tableRelationships) {
        this.tableRelationships = tableRelationships;
    }

    public void setTypeAware(boolean typeAware) {
        this.typeAware = typeAware;
    }

    public boolean isTypeAware() {
        return this.typeAware;
    }

    public static String getSeparator() {
        return separator;
    }
}

