/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.http;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.SecureConnectorStateImpl;
import com.metamatrix.connector.xml.base.XMLConnectionImpl;
import com.metamatrix.connector.xml.http.HTTPExecutor;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class HTTPConnectorState
extends SecureConnectorStateImpl {
    private int m_accessMethod = -1;
    private int m_parameterMethod = -1;
    private String m_uri = null;
    private String m_proxyUri = null;
    private int m_requestTimeout = -1;
    private String m_xmlParameterName = null;
    private MultiThreadedHttpConnectionManager m_connMgr = null;
    private HttpConnectionManagerParams m_connMgrParams = null;
    private HttpClient m_client = null;
    private boolean m_useHttpBasicAuth;
    private String m_httpBasicAuthUser;
    private String m_httpBasicAuthPwd;
    private String hostnameVerifierClassName;
    private static final int METHOD_UNSET = -1;
    private static final int METHOD_GET = 0;
    public static final String GET = "GET";
    private static final int METHOD_POST = 1;
    public static final String POST = "POST";
    private static final int PARAMETER_METHOD_NONE = 0;
    public static final String PARAMETER_NONE = "None";
    private static final int PARAMETER_METHOD_NAME_VALUE = 1;
    public static final String PARAMETER_NAME_VALUE = "Name/Value";
    private static final int PARAMETER_METHOD_XML_REQUEST = 2;
    public static final String PARAMETER_XML_REQUEST = "XMLRequest";
    private static final int PARAMETER_METHOD_XML_QUERY_STRING = 3;
    public static final String PARAMETER_XML_QUERY_STRING = "XMLInQueryString";
    public static final String ACCESS_METHOD = "AccessMethod";
    public static final String PARAMETER_METHOD = "ParameterMethod";
    public static final String URI = "Uri";
    public static final String PROXY_URI = "ProxyUri";
    public static final String REQUEST_TIMEOUT = "RequestTimeout";
    public static final String XML_PARAMETER_NAME = "XMLParmName";
    public static final String USE_HTTP_BASIC_AUTH = "UseHttpBasic";
    public static final String HTTP_BASIC_USER = "HttpBasicAuthUserName";
    public static final String HTTP_BASIC_PASSWORD = "HttpBasicAuthPassword";
    private static final String HOSTNAME_VERIFIER = "HostnameVerifier";

    public HTTPConnectorState() {
        this.setUseHttpBasicAuth(false);
        this.setHttpBasicAuthUser(new String());
        this.setHttpBasicAuthPwd(new String());
    }

    public void setState(Properties props) throws ConnectorException {
        super.setState(props);
        this.setAccessMethod(props.getProperty(ACCESS_METHOD));
        this.setParameterMethod(props.getProperty(PARAMETER_METHOD));
        this.setUri(props.getProperty(URI));
        this.setProxyUri(props.getProperty(PROXY_URI));
        this.setRequestTimeout(Integer.parseInt(props.getProperty(REQUEST_TIMEOUT)));
        this.setXmlParameterName(props.getProperty(XML_PARAMETER_NAME));
        String basicAuth = props.getProperty(USE_HTTP_BASIC_AUTH);
        boolean useAuth = Boolean.valueOf(basicAuth);
        this.setUseHttpBasicAuth(useAuth);
        this.setHttpBasicAuthUser(props.getProperty(HTTP_BASIC_USER));
        this.setHttpBasicAuthPwd(props.getProperty(HTTP_BASIC_PASSWORD));
        this.setHostnameVerifierClassName(props.getProperty(HOSTNAME_VERIFIER));
        if (this.getHostnameVerifierClassName() != null) {
            try {
                HostnameVerifier verifier = (HostnameVerifier)Class.forName(this.getHostnameVerifierClassName()).newInstance();
                HttpsURLConnection.setDefaultHostnameVerifier(verifier);
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e, "Unable to load HostnameVerifier");
            }
        }
        this.initHttpClient();
    }

    public Properties getState() {
        Properties props = super.getState();
        props.setProperty(ACCESS_METHOD, this.decodeAccessMethod(this.m_accessMethod));
        props.setProperty(PARAMETER_METHOD, this.decodeParameterMethod(this.m_parameterMethod));
        props.setProperty(URI, this.getUri());
        props.setProperty(PROXY_URI, this.getProxyUri());
        props.setProperty(REQUEST_TIMEOUT, Integer.toString(this.getRequestTimeout()));
        props.setProperty(XML_PARAMETER_NAME, this.getXmlParameterName());
        props.setProperty(USE_HTTP_BASIC_AUTH, Boolean.toString(this.useHttpBasicAuth()));
        props.setProperty(HTTP_BASIC_USER, this.getHttpBasicAuthUser());
        props.setProperty(HTTP_BASIC_PASSWORD, this.getHttpBasicAuthPwd());
        props.setProperty("TrustDeserializerClass", this.getSecurityDeserializerClass());
        return props;
    }

    public void setAccessMethod(String accessMethod) {
        this.m_accessMethod = this.encodeAccessMethod(accessMethod);
    }

    public String getAccessMethod() {
        return this.decodeAccessMethod(this.m_accessMethod);
    }

    public void setParameterMethod(String parameterMethod) {
        this.m_parameterMethod = this.encodeParameterMethod(parameterMethod);
    }

    public String getParameterMethod() {
        return this.decodeParameterMethod(this.m_parameterMethod);
    }

    public void setUri(String uri) {
        this.m_uri = uri;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setProxyUri(String proxyUri) {
        this.m_proxyUri = proxyUri;
    }

    public String getProxyUri() {
        return this.m_proxyUri;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.m_requestTimeout = requestTimeout;
    }

    public int getRequestTimeout() {
        return this.m_requestTimeout;
    }

    public void setXmlParameterName(String xmlParameterName) {
        this.m_xmlParameterName = xmlParameterName;
    }

    public String getXmlParameterName() {
        return this.m_xmlParameterName;
    }

    public DocumentProducer makeExecutor(XMLExecution execution) throws ConnectorException {
        return new HTTPExecutor(this, execution);
    }

    private int encodeAccessMethod(String method) {
        int retVal = -1;
        if (method.equalsIgnoreCase(GET)) {
            retVal = 0;
        } else if (method.equalsIgnoreCase(POST)) {
            retVal = 1;
        }
        return retVal;
    }

    private String decodeAccessMethod(int method) {
        String retVal = "";
        switch (method) {
            case 0: {
                retVal = GET;
                break;
            }
            case 1: {
                retVal = POST;
                break;
            }
        }
        return retVal;
    }

    private int encodeParameterMethod(String method) {
        int retVal = -1;
        if (method.equalsIgnoreCase(PARAMETER_NONE)) {
            retVal = 0;
        } else if (method.equalsIgnoreCase(PARAMETER_NAME_VALUE)) {
            retVal = 1;
        } else if (method.equalsIgnoreCase(PARAMETER_XML_REQUEST)) {
            retVal = 2;
        } else if (method.equalsIgnoreCase(PARAMETER_XML_QUERY_STRING)) {
            retVal = 3;
        }
        return retVal;
    }

    private String decodeParameterMethod(int method) {
        String retVal = "";
        switch (method) {
            case 0: {
                retVal = PARAMETER_NONE;
                break;
            }
            case 1: {
                retVal = PARAMETER_NAME_VALUE;
                break;
            }
            case 2: {
                retVal = PARAMETER_XML_REQUEST;
                break;
            }
            case 3: {
                retVal = PARAMETER_XML_QUERY_STRING;
                break;
            }
        }
        return retVal;
    }

    public HttpClient getClient() throws ConnectorException {
        return this.m_client;
    }

    private void initHttpClient() throws ConnectorException {
        this.m_connMgr = new MultiThreadedHttpConnectionManager();
        this.m_connMgrParams = new HttpConnectionManagerParams();
        int threads = 10;
        this.m_connMgrParams.setDefaultMaxConnectionsPerHost(10);
        this.m_connMgrParams.setMaxTotalConnections(10);
        this.m_connMgrParams.setConnectionTimeout(0);
        this.m_connMgrParams.setSoTimeout(this.getRequestTimeout());
        this.m_connMgr.setParams(this.m_connMgrParams);
        this.m_client = new HttpClient((HttpConnectionManager)this.m_connMgr);
        HostConfiguration hc = null;
        try {
            URI uri = new URI(this.getUri(), false);
            hc = this.m_client.getHostConfiguration();
            hc.setHost(uri);
            String proxyUriStr = this.getProxyUri();
            if (proxyUriStr != null && proxyUriStr != "") {
                URI proxyUri = new URI(proxyUriStr, false);
                int pp = proxyUri.getPort();
                int substrEnd = this.getProxyUri().lastIndexOf(":");
                String hostPart = null;
                hostPart = substrEnd == -1 ? this.getProxyUri() : this.getProxyUri().substring(0, substrEnd);
                if (pp >= 0) {
                    hc.setProxy(hostPart, pp);
                } else {
                    int defaultProxyPort = 80;
                    hc.setProxy(hostPart, 80);
                }
            }
        }
        catch (URIException uex) {
            ConnectorException ce = new ConnectorException(Messages.getString("HTTPConnectorState.connection.not.initialized") + this.getUri());
            ce.initCause((Throwable)uex);
            throw ce;
        }
        this.m_client.setHostConfiguration(hc);
        if (this.useHttpBasicAuth()) {
            AuthScope authScope = new AuthScope(null, -1);
            UsernamePasswordCredentials defCred = new UsernamePasswordCredentials(this.getHttpBasicAuthUser(), this.getHttpBasicAuthPwd());
            this.m_client.getState().setCredentials(authScope, (Credentials)defCred);
            this.m_client.getParams().setAuthenticationPreemptive(true);
        }
    }

    public void setUseHttpBasicAuth(boolean m_useHttpBasicAuth) {
        this.m_useHttpBasicAuth = m_useHttpBasicAuth;
    }

    public boolean useHttpBasicAuth() {
        return this.m_useHttpBasicAuth;
    }

    public void setHttpBasicAuthUser(String m_httpBasicAuthUser) {
        this.m_httpBasicAuthUser = m_httpBasicAuthUser;
    }

    public String getHttpBasicAuthUser() {
        return this.m_httpBasicAuthUser;
    }

    public void setHttpBasicAuthPwd(String m_httpBasicAuthPwd) {
        this.m_httpBasicAuthPwd = m_httpBasicAuthPwd;
    }

    public String getHttpBasicAuthPwd() {
        return this.m_httpBasicAuthPwd;
    }

    public Connection getConnection(CachingConnector connector, SecurityContext context, ConnectorEnvironment environment) throws ConnectorException {
        return new XMLConnectionImpl(connector, context, environment);
    }

    private void setHostnameVerifierClassName(String property) {
        this.hostnameVerifierClassName = property;
    }

    private String getHostnameVerifierClassName() {
        return this.hostnameVerifierClassName;
    }
}

