/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.jdbc.internal;

import com.metamatrix.modeler.schema.tools.model.jdbc.Column;
import com.metamatrix.modeler.schema.tools.model.jdbc.Table;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.DatabaseElementImpl;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelImpl;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Namespace;

public class TableImpl
extends DatabaseElementImpl
implements Table {
    private String m_catalog;
    private String m_schema;
    private ArrayList m_namespaces;
    private ArrayList m_columns;
    private SchemaObject element;
    private SchemaModel schemaModel;
    private boolean isBase;
    private final String[] wellKnownNamespaces = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.metamatrix.com/dummy", "http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/1999/XMLSchema-instance", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2001/XMLSchema", "http://soap-authentication.org/2001/10/", "http://schemas.xmlsoap.org/wsdl/", "http://schemas.xmlsoap.org/wsdl/soap/"};

    public TableImpl() {
        this.m_catalog = null;
        this.m_namespaces = new ArrayList();
        this.m_columns = new ArrayList();
    }

    public TableImpl(String name, String catalog, String inputXPath, String outputXPath) {
        super(name, inputXPath, outputXPath);
        this.setCatalog(catalog);
        this.m_namespaces = new ArrayList();
        this.m_columns = new ArrayList();
    }

    public void setElement(SchemaObject element) {
        this.element = element;
    }

    public void setSchemaModel(SchemaModel schemaModel) {
        this.schemaModel = schemaModel;
    }

    public String getNamespaceDeclaration() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.m_namespaces.size(); ++i) {
            Namespace ns = (Namespace)this.m_namespaces.get(i);
            if (this.testForWellKnownNS(ns)) continue;
            String pre = ns.getPrefix() == null || ns.getPrefix().trim().equals("") ? "xmlns" : "xmlns:" + ns.getPrefix();
            buff.append(pre);
            buff.append("='");
            buff.append(ns.getURI());
            buff.append("' ");
        }
        return buff.toString().trim();
    }

    private boolean testForWellKnownNS(Namespace ns) {
        boolean isWellKnown = false;
        String nsUri = ns.getURI();
        for (int i = 0; i < this.wellKnownNamespaces.length; ++i) {
            if (!this.wellKnownNamespaces[i].equals(nsUri)) continue;
            isWellKnown = true;
            break;
        }
        return isWellKnown;
    }

    public void addNamespace(Namespace ns) {
        this.m_namespaces.add(ns);
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void addColumn(Column column) {
        this.m_columns.add(column);
    }

    public Column[] getColumns() {
        List columns = null;
        columns = this.element != null && !this.isBase() ? this.element.getAllModelColumns() : new ArrayList();
        columns.addAll(this.m_columns);
        Column[] column = new Column[columns.size()];
        columns.toArray(column);
        return column;
    }

    public Table[] getChildTables() {
        ArrayList<Table> children = new ArrayList<Table>();
        if (null != this.element) {
            for (Relationship relationship : this.element.getChildren()) {
                SchemaObject child = relationship.getChild();
                Table table = this.schemaModel.findTable(child.getSimpleName());
                children.add(table);
            }
        }
        Table[] tables = new Table[children.size()];
        children.toArray(tables);
        return tables;
    }

    public Table[] getParentTables() {
        ArrayList<Table> parents = new ArrayList<Table>();
        for (Relationship relationship : this.element.getParents()) {
            SchemaObject parent = relationship.getParent();
            Table table = this.schemaModel.findTable(parent.getSimpleName());
            if (null == table) continue;
            parents.add(table);
        }
        Table[] tables = new Table[parents.size()];
        parents.toArray(tables);
        return tables;
    }

    public int getRelationToParent() {
        String key = this.element.getSimpleName() + ':' + this.element.getNamespace();
        return ((SchemaModelImpl)this.schemaModel).getRelationToParent(key);
    }

    public Relationship getRelationObjectToParent(Table parent) {
        Relationship result = null;
        SchemaObject parentElement = ((TableImpl)parent).getElement();
        List parents = this.element.getParents();
        for (Relationship parentRelation : parents) {
            if (!parentRelation.getParent().getSimpleName().equals(parentElement.getSimpleName())) continue;
            result = parentRelation;
            break;
        }
        return result;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public SchemaObject getElement() {
        return this.element;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public void setBase(boolean isBase) {
        this.isBase = isBase;
    }

    public int getMaxOccurs() {
        return this.element.getMaxOccurs();
    }

    public String toString() {
        return this.getName();
    }
}

