/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards.jdbc;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.core.extension.XAttribute;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.metamodels.core.extension.XEnumLiteral;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ColumnSet;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.ObjectExtension;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcTable;
import com.metamatrix.modeler.jdbc.relational.impl.Context;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import com.metamatrix.modeler.modelgenerator.xml.model.DatabaseMetaDataImpl;
import com.metamatrix.modeler.modelgenerator.xml.wizards.StateManager;
import com.metamatrix.modeler.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import com.metamatrix.modeler.schema.tools.model.schema.QName;
import com.metamatrix.modeler.schema.tools.processing.SchemaUtil;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class XmlSchemaAsRelationalModelProcessor
extends RelationalModelProcessorImpl {
    private boolean acs_mode = false;

    public XmlSchemaAsRelationalModelProcessor() {
    }

    public XmlSchemaAsRelationalModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public XmlSchemaAsRelationalModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    public void setACSMode(boolean mode) {
        this.acs_mode = mode;
    }

    protected void setNameAndNameInSource(RelationalEntity entity, String name, JdbcNode node, Context context) {
        super.setNameAndNameInSource(entity, name, node, context);
        this.processNewEntity(entity, name, node, context);
    }

    protected void processNewEntity(RelationalEntity entity, String name, JdbcNode node, Context context) {
        if (entity instanceof Catalog) {
            Catalog catalog = (Catalog)entity;
            this.processNewCatalog(name, node, context, catalog);
        } else if (entity instanceof Table) {
            Table table = (Table)entity;
            this.processNewTable(name, node, context, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNewTable(String name, JdbcNode node, Context context, Table table) {
        JdbcTable tableNode = (JdbcTable)node;
        ModelAnnotation modelAnnotation = context.getModelContents().getModelAnnotation();
        ModelType oldtype = modelAnnotation.getModelType();
        Catalog oldCatalog = table.getCatalog();
        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
        context.getResource().getContents().add((Object)table);
        try {
            this.setTableNamespacePrefixes(table, tableNode, name, context);
            this.addResponseField(table, tableNode, name, context);
            this.processRequestAttributes(table, tableNode, name, context);
        }
        finally {
            context.getResource().getContents().remove((Object)table);
            if (oldCatalog != null) {
                table.setCatalog(oldCatalog);
            }
            modelAnnotation.setModelType(oldtype);
        }
    }

    protected void processNewCatalog(String name, JdbcNode node, Context context, Catalog catalog) {
        this.setCatalogNamespacePrefixes(catalog, node, name, context);
    }

    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced) {
        String retval = object instanceof Table ? this.getTableNameInSource(object, name, node, context) : (object instanceof Column ? this.getColumnNameInSource(object, name, node, context) : (object instanceof PrimaryKey ? this.getPrimaryKeyNameInSource(object, name, node, context) : (object instanceof ForeignKey ? this.getForeignKeyNameInSource(object, name, node, context) : super.computeNameInSource(object, name, node, context, forced))));
        return retval;
    }

    protected String getTableNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getTableNameInSource(name, qname.getNamespace());
        return nameInSource;
    }

    protected String getColumnNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getColumnNameInSource(name, qname.getNamespace(), qname.getLName());
        return nameInSource;
    }

    protected String getPrimaryKeyNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getPrimaryKeyNameInSource(name, qname.getNamespace());
        return nameInSource;
    }

    protected String getForeignKeyNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getForeignKeyNameInSource(name, qname.getNamespace());
        return nameInSource;
    }

    private QName getTableQName(JdbcNode node) {
        JdbcNode catalogNode;
        JdbcTable jdbcTable = (JdbcTable)node;
        String tableName = jdbcTable.getName();
        String tableNamespace = null;
        for (catalogNode = node; catalogNode != null && !(catalogNode instanceof JdbcCatalog); catalogNode = catalogNode.getParent()) {
        }
        if (catalogNode instanceof JdbcCatalog) {
            JdbcCatalog jdbcCatalog = (JdbcCatalog)catalogNode;
            tableNamespace = jdbcCatalog.getName();
        }
        QName qname = SchemaUtil.getQName(tableNamespace, (String)tableName);
        return qname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCatalogNamespacePrefixes(Catalog entity, JdbcNode node, String name, Context context) {
        ModelAnnotation modelAnnotation = context.getModelContents().getModelAnnotation();
        ModelType oldtype = modelAnnotation.getModelType();
        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
        context.getResource().getContents().add((Object)entity);
        try {
            this.setNamespacePrefixesAttribute((RelationalEntity)entity, name, context, this.getCatalogNamespacePrefixesAttribute(), this.getCatalogClass());
        }
        finally {
            context.getResource().getContents().remove((Object)entity);
            modelAnnotation.setModelType(oldtype);
        }
    }

    private void addResponseField(Table entity, JdbcTable node, String name, Context context) {
        QName qname = this.getTableQName((JdbcNode)node);
        DatabaseMetaDataImpl metaDataImpl = this.getMetaDataImpl(context);
        Boolean requestTriState = metaDataImpl.isRequestOrResponseTable(qname);
        if (requestTriState == null) {
            return;
        }
        boolean request = requestTriState;
        ArrayList problems = new ArrayList();
        Column column = this.getFactory().createColumn();
        column.setOwner((ColumnSet)entity);
        String colName = request ? "ResponseOut" : "ResponseIn";
        int arbitrarySize = 1000;
        this.setColumnInfo(column, node, context, problems, colName, 12, String.class.getName(), arbitrarySize, 0, 0, 1, "", 0);
        column.setSelectable(request);
        this.setColumnRoleAttribute((RelationalEntity)column, request ? XsdAsRelationalImportWizard.getResponseOutRoleEnumValue() : XsdAsRelationalImportWizard.getResponseInRoleEnumValue());
        this.setColumnInputParamAttribute((RelationalEntity)column, request ? Boolean.FALSE : Boolean.TRUE);
        if (!request) {
            AccessPattern accessPattern = this.getFactory().createAccessPattern();
            accessPattern.setName(colName);
            accessPattern.setTable(entity);
            accessPattern.getColumns().add((Object)column);
        }
    }

    private void processRequestAttributes(Table entity, JdbcTable node, String name, Context context) {
        QName qname = this.getTableQName((JdbcNode)node);
        DatabaseMetaDataImpl metaDataImpl = this.getMetaDataImpl(context);
        Boolean requestTriState = metaDataImpl.isRequestOrResponseTable(qname);
        if (requestTriState == null) {
            return;
        }
        boolean request = requestTriState;
        if (request) {
            this.setXpathRootForInputAttribute((RelationalEntity)entity, this.getXPathRootForInputAttribute(), this.getTableClass());
        }
    }

    private void setXpathRootForInputAttribute(RelationalEntity entity, XAttribute xattribute, XClass xclass) {
        if (xattribute == null) {
            return;
        }
        if (xclass == null) {
            return;
        }
        String xrfi_attribute_value = null;
        xrfi_attribute_value = this.acs_mode ? "/REQUEST" : "/";
        ObjectExtension objectExtension = new ObjectExtension((EObject)entity, xclass, ModelerCore.getModelEditor());
        objectExtension.eDynamicSet((EStructuralFeature)xattribute, (Object)xrfi_attribute_value);
    }

    private void setTableNamespacePrefixes(Table entity, JdbcTable node, String name, Context context) {
        QName qname = this.getTableQName((JdbcNode)node);
        if (qname.getNamespace() != null && qname.getNamespace().equals(StateManager.globalNamespace)) {
            qname.setNamespace(null);
        }
        this.setNamespacePrefixesAttribute((RelationalEntity)entity, qname.getNamespace(), context, this.getTableNamespacePrefixesAttribute(), this.getTableClass());
    }

    private void setColumnRoleAttribute(RelationalEntity entity, XEnumLiteral role) {
        XAttribute xattribute = this.getColumnRoleAttribute();
        XClass xclass = this.getColumnClass();
        if (xattribute == null) {
            return;
        }
        if (xclass == null) {
            return;
        }
        ObjectExtension objectExtension = new ObjectExtension((EObject)entity, xclass, ModelerCore.getModelEditor());
        objectExtension.eDynamicSet((EStructuralFeature)xattribute, (Object)role);
    }

    private void setColumnInputParamAttribute(RelationalEntity entity, Boolean isParam) {
        XAttribute xattribute = this.getColumnInputParamAttribute();
        XClass xclass = this.getColumnClass();
        if (xattribute == null) {
            return;
        }
        if (xclass == null) {
            return;
        }
        ObjectExtension objectExtension = new ObjectExtension((EObject)entity, xclass, ModelerCore.getModelEditor());
        objectExtension.eDynamicSet((EStructuralFeature)xattribute, (Object)isParam);
    }

    private static String quoteString(String str) {
        if (str.indexOf(39) == -1) {
            return '\'' + str + '\'';
        }
        if (str.indexOf(34) == -1) {
            return '\"' + str + '\"';
        }
        StringBuffer retval = new StringBuffer();
        retval.append('\'');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                retval.append("&apos;");
                continue;
            }
            retval.append(c);
        }
        retval.append('\'');
        return retval.toString();
    }

    private void setNamespacePrefixesAttribute(RelationalEntity entity, String name, Context context, XAttribute xattribute, XClass xclass) {
        DatabaseMetaDataImpl metaDataImpl = this.getMetaDataImpl(context);
        if (metaDataImpl != null) {
            Map prefixes = metaDataImpl.getNamespacePrefixes(name);
            StringBuffer namespacePrefixes = new StringBuffer();
            for (Object oNamespace : prefixes.keySet()) {
                if (oNamespace == null) continue;
                String namespace = (String)oNamespace;
                Object oPrefix = prefixes.get(oNamespace);
                String prefix = (String)oPrefix;
                if (namespacePrefixes.length() != 0) {
                    namespacePrefixes.append(' ');
                }
                namespacePrefixes.append("xmlns");
                if (prefix != null && !prefix.equals("")) {
                    namespacePrefixes.append(':');
                }
                if (prefix != null) {
                    namespacePrefixes.append(prefix);
                }
                namespacePrefixes.append('=');
                String quotedNamespace = XmlSchemaAsRelationalModelProcessor.quoteString(namespace);
                namespacePrefixes.append(quotedNamespace);
            }
            if (xattribute == null) {
                return;
            }
            if (xclass == null) {
                return;
            }
            ObjectExtension objectExtension = new ObjectExtension((EObject)entity, xclass, ModelerCore.getModelEditor());
            objectExtension.eDynamicSet((EStructuralFeature)xattribute, (Object)namespacePrefixes.toString());
        }
    }

    private DatabaseMetaDataImpl getMetaDataImpl(Context context) {
        DatabaseMetaData metaData;
        JdbcDatabase db = context.getJdbcDatabase();
        try {
            metaData = db.getDatabaseMetaData();
        }
        catch (JdbcException e) {
            context.getWarnings().add(e);
            metaData = null;
        }
        DatabaseMetaDataImpl metaDataImpl = metaData instanceof DatabaseMetaDataImpl ? (DatabaseMetaDataImpl)metaData : null;
        return metaDataImpl;
    }

    protected XAttribute getColumnRoleAttribute() {
        return XsdAsRelationalImportWizard.getColumnRoleAttribute();
    }

    protected XAttribute getColumnInputParamAttribute() {
        return XsdAsRelationalImportWizard.getColumnInputParamAttribute();
    }

    protected XClass getColumnClass() {
        return XsdAsRelationalImportWizard.getColumnClass();
    }

    protected XAttribute getCatalogNamespacePrefixesAttribute() {
        return XsdAsRelationalImportWizard.getCatalogNamespacePrefixesAttribute();
    }

    protected XClass getCatalogClass() {
        return XsdAsRelationalImportWizard.getCatalogClass();
    }

    protected XAttribute getTableNamespacePrefixesAttribute() {
        return XsdAsRelationalImportWizard.getTableNamespacePrefixesAttribute();
    }

    protected XAttribute getXPathRootForInputAttribute() {
        return XsdAsRelationalImportWizard.getXPathRootForInputAttribute();
    }

    protected XClass getTableClass() {
        return XsdAsRelationalImportWizard.getTableClass();
    }
}

