/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.modeler.modelgenerator.xml.IUiConstants;
import com.metamatrix.modeler.modelgenerator.xml.Util;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.modeler.modelgenerator.xml.wizards.StateManager;
import com.metamatrix.modeler.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import com.metamatrix.modeler.schema.tools.processing.internal.SchemaProcessorImpl;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.util.SystemClipboardUtilities;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.viewsupport.StatusInfo;
import com.metamatrix.ui.internal.viewsupport.UiBusyIndicator;
import com.metamatrix.ui.internal.widget.ListMessageDialog;
import com.metamatrix.ui.internal.wizard.AbstractWizardPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.xsd.XSDSchema;

public abstract class XsdSelectionPage
extends AbstractWizardPage {
    String prefix;
    private PluginUtil util;
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    protected XsdAsRelationalImportWizard importWizard;
    private StateManager manager;
    private IAction copyAction;
    private IBaseLabelProvider labelProvider;
    private Object[] startupXsds;
    private IAction removeXsdAction;
    private ViewerFilter xsdFilter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParentElement, Object theElement) {
            boolean result = false;
            if (theElement instanceof IContainer) {
                IProject project = ((IContainer)theElement).getProject();
                if (project.isOpen()) {
                    try {
                        if (project.getNature("com.metamatrix.modeler.core.modelNature") != null) {
                            result = true;
                        }
                    }
                    catch (CoreException theException) {
                        XsdSelectionPage.this.util.log((Throwable)theException);
                    }
                }
            } else if (theElement instanceof IFile) {
                result = Util.isXsdFile((IFile)theElement);
            } else if (theElement instanceof File) {
                return ((File)theElement).isDirectory() || Util.isXsdFile((File)theElement);
            }
            return result;
        }
    };
    private ISelectionStatusValidator xsdValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] theSelection) {
            StatusInfo result = null;
            boolean valid = true;
            if (theSelection != null && theSelection.length > 0) {
                for (int i = 0; i < theSelection.length; ++i) {
                    if (theSelection[i] instanceof IFile && Util.isXsdFile((IFile)theSelection[i])) continue;
                    valid = false;
                    break;
                }
            } else {
                valid = false;
            }
            result = valid ? new StatusInfo(IUiConstants.PLUGIN_ID) : new StatusInfo(IUiConstants.PLUGIN_ID, 4, XsdSelectionPage.this.getString("msg.selectionIsNotXsd"));
            return result;
        }
    };
    private Button btnFileSystemAdd;
    private Button btnWorkspaceAdd;
    private TableViewer viewer;

    public XsdSelectionPage(XsdAsRelationalImportWizard importWizard, String prefix, PluginUtil util) {
        super(ClassUtil.getSimpleClassName(XsdSelectionPage.class), util.getString(prefix + "title"));
        this.importWizard = importWizard;
        this.manager = importWizard.getStateManager();
        this.prefix = prefix;
        this.util = util;
        this.setImageDescriptor(XmlImporterUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/WebService.gif"));
    }

    public void addXsdFiles(final Object[] theFiles, final boolean theWorkspaceResourceFlag) {
        UiBusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ArrayList<Object> problems = null;
                ArrayList<Object> newXsds = new ArrayList<Object>(theFiles.length);
                for (int i = 0; i < theFiles.length; ++i) {
                    boolean okToAdd = true;
                    String newPath = null;
                    newPath = theWorkspaceResourceFlag ? ((IFile)theFiles[i]).getLocation().toOSString() : ((File)theFiles[i]).getAbsolutePath();
                    for (Object xsd : XsdSelectionPage.this.manager.getSchemaKeySet()) {
                        String path = null;
                        if (xsd instanceof IFile) {
                            path = ((IFile)xsd).getLocation().toOSString();
                        } else if (xsd instanceof File) {
                            path = ((File)xsd).getAbsolutePath();
                        } else {
                            Assertion.failed((String)("Unexpected XSD object type of " + xsd.getClass()));
                        }
                        if (!path.equals(newPath)) continue;
                        okToAdd = false;
                        if (problems == null) {
                            problems = new ArrayList();
                        }
                        problems.add(theFiles[i]);
                        break;
                    }
                    if (!okToAdd) continue;
                    try {
                        if (theWorkspaceResourceFlag) {
                            XsdSelectionPage.this.addResource((IFile)theFiles[i]);
                        } else {
                            XsdSelectionPage.this.addResource((File)theFiles[i]);
                        }
                        newXsds.add(theFiles[i]);
                        continue;
                    }
                    catch (CoreException theException) {
                        XsdSelectionPage.this.util.log((Throwable)theException);
                        if (problems == null) {
                            problems = new ArrayList<Object>();
                        }
                        problems.add(theFiles[i]);
                    }
                }
                if (!newXsds.isEmpty()) {
                    XsdSelectionPage.this.getViewer().refresh();
                    XsdSelectionPage.this.getViewer().setSelection((ISelection)new StructuredSelection(newXsds), true);
                    XsdSelectionPage.this.setPageStatus();
                }
                if (problems != null) {
                    ListMessageDialog.openInformation((Shell)XsdSelectionPage.this.getShell(), (String)XsdSelectionPage.this.getString("dialog.problems.title"), null, (String)XsdSelectionPage.this.getString("dialog.problems.msg"), problems, (IBaseLabelProvider)XsdSelectionPage.this.getLabelProvider());
                }
            }
        });
    }

    public void createControl(Composite theParent) {
        int COLUMNS = 2;
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, IUiConstants.HelpContexts.XSD_SELECTION_PAGE);
        this.createTablePanel(pnlMain);
        this.createButtonPanel(pnlMain);
    }

    public boolean canFlipToNextPage() {
        return this.viewer.getTable().getItemCount() > 0 && super.canFlipToNextPage();
    }

    private void createButtonPanel(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4);
        this.btnWorkspaceAdd = WidgetFactory.createButton((Composite)pnl, (String)this.getString("button.addXsdFile.workspace"), (int)768);
        this.btnWorkspaceAdd.setToolTipText(this.getString("button.addXsdFile.workspace.tip"));
        this.btnWorkspaceAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                XsdSelectionPage.this.handleAddWorkspaceXsdFile();
            }
        });
        this.btnFileSystemAdd = WidgetFactory.createButton((Composite)pnl, (String)this.getString("button.addXsdFile.filesystem"), (int)768);
        this.btnFileSystemAdd.setToolTipText(this.getString("button.addXsdFile.filesystem.tip"));
        this.btnFileSystemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                XsdSelectionPage.this.handleAddFileSystemXsdFile();
            }
        });
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.copyAction = new Action(this.getString("action.copy"), 1){

            public void run() {
                XsdSelectionPage.this.handleCopyXsdInfo();
            }
        };
        this.copyAction.setImageDescriptor(Util.getSharedImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(Util.getSharedImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setHoverImageDescriptor(Util.getSharedImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setToolTipText(this.getString("action.copy.tip"));
        this.copyAction.setEnabled(false);
        theToolBarMgr.add(this.copyAction);
        this.removeXsdAction = new Action(this.getString("action.removeXsdFile"), 1){

            public void run() {
                XsdSelectionPage.this.handleRemoveXsdFile();
            }
        };
        this.removeXsdAction.setImageDescriptor(Util.getSharedImageDescriptor("IMG_TOOL_DELETE"));
        this.removeXsdAction.setToolTipText(this.getString("action.removeXsdFile.tip"));
        this.removeXsdAction.setEnabled(false);
        theToolBarMgr.add(this.removeXsdAction);
        theToolBarMgr.update(true);
    }

    private void createTableContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.copyAction);
        mgr.add(this.removeXsdAction);
        Control table = this.viewer.getControl();
        table.setMenu(mgr.createContextMenu(table));
    }

    private void createTablePanel(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        CLabel label = new CLabel((Composite)viewForm, 0);
        label.setText(this.getString("label.table"));
        GridData gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        viewForm.setTopLeft((Control)label);
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm, (int)0, (int)1808);
        viewForm.setContent((Control)pnl);
        this.viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)770);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new LabelProvider(){

            public String getText(Object theElement) {
                return XsdSelectionPage.getText(theElement);
            }
        };
        this.viewer.setLabelProvider(this.labelProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                XsdSelectionPage.this.handleTableSelectionChanged();
            }
        });
        this.viewer.addFilter(this.xsdFilter);
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)viewForm));
        this.createTableContextMenu();
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("XmlAsRelationalImporter");
            settings = temp == null ? settings.addNewSection("XmlAsRelationalImporter") : temp;
        }
        return settings;
    }

    private IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private TableViewer getViewer() {
        return this.viewer;
    }

    private String getString(String theKey) {
        return this.util.getString(this.prefix + theKey);
    }

    private String getString(String theKey, Object[] params) {
        return this.util.getString(this.prefix + theKey, params);
    }

    private void handleAddFileSystemXsdFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(this.getString("dialog.addXsd.title"));
        dialog.setFilterExtensions(Util.FILE_DIALOG_XSD_EXTENSIONS);
        if (dialog.open() != null) {
            boolean validFiles = true;
            String[] filenames = dialog.getFileNames();
            if (filenames != null && filenames.length > 0) {
                String directory = dialog.getFilterPath();
                Object[] xsdFiles = new Object[filenames.length];
                for (int i = 0; i < filenames.length; ++i) {
                    String path = new StringBuffer().append(directory).append(File.separatorChar).append(filenames[i]).toString();
                    xsdFiles[i] = new File(path);
                    if (Util.isXsdFile((File)xsdFiles[i])) continue;
                    validFiles = false;
                    break;
                }
                if (validFiles) {
                    this.addXsdFiles(xsdFiles, false);
                } else if (MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getString("dialog.wrongFileType.title"), (String)this.getString("dialog.wrongFileType.msg"))) {
                    this.handleAddFileSystemXsdFile();
                }
            }
        }
    }

    private void handleAddWorkspaceXsdFile() {
        Object[] xsdFiles = WidgetUtil.showWorkspaceObjectSelectionDialog((String)this.getString("dialog.addXsd.title"), (String)this.getString("dialog.addXsd.msg"), (boolean)true, null, (ViewerFilter)this.xsdFilter, (ISelectionStatusValidator)this.xsdValidator);
        if (xsdFiles != null && xsdFiles.length > 0) {
            this.addXsdFiles(xsdFiles, true);
        }
    }

    private void handleCopyXsdInfo() {
        XsdSelectionPage.copyToClipboard(this.viewer.getSelection());
    }

    private void handleRemoveXsdFile() {
        Object[] selectedXsdFiles = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        for (int i = 0; i < selectedXsdFiles.length; ++i) {
            Object resource = selectedXsdFiles[i];
            if (resource instanceof File) {
                this.removeResource((File)resource);
                continue;
            }
            this.removeResource((IFile)resource);
        }
        this.viewer.remove(selectedXsdFiles);
        this.handleTableSelectionChanged();
        this.setPageStatus();
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.copyAction.setEnabled(!selection.isEmpty());
        this.removeXsdAction.setEnabled(this.copyAction.isEnabled());
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void setPageStatus() {
        String msg = null;
        int xsdCount = this.manager.getSchemaCount();
        msg = xsdCount > 0 ? this.util.getString(this.prefix + "page.xsdsIncluded.msg", new Object[]{new Integer(xsdCount)}) : this.getString("page.noXsds.msg");
        this.setMessage(msg, 0);
        this.getContainer().updateButtons();
    }

    void setInitialSelection(ISelection theSelection) {
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            ArrayList<Object> xsds = new ArrayList<Object>();
            for (int i = 0; i < selectedObjects.length; ++i) {
                if (!(selectedObjects[i] instanceof IFile) || !Util.isXsdFile((IFile)selectedObjects[i])) continue;
                xsds.add(selectedObjects[i]);
            }
            if (!xsds.isEmpty()) {
                this.startupXsds = xsds.toArray();
            }
        }
    }

    public void setVisible(boolean theShowFlag) {
        if (theShowFlag) {
            if (this.viewer.getInput() == null) {
                this.restoreState();
            }
            this.setPageComplete(true);
            if (this.startupXsds != null) {
                this.addXsdFiles(this.startupXsds, true);
                this.startupXsds = null;
            }
            this.viewer.setInput((Object)this);
            this.setPageStatus();
            this.btnWorkspaceAdd.setFocus();
        }
        super.setVisible(theShowFlag);
    }

    private void addResource(IFile theFile) throws CoreException {
        ArgCheck.isNotNull((Object)theFile);
        if (!theFile.exists()) {
            Object[] params = new Object[]{theFile};
            String msg = this.getString("FileDoesNotExist", params);
            throw new IllegalArgumentException(msg);
        }
        URI uri = URI.createFileURI((String)theFile.getRawLocation().toString());
        this.addResourceURI(theFile, uri);
    }

    private void addResource(File theFile) throws CoreException {
        ArgCheck.isNotNull((Object)theFile);
        if (!theFile.exists()) {
            Object[] params = new Object[]{theFile};
            String msg = this.getString("FileDoesNotExist", params);
            throw new IllegalArgumentException(msg);
        }
        URI uri = this.getURI(theFile);
        this.addResourceURI(theFile, uri);
    }

    private void addResourceURI(Object key, URI uri) throws CoreException {
        XSDSchema schema = SchemaProcessorImpl.getSchemaFromURI((URI)uri);
        if (schema != null) {
            // empty if block
        }
        this.manager.addSchema(key, uri);
    }

    private boolean removeResource(File theFile) {
        ArgCheck.isNotNull((Object)theFile);
        return this.removeResourceURI(theFile);
    }

    private boolean removeResource(IFile theFile) {
        ArgCheck.isNotNull((Object)theFile);
        return this.removeResourceURI(theFile);
    }

    private boolean removeResourceURI(Object key) {
        Object oldValue = this.manager.removeSchema(key);
        return oldValue != null;
    }

    private URI getURI(File theFile) {
        URI uri;
        try {
            uri = URI.createFileURI((String)theFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public static String getText(Object theObject) {
        String result = "";
        if (theObject != null) {
            result = theObject instanceof IFile ? ((IFile)theObject).getFullPath().toOSString() : (theObject instanceof File ? theObject.toString() : theObject.toString());
        }
        return result;
    }

    public static void copyToClipboard(ISelection theSelection) {
        ArrayList<String> objects = new ArrayList<String>(SelectionUtilities.getSelectedObjects((ISelection)theSelection));
        if (!objects.isEmpty()) {
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                objects.set(i, XsdSelectionPage.getText(objects.get(i)));
            }
            SystemClipboardUtilities.copyToClipboard((ISelection)new StructuredSelection(objects));
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return XsdSelectionPage.this.manager.getSchemaKeySet().toArray();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }
}

