/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.log.Logger;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DimensionExtensionOperation
extends WorkspaceModifyOperation {
    protected static final String XML_FILE_EXTENSION_NAME = "XMLFileExtension";
    protected static final String XML_HTTP_EXTENSION_NAME = "XMLHTTPExtension";
    protected static final String XML_ACS_EXTENSION_NAME = "XMLACSExtension";
    private static final String HTTP_EXTENSION_MODEL = "XMLHttpConnectorExtensions.xmi";
    private static final String FILE_EXTENSION_MODEL = "XMLFileConnectorExtensions.xmi";
    private static final String ACS_EXTENSION_MODEL = "XMLACSExtensions.xmi";
    private static final String XML_EXTENSION_PROJECT = "XMLExtensionsProject";
    private static final String ACS_EXTENSION_PROJECT = "ACSExtensionsProject";
    private String m_extensionName;
    private Object m_internal;
    private Logger m_logger;

    public DimensionExtensionOperation(String extensionName, Object vdbContext, Logger logger) {
        this.m_extensionName = extensionName;
        this.m_internal = vdbContext;
        this.m_logger = logger;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String project = this.determineProject();
        String model = this.determineModel();
        ModelProject theProject = ModelerCore.getModelWorkspace().getModelProjects()[0];
        boolean extensionExists = this.checkExtensionExists(theProject.getProject(), model);
        Path newPath = new Path(model);
        IFile theFile = null;
        if (!extensionExists) {
            try {
                InputStream is = this.getExtensionAsStream(project, model);
                theFile = this.createNewFile((IPath)newPath, theProject.getProject(), is);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            IPath extPath = theFile.getFullPath();
        }
    }

    private IFile createNewFile(IPath path, IProject project, InputStream is) throws CoreException {
        IFile file = project.getFile(path);
        file.create(is, true, null);
        return file;
    }

    private InputStream getExtensionAsStream(String project, String model) throws IOException {
        String extensionZip = this.deriveExtensionZipLocation(project + ".zip");
        ZipFile zipFile = new ZipFile(extensionZip);
        ZipEntry sourceEntry = zipFile.getEntry(model);
        InputStream is = zipFile.getInputStream(sourceEntry);
        return is;
    }

    private boolean checkExtensionExists(IProject project, String model) throws ModelWorkspaceException {
        IFile contents = project.getFile(model);
        return contents.exists();
    }

    private String determineModel() {
        if (this.m_extensionName.equals(XML_FILE_EXTENSION_NAME)) {
            return FILE_EXTENSION_MODEL;
        }
        if (this.m_extensionName.equals(XML_HTTP_EXTENSION_NAME)) {
            return HTTP_EXTENSION_MODEL;
        }
        if (this.m_extensionName.equals(XML_ACS_EXTENSION_NAME)) {
            return ACS_EXTENSION_MODEL;
        }
        return null;
    }

    private String determineProject() {
        if (this.m_extensionName.equals(XML_FILE_EXTENSION_NAME) || this.m_extensionName.equals(XML_HTTP_EXTENSION_NAME)) {
            return XML_EXTENSION_PROJECT;
        }
        if (this.m_extensionName.equals(XML_ACS_EXTENSION_NAME)) {
            return ACS_EXTENSION_PROJECT;
        }
        return null;
    }

    private String deriveExtensionZipLocation(String zipName) throws IOException {
        URL zipUrl = XmlImporterUiPlugin.getDefault().find((IPath)new Path(zipName));
        URL resolvedZip = Platform.resolve((URL)zipUrl);
        return resolvedZip.getPath();
    }

    private void addExtensionToVdb(Object vdbContext, IPath modelPath, IFile theFile) throws VdbEditException {
        this.m_logger.log(2, "Entering addExtensionToVDB");
        Class<?> objClass = vdbContext.getClass();
        boolean extensionModelsExist = false;
        try {
            Method meth = objClass.getMethod("getVirtualDatabase", null);
            VirtualDatabase vdb = (VirtualDatabase)meth.invoke(vdbContext, null);
            EList modelList = vdb.getModels();
            for (ModelReference ref : modelList) {
                if (!HTTP_EXTENSION_MODEL.equals(ref.getName())) continue;
                extensionModelsExist = true;
                break;
            }
        }
        catch (Exception nme) {
            throw new VdbEditException((Throwable)nme);
        }
        if (!extensionModelsExist) {
            ModelReference[] ref = null;
            if (vdbContext instanceof InternalVdbEditingContext) {
                ref = ((InternalVdbEditingContext)vdbContext).addModel(null, modelPath, false);
            } else {
                try {
                    Method addModel = objClass.getMethod("addModel", IProgressMonitor.class, File.class, String.class, Boolean.TYPE);
                    String strPath = theFile.getFullPath().toString();
                    File modelFile = theFile.getLocation().toFile();
                    ref = (ModelReference[])addModel.invoke(vdbContext, null, modelFile, strPath, Boolean.FALSE);
                }
                catch (Exception ie) {
                    if (ie instanceof InvocationTargetException) {
                        throw new VdbEditException(ie.getCause());
                    }
                    throw new VdbEditException((Throwable)ie);
                }
            }
            try {
                ref[0].eResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException ioe) {
                throw new VdbEditException((Throwable)ioe);
            }
        }
        this.m_logger.log(2, "Exiting addExtensionToVDB");
    }
}

