/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.modelgenerator.xml.Util;
import com.metamatrix.modeler.modelgenerator.xml.wizards.unzipproject.ProjectImporter;
import com.metamatrix.ui.AbstractUiPlugin;
import com.metamatrix.ui.actions.ActionService;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;

public class XmlImporterUiPlugin
extends AbstractUiPlugin
implements IStartup {
    private static XmlImporterUiPlugin plugin;
    public static final String C_threshold = "c_Threshold";
    public static final String P_threshold = "p_Threshold";
    public static final String F_threshold = "f_Threshold";
    public static final String requestTable = "requestTable";
    public static final String mergedChildSep = "mergedChildSep";
    public static final String xsdLibrary = "xsdLibrary";
    private Util util = new Util();
    private boolean acsInstalled = false;
    private static boolean m_isDimension;
    private static Object m_rootContext;
    private static final String I18N_PREFIX;
    private static int baseExtensionProjectIndex;

    private void determineDimension() {
        try {
            m_isDimension = false;
            Class<?> theClass = Class.forName("com.metamatrix.ui.internal.product.ProductCustomizerMgr");
            Method getInstance = theClass.getMethod("getInstance", null);
            Object instance = getInstance.invoke(null, null);
            Method getProductCharacteristics = theClass.getMethod("getProductCharacteristics", null);
            Object productCharacteristics = getProductCharacteristics.invoke(instance, null);
            Class<?> prodCharClass = Class.forName("com.metamatrix.ui.product.IProductCharacteristics");
            Method getRootWorkspaceContext = prodCharClass.getMethod("getRootWorkspaceContext", null);
            Method isHiddenProjectCentric = prodCharClass.getMethod("isHiddenProjectCentric", null);
            Object isProjCentric = isHiddenProjectCentric.invoke(productCharacteristics, null);
            if (isProjCentric instanceof Boolean) {
                Boolean dimension = (Boolean)isProjCentric;
                m_isDimension = dimension;
            }
            if (!((m_rootContext = getRootWorkspaceContext.invoke(productCharacteristics, null)) instanceof WorkspaceRoot)) {
                m_isDimension = true;
            }
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (NoSuchMethodException nme) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public XmlImporterUiPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        this.determineDimension();
        plugin = this;
    }

    private String getString(String id) {
        return this.util.getString(I18N_PREFIX + id);
    }

    private String getString(String id, Object[] params) {
        return this.util.getString(I18N_PREFIX + id, params);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.util.initializePlatformLogger((Plugin)this);
        this.checkPluginDependencies();
        if (!XmlImporterUiPlugin.isDimension()) {
            this.ensureExtensionObjects();
        }
    }

    public static boolean isDimension() {
        return m_isDimension;
    }

    public static Object getRootContext() {
        return m_rootContext;
    }

    private void checkPluginDependencies() {
        if (Platform.getExtensionRegistry().getExtensions("com.librados.config").length > 0) {
            this.setAcsInstalled(true);
            this.util.log(1, "acs plug-in is installed");
        } else {
            this.util.log(1, "acs plug-in is not installed");
        }
    }

    public void earlyStartup() {
    }

    private void ensureExtensionObjects() throws Exception {
        this.util.log(1, "entering ensureExtensionObjects");
        IWorkspace workspace = ModelerCore.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        ArrayList extensionProjects = this.getKnownModelExtensions();
        IProject[] existingProjects = workspaceRoot.getProjects();
        this.util.log(1, "existing projects are: " + existingProjects.toString());
        IProject[] neededProjects = new IProject[extensionProjects.size()];
        block6: for (int iExistingProject = 0; iExistingProject < existingProjects.length; ++iExistingProject) {
            IProject existingProject = existingProjects[iExistingProject];
            String existingProjectName = existingProject.getName();
            for (int iNeededProject = 0; iNeededProject < extensionProjects.size(); ++iNeededProject) {
                ExtensionProjectDesc extensionProjectDesc = (ExtensionProjectDesc)extensionProjects.get(iNeededProject);
                if (existingProjectName == null || !existingProjectName.equals(extensionProjectDesc.projectName)) continue;
                neededProjects[iNeededProject] = existingProject;
                continue block6;
            }
        }
        this.util.log(1, "needed projects are: " + neededProjects.toString());
        for (int iNeededProject = 0; iNeededProject < extensionProjects.size(); ++iNeededProject) {
            IProject project;
            ExtensionProjectDesc extensionProjectDesc;
            block14: {
                extensionProjectDesc = (ExtensionProjectDesc)extensionProjects.get(iNeededProject);
                project = neededProjects[iNeededProject];
                if (project == null) {
                    try {
                        neededProjects[iNeededProject] = project = this.importExistingProject(extensionProjectDesc);
                        this.util.log(1, this.getString("importedExtensionProject", new Object[]{extensionProjectDesc.projectName}));
                        break block14;
                    }
                    catch (Exception e) {
                        if (extensionProjectDesc.required) {
                            throw new Exception(this.getString("unableToImportRequiredExtensionProject", new Object[]{extensionProjectDesc.projectName, extensionProjectDesc.pathName}), e);
                        }
                        if (!this.isAcsInstalled()) continue;
                        this.util.log(2, e, this.getString("unableToImportOptionalExtensionProject", new Object[]{extensionProjectDesc.projectName, extensionProjectDesc.pathName}));
                        continue;
                    }
                }
                this.util.log(1, this.getString("extensionProjectExists", new Object[]{extensionProjectDesc.projectName}));
            }
            if (project.isOpen()) {
                this.util.log(1, this.getString("extensionProjectAlreadyOpen", new Object[]{extensionProjectDesc.projectName}));
            } else {
                try {
                    this.openExistingProject(project);
                    this.util.log(1, this.getString("extensionProjectOpened", new Object[]{extensionProjectDesc.projectName}));
                }
                catch (Exception e) {
                    try {
                        project = this.importExistingProject(extensionProjectDesc);
                        this.openExistingProject(project);
                        this.util.log(1, this.getString("extensionProjectOpened", new Object[]{extensionProjectDesc.projectName}));
                    }
                    catch (Exception x) {
                        if (extensionProjectDesc.required) {
                            throw new Exception(this.getString("unableToOpenRequiredExtensionProject", new Object[]{extensionProjectDesc.projectName}), x);
                        }
                        this.util.log(2, x, this.getString("unableToOpenOptionalExtensionProject", new Object[]{extensionProjectDesc.projectName}));
                        continue;
                    }
                }
            }
            if (iNeededProject != baseExtensionProjectIndex) continue;
            int x = 0;
            x += 10;
        }
        this.util.log(1, "exiting ensureExtensionObjects");
    }

    private ArrayList getKnownModelExtensions() {
        ArrayList<ExtensionProjectDesc> extensionProjectDescriptions = new ArrayList<ExtensionProjectDesc>();
        extensionProjectDescriptions.add(new ExtensionProjectDesc("XMLExtensionsProject", "XMLExtensionsProject.zip", true));
        if (this.isAcsInstalled()) {
            extensionProjectDescriptions.add(new ExtensionProjectDesc("XMLACSExtensionsProject", "ACSExtensionsProject.zip", false));
        }
        return extensionProjectDescriptions;
    }

    private IProject importExistingProject(ExtensionProjectDesc extensionProjectDesc) throws Exception {
        String fullPath;
        String pathName = extensionProjectDesc.pathName;
        URL bundledurl = pathName == null ? null : XmlImporterUiPlugin.getDefault().find((IPath)new Path(pathName));
        URL resolvedurl = bundledurl == null ? null : Platform.resolve((URL)bundledurl);
        String path = resolvedurl == null ? null : resolvedurl.getPath();
        File file = path == null ? null : new File(path);
        String string = fullPath = file == null ? null : file.getCanonicalPath();
        if (fullPath == null) {
            throw new Exception(this.getString("unableToFindExtensionProjectZipFile", new Object[]{extensionProjectDesc.pathName, bundledurl, resolvedurl, path, fullPath}));
        }
        ProjectImporter projectImporter = new ProjectImporter();
        IWorkspace workspace = ModelerCore.getWorkspace();
        IProject[] projects = projectImporter.importFromZipFile(workspace, fullPath);
        if (projects == null || projects.length == 0) {
            throw new Exception(this.getString("unableToFindAnyExtensionProjectsInZipFile", new Object[]{extensionProjectDesc.pathName, bundledurl, resolvedurl, path, fullPath}));
        }
        if (projects.length > 1) {
            throw new Exception(this.getString("tooManyExtensionProjectsInZipFile", new Object[]{extensionProjectDesc.pathName, bundledurl, resolvedurl, path, fullPath, new Integer(projects.length)}));
        }
        return projects[0];
    }

    private void openExistingProject(IProject project) throws CoreException {
        project.open(null);
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return null;
    }

    public PluginUtil getPluginUtil() {
        return this.util;
    }

    public static XmlImporterUiPlugin getDefault() {
        return plugin;
    }

    public boolean isAcsInstalled() {
        return this.acsInstalled;
    }

    public void setAcsInstalled(boolean acsInstalled) {
        this.util.log(1, "entering setAcsInstalled");
        this.acsInstalled = acsInstalled;
        this.util.log(1, "exiting setAcsInstalled");
    }

    static {
        I18N_PREFIX = I18nUtil.getPropertyPrefix(XmlImporterUiPlugin.class);
        baseExtensionProjectIndex = 0;
    }

    private static class ExtensionProjectDesc {
        String projectName;
        String pathName;
        boolean required;

        ExtensionProjectDesc(String projectName, String fileName, boolean required) {
            this.projectName = projectName;
            this.pathName = fileName;
            this.required = required;
        }
    }
}

